/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.io;

import com.actelion.research.chem.io.CompoundFileHelper;
import java.io.File;
import java.util.Iterator;
import java.util.TreeMap;
import javax.swing.filechooser.FileFilter;

public class CompoundFileFilter
extends FileFilter {
    private TreeMap<String, CompoundFileFilter> mFilterMap = new TreeMap();
    private String mDescription = null;
    private String mFullDescription = null;
    private boolean mUseExtensionsInDescription = true;

    public CompoundFileFilter() {
    }

    public CompoundFileFilter(String extension) {
        this(extension, null);
    }

    public CompoundFileFilter(String extension, String description) {
        this();
        if (extension != null) {
            this.addExtension(extension);
        }
        if (description != null) {
            this.setDescription(description);
        }
    }

    public CompoundFileFilter(String[] filters) {
        this(filters, null);
    }

    public CompoundFileFilter(String[] filters, String description) {
        this();
        for (int i = 0; i < filters.length; ++i) {
            this.addExtension(filters[i]);
        }
        if (description != null) {
            this.setDescription(description);
        }
    }

    @Override
    public boolean accept(File f) {
        if (f != null) {
            if (f.isDirectory()) {
                return true;
            }
            String extension = this.getExtension(f);
            if (extension != null && this.mFilterMap.get(this.getExtension(f)) != null) {
                return true;
            }
        }
        return false;
    }

    public String getExtension(File f) {
        return CompoundFileHelper.getExtension(f);
    }

    public void addExtension(String extension) {
        if (this.mFilterMap == null) {
            this.mFilterMap = new TreeMap();
        }
        this.mFilterMap.put(extension.toLowerCase(), this);
        this.mFullDescription = null;
    }

    @Override
    public String getDescription() {
        if (this.mFullDescription == null) {
            if (this.mDescription == null || this.isExtensionListInDescription()) {
                this.mFullDescription = this.mDescription == null ? "(" : this.mDescription + " (";
                Iterator iterator = this.mFilterMap.keySet().stream().sorted().iterator();
                this.mFullDescription = this.mFullDescription + (String)iterator.next();
                while (iterator.hasNext()) {
                    this.mFullDescription = this.mFullDescription + ", " + (String)iterator.next();
                }
                this.mFullDescription = this.mFullDescription + ")";
            } else {
                this.mFullDescription = this.mDescription;
            }
        }
        return this.mFullDescription;
    }

    public void setDescription(String description) {
        this.mDescription = description;
        this.mFullDescription = null;
    }

    public void addDescription(String description) {
        this.mDescription = this.mDescription == null ? description : this.mDescription.concat(", " + description);
    }

    public void setExtensionListInDescription(boolean b) {
        this.mUseExtensionsInDescription = b;
        this.mFullDescription = null;
    }

    public boolean isExtensionListInDescription() {
        return this.mUseExtensionsInDescription;
    }
}

