/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.io;

import com.actelion.research.chem.Canonizer;
import com.actelion.research.chem.MolfileParser;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.io.CompoundFileFilter;
import com.actelion.research.chem.io.CompoundFileParser;
import com.actelion.research.chem.io.DWARFileParser;
import com.actelion.research.chem.io.Mol2FileParser;
import com.actelion.research.chem.io.ODEFileParser;
import com.actelion.research.chem.io.RXNFileCreator;
import com.actelion.research.chem.io.SDFileParser;
import com.actelion.research.chem.reaction.Reaction;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;

public abstract class CompoundFileHelper {
    public static final int cFileTypeMask = 262143;
    public static final int cFileTypeDataWarrior = 1;
    public static final int cFileTypeDataWarriorTemplate = 2;
    public static final int cFileTypeDataWarriorQuery = 4;
    public static final int cFileTypeDataWarriorMacro = 8;
    public static final int cFileTypeTextTabDelimited = 16;
    public static final int cFileTypeTextCommaSeparated = 32;
    public static final int cFileTypeText = 48;
    public static final int cFileTypeSDV3 = 64;
    public static final int cFileTypeSDV2 = 128;
    public static final int cFileTypeSD = 192;
    public static final int cFileTypeRXN = 256;
    public static final int cFileTypeSOM = 512;
    public static final int cFileTypeJPG = 1024;
    public static final int cFileTypeGIF = 2048;
    public static final int cFileTypePNG = 4096;
    public static final int cFileTypeSVG = 8192;
    public static final int cFileTypePictureFile = 15360;
    public static final int cFileTypeRDV3 = 16384;
    public static final int cFileTypeRDV2 = 32768;
    public static final int cFileTypeRD = 49152;
    public static final int cFileTypeMOL = 65536;
    public static final int cFileTypeMOL2 = 131072;
    public static final int cFileTypePDB = 262144;
    public static final int cFileTypeMMTF = 524288;
    public static final int cFileTypeProtein = 786432;
    public static final int cFileTypeSDGZ = 0x100000;
    public static final int cFileTypeUnknown = -1;
    public static final int cFileTypeDirectory = -2;
    public static final String cGZipExtention = ".gz";
    public static final int cFileTypeDataWarriorCompatibleData = 1097969;
    public static final int cFileTypeDataWarriorTemplateContaining = 7;
    private static File sCurrentDirectory;
    private int mRecordCount;
    private int mErrorCount;

    public abstract String selectOption(String var1, String var2, String[] var3);

    public abstract File selectFileToOpen(String var1, int var2);

    public abstract String selectFileToSave(String var1, int var2, String var3);

    public abstract void showMessage(String var1);

    public static File getCurrentDirectory() {
        return sCurrentDirectory;
    }

    public static void setCurrentDirectory(File d) {
        sCurrentDirectory = d;
    }

    public ArrayList<StereoMolecule> readStructuresFromFile(boolean readIdentifier) {
        File file = this.selectFileToOpen("Please select substance file", 196801);
        return this.readStructuresFromFile(file, readIdentifier);
    }

    public ArrayList<String> readIDCodesFromFile() {
        File file = this.selectFileToOpen("Please select substance file", 196801);
        return this.readIDCodesFromFile(file);
    }

    public ArrayList<StereoMolecule> readStructuresFromFile(File file, boolean readIdentifier) {
        if (file == null) {
            return null;
        }
        ArrayList<StereoMolecule> moleculeList = new ArrayList<StereoMolecule>();
        this.readChemObjectsFromFile(file, moleculeList, null, null, readIdentifier, false);
        return moleculeList;
    }

    public ArrayList<String> readIDCodesFromFile(File file) {
        if (file == null) {
            return null;
        }
        ArrayList<String> idcodeList = new ArrayList<String>();
        this.readChemObjectsFromFile(file, null, idcodeList, null, false, false);
        return idcodeList;
    }

    public ArrayList<String[]> readIDCodesWithNamesFromFile(File file, boolean readIDCoords) {
        if (file == null) {
            file = this.selectFileToOpen("Please select substance file", 65729);
        }
        if (file == null) {
            return null;
        }
        ArrayList<String[]> idcodeWithIDList = new ArrayList<String[]>();
        this.readChemObjectsFromFile(file, null, null, idcodeWithIDList, false, readIDCoords);
        return idcodeWithIDList;
    }

    private void readChemObjectsFromFile(File file, ArrayList<StereoMolecule> moleculeList, ArrayList<String> idcodeList, ArrayList<String[]> idcodeWithIDList, boolean readIdentifier, boolean readIDCoords) {
        String extention;
        this.mRecordCount = 0;
        this.mErrorCount = 0;
        String filename = file.getName();
        int index = filename.indexOf(46);
        String string = extention = index == -1 ? "" : filename.substring(index).toLowerCase();
        if (extention.equals(".mol") || extention.equals(".mol2")) {
            StereoMolecule mol = null;
            if (extention.equals(".mol")) {
                mol = new MolfileParser().getCompactMolecule(file);
            } else {
                try {
                    mol = new Mol2FileParser().load(filename);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (mol != null && mol.getAllAtoms() != 0) {
                if (moleculeList != null) {
                    moleculeList.add(mol);
                }
                if (idcodeList != null || idcodeWithIDList != null) {
                    Canonizer canonizer = new Canonizer(mol);
                    String idcode = canonizer.getIDCode();
                    String coords = canonizer.getEncodedCoordinates();
                    if (idcode != null && coords.length() != 0 && readIDCoords) {
                        idcode = idcode + " " + coords;
                    }
                    if (idcodeList != null) {
                        idcodeList.add(idcode);
                    }
                    if (idcodeWithIDList != null) {
                        String[] idcodeWithID = new String[]{idcode, mol.getName()};
                        idcodeWithIDList.add(idcodeWithID);
                    }
                }
            }
            return;
        }
        SDFileParser parser = extention.equals(".sdf") ? new SDFileParser(file) : (extention.equals(".dwar") ? new DWARFileParser(file) : (extention.equals(".ode") ? new ODEFileParser(file) : null));
        int indexOfID = -1;
        if (idcodeWithIDList != null || readIdentifier) {
            String id;
            String[] fieldNames = ((CompoundFileParser)parser).getFieldNames();
            if (fieldNames != null && fieldNames.length != 0 && (id = this.selectOption("Select compound name or identifier", filename, fieldNames)) != null) {
                for (int i = 0; i < fieldNames.length; ++i) {
                    if (!fieldNames[i].equals(id)) continue;
                    indexOfID = i;
                    break;
                }
            }
            if (parser instanceof SDFileParser) {
                parser = new SDFileParser(file, fieldNames);
            }
        }
        while (parser.next()) {
            ++this.mRecordCount;
            boolean isError = false;
            if (moleculeList != null) {
                StereoMolecule mol = ((CompoundFileParser)parser).getMolecule();
                if (mol != null) {
                    if (indexOfID != -1) {
                        mol.setName(((CompoundFileParser)parser).getFieldData(indexOfID));
                    }
                    moleculeList.add(mol);
                } else {
                    isError = true;
                }
            }
            if (idcodeList != null || idcodeWithIDList != null) {
                String coords;
                String idcode = parser.getIDCode();
                if (idcode != null && readIDCoords && (coords = parser.getCoordinates()) != null) {
                    idcode = idcode.concat(" ").concat(coords);
                }
                String id = null;
                if (idcodeWithIDList != null) {
                    id = ((CompoundFileParser)parser).getMoleculeName();
                    if (indexOfID != -1) {
                        id = ((CompoundFileParser)parser).getFieldData(indexOfID);
                    }
                }
                if (idcode != null) {
                    if (idcodeList != null) {
                        idcodeList.add(idcode);
                    }
                    if (idcodeWithIDList != null) {
                        String[] idcodeWithID = new String[]{idcode, id};
                        idcodeWithIDList.add(idcodeWithID);
                    }
                } else {
                    isError = true;
                }
            }
            if (!isError) continue;
            ++this.mErrorCount;
        }
    }

    public int getRecordCount() {
        return this.mRecordCount;
    }

    public int getErrorCount() {
        return this.mErrorCount;
    }

    public static CompoundFileFilter createFileFilter(int filetypes, boolean isSaving) {
        if (filetypes == -2) {
            return new CompoundFileFilter(){

                @Override
                public boolean accept(File f) {
                    return f.isDirectory();
                }
            };
        }
        CompoundFileFilter filter = new CompoundFileFilter();
        if ((filetypes & 1) != 0) {
            filter.addExtension("dwar");
            if (!isSaving) {
                filter.addExtension("ode");
            }
            filter.addDescription("DataWarrior data files");
        }
        if ((filetypes & 2) != 0) {
            filter.addExtension("dwat");
            if (!isSaving) {
                filter.addExtension("odt");
            }
            filter.addDescription("DataWarrior template files");
        }
        if ((filetypes & 4) != 0) {
            filter.addExtension("dwaq");
            if (!isSaving) {
                filter.addExtension("odq");
            }
            filter.addDescription("DataWarrior query files");
        }
        if ((filetypes & 8) != 0) {
            filter.addExtension("dwam");
            filter.addDescription("DataWarrior macro files");
        }
        if ((filetypes & 0x10) != 0) {
            filter.addExtension("txt");
            filter.addDescription("TAB delimited text files");
        }
        if ((filetypes & 0x20) != 0) {
            filter.addExtension("csv");
            filter.addDescription("Comma separated text files");
        }
        if ((filetypes & 0x100) != 0) {
            filter.addExtension("rxn");
            filter.addDescription("MDL reaction files");
        }
        if ((filetypes & 0xC0) != 0) {
            filter.addExtension("sdf");
            filter.addDescription("MDL SD-files");
        }
        if ((filetypes & 0x100000) != 0) {
            filter.addExtension("sdf.gz");
            filter.addDescription("gzipped MDL SD-files)");
        }
        if ((filetypes & 0xC000) != 0) {
            filter.addExtension("rdf");
            filter.addDescription("MDL RD-files");
        }
        if ((filetypes & 0x200) != 0) {
            filter.addExtension("dwas");
            if (!isSaving) {
                filter.addExtension("som");
            }
            filter.addDescription("DataWarrior self organized map");
        }
        if ((filetypes & 0x400) != 0) {
            filter.addExtension("jpg");
            filter.addExtension("jpeg");
            filter.addDescription("JPEG image files");
        }
        if ((filetypes & 0x800) != 0) {
            filter.addExtension("gif");
            filter.addDescription("GIF image files");
        }
        if ((filetypes & 0x1000) != 0) {
            filter.addExtension("png");
            filter.addDescription("PNG image files");
        }
        if ((filetypes & 0x2000) != 0) {
            filter.addExtension("svg");
            filter.addDescription("scalable vector graphics files");
        }
        if (filetypes == 1097969) {
            filter.setDescription("DataWarrior compatible files");
        }
        if (filetypes == 7) {
            filter.setDescription("Files containing a DataWarrior template");
        }
        if (filetypes == 15360) {
            filter.setDescription("Image files");
        }
        if ((filetypes & 0x40000) != 0) {
            filter.addExtension("pdb");
            filter.addDescription("Protein Data Bank files");
        }
        if ((filetypes & 0x80000) != 0) {
            filter.addExtension("mmtf");
            filter.addDescription("Binary Protein Data Bank files");
        }
        if ((filetypes & 0x10000) != 0) {
            filter.addExtension("mol");
            filter.addDescription("MDL Molfiles");
        }
        if ((filetypes & 0x20000) != 0) {
            filter.addExtension("mol2");
            filter.addDescription("Tripos Mol2 files");
        }
        return filter;
    }

    public static String getExtension(File file) {
        String filename;
        int index = -1;
        String string = filename = file == null ? null : file.getName();
        if (filename != null) {
            index = CompoundFileHelper.getExtensionIndex(filename);
        }
        return index == -1 ? null : filename.substring(index + 1).toLowerCase();
    }

    private static int getExtensionIndex(String filename) {
        int i = filename.lastIndexOf(46);
        if (i > 0 && i < filename.length() - 1 && filename.substring(i).equalsIgnoreCase(cGZipExtention)) {
            i = filename.lastIndexOf(46, i - 1);
        }
        return i > 0 && i < filename.length() - 1 ? i : -1;
    }

    public static String removePathAndExtension(String filePath) {
        int i2;
        int i1 = filePath.lastIndexOf(File.separatorChar);
        int n = i2 = CompoundFileHelper.getFileType(filePath) != -1 ? CompoundFileHelper.getExtensionIndex(filePath) : -1;
        if (i1 == -1) {
            return i2 == -1 ? filePath : filePath.substring(0, i2);
        }
        return i2 == -1 || i2 < i1 ? filePath.substring(i1 + 1) : filePath.substring(i1 + 1, i2);
    }

    public static String removeExtension(String filePath) {
        int i = CompoundFileHelper.getFileType(filePath) != -1 ? filePath.lastIndexOf(46) : -1;
        return i == -1 ? filePath : filePath.substring(0, i);
    }

    public static int getFileType(String filename) {
        int index = CompoundFileHelper.getExtensionIndex(filename);
        if (index == -1) {
            return -1;
        }
        String extension = filename.substring(index).toLowerCase();
        if (extension.equals(".dwar") || extension.equals(".ode")) {
            return 1;
        }
        if (extension.equals(".dwat") || extension.equals(".odt")) {
            return 2;
        }
        if (extension.equals(".dwaq") || extension.equals(".odq")) {
            return 4;
        }
        if (extension.equals(".dwas") || extension.equals(".som")) {
            return 512;
        }
        if (extension.equals(".dwam")) {
            return 8;
        }
        if (extension.equals(".txt")) {
            return 16;
        }
        if (extension.equals(".csv")) {
            return 32;
        }
        if (extension.equals(".sdf")) {
            return 192;
        }
        if (extension.equals(".sdf.gz")) {
            return 0x100000;
        }
        if (extension.equals(".rdf")) {
            return 49152;
        }
        if (extension.equals(".rxn")) {
            return 256;
        }
        if (extension.equals(".jpg") || extension.equals(".jpeg")) {
            return 1024;
        }
        if (extension.equals(".gif")) {
            return 2048;
        }
        if (extension.equals(".png")) {
            return 4096;
        }
        if (extension.equals(".svg")) {
            return 8192;
        }
        if (extension.equals(".mol")) {
            return 65536;
        }
        if (extension.equals(".mol2")) {
            return 131072;
        }
        if (extension.equals(".pdb")) {
            return 262144;
        }
        if (extension.equals(".mmtf")) {
            return 524288;
        }
        return -1;
    }

    public ArrayList<String> getExtensionList(int fileTypes) {
        ArrayList<String> list = new ArrayList<String>();
        int type = 1;
        while ((type & 0x3FFFF) != 0) {
            String extension;
            if ((type & fileTypes) != 0 && (extension = CompoundFileHelper.getExtension(type)).length() != 0 && !list.contains(extension)) {
                list.add(extension);
            }
            type <<= 1;
        }
        return list;
    }

    public static String getExtension(int filetype) {
        String extension = "";
        switch (filetype) {
            case 1: {
                extension = ".dwar";
                break;
            }
            case 4: {
                extension = ".dwaq";
                break;
            }
            case 2: {
                extension = ".dwat";
                break;
            }
            case 8: {
                extension = ".dwam";
                break;
            }
            case 16: {
                extension = ".txt";
                break;
            }
            case 32: {
                extension = ".csv";
                break;
            }
            case 64: 
            case 128: 
            case 192: {
                extension = ".sdf";
                break;
            }
            case 16384: 
            case 32768: 
            case 49152: {
                extension = ".rdf";
                break;
            }
            case 256: {
                extension = ".rxn";
                break;
            }
            case 512: {
                extension = ".dwas";
                break;
            }
            case 1024: {
                extension = ".jpeg";
                break;
            }
            case 2048: {
                extension = ".gif";
                break;
            }
            case 4096: {
                extension = ".png";
                break;
            }
            case 8192: {
                extension = ".svg";
                break;
            }
            case 65536: {
                extension = ".mol";
                break;
            }
            case 131072: {
                extension = ".mol2";
                break;
            }
            case 262144: {
                extension = ".pdb";
                break;
            }
            case 524288: {
                extension = ".mmtf";
                break;
            }
            case 0x100000: {
                extension = ".sdf.gz";
            }
        }
        return extension;
    }

    public void saveRXNFile(Reaction rxn) {
        String fileName = this.selectFileToSave("Select reaction file", 256, "Untitled Reaction");
        if (fileName != null) {
            String extension = ".rxn";
            int dotIndex = fileName.lastIndexOf(46);
            int slashIndex = fileName.lastIndexOf(File.separator);
            if (dotIndex == -1 || dotIndex < slashIndex) {
                fileName = fileName.concat(extension);
            } else if (!fileName.substring(dotIndex).equalsIgnoreCase(extension)) {
                this.showMessage("uncompatible file name extension.");
                return;
            }
            try {
                BufferedWriter theWriter = new BufferedWriter(new FileWriter(new File(fileName)));
                new RXNFileCreator(rxn).writeRXNfile(theWriter);
                theWriter.close();
            }
            catch (IOException e) {
                this.showMessage("IOException: " + e);
            }
        }
    }
}

