/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.io;

import com.actelion.research.chem.Canonizer;
import com.actelion.research.chem.IDCodeParser;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.descriptor.DescriptorHandler;
import com.actelion.research.chem.descriptor.DescriptorHandlerFactory;
import com.actelion.research.chem.io.CompoundFileHelper;
import com.actelion.research.chem.io.DWARFileParser;
import com.actelion.research.chem.io.SDFileParser;
import java.io.BufferedReader;
import java.io.IOException;

public abstract class CompoundFileParser {
    private StereoMolecule mMol;
    private DescriptorHandlerFactory mDHFactory;
    private boolean mStructureUpToDate;
    private boolean mIDCodeUpToDate;
    private String mIDCode;
    private String mCoords;
    protected BufferedReader mReader;

    public static CompoundFileParser createParser(String fileName) {
        CompoundFileParser parser = null;
        int fileType = CompoundFileHelper.getFileType(fileName);
        if (fileType == 1) {
            parser = new DWARFileParser(fileName);
        } else if (fileType == 192) {
            parser = new SDFileParser(fileName);
        }
        return parser.mReader == null ? null : parser;
    }

    public abstract String[] getFieldNames();

    public abstract String getFieldData(int var1);

    public abstract int getRowCount();

    protected abstract boolean advanceToNext();

    public boolean isOpen() {
        return this.mReader != null;
    }

    public boolean next() {
        this.mStructureUpToDate = false;
        this.mIDCodeUpToDate = false;
        return this.advanceToNext();
    }

    public final void close() {
        if (this.mReader != null) {
            try {
                this.mReader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public String getIDCode() {
        this.updateIDCodeAndCoords();
        return this.mIDCode;
    }

    public String getCoordinates() {
        this.updateIDCodeAndCoords();
        return this.mCoords;
    }

    public abstract String getMoleculeName();

    public void setDescriptorHandlerFactory(DescriptorHandlerFactory factory) {
        this.mDHFactory = factory;
    }

    public DescriptorHandlerFactory getDescriptorHandlerFactory() {
        return this.mDHFactory;
    }

    public int getFieldIndex(String fieldName) {
        String[] name = this.getFieldNames();
        if (name != null) {
            for (int i = 0; i < name.length; ++i) {
                if (!fieldName.equals(name[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public Object getDescriptor(String shortName) {
        if (this.mDHFactory != null) {
            Object d;
            DescriptorHandler dh = this.mDHFactory.getDefaultDescriptorHandler(shortName);
            return dh.calculationFailed(d = dh.createDescriptor(this.getMolecule())) ? null : d;
        }
        return null;
    }

    private void updateIDCodeAndCoords() {
        if (!this.mIDCodeUpToDate) {
            try {
                StereoMolecule mol = new StereoMolecule(this.getMolecule());
                mol.normalizeAmbiguousBonds();
                mol.canonizeCharge(true);
                Canonizer canonizer = new Canonizer(mol);
                this.mIDCode = canonizer.getIDCode();
                this.mCoords = canonizer.getEncodedCoordinates();
            }
            catch (Exception e) {
                this.mIDCode = null;
                this.mCoords = null;
            }
            this.mIDCodeUpToDate = true;
        }
    }

    public StereoMolecule getMolecule() {
        if (!this.mStructureUpToDate) {
            String idcode = this.getIDCode();
            String coords = this.getCoordinates();
            this.mMol = null;
            try {
                this.mMol = new IDCodeParser(coords == null).getCompactMolecule(idcode, coords);
                if (this.mMol != null) {
                    this.mMol.setName(this.getMoleculeName());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.mStructureUpToDate = true;
        return this.mMol;
    }
}

