/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.io;

import com.actelion.research.chem.descriptor.DescriptorConstants;
import com.actelion.research.chem.descriptor.DescriptorHandlerStandard2DFactory;
import com.actelion.research.chem.descriptor.DescriptorHelper;
import com.actelion.research.chem.io.CompoundFileParser;
import com.actelion.research.chem.io.CompoundTableConstants;
import com.actelion.research.io.BOMSkipper;
import com.actelion.research.util.BinaryDecoder;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import java.util.TreeMap;

public class DWARFileParser
extends CompoundFileParser
implements DescriptorConstants,
CompoundTableConstants {
    public static final int MODE_COORDINATES_PREFER_2D = 1;
    public static final int MODE_COORDINATES_PREFER_3D = 2;
    public static final int MODE_COORDINATES_REQUIRE_2D = 3;
    public static final int MODE_COORDINATES_REQUIRE_3D = 4;
    private static final int MODE_COORDINATE_MASK = 7;
    public static final int MODE_BUFFER_HEAD_AND_TAIL = 8;
    public static final int MODE_EXTRACT_DETAILS = 16;
    private String[] mFieldName;
    private String[] mFieldData;
    private String mLine;
    private String mCoordinate3DColumnName;
    private int[] mFieldIndex;
    private int mRecordCount;
    private int mMode;
    private int mIDCodeColumn;
    private int mCoordinateColumn;
    private int mCoordinate2DColumn;
    private int mCoordinate3DColumn;
    private int mMoleculeNameColumn;
    private int mFragFpColumn;
    private TreeMap<String, Properties> mColumnPropertyMap;
    private TreeMap<String, SpecialField> mSpecialFieldMap;
    private TreeMap<String, Integer> mDescriptorColumnMap;
    private ArrayList<String> mHeadOrTailLineList;
    private HashMap<String, byte[]> mDetails;

    public DWARFileParser(String fileName) {
        try {
            this.mReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fileName), "UTF-8"));
            BOMSkipper.skip(this.mReader);
            this.mMode = 1;
            this.init();
        }
        catch (IOException e) {
            this.mReader = null;
        }
    }

    public DWARFileParser(File file) {
        try {
            this.mReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
            BOMSkipper.skip(this.mReader);
            this.mMode = 1;
            this.init();
        }
        catch (IOException e) {
            this.mReader = null;
        }
    }

    public DWARFileParser(Reader reader) {
        try {
            this.mReader = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
            this.mMode = 1;
            this.init();
        }
        catch (IOException e) {
            this.mReader = null;
        }
    }

    public DWARFileParser(String fileName, int mode) {
        try {
            this.mReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fileName), "UTF-8"));
            BOMSkipper.skip(this.mReader);
            this.mMode = mode;
            this.init();
        }
        catch (IOException e) {
            this.mReader = null;
        }
    }

    public DWARFileParser(File file, int mode) {
        try {
            this.mReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
            BOMSkipper.skip(this.mReader);
            this.mMode = mode;
            this.init();
        }
        catch (IOException e) {
            this.mReader = null;
        }
    }

    public DWARFileParser(Reader reader, int mode) {
        try {
            this.mReader = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
            this.mMode = mode;
            this.init();
        }
        catch (IOException e) {
            this.mReader = null;
        }
    }

    private String readHeadOrTailLine() throws IOException {
        String line = this.mReader.readLine();
        if ((this.mMode & 8) != 0 && line != null) {
            this.mHeadOrTailLineList.add(line);
        }
        return line;
    }

    private void init() throws IOException {
        this.setDescriptorHandlerFactory(DescriptorHandlerStandard2DFactory.getFactory());
        if ((this.mMode & 8) != 0) {
            this.mHeadOrTailLineList = new ArrayList();
        }
        int coordinateMode = this.mMode & 7;
        String line = this.readHeadOrTailLine();
        if (line == null || !line.equals("<datawarrior-fileinfo>")) {
            throw new IOException("no header found");
        }
        this.mRecordCount = -1;
        line = this.readHeadOrTailLine();
        while (line != null && !line.equals("</datawarrior-fileinfo>")) {
            if (line.startsWith("<version")) {
                String version = this.extractValue(line);
                if (!version.startsWith("3.") && !version.equals("")) {
                    throw new IOException("unsupported .dwar file version");
                }
            } else if (line.startsWith("<rowcount")) {
                try {
                    this.mRecordCount = Integer.parseInt(this.extractValue(line));
                }
                catch (NumberFormatException version) {
                    // empty catch block
                }
            }
            line = this.readHeadOrTailLine();
        }
        line = this.readHeadOrTailLine();
        while (line != null && (line.equals("<datawarrior explanation>") || line.equals("<datawarrior macroList>"))) {
            line = this.readHeadOrTailLine();
            while (line != null && !line.equals("</datawarrior explanation>") && !line.equals("</datawarrior macroList>")) {
                line = this.readHeadOrTailLine();
            }
            line = this.readHeadOrTailLine();
        }
        this.mColumnPropertyMap = new TreeMap();
        if (line != null && line.equals("<column properties>")) {
            line = this.readHeadOrTailLine();
            Object columnName = null;
            while (line != null && !line.equals("</column properties>")) {
                if (line.startsWith("<columnName")) {
                    columnName = this.extractValue(line);
                    this.mColumnPropertyMap.put((String)columnName, new Properties());
                } else if (line.startsWith("<columnProperty")) {
                    String[] property = this.extractValue(line).split("\\t");
                    if (property.length == 1) {
                        this.mColumnPropertyMap.get(columnName).setProperty(property[0], "");
                    } else {
                        this.mColumnPropertyMap.get(columnName).setProperty(property[0], property[1]);
                    }
                }
                line = this.readHeadOrTailLine();
            }
            line = this.readHeadOrTailLine();
        }
        this.mSpecialFieldMap = new TreeMap();
        for (String columnName : this.mColumnPropertyMap.keySet()) {
            Properties properties = this.mColumnPropertyMap.get(columnName);
            String specialType = properties.getProperty("specialType");
            if (specialType == null) continue;
            this.mSpecialFieldMap.put(columnName, new SpecialField(columnName, specialType, properties.getProperty("parent"), properties.getProperty("idColumn"), properties.getProperty("version")));
        }
        ArrayList<String> columnNameList = new ArrayList<String>();
        ArrayList<Integer> columnIndexList = new ArrayList<Integer>();
        if (line == null) {
            throw new IOException("unexpected end of file");
        }
        int fromIndex = 0;
        int toIndex = 0;
        int sourceColumn = 0;
        do {
            String columnName;
            if ((toIndex = line.indexOf(9, fromIndex)) == -1) {
                columnName = line.substring(fromIndex);
            } else {
                columnName = line.substring(fromIndex, toIndex);
                fromIndex = toIndex + 1;
            }
            if (this.mSpecialFieldMap.containsKey(columnName)) {
                this.mSpecialFieldMap.get((Object)columnName).fieldIndex = sourceColumn;
            } else {
                columnNameList.add(columnName);
                columnIndexList.add(new Integer(sourceColumn));
            }
            ++sourceColumn;
        } while (toIndex != -1);
        this.mFieldName = new String[columnNameList.size()];
        this.mFieldIndex = new int[columnNameList.size()];
        for (int i = 0; i < columnNameList.size(); ++i) {
            this.mFieldName[i] = (String)columnNameList.get(i);
            this.mFieldIndex[i] = (Integer)columnIndexList.get(i);
        }
        this.mFieldData = new String[sourceColumn];
        this.mIDCodeColumn = -1;
        this.mCoordinateColumn = -1;
        this.mCoordinate2DColumn = -1;
        this.mCoordinate3DColumn = -1;
        this.mMoleculeNameColumn = -1;
        this.mFragFpColumn = -1;
        SpecialField idcodeColumn = this.mSpecialFieldMap.get("Structure");
        if (idcodeColumn == null || !idcodeColumn.type.equals("idcode")) {
            for (SpecialField specialColumn : this.mSpecialFieldMap.values()) {
                if (!specialColumn.type.equals("idcode") || idcodeColumn != null && idcodeColumn.fieldIndex <= specialColumn.fieldIndex) continue;
                idcodeColumn = specialColumn;
            }
        }
        if (idcodeColumn != null) {
            if (idcodeColumn.idColumn != null) {
                for (int i = 0; i < this.mFieldName.length; ++i) {
                    if (!idcodeColumn.idColumn.equals(this.mFieldName[i])) continue;
                    this.mMoleculeNameColumn = this.mFieldIndex[i];
                    break;
                }
            }
            this.mIDCodeColumn = idcodeColumn.fieldIndex;
            for (SpecialField specialColumn : this.mSpecialFieldMap.values()) {
                if (!idcodeColumn.name.equals(specialColumn.parent)) continue;
                if (DWARFileParser.DESCRIPTOR_FFP512.shortName.equals(specialColumn.type) && "1.2.1".equals(specialColumn.version)) {
                    this.mFragFpColumn = specialColumn.fieldIndex;
                } else if ("idcoordinates2D".equals(specialColumn.type)) {
                    this.mCoordinate2DColumn = specialColumn.fieldIndex;
                } else if ("idcoordinates3D".equals(specialColumn.type)) {
                    this.mCoordinate3DColumn = specialColumn.fieldIndex;
                    this.mCoordinate3DColumnName = specialColumn.name;
                }
                if (!DescriptorHelper.isDescriptorShortName(specialColumn.type) || !DescriptorHelper.getDescriptorInfo((String)specialColumn.type).version.equals(specialColumn.version)) continue;
                if (this.mDescriptorColumnMap == null) {
                    this.mDescriptorColumnMap = new TreeMap();
                }
                this.mDescriptorColumnMap.put(specialColumn.type, new Integer(specialColumn.fieldIndex));
            }
            if (this.mCoordinate2DColumn != -1 && (coordinateMode == 3 || coordinateMode == 1 || coordinateMode == 2 && this.mCoordinate3DColumn == -1)) {
                this.mCoordinateColumn = this.mCoordinate2DColumn;
            }
            if (this.mCoordinate3DColumn != -1 && (coordinateMode == 4 || coordinateMode == 2 || coordinateMode == 1 && this.mCoordinate2DColumn == -1)) {
                this.mCoordinateColumn = this.mCoordinate3DColumn;
            }
        }
    }

    public boolean hasStructures() {
        return this.mIDCodeColumn != -1;
    }

    public boolean hasStructureCoordinates() {
        return this.mCoordinateColumn != -1;
    }

    public boolean hasStructureCoordinates2D() {
        return this.mCoordinate2DColumn != -1;
    }

    public boolean hasStructureCoordinates3D() {
        return this.mCoordinate3DColumn != -1;
    }

    public String getStructureCoordinates3DColumnName() {
        return this.mCoordinate3DColumnName;
    }

    @Override
    public String[] getFieldNames() {
        return this.mFieldName;
    }

    public int getSpecialFieldIndex(String columnName) {
        for (SpecialField sf : this.mSpecialFieldMap.values()) {
            if (!columnName.equals(sf.name)) continue;
            return sf.fieldIndex;
        }
        return -1;
    }

    public int getChildFieldIndex(String parentColumnName, String childType) {
        for (SpecialField sf : this.mSpecialFieldMap.values()) {
            if (!parentColumnName.equals(sf.parent) || !childType.equals(sf.type)) continue;
            return sf.fieldIndex;
        }
        return -1;
    }

    @Override
    public int getRowCount() {
        return this.mRecordCount;
    }

    public ArrayList<String> getHeadOrTail() {
        return this.mHeadOrTailLineList;
    }

    public HashMap<String, byte[]> getDetails() {
        return this.mDetails;
    }

    public String getRow() {
        return this.mLine;
    }

    @Override
    protected boolean advanceToNext() {
        if (this.mReader == null) {
            return false;
        }
        this.mLine = null;
        try {
            this.mLine = this.mReader.readLine();
            if (this.mLine == null || this.mLine.equals("<datawarrior properties>") || this.mLine.equals("<hitlist data>") || this.mLine.equals("<detail data>") || this.mLine.startsWith("<data dependent properties type=\"")) {
                if ((this.mMode & 8) != 0) {
                    this.mHeadOrTailLineList.clear();
                    this.mHeadOrTailLineList.add(this.mLine);
                }
                while (this.mLine != null) {
                    if (this.mLine.equals("<detail data>") && (this.mMode & 0x10) != 0) {
                        this.extractDetails();
                    }
                    this.mLine = this.readHeadOrTailLine();
                }
                this.mReader.close();
                return false;
            }
        }
        catch (IOException e) {
            return false;
        }
        int column = 0;
        int index1 = 0;
        int index2 = this.mLine.indexOf(9);
        while (index2 != -1) {
            if (column < this.mFieldData.length) {
                this.mFieldData[column] = this.mLine.substring(index1, index2).replace("<NL>", "\n").replace("<TAB>", "\t");
            }
            ++column;
            index1 = index2 + 1;
            index2 = this.mLine.indexOf(9, index1);
        }
        if (column < this.mFieldData.length) {
            this.mFieldData[column] = this.mLine.substring(index1).replace("<NL>", "\n").replace("<TAB>", "\t");
        }
        return true;
    }

    private void extractDetails() {
        this.mDetails = new HashMap();
        try {
            String theLine;
            while ((theLine = this.readHeadOrTailLine()) != null && !theLine.equals("</detail data>")) {
                if (!theLine.startsWith("<detailID")) continue;
                String detailID = this.extractValue(theLine);
                BinaryDecoder decoder = new BinaryDecoder(this.mReader);
                int size = decoder.initialize(8);
                byte[] detailData = new byte[size];
                for (int i = 0; i < size; ++i) {
                    detailData[i] = (byte)decoder.read();
                }
                this.mDetails.put(detailID, detailData);
            }
        }
        catch (Exception e) {
            this.mDetails = null;
        }
    }

    @Override
    public String getIDCode() {
        if (this.mIDCodeColumn == -1) {
            return null;
        }
        String s = this.mFieldData[this.mIDCodeColumn];
        return s == null || s.length() == 0 ? null : s;
    }

    @Override
    public String getCoordinates() {
        if (this.mCoordinateColumn == -1) {
            return null;
        }
        String s = this.mFieldData[this.mCoordinateColumn];
        return s == null || s.length() == 0 ? null : s;
    }

    public String getCoordinates2D() {
        if (this.mCoordinate2DColumn == -1) {
            return null;
        }
        String s = this.mFieldData[this.mCoordinate2DColumn];
        return s == null || s.length() == 0 ? null : s;
    }

    public String getCoordinates3D() {
        if (this.mCoordinate3DColumn == -1) {
            return null;
        }
        String s = this.mFieldData[this.mCoordinate3DColumn];
        return s == null || s.length() == 0 ? null : s;
    }

    @Override
    public String getMoleculeName() {
        if (this.mMoleculeNameColumn == -1) {
            return null;
        }
        String s = this.mFieldData[this.mMoleculeNameColumn];
        return s == null || s.length() == 0 ? null : s;
    }

    @Override
    public Object getDescriptor(String shortName) {
        String s;
        Integer column = this.mDescriptorColumnMap == null ? null : this.mDescriptorColumnMap.get(shortName);
        String string = s = column == null ? null : this.mFieldData[column];
        return s == null || s.length() == 0 ? super.getDescriptor(shortName) : (this.getDescriptorHandlerFactory() == null ? null : this.getDescriptorHandlerFactory().getDefaultDescriptorHandler(shortName).decode(s));
    }

    public String getIndex() {
        if (this.mFragFpColumn == -1) {
            return null;
        }
        String s = this.mFieldData[this.mFragFpColumn];
        return s == null || s.length() == 0 ? null : s;
    }

    @Override
    public String getFieldData(int no) {
        return this.mFieldData[this.mFieldIndex[no]];
    }

    public TreeMap<String, SpecialField> getSpecialFieldMap() {
        return this.mSpecialFieldMap;
    }

    public String getSpecialFieldData(int fieldIndex) {
        return this.mFieldData[fieldIndex];
    }

    public Properties getColumnProperties(String columnName) {
        return this.mColumnPropertyMap.get(columnName);
    }

    private String extractValue(String theLine) {
        int index1 = theLine.indexOf("=\"") + 2;
        int index2 = theLine.indexOf("\"", index1);
        return theLine.substring(index1, index2);
    }

    public class SpecialField {
        public String name;
        public String type;
        public String parent;
        public String idColumn;
        public String version;
        public int fieldIndex;

        public SpecialField(String name, String type, String parent, String idColumn, String version) {
            this.name = name;
            this.type = type;
            this.parent = parent;
            this.idColumn = idColumn;
            this.version = version;
            this.fieldIndex = -1;
        }
    }
}

