/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.io;

import com.actelion.research.chem.AromaticityResolver;
import com.actelion.research.chem.ExtendedMolecule;
import com.actelion.research.chem.Molecule;
import com.actelion.research.chem.Molecule3D;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.io.AbstractParser;
import java.io.LineNumberReader;
import java.io.Reader;
import java.io.Writer;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;

public class Mol2FileParser
extends AbstractParser {
    public static final int iNO_CHARGES = 0;
    public static final int iDEL_RE = 1;
    public static final int iGASTEIGER = 2;
    public static final int iGAST_HUCK = 3;
    public static final int iHUCKEL = 4;
    public static final int iPULLMAN = 5;
    public static final int iGAUSS80_CHARGES = 6;
    public static final int iAMPAC_CHARGES = 7;
    public static final int iMULLIKEN_CHARGES = 8;
    public static final int iDICT_CHARGES = 9;
    public static final int iMMFF94_CHARGES = 10;
    public static final int iUSER_CHARGES = 11;
    private static final NumberFormat NF_PARTIAL_CHARGES = new DecimalFormat(" 0.0000;-0.0000");
    private static final String sNO_CHARGES = "NO_CHARGES";
    private static final String sDEL_RE = "DEL_RE";
    private static final String sGASTEIGER = "GASTEIGER";
    private static final String sGAST_HUCK = "GAST_HUCK";
    private static final String sHUCKEL = "HUCKEL";
    private static final String sPULLMAN = "PULLMAN";
    private static final String sGAUSS80_CHARGES = "GAUSS80_CHARGES";
    private static final String sAMPAC_CHARGES = "AMPAC_CHARGES";
    private static final String sMULLIKEN_CHARGES = "MULLIKEN_CHARGES";
    private static final String sDICT_CHARGES = "DICT_CHARGES";
    private static final String sMMFF94_CHARGES = "MMFF94_CHARGES";
    private static final String sUSER_CHARGES = "USER_CHARGES";
    private static HashMap<Integer, String> hmIndex_CHARGETYPE;
    private boolean isLoadHydrogen = true;

    private void addMol(List<Molecule3D> res, Molecule3D m, Set<Integer> aromaticAtoms, Set<Integer> aromaticBonds) {
        if (m == null || m.getAllAtoms() == 0) {
            return;
        }
        StereoMolecule mol = new StereoMolecule(m);
        int[] bondMap = mol.getHandleHydrogenBondMap();
        boolean j = false;
        new AromaticityResolver(mol).locateDelocalizedDoubleBonds(null, true, true);
        for (int i = 0; i < mol.getBonds(); ++i) {
            m.setBondOrder(i, mol.getBondOrder(bondMap[i]));
        }
        this.assignCharges(m);
        m.setAllAtomFlag(2, true);
        res.add(m);
    }

    private void assignCharges(Molecule3D mol) {
        for (int atom = 0; atom < mol.getAtoms(); ++atom) {
            if (mol.getAtomicNo(atom) == 7) {
                if (mol.getOccupiedValence(atom) == 4) {
                    mol.setAtomCharge(atom, 1);
                } else if (mol.getOccupiedValence(atom) == 2) {
                    mol.setAtomCharge(atom, -1);
                }
            }
            if (mol.getAtomicNo(atom) == 8) {
                if (mol.getOccupiedValence(atom) == 3) {
                    mol.setAtomCharge(atom, 1);
                } else if (mol.getOccupiedValence(atom) == 1) {
                    mol.setAtomCharge(atom, -1);
                }
            }
            if (mol.getAtomicNo(atom) != 16) continue;
            if (mol.getOccupiedValence(atom) == 3) {
                mol.setAtomCharge(atom, 1);
                continue;
            }
            if (mol.getOccupiedValence(atom) != 1) continue;
            mol.setAtomCharge(atom, -1);
        }
    }

    public static String getChargeType(int type) {
        if (hmIndex_CHARGETYPE == null) {
            hmIndex_CHARGETYPE = new HashMap();
            hmIndex_CHARGETYPE.put(0, sNO_CHARGES);
            hmIndex_CHARGETYPE.put(1, sDEL_RE);
            hmIndex_CHARGETYPE.put(2, sGASTEIGER);
            hmIndex_CHARGETYPE.put(3, sGAST_HUCK);
            hmIndex_CHARGETYPE.put(4, sHUCKEL);
            hmIndex_CHARGETYPE.put(5, sPULLMAN);
            hmIndex_CHARGETYPE.put(6, sGAUSS80_CHARGES);
            hmIndex_CHARGETYPE.put(7, sAMPAC_CHARGES);
            hmIndex_CHARGETYPE.put(8, sMULLIKEN_CHARGES);
            hmIndex_CHARGETYPE.put(9, sDICT_CHARGES);
            hmIndex_CHARGETYPE.put(10, sMMFF94_CHARGES);
            hmIndex_CHARGETYPE.put(11, sUSER_CHARGES);
        }
        return hmIndex_CHARGETYPE.get(type);
    }

    @Override
    public List<Molecule3D> loadGroup(String fileName, Reader in, int from, int to) throws Exception {
        String line;
        ArrayList<Molecule3D> res = new ArrayList<Molecule3D>();
        Molecule3D m = new Molecule3D();
        HashSet<Integer> aromaticAtoms = new HashSet<Integer>();
        HashSet<Integer> aromaticBonds = new HashSet<Integer>();
        TreeMap<Integer, Integer> nToA = new TreeMap<Integer, Integer>();
        LineNumberReader reader = new LineNumberReader(in);
        int state = 0;
        int lineNo = 0;
        int count = -1;
        while ((line = reader.readLine()) != null) {
            if (line.startsWith("@<TRIPOS>")) {
                lineNo = 0;
            }
            if (line.startsWith("@<TRIPOS>MOLECULE")) {
                state = 0;
                continue;
            }
            if (line.startsWith("@<TRIPOS>ATOM")) {
                state = 1;
                continue;
            }
            if (line.startsWith("@<TRIPOS>BOND")) {
                state = 2;
                continue;
            }
            if (line.startsWith("@<TRIPOS>")) {
                state = -1;
                continue;
            }
            ++lineNo;
            switch (state) {
                case 0: {
                    if (lineNo != 1 || from > ++count || to >= 0 && to < count) break;
                    this.addMol(res, m, aromaticAtoms, aromaticBonds);
                    m = new Molecule3D();
                    aromaticAtoms.clear();
                    aromaticBonds.clear();
                    String molName = line.trim();
                    m.setName(molName);
                    break;
                }
                case 1: {
                    StringTokenizer st;
                    try {
                        st = new StringTokenizer(line, "\t ");
                        int n = Integer.parseInt(st.nextToken().trim());
                        String atomName = st.nextToken().trim();
                        double x = Double.parseDouble(st.nextToken().trim());
                        double y = Double.parseDouble(st.nextToken().trim());
                        double z = Double.parseDouble(st.nextToken().trim());
                        String atomClass = st.hasMoreTokens() ? st.nextToken().trim() : "";
                        String chainId = st.hasMoreTokens() ? st.nextToken().trim() : "";
                        String amino = st.hasMoreTokens() ? st.nextToken().trim() : "";
                        String charge = st.hasMoreTokens() ? st.nextToken().trim() : "";
                        String elt = new StringTokenizer(atomClass, ".").nextToken();
                        boolean aromatic = atomClass.endsWith(".ar");
                        int atomicNo = Molecule.getAtomicNoFromLabel(elt);
                        if (atomicNo < 0) {
                            throw new Exception("Invalid Atomic Number for " + n + ": " + elt);
                        }
                        if (!this.isLoadHydrogen && atomicNo <= 1) break;
                        int a = m.addAtom(atomicNo);
                        m.setAtomX(a, x);
                        m.setAtomY(a, -y);
                        m.setAtomZ(a, -z);
                        m.setAtomName(a, atomName);
                        m.setAtomChainId(a, chainId);
                        m.setAtomAmino(a, amino);
                        if (aromatic) {
                            aromaticAtoms.add(a);
                        }
                        try {
                            m.setPartialCharge(a, Double.parseDouble(charge));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        nToA.put(n, a);
                        break;
                    }
                    catch (NumberFormatException e) {
                        throw new Exception("Invalid number at line " + reader.getLineNumber() + ": " + line);
                    }
                }
                case 2: {
                    int order;
                    StringTokenizer st = new StringTokenizer(line);
                    if (st.countTokens() < 3) break;
                    st.nextToken();
                    int n1 = Integer.parseInt(st.nextToken());
                    int n2 = Integer.parseInt(st.nextToken());
                    String o = st.nextToken();
                    Integer i1 = (Integer)nToA.get(n1);
                    Integer i2 = (Integer)nToA.get(n2);
                    if (i1 == null || i2 == null) break;
                    if (o.equals("ar")) {
                        order = 64;
                    } else if (o.equals("am")) {
                        order = 1;
                    } else {
                        if (o.equals("un") || o.equals("nc") || o.equals("du")) break;
                        order = Integer.parseInt(o);
                        if (order == 1) {
                            order = 1;
                        } else if (order == 2) {
                            order = 2;
                        } else if (order == 3) {
                            order = 4;
                        } else {
                            throw new RuntimeException("Unknown bond type " + order + ".");
                        }
                    }
                    int a1 = i1;
                    int a2 = i2;
                    int b = m.addBond(a1, a2, order);
                    break;
                }
            }
        }
        ++count;
        int[] bondMap = m.getHandleHydrogenBondMap();
        int[] atomMap = m.getHandleHydrogenMap();
        HashSet aromaticAtomsMapped = new HashSet();
        HashSet aromaticBondsMapped = new HashSet();
        aromaticAtoms.stream().forEach(aa -> aromaticAtomsMapped.add(atomMap[aa]));
        aromaticBonds.stream().forEach(ab -> aromaticBondsMapped.add(bondMap[ab]));
        if (from <= count && (to < 0 || to >= count)) {
            m.ensureHelperArrays(7);
            this.addMol(res, m, aromaticAtoms, aromaticBonds);
        }
        return res;
    }

    @Override
    public void save(Molecule3D mol, Writer writer) throws Exception {
        this.save(Collections.singletonList(mol), writer);
    }

    @Override
    public void save(List<Molecule3D> mols, Writer writer) throws Exception {
        this.save(mols, 0, writer);
    }

    public void save(List<Molecule3D> mols, int chargeType, Writer writer) throws Exception {
        DecimalFormat df = new DecimalFormat("0.0000");
        for (Molecule3D mol : mols) {
            int i;
            int nAtoms = 0;
            int nBonds = 0;
            for (i = 0; i < mol.getAllAtoms(); ++i) {
                if (mol.getAtomicNo(i) <= 0) continue;
                ++nAtoms;
            }
            for (i = 0; i < mol.getAllBonds(); ++i) {
                if (mol.getAtomicNo(mol.getBondAtom(0, i)) <= 0 || mol.getAtomicNo(mol.getBondAtom(1, i)) <= 0) continue;
                ++nBonds;
            }
            writer.write("@<TRIPOS>MOLECULE" + NEWLINE);
            writer.write(mol.getName() + NEWLINE);
            Mol2FileParser.writeR(writer, "" + nAtoms, 5);
            Mol2FileParser.writeR(writer, "" + nBonds, 6);
            writer.write(NEWLINE);
            writer.write("SMALL" + NEWLINE);
            writer.write(Mol2FileParser.getChargeType(chargeType) + NEWLINE);
            writer.write("@<TRIPOS>ATOM" + NEWLINE);
            for (i = 0; i < mol.getAllAtoms(); ++i) {
                if (mol.getAtomicNo(i) <= 0) continue;
                Mol2FileParser.writeR(writer, "" + (i + 1), 7);
                writer.write(" ");
                String desc = mol.getAtomName(i);
                if (desc == null || desc.length() == 0) {
                    desc = "" + ExtendedMolecule.cAtomLabel[mol.getAtomicNo(i)];
                }
                Mol2FileParser.writeL(writer, desc, 8);
                Mol2FileParser.writeR(writer, df.format(mol.getAtomX(i)), 10);
                Mol2FileParser.writeR(writer, df.format(mol.getAtomY(i)), 10);
                Mol2FileParser.writeR(writer, df.format(mol.getAtomZ(i)), 10);
                writer.write(" ");
                Mol2FileParser.writeL(writer, ExtendedMolecule.cAtomLabel[mol.getAtomicNo(i)] + (mol.isAromaticAtom(i) ? ".ar" : ""), 8);
                Mol2FileParser.writeR(writer, mol.getAtomChainId(i) != null && mol.getAtomChainId(i).length() > 0 ? mol.getAtomChainId(i) : "1", 5);
                writer.write("  ");
                Mol2FileParser.writeL(writer, mol.getAtomAmino(i) != null && mol.getAtomAmino(i).length() > 0 ? mol.getAtomAmino(i) : "1", 11);
                writer.write(NF_PARTIAL_CHARGES.format(mol.getPartialCharge(i)));
                writer.write(NEWLINE);
            }
            writer.write("@<TRIPOS>BOND" + NEWLINE);
            for (i = 0; i < mol.getAllBonds(); ++i) {
                if (mol.getAtomicNo(mol.getBondAtom(0, i)) <= 0 || mol.getAtomicNo(mol.getBondAtom(1, i)) <= 0) continue;
                Mol2FileParser.writeR(writer, "" + (i + 1), 6);
                Mol2FileParser.writeR(writer, "" + (mol.getBondAtom(0, i) + 1), 5);
                Mol2FileParser.writeR(writer, "" + (mol.getBondAtom(1, i) + 1), 5);
                writer.write(" ");
                Mol2FileParser.writeL(writer, "" + mol.getBondOrder(i), 5);
                writer.write(NEWLINE);
            }
        }
    }

    public static void main(String[] args) throws Exception {
        List<Molecule3D> res = new Mol2FileParser().loadGroup("c:/mopac11971.mol2");
        System.out.println("models=" + res.size() + " atm=" + res.get(0).getAllAtoms() + " " + res.get(0).getAtoms());
    }
}

