/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.io;

import com.actelion.research.chem.descriptor.DescriptorConstants;
import com.actelion.research.chem.io.CompoundFileParser;
import com.actelion.research.chem.io.CompoundTableConstants;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Properties;
import java.util.TreeMap;

public class ODEFileParser
extends CompoundFileParser
implements CompoundTableConstants,
DescriptorConstants {
    private BufferedReader mReader;
    private String[] mFieldName;
    private String[] mFieldData;
    private String mIDCodeColumnName;
    private String mCoordinateColumnName;
    private String mFragFpColumnName;
    private int[] mFieldIndex;
    private int mIDCodeColumn;
    private int mCoordinateColumn;
    private int mIndexColumn;
    private int mOutdatedIndexColumn;

    public ODEFileParser(String fileName) {
        try {
            this.mReader = new BufferedReader(new FileReader(fileName));
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        this.init();
    }

    public ODEFileParser(File file) {
        try {
            this.mReader = new BufferedReader(new FileReader(file));
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        this.init();
    }

    public ODEFileParser(Reader reader) {
        this.mReader = new BufferedReader(reader);
        this.init();
    }

    private void init() {
        this.mIDCodeColumn = -1;
        this.mCoordinateColumn = -1;
        this.mIndexColumn = -1;
        this.mOutdatedIndexColumn = -1;
        ArrayList<String> columnNameList = new ArrayList<String>();
        ArrayList<Integer> columnIndexList = new ArrayList<Integer>();
        String header = null;
        if (this.mReader != null) {
            try {
                header = this.mReader.readLine();
                if (header != null && header.equals("<datawarrior-fileinfo>")) {
                    header = this.mReader.readLine();
                    while (header != null && !header.equals("</datawarrior-fileinfo>")) {
                        header = this.mReader.readLine();
                    }
                    header = this.mReader.readLine();
                }
                if (header != null && header.equals("<column properties>")) {
                    TreeMap<String, Properties> columnProperties = new TreeMap<String, Properties>();
                    header = this.mReader.readLine();
                    Properties properties = null;
                    String columnName = null;
                    while (header != null && !header.equals("</column properties>")) {
                        if (header.startsWith("<columnName")) {
                            columnName = ODEFileParser.extractValue(header);
                            properties = new Properties();
                        } else if (header.startsWith("<columnProperty")) {
                            String keyAndValue = ODEFileParser.extractValue(header);
                            if (keyAndValue.equals("isIDCode\ttrue") || keyAndValue.equals("specialType\tidcode")) {
                                this.mIDCodeColumnName = columnName;
                            } else {
                                int index = keyAndValue.indexOf(9);
                                properties.put(keyAndValue.substring(0, index), keyAndValue.substring(index + 1));
                            }
                        }
                        if (!(header = this.mReader.readLine()).startsWith("<columnName") && !header.equals("</column properties>")) continue;
                        columnProperties.put(columnName, properties);
                    }
                    if (this.mIDCodeColumnName != null) {
                        for (String key : columnProperties.keySet()) {
                            Properties props = (Properties)columnProperties.get(key);
                            if ("idcoordinates2D".equals(props.get("specialType")) && this.mIDCodeColumnName.equals(props.get("parent"))) {
                                this.mCoordinateColumnName = key;
                                continue;
                            }
                            if (!ODEFileParser.DESCRIPTOR_FFP512.shortName.equals(props.get("specialType")) || !"1.2.1".equals(props.get("version")) || !this.mIDCodeColumnName.equals(props.get("parent"))) continue;
                            this.mFragFpColumnName = key;
                        }
                    }
                    header = this.mReader.readLine();
                }
            }
            catch (IOException columnProperties) {
                // empty catch block
            }
        }
        if (header == null) {
            this.mReader = null;
            return;
        }
        int fromIndex = 0;
        int toIndex = 0;
        int sourceColumn = 0;
        do {
            String columnName;
            if ((toIndex = header.indexOf(9, fromIndex)) == -1) {
                columnName = header.substring(fromIndex);
            } else {
                columnName = header.substring(fromIndex, toIndex);
                fromIndex = toIndex + 1;
            }
            if (this.mIDCodeColumn == -1 && columnName.equals(this.mIDCodeColumnName)) {
                this.mIDCodeColumn = sourceColumn;
            } else if (this.mCoordinateColumn == -1 && columnName.equals(this.mCoordinateColumnName)) {
                this.mCoordinateColumn = sourceColumn;
            } else if (this.mIndexColumn == -1 && columnName.equals(this.mFragFpColumnName)) {
                this.mIndexColumn = sourceColumn;
            } else if (columnName.equalsIgnoreCase("idcode") && this.mIDCodeColumn == -1) {
                this.mIDCodeColumn = sourceColumn;
            } else if (columnName.equalsIgnoreCase("idcoordinates") && this.mCoordinateColumn == -1) {
                this.mCoordinateColumn = sourceColumn;
            } else if (columnName.startsWith("fingerprint") && this.mIndexColumn == -1) {
                if (columnName.endsWith("1.2.1")) {
                    this.mIndexColumn = sourceColumn;
                } else {
                    this.mOutdatedIndexColumn = sourceColumn;
                }
            }
            if (sourceColumn != this.mIDCodeColumn && sourceColumn != this.mCoordinateColumn && sourceColumn != this.mIndexColumn && sourceColumn != this.mOutdatedIndexColumn) {
                columnNameList.add(columnName);
                columnIndexList.add(new Integer(sourceColumn));
            }
            ++sourceColumn;
        } while (toIndex != -1);
        this.mFieldName = new String[columnNameList.size()];
        this.mFieldIndex = new int[columnNameList.size()];
        for (int i = 0; i < columnNameList.size(); ++i) {
            this.mFieldName[i] = (String)columnNameList.get(i);
            this.mFieldIndex[i] = (Integer)columnIndexList.get(i);
        }
        this.mFieldData = new String[sourceColumn];
    }

    @Override
    public String[] getFieldNames() {
        return this.mFieldName;
    }

    @Override
    protected boolean advanceToNext() {
        return this.moreRecordsAvailable();
    }

    @Override
    public String getMoleculeName() {
        return null;
    }

    @Override
    public int getRowCount() {
        return -1;
    }

    public boolean moreRecordsAvailable() {
        if (this.mReader == null) {
            return false;
        }
        String line = null;
        try {
            line = this.mReader.readLine();
            if (line == null || line.equals("<datawarrior properties>") || line.equals("<column properties>") || line.equals("<hitlist data>") || line.equals("<detail data>")) {
                this.mReader.close();
                return false;
            }
        }
        catch (IOException e) {
            return false;
        }
        int column = 0;
        int index1 = 0;
        int index2 = line.indexOf(9);
        while (index2 != -1) {
            this.mFieldData[column] = line.substring(index1, index2);
            ++column;
            index1 = index2 + 1;
            index2 = line.indexOf(9, index1);
        }
        this.mFieldData[column] = line.substring(index1);
        return true;
    }

    @Override
    public String getIDCode() {
        if (this.mIDCodeColumn == -1) {
            return null;
        }
        String s = this.mFieldData[this.mIDCodeColumn];
        return s == null || s.length() == 0 ? null : s;
    }

    @Override
    public String getCoordinates() {
        if (this.mCoordinateColumn == -1) {
            return null;
        }
        String s = this.mFieldData[this.mCoordinateColumn];
        return s == null || s.length() == 0 ? null : s;
    }

    public String getIndex() {
        if (this.mIndexColumn == -1) {
            return null;
        }
        String s = this.mFieldData[this.mIndexColumn];
        return s == null || s.length() == 0 ? null : s;
    }

    @Override
    public String getFieldData(int no) {
        return this.mFieldData[this.mFieldIndex[no]];
    }

    public static String extractValue(String theLine) {
        int index1 = theLine.indexOf("=\"") + 2;
        int index2 = theLine.indexOf("\"", index1);
        return theLine.substring(index1, index2);
    }
}

