/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.io;

import com.actelion.research.chem.MolfileParser;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.UniqueStringList;
import com.actelion.research.chem.io.RXNFileParser;
import com.actelion.research.chem.reaction.Reaction;
import com.actelion.research.io.BOMSkipper;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.util.TreeMap;

public class RDFileParser {
    private static final int DEFAULT_RECORDS_TO_INSPECT = 1024;
    public static final String cNewLineString = "\n";
    private BufferedReader mReader;
    private String[] mFieldName;
    private String[] mFieldData;
    private int mNoOfRecords = 0;
    private String mLine;
    private String mIRegNo;
    private String mERegNo;
    private TreeMap<String, String> mDataMap;

    public RDFileParser(String fileName) {
        try {
            this.mReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fileName), "UTF-8"));
            BOMSkipper.skip(this.mReader);
            this.readHeader();
        }
        catch (IOException e) {
            this.mReader = null;
        }
    }

    public RDFileParser(File file) {
        try {
            this.mReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
            BOMSkipper.skip(this.mReader);
            this.readHeader();
        }
        catch (IOException e) {
            this.mReader = null;
        }
    }

    public RDFileParser(Reader reader) {
        this.mReader = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
        try {
            this.readHeader();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void readHeader() throws IOException {
        if (!"$RDFILE 1".equals(this.mReader.readLine()) || this.mReader.readLine() == null || (this.mLine = this.mReader.readLine()) == null) {
            this.mReader.close();
            this.mReader = null;
            return;
        }
        this.mDataMap = new TreeMap();
    }

    public boolean hasNext() {
        return this.mReader != null;
    }

    public int getRowCount() {
        return this.mNoOfRecords;
    }

    public TreeMap<String, String> getFieldData() {
        return this.mDataMap;
    }

    public String getFieldData(String key) {
        return this.mDataMap.get(key);
    }

    public String getERegNo() {
        return this.mERegNo;
    }

    public String getIRegNo() {
        return this.mIRegNo;
    }

    public Reaction getNextReaction() {
        if (this.mReader == null) {
            return null;
        }
        this.mIRegNo = null;
        this.mERegNo = null;
        Reaction rxn = null;
        this.mDataMap.clear();
        String key = null;
        while (this.mLine != null) {
            block17: {
                if (this.mLine.startsWith("$REREG ")) {
                    this.mERegNo = this.mLine.substring(7).trim();
                } else if (this.mLine.startsWith("$RIREG ")) {
                    this.mIRegNo = this.mLine.substring(7).trim();
                } else {
                    if (this.mLine.startsWith("$RFMT")) {
                        rxn = new Reaction();
                        try {
                            if (!new RXNFileParser().parse(rxn, this.mReader)) {
                                this.mReader = null;
                                return null;
                            }
                            break block17;
                        }
                        catch (Exception e) {
                            this.mReader = null;
                            return null;
                        }
                    }
                    if (this.mLine.startsWith("$DTYPE ")) {
                        key = this.mLine.substring(7).trim();
                    } else if (this.mLine.startsWith("$DATUM ") && key != null) {
                        String value = this.mLine.substring(7).trim();
                        if (value.length() != 0) {
                            this.mDataMap.put(key, value);
                        }
                        key = null;
                    }
                }
            }
            try {
                this.mLine = this.mReader.readLine();
                if (this.mLine == null) {
                    this.mReader.close();
                    this.mReader = null;
                }
            }
            catch (IOException e) {
                return null;
            }
            if (!this.isReactionNext()) continue;
        }
        ++this.mNoOfRecords;
        return rxn;
    }

    public boolean isMoleculeNext() {
        return this.mLine != null && (this.mLine.startsWith("$MFMT") || this.mLine.startsWith("$MEGEG") || this.mLine.startsWith("$MIREG"));
    }

    public boolean isReactionNext() {
        return this.mLine != null && (this.mLine.startsWith("$RFMT") || this.mLine.startsWith("$REGEG") || this.mLine.startsWith("$RIREG"));
    }

    public StereoMolecule getNextMolecule() {
        if (this.mReader == null) {
            return null;
        }
        this.mIRegNo = null;
        this.mERegNo = null;
        StereoMolecule mol = null;
        this.mDataMap.clear();
        String key = null;
        while (this.mLine != null) {
            block17: {
                if (this.mLine.startsWith("$MEREG ")) {
                    this.mERegNo = this.mLine.substring(7).trim();
                } else if (this.mLine.startsWith("$MIREG ")) {
                    this.mIRegNo = this.mLine.substring(7).trim();
                } else {
                    if (this.mLine.startsWith("$MFMT")) {
                        this.mIRegNo = this.mLine.substring(7).trim();
                        mol = new StereoMolecule();
                        try {
                            if (!new MolfileParser().parse(mol, this.mReader)) {
                                this.mReader = null;
                                return null;
                            }
                            break block17;
                        }
                        catch (Exception e) {
                            this.mReader = null;
                            return null;
                        }
                    }
                    if (this.mLine.startsWith("$DTYPE ")) {
                        key = this.mLine.substring(7).trim();
                    } else if (this.mLine.startsWith("$DATUM ") && key != null) {
                        String value = this.mLine.substring(7).trim();
                        if (value.length() != 0) {
                            this.mDataMap.put(key, value);
                        }
                        key = null;
                    }
                }
            }
            try {
                this.mLine = this.mReader.readLine();
                if (this.mLine == null) {
                    this.mReader.close();
                    this.mReader = null;
                }
            }
            catch (IOException e) {
                return null;
            }
            if (!this.isMoleculeNext()) continue;
        }
        ++this.mNoOfRecords;
        return mol;
    }

    public String[] getFieldNames() {
        if (this.mFieldName == null) {
            this.extractAllFieldNames(1024);
        }
        return this.mFieldName;
    }

    private void extractAllFieldNames(int recordsToInspect) {
        UniqueStringList fieldNameList = new UniqueStringList();
        for (int records = 0; records < recordsToInspect; ++records) {
            Serializable chem;
            Serializable serializable = chem = this.isReactionNext() ? this.getNextReaction() : this.getNextMolecule();
            if (chem == null) break;
            for (String key : this.mDataMap.keySet()) {
                fieldNameList.addString(key);
            }
        }
        this.mFieldName = fieldNameList.toArray();
    }
}

