/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.io;

import com.actelion.research.chem.MolfileCreator;
import com.actelion.research.chem.reaction.Reaction;
import com.actelion.research.chem.reaction.ReactionEncoder;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;

public class RXNFileCreator {
    public static final String RXN_CODE_TAG = "OCL_RXN_V1.0:";
    private static final String NL = System.lineSeparator();
    private StringBuffer rxnbuffer = null;

    public RXNFileCreator(Reaction rxn) {
        this(rxn, null);
    }

    public RXNFileCreator(Reaction r, String programName) {
        Reaction rxn = new Reaction(r);
        try {
            StringWriter theWriter = new StringWriter();
            theWriter.write("$RXN" + NL);
            theWriter.write(programName != null ? programName : "");
            theWriter.write(NL + NL);
            theWriter.write(RXN_CODE_TAG + ReactionEncoder.encode(r, true, 11));
            theWriter.write(NL);
            theWriter.write("  " + rxn.getReactants() + "  " + rxn.getProducts() + NL);
            double scale = this.getScalingFactor(rxn);
            for (int i = 0; i < rxn.getMolecules(); ++i) {
                theWriter.write("$MOL" + NL);
                new MolfileCreator(rxn.getMolecule(i), true, scale, null).writeMolfile(theWriter);
            }
            this.rxnbuffer = theWriter.getBuffer();
            theWriter.close();
        }
        catch (Exception e) {
            System.err.println("Error in RXNFileCreator: " + e);
        }
    }

    private double getScalingFactor(Reaction rxn) {
        double avbl = 0.0;
        int bondCount = 0;
        for (int m = 0; m < rxn.getMolecules(); ++m) {
            avbl += rxn.getMolecule(m).getAverageBondLength() * (double)rxn.getMolecule(m).getAllBonds();
            bondCount += rxn.getMolecule(m).getAllBonds();
        }
        if (bondCount != 0) {
            return (double)bondCount / avbl;
        }
        return 1.0;
    }

    public String getRXNfile() {
        return this.rxnbuffer != null ? this.rxnbuffer.toString() : null;
    }

    public void writeRXNfile(Writer theWriter) throws IOException {
        if (this.rxnbuffer == null) {
            throw new IOException("NULL RXNFileBuffer!");
        }
        theWriter.write(this.rxnbuffer.toString());
    }
}

