/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.io;

import com.actelion.research.chem.MolfileParser;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.reaction.Reaction;
import com.actelion.research.chem.reaction.ReactionEncoder;
import com.actelion.research.io.BOMSkipper;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;

public class RXNFileParser {
    private static final String RXN_V3_COUNTS_LINE = "M  V30 COUNTS";
    private static final String V30_BEGIN_REACTANT = "M  V30 BEGIN REACTANT";
    private static final String V30_BEGIN_PRODUCT = "M  V30 BEGIN PRODUCT";
    private static final String RXN_MAGIC = "$RXN";
    private static final String RXN_V3_MAGIC = "$RXN V3000";
    private static final String END_CTAB = "M  V30 END CTAB";
    private static final String END_MOL_TAG = "M  END";
    private static final String MOL_MAGIC = "$MOL";
    private static final String AUX_MOLFILE_HEADER = "\nActelion Java MolfileCreator 2.0\n\n  0  0  0  0  0  0              0 V3000\n";
    private static final int DEFAULT_CAPACITY = 32768;

    public Reaction getReaction(String buffer) throws Exception {
        return this.getReaction(buffer, false);
    }

    public Reaction getReaction(String buffer, boolean ignoreIdCode) throws Exception {
        Reaction theReaction = new Reaction();
        BufferedReader theReader = new BufferedReader(new StringReader(buffer));
        this.parse(theReaction, theReader, ignoreIdCode);
        return theReaction;
    }

    public Reaction getReaction(File file) throws Exception {
        return this.getReaction(file, false);
    }

    public Reaction getReaction(File file, boolean ignoreIdCode) throws Exception {
        Reaction theReaction = new Reaction();
        BufferedReader theReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
        BOMSkipper.skip(theReader);
        this.parse(theReaction, theReader, ignoreIdCode);
        return theReaction;
    }

    public boolean parse(Reaction theReaction, String buffer) throws Exception {
        return this.parse(theReaction, buffer, false);
    }

    public boolean parse(Reaction theReaction, String buffer, boolean ignoreIdCode) throws Exception {
        BufferedReader theReader = new BufferedReader(new StringReader(buffer));
        return this.parse(theReaction, theReader, ignoreIdCode);
    }

    public boolean parse(Reaction theReaction, File file) throws Exception {
        return this.parse(theReaction, file, false);
    }

    public boolean parse(Reaction theReaction, File file, boolean ignoreIdCode) throws Exception {
        BufferedReader theReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
        BOMSkipper.skip(theReader);
        return this.parse(theReaction, theReader, ignoreIdCode);
    }

    public boolean parse(Reaction theReaction, BufferedReader theReader) throws Exception {
        return this.parse(theReaction, theReader, false);
    }

    public boolean parse(Reaction theReaction, BufferedReader theReader, boolean ignoreIdCode) throws Exception {
        String theLine = theReader.readLine();
        boolean ok = false;
        if (theLine == null || !theLine.startsWith(RXN_MAGIC)) {
            throw new Exception("'$RXN' tag not found");
        }
        ok = theLine.equals(RXN_V3_MAGIC) ? this.parseV3(theReaction, theReader, ignoreIdCode) : this.parseV2(theReaction, theReader, ignoreIdCode);
        return ok;
    }

    private boolean parseV3(Reaction theReaction, BufferedReader theReader, boolean ignoreIdCode) throws Exception {
        String encoding;
        String name = theReader.readLine().trim();
        if (name.length() != 0) {
            theReaction.setName(name);
        }
        theReader.readLine();
        String comment = theReader.readLine();
        if (!ignoreIdCode && comment.startsWith("OCL_RXN_V1.0:") && ReactionEncoder.decode(encoding = comment.substring("OCL_RXN_V1.0:".length()), true, theReaction) != null) {
            return true;
        }
        String theLine = theReader.readLine();
        MolfileParser molParser = new MolfileParser();
        if (theLine != null && theLine.startsWith(RXN_V3_COUNTS_LINE)) {
            StringBuffer molfile;
            StereoMolecule molecule;
            int i;
            String t = theLine.substring(13).trim();
            String[] p = t.split(" ");
            int reactantCount = Integer.parseInt(p[0]);
            int productCount = Integer.parseInt(p[1]);
            if (reactantCount > 0) {
                theLine = theReader.readLine();
                if (V30_BEGIN_REACTANT.equals(theLine)) {
                    for (i = 0; i < reactantCount; ++i) {
                        molecule = new StereoMolecule();
                        molfile = new StringBuffer(32768);
                        molfile.append(AUX_MOLFILE_HEADER);
                        do {
                            theLine = theReader.readLine();
                            molfile.append(theLine);
                            molfile.append("\n");
                        } while (theLine != null && !theLine.startsWith(END_CTAB));
                        molParser.parse(molecule, molfile);
                        theReaction.addReactant(molecule);
                    }
                }
                theLine = theReader.readLine();
            }
            if (productCount > 0 && V30_BEGIN_PRODUCT.equals(theLine = theReader.readLine())) {
                for (i = 0; i < productCount; ++i) {
                    molecule = new StereoMolecule();
                    molfile = new StringBuffer(32768);
                    molfile.append(AUX_MOLFILE_HEADER);
                    do {
                        theLine = theReader.readLine();
                        molfile.append(theLine);
                        molfile.append("\n");
                    } while (theLine != null && !theLine.startsWith(END_CTAB));
                    molParser.parse(molecule, molfile);
                    theReaction.addProduct(molecule);
                }
                theLine = theReader.readLine();
            }
            return true;
        }
        return false;
    }

    private boolean parseV2(Reaction theReaction, BufferedReader theReader, boolean ignoreIdCode) throws Exception {
        StringBuffer molfile;
        int i;
        String encoding;
        String name = theReader.readLine().trim();
        if (name.length() != 0) {
            theReaction.setName(name);
        }
        theReader.readLine();
        String comment = theReader.readLine();
        if (!ignoreIdCode && comment.startsWith("OCL_RXN_V1.0:") && ReactionEncoder.decode(encoding = comment.substring("OCL_RXN_V1.0:".length()), true, theReaction) != null) {
            return true;
        }
        String theLine = theReader.readLine();
        int reactantCount = Integer.parseInt(theLine.substring(0, 3).trim());
        int productCount = Integer.parseInt(theLine.substring(3, 6).trim());
        MolfileParser molParser = new MolfileParser();
        for (i = 0; i < reactantCount; ++i) {
            theLine = theReader.readLine();
            if (theLine == null || !theLine.startsWith(MOL_MAGIC)) {
                throw new Exception("'$MOL' tag not found");
            }
            StereoMolecule reactant = new StereoMolecule();
            molfile = new StringBuffer(32768);
            do {
                theLine = theReader.readLine();
                molfile.append(theLine);
                molfile.append("\n");
            } while (theLine != null && !theLine.startsWith(END_MOL_TAG));
            if (theLine == null) {
                throw new Exception("'M  END' not found");
            }
            molParser.parse(reactant, molfile);
            theReaction.addReactant(reactant);
        }
        for (i = 0; i < productCount; ++i) {
            theLine = theReader.readLine();
            if (theLine == null || !theLine.startsWith(MOL_MAGIC)) {
                throw new Exception("'$MOL' tag not found");
            }
            StereoMolecule product = new StereoMolecule();
            molfile = new StringBuffer(32768);
            do {
                theLine = theReader.readLine();
                molfile.append(theLine);
                molfile.append("\n");
            } while (theLine != null && !theLine.startsWith(END_MOL_TAG));
            if (theLine == null) {
                throw new Exception("'M  END' not found");
            }
            molParser.parse(product, molfile);
            theReaction.addProduct(product);
        }
        return true;
    }
}

