/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.io;

import com.actelion.research.chem.MolfileParser;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.UniqueStringList;
import com.actelion.research.chem.io.CompoundFileParser;
import com.actelion.research.io.BOMSkipper;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;

public class SDFileParser
extends CompoundFileParser {
    private static final int DEFAULT_RECORDS_TO_INSPECT = 10240;
    private static final String[] cIDFieldNames = new String[]{"Idorsia No", "Actelion No", "ID", "IDNUMBER", "COMPOUND_ID", "NAME", "COMPND"};
    public static final String cNewLineString = "\n";
    private StringBuilder mMolfileBuffer;
    private StringBuilder mDataBuffer;
    private StereoMolecule mMol;
    private String[] mFieldName;
    private String[] mFieldData;
    private int mNoOfRecords = -1;
    private int mIDFieldIndex;

    public SDFileParser(String fileName) {
        this(fileName, null);
    }

    public SDFileParser(String fileName, String[] fieldName) {
        this.mFieldName = fieldName;
        try {
            this.mReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fileName), "UTF-8"));
            BOMSkipper.skip(this.mReader);
        }
        catch (IOException e) {
            this.mReader = null;
        }
        this.init();
    }

    public SDFileParser(File file) {
        this(file, null);
    }

    public SDFileParser(File file, String[] fieldName) {
        this.mFieldName = fieldName;
        try {
            this.mReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
            BOMSkipper.skip(this.mReader);
        }
        catch (IOException e) {
            this.mReader = null;
        }
        this.init();
    }

    public SDFileParser(Reader reader) {
        this(reader, null);
    }

    public SDFileParser(Reader reader, String[] fieldName) {
        this.mFieldName = fieldName;
        this.mReader = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
        this.init();
    }

    private void init() {
        this.mMolfileBuffer = new StringBuilder(10240);
        this.mDataBuffer = new StringBuilder(10240);
    }

    private void extractAllFieldNames(int recordsToInspect) {
        int records = 0;
        UniqueStringList fieldNameList = new UniqueStringList();
        while (records < recordsToInspect) {
            String fieldName;
            String line;
            try {
                line = this.mReader.readLine();
            }
            catch (IOException e) {
                if (records >= recordsToInspect) break;
                this.mNoOfRecords = records;
                break;
            }
            if (line == null) {
                if (records >= recordsToInspect) break;
                this.mNoOfRecords = records;
                break;
            }
            if (line.startsWith("$$$$")) {
                ++records;
            }
            if (!line.startsWith(">") || (fieldName = this.extractFieldName(line)) == null) continue;
            fieldNameList.addString(fieldName);
        }
        try {
            this.mReader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.mFieldName = fieldNameList.toArray();
    }

    @Override
    public int getRowCount() {
        return this.mNoOfRecords;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean advanceToNext() {
        String line;
        if (this.mReader == null) {
            return false;
        }
        this.mMolfileBuffer.setLength(0);
        this.mDataBuffer.setLength(0);
        this.mMol = null;
        boolean molfileComplete = false;
        int fieldIndex = -1;
        String fieldName = null;
        this.mFieldData = this.mFieldName == null ? null : new String[this.mFieldName.length];
        this.mIDFieldIndex = -1;
        block2: do {
            block14: {
                try {
                    line = this.mReader.readLine();
                    if (line == null) {
                        this.mMolfileBuffer.setLength(0);
                        this.mReader.close();
                        return false;
                    }
                }
                catch (IOException e) {
                    this.mMolfileBuffer.setLength(0);
                    return false;
                }
                if (!molfileComplete) {
                    if (line.startsWith(">")) {
                        molfileComplete = true;
                        this.mMolfileBuffer.append("M  END");
                        this.mMolfileBuffer.append('\n');
                        this.mDataBuffer.append(line);
                        this.mDataBuffer.append('\n');
                        break block14;
                    } else {
                        this.mMolfileBuffer.append(line);
                        this.mMolfileBuffer.append('\n');
                        if (!line.startsWith("M  END")) continue;
                        molfileComplete = true;
                        continue;
                    }
                }
                this.mDataBuffer.append(line);
                this.mDataBuffer.append('\n');
            }
            if (this.mFieldName == null) continue;
            if (line.length() == 0) {
                fieldIndex = -1;
                continue;
            }
            if (fieldIndex == -1) {
                fieldName = this.extractFieldName(line);
                if (fieldName == null) continue;
                fieldIndex = -1;
            } else {
                if (this.mFieldData[fieldIndex] == null) {
                    this.mFieldData[fieldIndex] = line;
                    continue;
                }
                this.mFieldData[fieldIndex] = this.mFieldData[fieldIndex].concat(cNewLineString).concat(line);
                continue;
            }
            for (int field = 0; field < this.mFieldName.length; ++field) {
                if (!fieldName.equals(this.mFieldName[field])) continue;
                fieldIndex = field;
                break;
            }
            if (this.mIDFieldIndex != -1) continue;
            for (String idName : cIDFieldNames) {
                if (!fieldName.equals(idName)) continue;
                this.mIDFieldIndex = fieldIndex;
                continue block2;
            }
        } while (!line.startsWith("$$$$"));
        return true;
    }

    @Override
    public StereoMolecule getMolecule() {
        if (this.mMol != null) {
            return this.mMol;
        }
        this.mMol = new MolfileParser().getCompactMolecule(this.getNextMolFile());
        if (this.mMol != null && (this.mMol.getName() == null || this.mMol.getName().length() == 0)) {
            this.mMol.setName(this.getMoleculeName());
        }
        return this.mMol;
    }

    @Override
    public String getMoleculeName() {
        return this.mIDFieldIndex != -1 && this.mFieldData != null ? this.mFieldData[this.mIDFieldIndex] : (this.mMol != null ? this.mMol.getName() : null);
    }

    public String getNextMolFile() {
        String molfile = this.mMolfileBuffer.toString();
        return molfile;
    }

    public String getNextFieldData() {
        String fieldData = this.mDataBuffer.toString();
        return fieldData;
    }

    @Override
    public String[] getFieldNames() {
        if (this.mFieldName == null) {
            this.extractAllFieldNames(10240);
        }
        return this.mFieldName;
    }

    public String[] getFieldNames(int recordsToInspect) {
        if (this.mFieldName == null) {
            this.extractAllFieldNames(recordsToInspect);
        }
        return this.mFieldName;
    }

    @Override
    public String getFieldData(int index) {
        if (this.mFieldData == null) {
            return null;
        }
        return this.mFieldData[index];
    }

    protected String extractFieldName(String line) {
        int i;
        int index;
        if (line.length() == 0 || line.charAt(0) != '>') {
            return null;
        }
        int openBracket = 0;
        int closeBracket = 0;
        for (index = 1; index < line.length(); ++index) {
            if (line.charAt(index) == '<') {
                if (openBracket != 0) {
                    return null;
                }
                openBracket = index;
                continue;
            }
            if (line.charAt(index) != '>') continue;
            if (closeBracket != 0) {
                return null;
            }
            closeBracket = index;
        }
        if (openBracket != 0 && openBracket < closeBracket) {
            return line.substring(openBracket + 1, closeBracket);
        }
        index = line.indexOf("DT", 1);
        if (index == -1) {
            return null;
        }
        for (i = index + 2; line.length() > i && Character.isDigit(line.charAt(i)); ++i) {
        }
        return i == index + 2 ? null : line.substring(index, i);
    }
}

