/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.mcs;

import com.actelion.research.chem.ExtendedMoleculeFunctions;
import com.actelion.research.chem.RingCollection;
import com.actelion.research.chem.SSSearcher;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.util.datamodel.IntVec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;

public class MCS {
    public static final int PAR_CLEAVE_RINGS = 0;
    public static final int PAR_KEEP_RINGS = 1;
    public static final int PAR_KEEP_AROMATIC_RINGS = 2;
    private static final boolean DEBUG = false;
    private static final int CAPACITY = 1200;
    private StereoMolecule mol;
    private StereoMolecule frag;
    private HashSet<IntVec> hsIndexFragCandidates;
    private HashSet<IntVec> hsIndexFragGarbage;
    private HashSet<IntVec> hsIndexFragSolution;
    private SSSearcher sss;
    private ComparatorBitsSet comparatorBitsSet;
    private StereoMolecule molMCS;
    private boolean considerAromaticRings = false;
    private boolean considerRings = false;
    private List<IntVec> liMCSSolutions;
    private HashMap<Integer, List<int[]>> hmRingBnd_ListRingBnds;
    private HashMap<Integer, List<int[]>> hmAromaticRingBnd_ListRingBnds;
    private RingCollection ringCollection;
    boolean[] excluded = null;
    private int[] arrMatchListFrag2Mol;

    public MCS() {
        this(0, null);
    }

    public MCS(int ringStatus) {
        this(ringStatus, null);
    }

    public MCS(int ringStatus, SSSearcher searcher) {
        switch (ringStatus) {
            case 0: {
                break;
            }
            case 1: {
                this.considerRings = true;
                break;
            }
            case 2: {
                this.considerAromaticRings = true;
                break;
            }
        }
        this.hsIndexFragCandidates = new HashSet(1200);
        this.hsIndexFragGarbage = new HashSet(1200);
        this.hsIndexFragSolution = new HashSet(1200);
        this.liMCSSolutions = new ArrayList<IntVec>(1200);
        this.sss = searcher == null ? new SSSearcher() : searcher;
        this.comparatorBitsSet = new ComparatorBitsSet();
        this.hmRingBnd_ListRingBnds = new HashMap();
        this.hmAromaticRingBnd_ListRingBnds = new HashMap();
    }

    public void setSSSearcher(SSSearcher sss) {
        this.sss = sss;
    }

    public void set(StereoMolecule mol, StereoMolecule frag) {
        this.set(mol, frag, null);
    }

    public void set(StereoMolecule mol, StereoMolecule frag, boolean[] excluded) {
        StereoMolecule fragBiggestSub = new StereoMolecule(frag);
        fragBiggestSub.ensureHelperArrays(7);
        fragBiggestSub.stripSmallFragments();
        fragBiggestSub.ensureHelperArrays(7);
        this.mol = mol;
        this.frag = fragBiggestSub;
        this.excluded = excluded;
        this.init();
    }

    private void init() {
        this.hsIndexFragCandidates.clear();
        this.hsIndexFragGarbage.clear();
        this.hsIndexFragSolution.clear();
        this.liMCSSolutions.clear();
        this.hmRingBnd_ListRingBnds.clear();
        this.hmAromaticRingBnd_ListRingBnds.clear();
        this.initCandidates();
    }

    private void initCandidates() {
        this.ringCollection = this.frag.getRingSet();
        int rings = this.ringCollection.getSize();
        for (int i = 0; i < rings; ++i) {
            List<int[]> li;
            int j;
            int[] arrIndexBnd = this.ringCollection.getRingBonds(i);
            for (j = 0; j < arrIndexBnd.length; ++j) {
                if (!this.hmRingBnd_ListRingBnds.containsKey(arrIndexBnd[j])) {
                    this.hmRingBnd_ListRingBnds.put(arrIndexBnd[j], new ArrayList());
                }
                li = this.hmRingBnd_ListRingBnds.get(arrIndexBnd[j]);
                li.add(arrIndexBnd);
            }
            if (!this.ringCollection.isAromatic(i)) continue;
            for (j = 0; j < arrIndexBnd.length; ++j) {
                if (!this.hmAromaticRingBnd_ListRingBnds.containsKey(arrIndexBnd[j])) {
                    this.hmAromaticRingBnd_ListRingBnds.put(arrIndexBnd[j], new ArrayList());
                }
                li = this.hmAromaticRingBnd_ListRingBnds.get(arrIndexBnd[j]);
                li.add(arrIndexBnd);
            }
        }
        int nInts = (int)((double)this.frag.getBonds() / 32.0 + 0.96875);
        for (int i = 0; i < this.frag.getBonds(); ++i) {
            IntVec iv = new IntVec(nInts);
            this.setBitAndAddRelatedRingBonds(i, iv);
            this.hsIndexFragCandidates.add(iv);
        }
    }

    private void setBitAndAddRelatedRingBonds(int bit, IntVec iv) {
        if (!this.considerAromaticRings && !this.considerRings) {
            iv.setBit(bit);
        } else if (this.considerRings) {
            iv.setBit(bit);
            if (this.hmRingBnd_ListRingBnds.containsKey(bit)) {
                List<int[]> li = this.hmRingBnd_ListRingBnds.get(bit);
                for (int i = 0; i < li.size(); ++i) {
                    int[] a = li.get(i);
                    for (int j = 0; j < a.length; ++j) {
                        iv.setBit(a[j]);
                    }
                }
            }
        } else if (this.considerAromaticRings) {
            iv.setBit(bit);
            if (this.hmAromaticRingBnd_ListRingBnds.containsKey(bit)) {
                List<int[]> li = this.hmAromaticRingBnd_ListRingBnds.get(bit);
                for (int i = 0; i < li.size(); ++i) {
                    int[] a = li.get(i);
                    for (int j = 0; j < a.length; ++j) {
                        iv.setBit(a[j]);
                    }
                }
            }
        }
        iv.calculateHashCode();
    }

    private List<IntVec> getAllSolutionsForCommonSubstructures() {
        this.sss.setMolecule(this.mol);
        this.frag.setFragment(true);
        this.sss.setFragment(this.frag);
        try {
            if (this.sss.findFragmentInMolecule(4, 4, this.excluded) > 0) {
                this.molMCS = this.frag;
                ArrayList<IntVec> liIndexFragCandidates = new ArrayList<IntVec>(this.hsIndexFragCandidates);
                if (liIndexFragCandidates != null && !liIndexFragCandidates.isEmpty()) {
                    IntVec iv = (IntVec)liIndexFragCandidates.get(0);
                    iv.setBits(0, iv.sizeBits());
                    iv.calculateHashCode();
                    ArrayList<IntVec> li = new ArrayList<IntVec>();
                    li.add(iv);
                    return li;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        int maxSizeCandidates = 0;
        while (!this.hsIndexFragCandidates.isEmpty()) {
            ArrayList<IntVec> liIndexFragCandidates = new ArrayList<IntVec>(this.hsIndexFragCandidates);
            Collections.sort(liIndexFragCandidates, this.comparatorBitsSet);
            IntVec iv = (IntVec)liIndexFragCandidates.get(liIndexFragCandidates.size() - 1);
            this.hsIndexFragCandidates.remove(iv);
            StereoMolecule fragSub = MCS.getSubFrag(this.frag, iv);
            this.sss.setFragment(fragSub);
            if (this.sss.findFragmentInMolecule(4, 8, this.excluded) > 0) {
                this.hsIndexFragSolution.add(iv);
                this.removeAllSubSolutions(iv);
                if (iv.getBitsSet() != this.frag.getBonds()) {
                    List<IntVec> liIV = this.getAllPlusOneAtomCombinations(iv, this.frag);
                    for (IntVec ivPlus : liIV) {
                        if (this.hsIndexFragGarbage.contains(ivPlus) || this.hsIndexFragSolution.contains(ivPlus)) continue;
                        this.hsIndexFragCandidates.add(ivPlus);
                    }
                }
                if (maxSizeCandidates >= this.hsIndexFragCandidates.size()) continue;
                maxSizeCandidates = this.hsIndexFragCandidates.size();
                continue;
            }
            this.hsIndexFragGarbage.add(iv);
        }
        if (this.hsIndexFragSolution.size() == 0) {
            return null;
        }
        return MCS.getFinalSolutionSet(this.hsIndexFragSolution);
    }

    public LinkedList<StereoMolecule> getAllCommonSubstructures() {
        List<IntVec> liIndexFragSolution = this.getAllSolutionsForCommonSubstructures();
        if (liIndexFragSolution == null) {
            return null;
        }
        Collections.sort(liIndexFragSolution, this.comparatorBitsSet);
        IntVec ivMCS = liIndexFragSolution.get(liIndexFragSolution.size() - 1);
        this.molMCS = MCS.getSubFrag(this.frag, ivMCS);
        ArrayList<StereoMolecule> li = new ArrayList<StereoMolecule>();
        for (IntVec iv : liIndexFragSolution) {
            li.add(MCS.getSubFrag(this.frag, iv));
        }
        return ExtendedMoleculeFunctions.removeSubStructures(li);
    }

    public StereoMolecule getMCS() {
        List<IntVec> liIndexFragSolution = this.getAllSolutionsForCommonSubstructures();
        if (liIndexFragSolution == null) {
            return null;
        }
        Collections.sort(liIndexFragSolution, this.comparatorBitsSet);
        IntVec ivMCS = liIndexFragSolution.get(liIndexFragSolution.size() - 1);
        this.molMCS = MCS.getSubFrag(this.frag, ivMCS);
        return this.molMCS;
    }

    public boolean[][] getMCSBondArray(boolean[] arrBondMCSMol, boolean[] arrBondFrag) {
        boolean[][] arrBondMol_Result = new boolean[2][];
        List<IntVec> liIndexFragSolution = this.getAllSolutionsForCommonSubstructures();
        if (liIndexFragSolution == null) {
            return null;
        }
        Collections.sort(liIndexFragSolution, this.comparatorBitsSet);
        IntVec ivMCSLargest = liIndexFragSolution.get(liIndexFragSolution.size() - 1);
        int bonds = this.frag.getBonds();
        if (arrBondFrag == null) {
            arrBondFrag = new boolean[bonds];
        } else {
            Arrays.fill(arrBondFrag, false);
        }
        for (int i = 0; i < bonds; ++i) {
            if (!ivMCSLargest.isBitSet(i)) continue;
            arrBondFrag[i] = true;
        }
        StereoMolecule fragSub = MCS.getSubFrag(this.frag, ivMCSLargest);
        this.sss.setFragment(fragSub);
        this.arrMatchListFrag2Mol = null;
        if (this.sss.findFragmentInMolecule(4, 8, this.excluded) > 0) {
            ArrayList<int[]> liMatchSubFrag2Mol = this.sss.getMatchList();
            this.arrMatchListFrag2Mol = this.getMappedMatchListFrag2Mol(fragSub, liMatchSubFrag2Mol.get(0));
            int bondsMol = this.mol.getBonds();
            if (arrBondMCSMol == null) {
                arrBondMCSMol = new boolean[bondsMol];
            } else {
                Arrays.fill(arrBondMCSMol, false);
            }
            this.getBondArrayMolecule(this.arrMatchListFrag2Mol, arrBondFrag, arrBondMCSMol);
        }
        arrBondMol_Result[0] = arrBondMCSMol;
        arrBondMol_Result[1] = arrBondFrag;
        return arrBondMol_Result;
    }

    public int[] getArrMatchListFrag2Mol() {
        return this.arrMatchListFrag2Mol;
    }

    private int[] getMappedMatchListFrag2Mol(StereoMolecule fragSub, int[] arrMatchListSubFrag2Mol) {
        int i;
        int[] arrMatchListFrag2Mol = new int[this.frag.getAtoms()];
        this.sss.setMol(fragSub, this.frag);
        this.sss.findFragmentInMolecule(4, 8, null);
        ArrayList<int[]> liMatchSubFrag2Mol = this.sss.getMatchList();
        int[] arrMatchListSubFrag2Frag = liMatchSubFrag2Mol.get(0);
        HashMap<Integer, Integer> hmIndexSubFrag_IndexFrag = new HashMap<Integer, Integer>();
        for (i = 0; i < arrMatchListSubFrag2Frag.length; ++i) {
            hmIndexSubFrag_IndexFrag.put(i, arrMatchListSubFrag2Frag[i]);
        }
        i = 0;
        while (i < arrMatchListSubFrag2Mol.length) {
            int indexAtSubFragment = i++;
            int indexAtFragment = (Integer)hmIndexSubFrag_IndexFrag.get(indexAtSubFragment);
            arrMatchListFrag2Mol[indexAtFragment] = arrMatchListSubFrag2Mol[indexAtSubFragment];
        }
        return arrMatchListFrag2Mol;
    }

    private boolean[] getBondArrayMolecule(int[] arrMatchFragment2Mol, boolean[] arrBondMCSFrag, boolean[] arrBondMCSMol) {
        for (int i = 0; i < arrMatchFragment2Mol.length; ++i) {
            int indexAtFrag = i;
            int indexAtMol = arrMatchFragment2Mol[i];
            int nConn2Frag = this.frag.getConnAtoms(indexAtFrag);
            for (int j = 0; j < nConn2Frag; ++j) {
                int indexAtMolConn;
                int indexBondMol;
                int indexAtFragConn = this.frag.getConnAtom(indexAtFrag, j);
                int indexBondFrag = this.frag.getBond(indexAtFrag, indexAtFragConn);
                if (!arrBondMCSFrag[indexBondFrag] || (indexBondMol = this.mol.getBond(indexAtMol, indexAtMolConn = arrMatchFragment2Mol[indexAtFragConn])) <= -1) continue;
                arrBondMCSMol[indexBondMol] = true;
            }
        }
        return arrBondMCSMol;
    }

    private static StereoMolecule getSubFrag(StereoMolecule frag, IntVec iv) {
        boolean[] isFragmentAtom = new boolean[frag.getAtoms()];
        int atoms = 0;
        int bonds = frag.getBonds();
        for (int bond = 0; bond < bonds; ++bond) {
            if (!iv.isBitSet(bond)) continue;
            for (int i = 0; i < 2; ++i) {
                int atom = frag.getBondAtom(i, bond);
                if (isFragmentAtom[atom]) continue;
                isFragmentAtom[atom] = true;
                ++atoms;
            }
        }
        StereoMolecule fragSubBonds = new StereoMolecule(atoms, bonds);
        fragSubBonds.setFragment(true);
        frag.copyMoleculeByAtoms(fragSubBonds, isFragmentAtom, true, null);
        fragSubBonds.ensureHelperArrays(7);
        return fragSubBonds;
    }

    private List<IntVec> getAllPlusOneAtomCombinations(IntVec iv, StereoMolecule frag) {
        int indexAt2;
        int indexAt1;
        int i;
        int bonds = frag.getBonds();
        ArrayList<IntVec> liIntVec = new ArrayList<IntVec>();
        HashSet<Integer> hsAtomIndex = new HashSet<Integer>();
        for (i = 0; i < bonds; ++i) {
            if (!iv.isBitSet(i)) continue;
            indexAt1 = frag.getBondAtom(0, i);
            indexAt2 = frag.getBondAtom(1, i);
            hsAtomIndex.add(indexAt1);
            hsAtomIndex.add(indexAt2);
        }
        for (i = 0; i < bonds; ++i) {
            if (iv.isBitSet(i)) continue;
            indexAt1 = frag.getBondAtom(0, i);
            indexAt2 = frag.getBondAtom(1, i);
            if (!hsAtomIndex.contains(indexAt1) && !hsAtomIndex.contains(indexAt2)) continue;
            IntVec ivPlus = new IntVec(iv.get());
            this.setBitAndAddRelatedRingBonds(i, ivPlus);
            liIntVec.add(ivPlus);
        }
        return liIntVec;
    }

    private void removeAllSubSolutions(IntVec ivSolution) {
        ArrayList<IntVec> liIndexFragSolution = new ArrayList<IntVec>(this.hsIndexFragCandidates);
        for (IntVec ivCandidate : liIndexFragSolution) {
            if (!MCS.isCandidateInSolution(ivSolution, ivCandidate)) continue;
            this.hsIndexFragCandidates.remove(ivCandidate);
        }
    }

    private static List<IntVec> getFinalSolutionSet(HashSet<IntVec> hsIndexFragSolution) {
        ArrayList<IntVec> liIndexFragSolution = new ArrayList<IntVec>(hsIndexFragSolution);
        block0: for (int i = liIndexFragSolution.size() - 1; i >= 0; --i) {
            IntVec ivCandidate = (IntVec)liIndexFragSolution.get(i);
            for (int j = 0; j < liIndexFragSolution.size(); ++j) {
                IntVec ivSolution = (IntVec)liIndexFragSolution.get(j);
                if (i == j || !MCS.isCandidateInSolution(ivSolution, ivCandidate)) continue;
                liIndexFragSolution.remove(i);
                continue block0;
            }
        }
        return liIndexFragSolution;
    }

    private static final boolean isCandidateInSolution(IntVec ivSolution, IntVec ivCandidate) {
        IntVec iv = IntVec.OR(ivSolution, ivCandidate);
        return iv.equals(ivSolution);
    }

    public double getScore() {
        double sc = 0.0;
        double nBndsFrag = this.frag.getBonds();
        double nBndsMol = this.mol.getBonds();
        double nBndsMCS = this.molMCS.getBonds();
        sc = nBndsMCS / Math.max(nBndsFrag, nBndsMol);
        return sc;
    }

    public boolean isConsiderAromaticRings() {
        return this.considerAromaticRings;
    }

    public boolean isConsiderRings() {
        return this.considerRings;
    }

    private static class ComparatorBitsSet
    implements Comparator<IntVec> {
        private ComparatorBitsSet() {
        }

        @Override
        public int compare(IntVec iv1, IntVec iv2) {
            int bits2;
            int bits1 = iv1.getBitsSet();
            if (bits1 > (bits2 = iv2.getBitsSet())) {
                return 1;
            }
            if (bits1 < bits2) {
                return -1;
            }
            return 0;
        }
    }
}

