/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.reaction;

import com.actelion.research.chem.SSSearcher;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.mcs.MCS;
import com.actelion.research.chem.reaction.Reaction;

public class CommonSubGraphHelper {
    public static Result getMCS(Reaction reaction, boolean[] exclude, SSSearcher sss) {
        MCS mcs = new MCS(0, sss);
        return CommonSubGraphHelper.getCommonSubGraph(mcs, reaction, exclude);
    }

    private static Result getCommonSubGraph(MCS mcs, Reaction reaction, boolean[] exclude) {
        Result ret = null;
        try {
            int rn = reaction.getReactants();
            int pn = reaction.getProducts();
            StereoMolecule res = null;
            int resReactantIndex = -1;
            int resProductIndex = -1;
            int max = 0;
            for (int r = 0; r < rn; ++r) {
                StereoMolecule reactant = reaction.getReactant(r);
                for (int p = 0; p < pn; ++p) {
                    int na;
                    StereoMolecule product = reaction.getProduct(p);
                    mcs.set(product, reactant, exclude);
                    StereoMolecule m = mcs.getMCS();
                    if (m == null || max >= (na = m.getAllAtoms())) continue;
                    res = m;
                    resReactantIndex = r;
                    resProductIndex = p;
                    max = na;
                }
            }
            if (res != null) {
                ret = new Result(res, resReactantIndex, resProductIndex);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    static class Result {
        private StereoMolecule molecule;
        private int reactant;
        private int product;

        public Result(StereoMolecule m, int rI, int pI) {
            this.setMolecule(m);
            this.setReactant(rI);
            this.setProduct(pI);
        }

        public String toString() {
            return "MCS Result: R=" + this.getReactant() + " P=" + this.getProduct() + " #Atoms=" + this.getMolecule().getAllAtoms();
        }

        public StereoMolecule getMolecule() {
            return this.molecule;
        }

        public void setMolecule(StereoMolecule molecule) {
            this.molecule = molecule;
        }

        public int getReactant() {
            return this.reactant;
        }

        public void setReactant(int reactant) {
            this.reactant = reactant;
        }

        public int getProduct() {
            return this.product;
        }

        public void setProduct(int product) {
            this.product = product;
        }
    }
}

