/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.reaction;

import com.actelion.research.chem.RingCollection;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.reaction.ClassificationData;
import java.util.TreeMap;

public class FunctionalGroupClassifier {
    private StereoMolecule mMol;
    private TreeMap<Integer, Integer> mFunctionalGroupCountMap;

    public FunctionalGroupClassifier(StereoMolecule mol) {
        this.mMol = mol;
        this.mMol.ensureHelperArrays(15);
    }

    public TreeMap<Integer, Integer> getFunctionGroupCountMap() {
        if (this.mFunctionalGroupCountMap == null) {
            this.classifyFunctionalGroups();
        }
        return this.mFunctionalGroupCountMap;
    }

    public int[][] getOrganicFunctionalGroupCounts() {
        if (this.mFunctionalGroupCountMap == null) {
            this.classifyFunctionalGroups();
        }
        int[][] v = new int[this.mFunctionalGroupCountMap.size()][2];
        int index = 0;
        for (Integer key : this.mFunctionalGroupCountMap.keySet()) {
            v[index][0] = key;
            v[index][1] = this.mFunctionalGroupCountMap.get(key).byteValue();
            ++index;
        }
        return v;
    }

    public static int getFunctionalGroupEquivalenceLevel(int fg1, int fg2) {
        if (fg1 == fg2) {
            return 0;
        }
        int mask = 1;
        for (int i = 1; i < 8; ++i) {
            if (FunctionalGroupClassifier.nodeExists(fg1, i) || FunctionalGroupClassifier.nodeExists(fg2, i)) {
                return -1;
            }
            if ((fg1 |= mask) == (fg2 |= mask)) {
                return i;
            }
            mask *= 2;
        }
        return -1;
    }

    private static boolean nodeExists(int fgID, int level) {
        return ClassificationData.getInstance().getEFGName(fgID, 8 - level) != null;
    }

    private void classifyFunctionalGroups() {
        int atm;
        this.mFunctionalGroupCountMap = new TreeMap();
        for (atm = 0; atm < this.mMol.getAtoms(); ++atm) {
            this.mMol.setAtomMarker(atm, this.mMol.getAtomicNo(atm) != 6 || this.getAtomPi(atm) != 0 || this.mMol.isAtomStereoCenter(atm));
        }
        for (int i = 0; i < this.mMol.getRingSet().getSize(); ++i) {
            int j;
            if (this.mMol.getRingSet().getRingSize(i) != 3) continue;
            int[] ringAtom = this.mMol.getRingSet().getRingAtoms(i);
            boolean heteroFound = false;
            for (j = 0; j < 3; ++j) {
                if (this.mMol.getAtomicNo(ringAtom[j]) == 6) continue;
                heteroFound = true;
            }
            if (!heteroFound) {
                // empty if block
            }
            for (j = 0; j < 3; ++j) {
                this.mMol.setAtomMarker(ringAtom[j], true);
            }
        }
        for (atm = 0; atm < this.mMol.getAtoms(); ++atm) {
            if (!this.mMol.isMarkedAtom(atm) || !this.mMol.isMetalAtom(atm)) continue;
            this.classMet(atm);
        }
        for (atm = 0; atm < this.mMol.getAtoms(); ++atm) {
            if (!this.mMol.isMarkedAtom(atm) || this.mMol.getAtomicNo(atm) != 5) continue;
            this.storeEClass(this.classB(atm));
        }
        for (atm = 0; atm < this.mMol.getAtoms(); ++atm) {
            if (!this.mMol.isMarkedAtom(atm) || this.mMol.getAtomicNo(atm) != 14) continue;
            this.storeEClass(this.classSi(atm));
        }
        for (atm = 0; atm < this.mMol.getAtoms(); ++atm) {
            if (!this.mMol.isMarkedAtom(atm) || !this.mMol.isElectronegative(atm)) continue;
            if (this.mMol.getConnAtoms(atm) == 1) {
                int connAtm;
                if (this.mMol.getConnBondOrder(atm, 0) != 2 || this.mMol.getAtomicNo(connAtm = this.mMol.getConnAtom(atm, 0)) != 6) continue;
                this.storeEClass(this.classCX(atm, connAtm));
                continue;
            }
            if (this.mMol.getAtomicNo(atm) != 7) continue;
            for (int i = 0; i < this.mMol.getConnAtoms(atm); ++i) {
                int connAtm;
                if (this.mMol.getConnBondOrder(atm, i) != 2 || this.mMol.getAtomicNo(connAtm = this.mMol.getConnAtom(atm, i)) != 6) continue;
                this.storeEClass(this.classCX(atm, connAtm));
            }
        }
        for (atm = 0; atm < this.mMol.getAtoms(); ++atm) {
            if (this.mMol.getAtomicNo(atm) != 33 || !this.mMol.isMarkedAtom(atm)) continue;
            this.storeEClass(this.classAs(atm));
        }
        for (atm = 0; atm < this.mMol.getAtoms(); ++atm) {
            if (this.mMol.getAtomicNo(atm) != 52 || !this.mMol.isMarkedAtom(atm)) continue;
            this.storeEClass(this.classTe(atm));
        }
        for (atm = 0; atm < this.mMol.getAtoms(); ++atm) {
            if (this.mMol.getAtomicNo(atm) != 34 || !this.mMol.isMarkedAtom(atm)) continue;
            this.storeEClass(this.classSe(atm));
        }
        for (atm = 0; atm < this.mMol.getAtoms(); ++atm) {
            if (this.mMol.getAtomicNo(atm) != 15 || !this.mMol.isMarkedAtom(atm)) continue;
            this.storeEClass(this.classP(atm));
        }
        for (atm = 0; atm < this.mMol.getAtoms(); ++atm) {
            if (this.mMol.getAtomicNo(atm) != 16 || !this.mMol.isMarkedAtom(atm)) continue;
            this.storeEClass(this.classS(atm));
        }
        for (atm = 0; atm < this.mMol.getAtoms(); ++atm) {
            if (this.mMol.getAtomicNo(atm) != 53 || !this.mMol.isMarkedAtom(atm)) continue;
            this.storeEClass(this.classI(atm));
        }
        for (atm = 0; atm < this.mMol.getAtoms(); ++atm) {
            if (this.mMol.getAtomicNo(atm) != 35 || !this.mMol.isMarkedAtom(atm)) continue;
            this.storeEClass(this.classBr(atm));
        }
        for (atm = 0; atm < this.mMol.getAtoms(); ++atm) {
            if (this.mMol.getAtomicNo(atm) != 17 || !this.mMol.isMarkedAtom(atm)) continue;
            this.storeEClass(this.classCl(atm));
        }
        for (atm = 0; atm < this.mMol.getAtoms(); ++atm) {
            if (this.mMol.getAtomicNo(atm) != 9 || !this.mMol.isMarkedAtom(atm)) continue;
            this.storeEClass(this.classF(atm));
        }
        for (atm = 0; atm < this.mMol.getAtoms(); ++atm) {
            if (this.mMol.getAtomicNo(atm) != 7 || !this.mMol.isMarkedAtom(atm)) continue;
            this.storeEClass(this.classN(atm));
        }
        for (atm = 0; atm < this.mMol.getAtoms(); ++atm) {
            if (this.mMol.getAtomicNo(atm) != 8 || !this.mMol.isMarkedAtom(atm)) continue;
            this.storeEClass(this.classO(atm));
        }
        for (atm = 0; atm < this.mMol.getAtoms(); ++atm) {
            if (this.mMol.getAtomicNo(atm) != 6 || !this.mMol.isMarkedAtom(atm)) continue;
            this.storeEClass(this.classC(atm));
        }
    }

    private void classMet(int atm) {
        int[] carbon = new int[16];
        int nrofCarbs = this.getCarbons(atm, carbon);
        this.mMol.setAtomMarker(atm, false);
        if (nrofCarbs > 1) {
            for (int i = 0; i < nrofCarbs; ++i) {
                this.classCMet(carbon[i], atm);
            }
        } else if (nrofCarbs == 1) {
            this.classCMet(carbon[0], atm);
        }
    }

    private void classCMet(int carbon, int metal) {
        byte[] metClass = new byte[]{-2, -2, -2, 0, 8, -2, -2, -2, -2, -2, -2, 4, 8, 16, -2, -2, -2, -2, -2, 4, 12, 40, 48, 52, 52, 56, 56, 56, 56, 32, 36, 20, 24, -2, -2, -2, -2, 4, 12, 40, 48, 52, 52, -2, 60, 60, 60, 32, 36, 20, 24, 28, -2, -2, -2, 4, 12, 40, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 48, 52, 52, 60, 60, 60, 60, 32, 36, 20, 24, 28, -2, -2, -2, -2, -2, 40, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44};
        int eClass = metClass[this.mMol.getAtomicNo(metal)];
        if (eClass == -2) {
            this.storeEClass(-2);
            return;
        }
        if (this.getAtomZ(carbon) != 0) {
            eClass += 2;
        }
        if (this.mMol.isAllylicAtom(carbon)) {
            ++eClass;
        }
        this.storeEClass(eClass);
    }

    private int classB(int atm) {
        int[] hetAtm = new int[16];
        this.mMol.setAtomMarker(atm, false);
        if (this.getAtomPi(atm) != 0) {
            return -2;
        }
        if (this.mMol.getAtomCharge(atm) == -1) {
            int nrofHets = this.getHeteros(atm, hetAtm, -1);
            if (nrofHets != this.getAtomZ(atm)) {
                return -2;
            }
            switch (nrofHets) {
                case 4: {
                    return 71;
                }
                case 3: {
                    if (this.getAtomSigma(atm) != 0) {
                        return 70;
                    }
                    return 64;
                }
                case 2: {
                    if (this.getAtomSigma(atm) == 2) {
                        return 69;
                    }
                    return 64;
                }
                case 1: {
                    if (this.getAtomSigma(atm) == 3) {
                        return 68;
                    }
                    return 65;
                }
            }
            if (this.getAtomSigma(atm) == 4) {
                return 67;
            }
            return 66;
        }
        if (this.mMol.getAtomCharge(atm) != 0) {
            return -2;
        }
        int nrofHets = this.getHeteros(atm, hetAtm, -1);
        if (nrofHets != this.getAtomZ(atm)) {
            return 87;
        }
        if (this.mMol.getConnAtoms(atm) - this.getAtomZ(atm) - this.getAtomSigma(atm) != 0) {
            return 79;
        }
        switch (nrofHets) {
            case 3: {
                if (this.mMol.getAtomicNo(hetAtm[0]) == this.mMol.getAtomicNo(hetAtm[1]) && this.mMol.getAtomicNo(hetAtm[1]) == this.mMol.getAtomicNo(hetAtm[2])) {
                    if (this.mMol.getAtomicNo(hetAtm[0]) == 7) {
                        return 84;
                    }
                    if (this.mMol.getAtomicNo(hetAtm[0]) == 8) {
                        return 85;
                    }
                }
                return 86;
            }
            case 2: {
                if (this.mMol.getConnAtoms(atm) < 3) {
                    if (this.mMol.getAtomicNo(hetAtm[0]) == this.mMol.getAtomicNo(hetAtm[1])) {
                        if (this.mMol.getAtomicNo(hetAtm[0]) == 7) {
                            return 76;
                        }
                        if (this.mMol.getAtomicNo(hetAtm[0]) == 8) {
                            return 77;
                        }
                    }
                    return 78;
                }
                int connAtm = -1;
                for (int i = 0; i < this.mMol.getConnAtoms(atm) && this.mMol.isElectronegative(connAtm = this.mMol.getConnAtom(atm, i)); ++i) {
                }
                if (this.getAtomSigma(atm) != 0) {
                    if (this.mMol.getAtomicNo(hetAtm[0]) == this.mMol.getAtomicNo(hetAtm[1])) {
                        switch (this.mMol.getAtomicNo(hetAtm[0])) {
                            case 7: {
                                return 92;
                            }
                            case 8: {
                                if (this.mMol.isAromaticAtom(connAtm)) {
                                    return 88;
                                }
                                if (this.getAtomPi(connAtm) != 0) {
                                    return 89;
                                }
                                if (this.mMol.isAllylicAtom(connAtm)) {
                                    return 90;
                                }
                                return 91;
                            }
                        }
                    }
                    return 93;
                }
                return -2;
            }
            case 1: {
                if (this.mMol.getConnAtoms(atm) == 1) {
                    return 75;
                }
                if (this.mMol.getConnAtoms(atm) == 2) {
                    return 74;
                }
                if (this.mMol.getConnAtoms(atm) != 3) break;
                switch (this.mMol.getAtomicNo(hetAtm[0])) {
                    case 7: {
                        return 80;
                    }
                    case 8: {
                        return 81;
                    }
                    case 16: {
                        return 82;
                    }
                }
                return 83;
            }
        }
        switch (this.getAtomSigma(atm)) {
            case 3: {
                return 94;
            }
            case 2: {
                return 72;
            }
        }
        return 73;
    }

    private int classSi(int atm) {
        int[] hetAtm = new int[16];
        this.mMol.setAtomMarker(atm, false);
        if (this.getAtomPi(atm) != 0) {
            return -2;
        }
        boolean alkinyl = false;
        boolean aryl = false;
        boolean vinyl = false;
        boolean acyl = false;
        boolean allyl = false;
        for (int i = 0; i < this.mMol.getConnAtoms(atm); ++i) {
            int connAtm = this.mMol.getConnAtom(atm, i);
            if (this.mMol.getAtomicNo(connAtm) != 6) continue;
            if (this.getAtomPi(connAtm) == 2) {
                alkinyl = true;
                continue;
            }
            if (this.mMol.isAromaticAtom(connAtm)) {
                aryl = true;
                continue;
            }
            if (this.getAtomPi(connAtm) == 1) {
                vinyl = true;
                continue;
            }
            if (this.getAtomZ(connAtm) > 1) {
                for (int j = 0; j < this.mMol.getConnAtoms(connAtm); ++j) {
                    int nextConn = this.mMol.getConnAtom(connAtm, j);
                    if (this.mMol.getAtomicNo(nextConn) != 8 || this.mMol.getConnBondOrder(connAtm, j) != 2) continue;
                    acyl = true;
                }
            }
            if (acyl || !this.mMol.isAllylicAtom(connAtm)) continue;
            allyl = true;
        }
        if (this.getAtomZ(atm) == 0) {
            switch (this.getAtomSigma(atm)) {
                case 4: {
                    if (acyl) {
                        return 180;
                    }
                    if (alkinyl) {
                        return 176;
                    }
                    if (vinyl) {
                        return 177;
                    }
                    if (allyl) {
                        return 179;
                    }
                    if (aryl) {
                        return 178;
                    }
                    return 181;
                }
                case 3: {
                    return 160;
                }
                case 2: {
                    return 161;
                }
            }
            return 162;
        }
        if (this.getAtomZ(atm) == 1) {
            int betaCs = 0;
            for (int i = 0; i < this.mMol.getConnAtoms(atm); ++i) {
                int connAtm = this.mMol.getConnAtom(atm, i);
                if (this.mMol.isElectronegative(connAtm)) {
                    hetAtm[0] = connAtm;
                    continue;
                }
                betaCs += this.getAtomSigma(connAtm);
            }
            switch (this.getAtomSigma(atm)) {
                case 3: {
                    if (this.mMol.getAtomicNo(hetAtm[0]) == 8) {
                        switch (betaCs) {
                            case 0: {
                                return 136;
                            }
                            case 1: {
                                return 137;
                            }
                            case 2: {
                                return 138;
                            }
                            case 3: {
                                return 139;
                            }
                            case 4: {
                                return 140;
                            }
                            case 5: {
                                return 141;
                            }
                            case 6: {
                                return 142;
                            }
                        }
                        return 143;
                    }
                    if (this.mMol.getAtomicNo(hetAtm[0]) == 7) {
                        switch (betaCs) {
                            case 0: {
                                return 128;
                            }
                            case 1: {
                                return 129;
                            }
                            case 2: {
                                return 130;
                            }
                            case 3: {
                                return 131;
                            }
                            case 4: {
                                return 132;
                            }
                            case 5: {
                                return 133;
                            }
                            case 6: {
                                return 134;
                            }
                        }
                        return 135;
                    }
                    switch (this.mMol.getAtomicNo(hetAtm[0])) {
                        case 15: {
                            return 152;
                        }
                        case 16: {
                            return 153;
                        }
                    }
                    return 154;
                }
                case 2: {
                    if (this.mMol.getAtomicNo(hetAtm[0]) == 8) {
                        return 164;
                    }
                    return 165;
                }
            }
            if (this.mMol.getAtomicNo(hetAtm[0]) == 8) {
                return 166;
            }
            return 167;
        }
        if (this.getAtomZ(atm) == 2) {
            if (this.getHeteros(atm, hetAtm, -1) != 2) {
                return -2;
            }
            switch (this.getAtomSigma(atm)) {
                case 2: {
                    if (this.mMol.getAtomicNo(hetAtm[0]) == this.mMol.getAtomicNo(hetAtm[1])) {
                        switch (this.mMol.getAtomicNo(hetAtm[0])) {
                            case 7: {
                                return 145;
                            }
                            case 8: {
                                return 144;
                            }
                            case 16: {
                                return 146;
                            }
                        }
                    }
                    return 147;
                }
            }
            if (this.mMol.getAtomicNo(hetAtm[0]) == this.mMol.getAtomicNo(hetAtm[1])) {
                switch (this.mMol.getAtomicNo(hetAtm[0])) {
                    case 7: {
                        return 169;
                    }
                    case 8: {
                        return 168;
                    }
                    case 16: {
                        return 170;
                    }
                }
            }
            return 171;
        }
        if (this.getAtomZ(atm) == 3) {
            if (this.getHeteros(atm, hetAtm, -1) != 3) {
                return -2;
            }
            switch (this.getAtomSigma(atm)) {
                case 1: {
                    if (this.mMol.getAtomicNo(hetAtm[0]) == 8 && this.mMol.getAtomicNo(hetAtm[1]) == 8 && this.mMol.getAtomicNo(hetAtm[2]) == 8) {
                        return 148;
                    }
                    return 149;
                }
            }
            if (this.mMol.getAtomicNo(hetAtm[0]) == 8 && this.mMol.getAtomicNo(hetAtm[1]) == 8 && this.mMol.getAtomicNo(hetAtm[2]) == 8) {
                return 172;
            }
            return 173;
        }
        if (this.getAtomZ(atm) == 4) {
            if (this.getHeteros(atm, hetAtm, -1) != 4) {
                return -2;
            }
            if (this.mMol.getAtomicNo(hetAtm[0]) == 8 && this.mMol.getAtomicNo(hetAtm[1]) == 8 && this.mMol.getAtomicNo(hetAtm[2]) == 8 && this.mMol.getAtomicNo(hetAtm[3]) == 8) {
                return 150;
            }
            return 151;
        }
        return -1;
    }

    private int classCX(int atm, int carbonylC) {
        int nextCarbon;
        int nrofHets;
        int[] carbon = new int[16];
        int[] hetAtm = new int[16];
        if (this.bondToMet(carbonylC)) {
            return -1;
        }
        if (this.mMol.getAtomicNo(atm) == 7) {
            if (this.mMol.isAromaticAtom(atm)) {
                return -1;
            }
            if (!this.bondToMet(atm)) {
                nrofHets = this.getHeteros(atm, hetAtm, -1);
                if (this.mMol.getAtomCharge(atm) == 1) {
                    if (this.mMol.getConnAtoms(atm) == 1) {
                        this.storeEClass(532);
                    } else {
                        switch (this.getAtomZ(atm)) {
                            case 2: {
                                if (nrofHets == 1) {
                                    this.storeEClass(516);
                                    break;
                                }
                                if (this.mMol.getAtomicNo(hetAtm[0]) == 8 && this.mMol.getAtomicNo(hetAtm[1]) == 8) {
                                    for (int i = 0; i < 2; ++i) {
                                        if (this.mMol.getConnAtoms(hetAtm[i]) != 1) continue;
                                        this.mMol.setAtomMarker(hetAtm[i], false);
                                    }
                                    this.storeEClass(534);
                                    break;
                                }
                                this.storeEClass(535);
                                break;
                            }
                            case 1: {
                                if (this.mMol.getAtomicNo(hetAtm[0]) == 8) {
                                    if (this.mMol.getConnAtoms(hetAtm[0]) == 1) {
                                        this.mMol.setAtomMarker(hetAtm[0], false);
                                    }
                                    this.storeEClass(524);
                                    break;
                                }
                                this.storeEClass(525);
                                break;
                            }
                            default: {
                                this.storeEClass(533);
                                break;
                            }
                        }
                    }
                } else if (this.mMol.getConnAtoms(atm) == 1) {
                    this.storeEClass(592);
                } else if (nrofHets != 0) {
                    if (this.hasDBondToHetero(hetAtm[0])) {
                        this.storeEClass(601);
                    } else if (this.mMol.getAtomicNo(hetAtm[0]) == 7) {
                        if (this.getAtomPi(hetAtm[0]) != 0) {
                            this.storeEClass(604);
                        } else {
                            this.storeEClass(605);
                        }
                    } else if (this.mMol.getAtomicNo(hetAtm[0]) == 8) {
                        if (this.mMol.getConnAtoms(hetAtm[0]) == 1) {
                            this.mMol.setAtomMarker(hetAtm[0], false);
                            this.storeEClass(606);
                        } else {
                            this.storeEClass(607);
                        }
                    } else {
                        this.storeEClass(602);
                    }
                } else {
                    nextCarbon = this.getNextConn(atm, carbonylC);
                    if (this.mMol.isAromaticAtom(nextCarbon)) {
                        this.storeEClass(599);
                    } else if (this.hasDBondToHetero(nextCarbon)) {
                        this.storeEClass(600);
                    } else if (this.getAtomPi(nextCarbon) != 0) {
                        if (this.getAtomSigma(nextCarbon) == 2) {
                            this.storeEClass(596);
                        } else {
                            this.storeEClass(597);
                        }
                    } else if (this.getAtomZ(nextCarbon) > 1) {
                        this.storeEClass(598);
                    } else if (this.getAtomSigma(nextCarbon) > 1) {
                        this.storeEClass(594);
                    } else {
                        this.storeEClass(595);
                    }
                }
            }
        }
        this.mMol.setAtomMarker(atm, false);
        if (this.getAtomPi(carbonylC) != 0) {
            int nextCarbon2 = this.getNextConn(carbonylC, atm);
            this.mMol.setAtomMarker(carbonylC, false);
            this.mMol.setAtomMarker(nextCarbon2, false);
            switch (this.mMol.getAtomicNo(atm)) {
                case 7: {
                    return 536;
                }
                case 8: {
                    return 537;
                }
                case 16: {
                    return 538;
                }
            }
            return 539;
        }
        nrofHets = this.getHeteros(carbonylC, hetAtm, atm);
        switch (this.mMol.getAtomicNo(atm)) {
            case 7: {
                int temp;
                switch (this.getAtomZ(carbonylC)) {
                    case 4: {
                        if (nrofHets == 1) {
                            if (this.mMol.getAtomicNo(hetAtm[0]) == 7) {
                                return 542;
                            }
                            if (this.mMol.getAtomicNo(hetAtm[0]) == 8 || this.mMol.getAtomicNo(hetAtm[0]) == 16) {
                                return -1;
                            }
                            return 543;
                        }
                        if (this.mMol.getAtomicNo(hetAtm[0]) > this.mMol.getAtomicNo(hetAtm[1])) {
                            temp = hetAtm[0];
                            hetAtm[0] = hetAtm[1];
                            hetAtm[1] = temp;
                        }
                        if (this.mMol.getAtomicNo(hetAtm[0]) == 7) {
                            switch (this.mMol.getAtomicNo(hetAtm[1])) {
                                case 7: {
                                    return 560;
                                }
                                case 8: {
                                    return 561;
                                }
                                case 16: {
                                    return 562;
                                }
                            }
                            return 563;
                        }
                        if (this.mMol.getAtomicNo(hetAtm[0]) == 8) {
                            switch (this.mMol.getAtomicNo(hetAtm[1])) {
                                case 8: {
                                    return 564;
                                }
                                case 16: {
                                    return 565;
                                }
                            }
                            return 566;
                        }
                        if (this.mMol.getAtomicNo(hetAtm[0]) == 16 && this.mMol.getAtomicNo(hetAtm[1]) == 16) {
                            return 568;
                        }
                        if (this.mMol.getAtomicNo(hetAtm[0]) == 16 || this.mMol.getAtomicNo(hetAtm[1]) == 16) {
                            return 569;
                        }
                        return 570;
                    }
                    case 3: {
                        if (this.checkAnhydride(hetAtm[0], carbonylC)) {
                            if (this.getAtomSigma(carbonylC) != 0) {
                                switch (this.mMol.getAtomicNo(hetAtm[0])) {
                                    case 7: {
                                        return 544;
                                    }
                                    case 8: {
                                        return 545;
                                    }
                                    case 16: {
                                        return 546;
                                    }
                                }
                                return 547;
                            }
                            switch (this.mMol.getAtomicNo(hetAtm[0])) {
                                case 7: {
                                    return 552;
                                }
                                case 8: {
                                    return 553;
                                }
                                case 16: {
                                    return 554;
                                }
                            }
                            return 555;
                        }
                        if (this.getAtomSigma(carbonylC) != 0) {
                            switch (this.mMol.getAtomicNo(hetAtm[0])) {
                                case 7: {
                                    return 548;
                                }
                                case 8: {
                                    return 549;
                                }
                                case 16: {
                                    return 550;
                                }
                            }
                            return 551;
                        }
                        switch (this.mMol.getAtomicNo(hetAtm[0])) {
                            case 7: {
                                return 556;
                            }
                            case 8: {
                                return 557;
                            }
                            case 16: {
                                return 558;
                            }
                        }
                        return 559;
                    }
                }
                if (this.getAtomSigma(carbonylC) == 2) {
                    if (this.mMol.isAllylicAtom(carbonylC)) {
                        return 572;
                    }
                    return 573;
                }
                if (this.getAtomSigma(carbonylC) == 1) {
                    if (this.mMol.isAllylicAtom(carbonylC)) {
                        return 574;
                    }
                    return 575;
                }
                return 468;
            }
            case 8: {
                int temp;
                switch (this.getAtomZ(carbonylC)) {
                    case 4: {
                        if (nrofHets == 1) {
                            this.mMol.setAtomMarker(hetAtm[0], false);
                            return 540;
                        }
                        if (this.mMol.getAtomicNo(hetAtm[0]) > this.mMol.getAtomicNo(hetAtm[1])) {
                            temp = hetAtm[0];
                            hetAtm[0] = hetAtm[1];
                            hetAtm[1] = temp;
                        }
                        if (this.mMol.getAtomicNo(hetAtm[0]) == 7) {
                            switch (this.mMol.getAtomicNo(hetAtm[1])) {
                                case 7: {
                                    return 640;
                                }
                                case 8: {
                                    return 641;
                                }
                                case 16: {
                                    return 642;
                                }
                            }
                            return 643;
                        }
                        if (this.mMol.getAtomicNo(hetAtm[0]) == 8) {
                            switch (this.mMol.getAtomicNo(hetAtm[1])) {
                                case 8: {
                                    return 644;
                                }
                                case 16: {
                                    return 645;
                                }
                            }
                            return 646;
                        }
                        if (this.mMol.getAtomicNo(hetAtm[0]) == 16 && this.mMol.getAtomicNo(hetAtm[1]) == 16) {
                            return 648;
                        }
                        if (this.mMol.getAtomicNo(hetAtm[0]) == 16 || this.mMol.getAtomicNo(hetAtm[1]) == 16) {
                            return 649;
                        }
                        return 650;
                    }
                    case 3: {
                        if (this.checkAnhydride(hetAtm[0], carbonylC)) {
                            if (this.getAtomSigma(carbonylC) != 0) {
                                switch (this.mMol.getAtomicNo(hetAtm[0])) {
                                    case 7: {
                                        return 656;
                                    }
                                    case 8: {
                                        return 657;
                                    }
                                    case 16: {
                                        return 658;
                                    }
                                }
                                return 659;
                            }
                            switch (this.mMol.getAtomicNo(hetAtm[0])) {
                                case 7: {
                                    return 664;
                                }
                                case 8: {
                                    return 665;
                                }
                                case 16: {
                                    return 666;
                                }
                            }
                            return 667;
                        }
                        if (this.getAtomSigma(carbonylC) != 0) {
                            switch (this.mMol.getAtomicNo(hetAtm[0])) {
                                case 7: {
                                    return 660;
                                }
                                case 8: {
                                    return 661;
                                }
                                case 16: {
                                    return 662;
                                }
                            }
                            return 663;
                        }
                        switch (this.mMol.getAtomicNo(hetAtm[0])) {
                            case 7: {
                                return 668;
                            }
                            case 8: {
                                return 669;
                            }
                            case 16: {
                                return 670;
                            }
                        }
                        return 671;
                    }
                }
                if (this.getAtomSigma(carbonylC) == 2) {
                    if (this.isQuinone(carbonylC)) {
                        return 188;
                    }
                    if (this.getCarbons(carbonylC, carbon) != 2) {
                        return -2;
                    }
                    if (this.mMol.isAromaticAtom(carbon[0]) && this.mMol.isAromaticAtom(carbon[1])) {
                        return 688;
                    }
                    nextCarbon = -1;
                    if (this.mMol.isAromaticAtom(carbon[0])) {
                        nextCarbon = carbon[1];
                    }
                    if (this.mMol.isAromaticAtom(carbon[1])) {
                        nextCarbon = carbon[0];
                    }
                    if (nextCarbon != -1) {
                        if (this.getAtomPi(nextCarbon) != 0) {
                            return 672;
                        }
                        switch (this.getAtomZ(nextCarbon)) {
                            case 3: {
                                return 684;
                            }
                            case 2: {
                                return 685;
                            }
                            case 1: {
                                if (this.getAtomSigma(nextCarbon) == 3) {
                                    return 686;
                                }
                                return 687;
                            }
                        }
                        if (this.getAtomSigma(nextCarbon) == 4) {
                            return 690;
                        }
                        return 691;
                    }
                    if (this.getAtomPi(carbon[0]) != 0 && this.getAtomPi(carbon[1]) != 0) {
                        return 673;
                    }
                    nextCarbon = -1;
                    if (this.getAtomPi(carbon[0]) != 0) {
                        nextCarbon = carbon[1];
                    }
                    if (this.getAtomPi(carbon[1]) != 0) {
                        nextCarbon = carbon[0];
                    }
                    if (nextCarbon != -1) {
                        switch (this.getAtomZ(nextCarbon)) {
                            case 3: {
                                return 676;
                            }
                            case 2: {
                                return 677;
                            }
                            case 1: {
                                if (this.getAtomSigma(nextCarbon) == 3) {
                                    return 678;
                                }
                                return 679;
                            }
                        }
                        if (this.getAtomSigma(nextCarbon) == 4) {
                            return 674;
                        }
                        return 675;
                    }
                    int allSigma = this.getAtomSigma(carbon[0]) + this.getAtomSigma(carbon[1]);
                    int allZ = this.getAtomZ(carbon[0]) + this.getAtomZ(carbon[1]);
                    if (allZ > 4) {
                        return 680;
                    }
                    if (allZ > 2) {
                        return 681;
                    }
                    if (allZ != 0) {
                        if (allSigma + allZ > 6) {
                            return 682;
                        }
                        return 683;
                    }
                    if (allSigma > 6) {
                        return 692;
                    }
                    return 693;
                }
                if (this.getAtomSigma(carbonylC) == 1) {
                    nextCarbon = this.getNextConn(carbonylC, atm);
                    if (this.mMol.isAromaticAtom(nextCarbon)) {
                        return 432;
                    }
                    if (this.getAtomPi(nextCarbon) == 2) {
                        return 435;
                    }
                    if (this.getAtomPi(nextCarbon) != 0) {
                        return 434;
                    }
                    switch (this.getAtomZ(nextCarbon)) {
                        case 3: {
                            return 440;
                        }
                        case 2: {
                            if (this.getAtomSigma(nextCarbon) == 1) {
                                return 443;
                            }
                            return 442;
                        }
                        case 1: {
                            if (this.getAtomSigma(nextCarbon) == 1) {
                                return 444;
                            }
                            if (this.getAtomSigma(nextCarbon) == 2) {
                                return 445;
                            }
                            return 446;
                        }
                    }
                    if (this.getAtomSigma(nextCarbon) < 3) {
                        return 439;
                    }
                    if (this.getAtomSigma(nextCarbon) == 3) {
                        return 438;
                    }
                    return 436;
                }
                return 469;
            }
            case 15: {
                return 102;
            }
            case 16: {
                int temp;
                switch (this.getAtomZ(carbonylC)) {
                    case 4: {
                        if (nrofHets == 1) {
                            this.mMol.setAtomMarker(hetAtm[0], false);
                            return 541;
                        }
                        if (this.mMol.getAtomicNo(hetAtm[0]) > this.mMol.getAtomicNo(hetAtm[1])) {
                            temp = hetAtm[0];
                            hetAtm[0] = hetAtm[1];
                            hetAtm[1] = temp;
                        }
                        if (this.mMol.getAtomicNo(hetAtm[0]) == 7) {
                            switch (this.mMol.getAtomicNo(hetAtm[1])) {
                                case 7: {
                                    return 704;
                                }
                                case 8: {
                                    return 705;
                                }
                                case 16: {
                                    return 706;
                                }
                            }
                            return 707;
                        }
                        if (this.mMol.getAtomicNo(hetAtm[0]) == 8) {
                            switch (this.mMol.getAtomicNo(hetAtm[1])) {
                                case 8: {
                                    return 708;
                                }
                                case 16: {
                                    return 709;
                                }
                            }
                            return 710;
                        }
                        if (this.mMol.getAtomicNo(hetAtm[0]) == 16 && this.mMol.getAtomicNo(hetAtm[1]) == 16) {
                            return 712;
                        }
                        if (this.mMol.getAtomicNo(hetAtm[0]) == 16 || this.mMol.getAtomicNo(hetAtm[1]) == 16) {
                            return 713;
                        }
                        return 714;
                    }
                    case 3: {
                        if (this.getAtomSigma(carbonylC) != 0) {
                            switch (this.mMol.getAtomicNo(hetAtm[0])) {
                                case 7: {
                                    return 720;
                                }
                                case 8: {
                                    return 721;
                                }
                                case 16: {
                                    return 722;
                                }
                            }
                            return 723;
                        }
                        switch (this.mMol.getAtomicNo(hetAtm[0])) {
                            case 7: {
                                return 724;
                            }
                            case 8: {
                                return 725;
                            }
                            case 16: {
                                return 726;
                            }
                        }
                        return 727;
                    }
                }
                if (this.getAtomSigma(carbonylC) == 2) {
                    if (this.mMol.isAllylicAtom(carbonylC)) {
                        return 716;
                    }
                    return 717;
                }
                if (this.getAtomSigma(carbonylC) == 1) {
                    if (this.mMol.isAllylicAtom(carbonylC)) {
                        return 718;
                    }
                    return 719;
                }
                return 470;
            }
            case 34: {
                switch (this.getAtomZ(carbonylC)) {
                    case 4: {
                        return 412;
                    }
                    case 3: {
                        if (this.getAtomSigma(carbonylC) != 0) {
                            return 410;
                        }
                        return 411;
                    }
                }
                if (this.getAtomSigma(carbonylC) == 2) {
                    return 408;
                }
                return 409;
            }
        }
        return -2;
    }

    private int classAs(int atm) {
        this.mMol.setAtomMarker(atm, false);
        if (this.getAtomSigma(atm) == 0) {
            switch (this.getAtomZ(atm)) {
                case 3: {
                    return 120;
                }
                case 5: {
                    return 121;
                }
            }
            return 122;
        }
        if (this.getAtomSigma(atm) == 1) {
            switch (this.getAtomZ(atm)) {
                case 0: {
                    return 124;
                }
                case 2: {
                    return 125;
                }
                case 4: {
                    return 126;
                }
            }
            return 127;
        }
        return 123;
    }

    private int classTe(int atm) {
        this.mMol.setAtomMarker(atm, false);
        if (this.getAtomSigma(atm) == 0) {
            switch (this.getAtomZ(atm)) {
                case 2: {
                    return 248;
                }
                case 4: {
                    return 249;
                }
                case 6: {
                    return 250;
                }
            }
            return 251;
        }
        if (this.getAtomSigma(atm) == 1) {
            switch (this.getAtomZ(atm)) {
                case 1: {
                    return 244;
                }
                case 3: {
                    return 245;
                }
                case 5: {
                    return 246;
                }
            }
            return 247;
        }
        if (this.getAtomSigma(atm) == 2) {
            switch (this.getAtomZ(atm)) {
                case 0: {
                    return 252;
                }
                case 2: {
                    return 253;
                }
                case 4: {
                    return 254;
                }
            }
            return 255;
        }
        return -1;
    }

    private int classSe(int atm) {
        int[] carbon = new int[16];
        int[] hetAtm = new int[16];
        this.mMol.setAtomMarker(atm, false);
        int nrofCarbs = this.getCarbons(atm, carbon);
        for (int i = 0; i < nrofCarbs; ++i) {
            this.classCSe(carbon[i]);
        }
        if (this.getAtomZ(atm) == 0) {
            if (this.getAtomSigma(atm) == 2) {
                return 414;
            }
            return 415;
        }
        int[] tripleBnds = new int[1];
        int[] doubleBnds = new int[1];
        int nrofHets = this.getSortedHeteros(atm, hetAtm, tripleBnds, doubleBnds, -1);
        if (tripleBnds[0] != 0) {
            return -2;
        }
        if (this.getAtomZ(atm) == 1) {
            if (this.getAtomSigma(atm) == 1) {
                switch (this.mMol.getAtomicNo(hetAtm[0])) {
                    case 8: {
                        if (this.mMol.getConnAtoms(hetAtm[0]) == 1) {
                            this.mMol.setAtomMarker(hetAtm[0], false);
                            return 384;
                        }
                        return 385;
                    }
                    case 17: {
                        this.mMol.setAtomMarker(hetAtm[0], false);
                        return 386;
                    }
                    case 34: {
                        if (this.mMol.getConnAtoms(hetAtm[0]) == 1) {
                            this.mMol.setAtomMarker(hetAtm[0], false);
                            return 388;
                        }
                        if (this.getAtomZ(hetAtm[0]) == 1) {
                            return 389;
                        }
                        return 390;
                    }
                }
                return 387;
            }
            return 391;
        }
        if (this.getAtomZ(atm) == 2) {
            if (nrofHets == 1 && this.mMol.getAtomicNo(hetAtm[0]) == 8 && this.getAtomSigma(atm) == 2) {
                this.mMol.setAtomMarker(hetAtm[0], false);
                return 392;
            }
            return 393;
        }
        if (this.getAtomZ(atm) == 3) {
            if (nrofHets == 2 && this.mMol.getAtomicNo(hetAtm[0]) == 8 && this.getAtomSigma(atm) == 1) {
                this.mMol.setAtomMarker(hetAtm[0], false);
                if (this.mMol.getAtomicNo(hetAtm[1]) == 8) {
                    if (this.mMol.getConnAtoms(hetAtm[1]) == 1) {
                        this.mMol.setAtomMarker(hetAtm[1], false);
                        return 400;
                    }
                    return 401;
                }
                return 402;
            }
            return 403;
        }
        if (this.getAtomZ(atm) == 4) {
            if (nrofHets == 2 && this.mMol.getAtomicNo(hetAtm[0]) == 8 && this.mMol.getAtomicNo(hetAtm[1]) == 8 && this.getAtomSigma(atm) == 2) {
                this.mMol.setAtomMarker(hetAtm[0], false);
                this.mMol.setAtomMarker(hetAtm[1], false);
                return 396;
            }
            if (nrofHets == 3 && this.mMol.getAtomicNo(hetAtm[0]) == 8) {
                this.mMol.setAtomMarker(hetAtm[0], false);
                if (this.mMol.getAtomicNo(hetAtm[1]) == 8 && this.mMol.getAtomicNo(hetAtm[2]) == 8) {
                    return 397;
                }
                return 398;
            }
            return 399;
        }
        if (this.getAtomZ(atm) == 5) {
            if (nrofHets == 3 && this.mMol.getAtomicNo(hetAtm[0]) == 8 && this.mMol.getAtomicNo(hetAtm[1]) == 8 && this.getAtomSigma(atm) == 1) {
                this.mMol.setAtomMarker(hetAtm[0], false);
                this.mMol.setAtomMarker(hetAtm[1], false);
                if (this.mMol.getAtomicNo(hetAtm[2]) == 8) {
                    if (this.mMol.getConnAtoms(hetAtm[2]) == 1) {
                        this.mMol.setAtomMarker(hetAtm[1], false);
                        return 404;
                    }
                    return 405;
                }
                return 406;
            }
            return 407;
        }
        if (this.getAtomZ(atm) == 6) {
            if (nrofHets == 4 && this.mMol.getAtomicNo(hetAtm[0]) == 8 && this.mMol.getAtomicNo(hetAtm[1]) == 8 && this.mMol.getAtomicNo(hetAtm[2]) == 8 && this.mMol.getAtomicNo(hetAtm[3]) == 8) {
                this.mMol.setAtomMarker(hetAtm[0], false);
                this.mMol.setAtomMarker(hetAtm[1], false);
                return 394;
            }
            return 395;
        }
        return -1;
    }

    private void classCSe(int atm) {
        if (this.mMol.isAromaticAtom(atm)) {
            this.storeEClass(416);
            return;
        }
        if (this.hasDBondToHetero(atm)) {
            this.storeEClass(424);
            return;
        }
        if (this.getAtomZ(atm) == 1) {
            if (this.getAtomPi(atm) != 0) {
                if (this.getAtomSigma(atm) == 1) {
                    this.storeEClass(418);
                } else {
                    this.storeEClass(419);
                }
                return;
            }
            if (this.mMol.isAllylicAtom(atm)) {
                this.storeEClass(423);
            }
            switch (this.getAtomSigma(atm)) {
                case 3: {
                    this.storeEClass(420);
                    return;
                }
                case 2: {
                    this.storeEClass(421);
                    return;
                }
            }
            this.storeEClass(422);
            return;
        }
        if (this.getAtomZ(atm) == 2) {
            if (this.getAtomPi(atm) != 0) {
                this.storeEClass(417);
                return;
            }
            switch (this.getAtomSigma(atm)) {
                case 2: {
                    this.storeEClass(425);
                    return;
                }
                case 1: {
                    this.storeEClass(426);
                    return;
                }
            }
            this.storeEClass(427);
            return;
        }
        if (this.getAtomZ(atm) == 3) {
            if (this.getAtomSigma(atm) != 0) {
                this.storeEClass(428);
            } else {
                this.storeEClass(429);
            }
            return;
        }
        this.storeEClass(430);
    }

    private int classP(int atm) {
        int[] hetAtm = new int[16];
        this.mMol.setAtomMarker(atm, false);
        int phenyl = 0;
        int vinyl = 0;
        int alkyl = 0;
        for (int i = 0; i < this.mMol.getConnAtoms(atm); ++i) {
            int connAtm = this.mMol.getConnAtom(atm, i);
            if (this.mMol.getAtomicNo(connAtm) != 6) continue;
            if (this.mMol.isAromaticAtom(connAtm)) {
                ++phenyl;
                continue;
            }
            if (this.getAtomPi(connAtm) != 0) {
                ++vinyl;
                continue;
            }
            ++alkyl;
        }
        if (this.getAtomZ(atm) == 0) {
            if (this.mMol.getAtomCharge(atm) == 1) {
                return 96;
            }
            if (this.getAtomPi(atm) == 0) {
                if (this.getAtomSigma(atm) == 3) {
                    if (phenyl == 3) {
                        return 104;
                    }
                    return 105;
                }
                if (this.getAtomSigma(atm) == 2) {
                    return 98;
                }
                return 99;
            }
            if (this.getAtomPi(atm) == 1) {
                if (this.getAtomSigma(atm) == 4) {
                    return 100;
                }
                if (this.getAtomSigma(atm) == 2) {
                    return 101;
                }
                return 103;
            }
            return -2;
        }
        if (this.mMol.getAtomCharge(atm) == 1) {
            return 97;
        }
        if (this.getAtomZ(atm) == 1) {
            return 110;
        }
        int[] tripleBnds = new int[1];
        int[] doubleBnds = new int[1];
        int nrofHets = this.getSortedHeteros(atm, hetAtm, tripleBnds, doubleBnds, -1);
        if (tripleBnds[0] != 0) {
            return -2;
        }
        if (this.getAtomZ(atm) == 2) {
            if (nrofHets == 1) {
                if (this.mMol.getAtomicNo(hetAtm[0]) == 8) {
                    this.mMol.setAtomMarker(hetAtm[0], false);
                    return 108;
                }
                return 109;
            }
            return 111;
        }
        if (this.getAtomZ(atm) == 3) {
            if (nrofHets == 2) {
                if (this.mMol.getAtomicNo(hetAtm[0]) == 8) {
                    this.mMol.setAtomMarker(hetAtm[0], false);
                    return 112;
                }
                return 113;
            }
            if (this.mMol.getAtomicNo(hetAtm[0]) == 8 && this.mMol.getAtomicNo(hetAtm[1]) == 8 && this.mMol.getAtomicNo(hetAtm[2]) == 8) {
                return 106;
            }
            return 107;
        }
        if (this.getAtomZ(atm) == 4) {
            if (nrofHets == 3) {
                if (this.mMol.getAtomicNo(hetAtm[0]) == 8) {
                    this.mMol.setAtomMarker(hetAtm[0], false);
                    if (this.mMol.getAtomicNo(hetAtm[1]) == 8 && this.mMol.getAtomicNo(hetAtm[2]) == 8) {
                        return 114;
                    }
                    return 115;
                }
                return 116;
            }
            return -2;
        }
        if (this.getAtomZ(atm) == 5) {
            if (nrofHets == 4) {
                if (this.mMol.getAtomicNo(hetAtm[0]) == 8) {
                    this.mMol.setAtomMarker(hetAtm[0], false);
                    if (this.mMol.getAtomicNo(hetAtm[1]) == 8 && this.mMol.getAtomicNo(hetAtm[2]) == 8 && this.mMol.getAtomicNo(hetAtm[3]) == 8) {
                        return 118;
                    }
                    return 119;
                }
                return 117;
            }
            return -2;
        }
        return -2;
    }

    private int classS(int atm) {
        int[] carbon = new int[16];
        int[] hetAtm = new int[16];
        this.mMol.setAtomMarker(atm, false);
        if (!this.mMol.isAromaticAtom(atm)) {
            int nrofCarbs = this.getCarbons(atm, carbon);
            for (int i = 0; i < nrofCarbs; ++i) {
                this.classCS(carbon[i], atm);
            }
        }
        if (this.mMol.isAromaticAtom(atm)) {
            return 187;
        }
        if (this.mMol.getAtomCharge(atm) == 1) {
            return 735;
        }
        if (this.getAtomZ(atm) == 0) {
            if (this.getAtomSigma(atm) == 2) {
                return 732;
            }
            return 733;
        }
        int[] tripleBnds = new int[1];
        int[] doubleBnds = new int[1];
        int nrofHets = this.getSortedHeteros(atm, hetAtm, tripleBnds, doubleBnds, -1);
        if (tripleBnds[0] != 0) {
            return -2;
        }
        if (this.getAtomZ(atm) == 1) {
            if (this.getAtomSigma(atm) == 1) {
                if (this.mMol.getAtomicNo(hetAtm[0]) == 16) {
                    if (this.mMol.getConnAtoms(hetAtm[0]) == 1) {
                        this.mMol.setAtomMarker(hetAtm[0], false);
                        return 728;
                    }
                    if (this.getAtomZ(hetAtm[0]) == 1) {
                        return 729;
                    }
                    return 730;
                }
                return 731;
            }
            if (this.mMol.getConnAtoms(atm) > 1) {
                return -1;
            }
            return 734;
        }
        if (this.getAtomZ(atm) == 2) {
            if (nrofHets == 1 && this.mMol.getAtomicNo(hetAtm[0]) == 8 && this.getAtomSigma(atm) == 2) {
                this.mMol.setAtomMarker(hetAtm[0], false);
                return 736;
            }
            return 737;
        }
        if (this.getAtomZ(atm) == 3) {
            if (nrofHets == 2 && this.mMol.getAtomicNo(hetAtm[0]) == 8 && this.getAtomSigma(atm) == 1) {
                this.mMol.setAtomMarker(hetAtm[0], false);
                if (this.mMol.getAtomicNo(hetAtm[1]) == 8) {
                    return 744;
                }
                return 745;
            }
            return 746;
        }
        if (this.getAtomZ(atm) == 4) {
            if (nrofHets == 2 && this.mMol.getAtomicNo(hetAtm[0]) == 8 && this.mMol.getAtomicNo(hetAtm[1]) == 8 && this.getAtomSigma(atm) == 2) {
                this.mMol.setAtomMarker(hetAtm[0], false);
                this.mMol.setAtomMarker(hetAtm[1], false);
                return 740;
            }
            if (nrofHets == 3 && this.mMol.getAtomicNo(hetAtm[0]) == 8 && this.getAtomSigma(atm) == 0) {
                this.mMol.setAtomMarker(hetAtm[0], false);
                if (this.mMol.getAtomicNo(hetAtm[1]) == 8 && this.mMol.getAtomicNo(hetAtm[2]) == 8) {
                    return 741;
                }
                return 742;
            }
            return 743;
        }
        if (this.getAtomZ(atm) == 5) {
            if (nrofHets == 3 && this.mMol.getAtomicNo(hetAtm[0]) == 8 && this.mMol.getAtomicNo(hetAtm[1]) == 8 && this.getAtomSigma(atm) == 1) {
                this.mMol.setAtomMarker(hetAtm[0], false);
                this.mMol.setAtomMarker(hetAtm[1], false);
                if (this.mMol.getAtomicNo(hetAtm[2]) == 8) {
                    return 748;
                }
                return 749;
            }
            return 750;
        }
        if (this.getAtomZ(atm) == 6) {
            if (nrofHets == 4 && this.mMol.getAtomicNo(hetAtm[0]) == 8 && this.mMol.getAtomicNo(hetAtm[1]) == 8) {
                this.mMol.setAtomMarker(hetAtm[0], false);
                this.mMol.setAtomMarker(hetAtm[1], false);
                return 738;
            }
            return 739;
        }
        return -1;
    }

    private void classCS(int carbon, int sulfur) {
        int[] hetAtm = new int[16];
        if (this.bondToMet(carbon)) {
            return;
        }
        if (this.mMol.isAromaticAtom(carbon)) {
            this.storeEClass(448);
            return;
        }
        if (this.getAtomPi(carbon) == 2) {
            this.storeEClass(449);
            return;
        }
        int[] tripleBnds = new int[1];
        int[] doubleBnds = new int[1];
        int nrofHets = this.getSortedHeteros(carbon, hetAtm, tripleBnds, doubleBnds, sulfur);
        if (tripleBnds[0] != 0) {
            this.storeEClass(464);
            return;
        }
        if (this.hasDBondToHetero(carbon)) {
            this.storeEClass(465);
            return;
        }
        if (this.getAtomPi(carbon) == 1) {
            if (this.getAtomZ(carbon) == 2) {
                if (this.mMol.getAtomicNo(hetAtm[0]) == 16) {
                    this.storeEClass(456);
                } else {
                    this.storeEClass(457);
                }
            } else if (this.getAtomSigma(carbon) == 2) {
                this.storeEClass(450);
            } else {
                this.storeEClass(451);
            }
            return;
        }
        if (this.getAtomZ(carbon) == 1) {
            if (this.mMol.isAllylicAtom(carbon)) {
                this.storeEClass(455);
            }
            switch (this.getAtomSigma(carbon)) {
                case 3: {
                    this.storeEClass(454);
                    return;
                }
                case 2: {
                    this.storeEClass(453);
                    return;
                }
            }
            this.storeEClass(452);
            return;
        }
        if (this.getAtomZ(carbon) == 2) {
            if (this.getAtomSigma(carbon) == 0) {
                if (this.mMol.getAtomicNo(hetAtm[0]) == 16) {
                    this.storeEClass(462);
                } else {
                    this.storeEClass(463);
                }
                return;
            }
            if (this.getAtomSigma(carbon) == 1) {
                if (this.mMol.getAtomicNo(hetAtm[0]) == 16) {
                    this.storeEClass(460);
                } else {
                    this.storeEClass(461);
                }
                return;
            }
            if (this.getAtomSigma(carbon) == 2) {
                if (this.mMol.getAtomicNo(hetAtm[0]) == 16) {
                    this.storeEClass(458);
                } else {
                    this.storeEClass(459);
                }
                return;
            }
        }
        if (this.getAtomZ(carbon) == 3) {
            this.storeEClass(466);
            return;
        }
        if (this.getAtomZ(carbon) == 4) {
            this.storeEClass(467);
        }
    }

    private int classI(int atm) {
        int[] iodineClass = new int[]{352, 353, 355, 354, 356, 359, 358, 357, 360, 361, 362, 368, 370, 369, 364, 365, 366, 367, 371, 372, 373, 374, 375, 380, 381, 377, 376, 382, 383, 378, 379};
        this.mMol.setAtomMarker(atm, false);
        if (this.mMol.getConnAtoms(atm) > 1) {
            return 363;
        }
        int eClass = this.classHal(atm, 53);
        if (eClass < 0) {
            return eClass;
        }
        return iodineClass[eClass];
    }

    private int classBr(int atm) {
        int[] bromineClass = new int[]{320, 321, 323, 322, 324, 327, 326, 325, 328, 329, 330, 336, 338, 337, 332, 333, 334, 335, 339, 340, 341, 342, 343, 348, 349, 345, 344, 350, 351, 346, 347};
        this.mMol.setAtomMarker(atm, false);
        if (this.mMol.getConnAtoms(atm) > 1) {
            return -2;
        }
        int eClass = this.classHal(atm, 35);
        if (eClass < 0) {
            return eClass;
        }
        return bromineClass[eClass];
    }

    private int classCl(int atm) {
        int[] chlorineClass = new int[]{288, 289, 291, 290, 292, 295, 294, 293, 296, 297, 298, 304, 306, 305, 300, 301, 302, 303, 307, 308, 309, 310, 311, 316, 317, 313, 312, 318, 319, 314, 315};
        this.mMol.setAtomMarker(atm, false);
        if (this.mMol.getConnAtoms(atm) > 1) {
            return -2;
        }
        int eClass = this.classHal(atm, 17);
        if (eClass < 0) {
            return eClass;
        }
        return chlorineClass[eClass];
    }

    private int classF(int atm) {
        int[] fluorineClass = new int[]{256, 257, 259, 258, 260, 263, 262, 261, 264, 265, 266, 272, 274, 273, 268, 269, 270, 271, 275, 276, 277, 278, 279, 284, 285, 281, 280, 286, 287, 282, 283};
        this.mMol.setAtomMarker(atm, false);
        if (this.mMol.getConnAtoms(atm) > 1) {
            return -2;
        }
        int eClass = this.classHal(atm, 9);
        if (eClass < 0) {
            return eClass;
        }
        return fluorineClass[eClass];
    }

    private int classHal(int atm, int halType) {
        int[] hetAtm = new int[3];
        if (this.mMol.getConnAtoms(atm) != 1) {
            return -2;
        }
        int connAtm = this.mMol.getConnAtom(atm, 0);
        if (this.mMol.getAtomicNo(connAtm) == 6) {
            if (this.bondToMet(connAtm)) {
                return -1;
            }
            if (this.mMol.isAromaticAtom(connAtm)) {
                return 0;
            }
            switch (this.getAtomZ(connAtm)) {
                case 1: {
                    if (this.getAtomPi(connAtm) == 2) {
                        return 1;
                    }
                    if (this.getAtomPi(connAtm) == 1) {
                        if (this.getAtomSigma(connAtm) == 1) {
                            return 2;
                        }
                        return 3;
                    }
                    if (this.mMol.isAllylicAtom(connAtm)) {
                        return 4;
                    }
                    switch (this.getAtomSigma(connAtm)) {
                        case 3: {
                            return 5;
                        }
                        case 2: {
                            return 6;
                        }
                    }
                    return 7;
                }
                case 2: {
                    if (this.getHeteros(connAtm, hetAtm, atm) != 1) {
                        return -2;
                    }
                    if (this.getAtomPi(connAtm) != 0) {
                        return 8;
                    }
                    if (this.mMol.isAllylicAtom(connAtm)) {
                        return 9;
                    }
                    return 10;
                }
                case 3: {
                    int nrofHets = this.getHeteros(connAtm, hetAtm, atm);
                    if (nrofHets == 1) {
                        if (this.mMol.getAtomicNo(hetAtm[0]) == 8) {
                            this.mMol.setAtomMarker(hetAtm[0], false);
                            return 11;
                        }
                        if (this.mMol.getAtomicNo(hetAtm[0]) == 7) {
                            return 12;
                        }
                        return 13;
                    }
                    if (this.mMol.getAtomicNo(hetAtm[0]) == halType && this.mMol.getAtomicNo(hetAtm[1]) == halType) {
                        this.mMol.setAtomMarker(hetAtm[0], false);
                        this.mMol.setAtomMarker(hetAtm[1], false);
                        if (this.mMol.isStabilizedAtom(connAtm)) {
                            return 14;
                        }
                        return 15;
                    }
                    if (this.mMol.isStabilizedAtom(connAtm)) {
                        return 16;
                    }
                    return 17;
                }
                case 4: {
                    int[] tripleBnds = new int[1];
                    int[] doubleBnds = new int[1];
                    int nrofHets = this.getSortedHeteros(connAtm, hetAtm, tripleBnds, doubleBnds, atm);
                    if (nrofHets == 1) {
                        if (this.mMol.getConnAtoms(hetAtm[0]) == 2) {
                            this.mMol.setAtomMarker(hetAtm[0], false);
                        }
                        return 18;
                    }
                    if (nrofHets == 2) {
                        if (this.mMol.getAtomicNo(hetAtm[0]) == 8) {
                            return 19;
                        }
                        if (this.mMol.getAtomicNo(hetAtm[0]) == 7) {
                            return 20;
                        }
                        return 21;
                    }
                    if (nrofHets != 3) break;
                    return 22;
                }
            }
            return -2;
        }
        if (this.mMol.getAtomicNo(connAtm) == 7) {
            if (this.mMol.isStabilizedAtom(connAtm)) {
                return 23;
            }
            return 24;
        }
        if (this.mMol.getAtomicNo(connAtm) == 8) {
            int nextConn = this.getNextConn(connAtm, atm);
            if (nextConn == -1 || this.mMol.getAtomicNo(nextConn) == 6) {
                return 26;
            }
            return 25;
        }
        if (this.mMol.getAtomicNo(connAtm) == 5) {
            return 27;
        }
        if (this.mMol.getAtomicNo(connAtm) == 14) {
            return 28;
        }
        if (this.mMol.getAtomicNo(connAtm) == 15) {
            return 29;
        }
        if (this.mMol.getAtomicNo(connAtm) == 16) {
            return 30;
        }
        return -2;
    }

    private int classN(int atm) {
        int connAtm;
        int i;
        int[] conn = new int[3];
        int[] hetAtm = new int[16];
        this.mMol.setAtomMarker(atm, false);
        if (this.mMol.getConnAtoms(atm) == 0) {
            return -2;
        }
        for (i = 0; i < this.mMol.getConnAtoms(atm); ++i) {
            connAtm = this.mMol.getConnAtom(atm, i);
            if (!this.mMol.isElectropositive(connAtm)) continue;
            if (this.mMol.getAtomicNo(connAtm) == 14) {
                if (this.mMol.getConnAtoms(atm) == 3) {
                    if (this.mMol.isStabilizedAtom(atm)) {
                        return 157;
                    }
                    return 159;
                }
                if (this.mMol.isStabilizedAtom(atm)) {
                    return 156;
                }
                return 158;
            }
            if (this.mMol.getAtomicNo(connAtm) == 5) {
                return 190;
            }
            return 191;
        }
        if (this.mMol.isAromaticAtom(atm)) {
            if (this.getAtomPi(atm) != 0) {
                return 184;
            }
            return 185;
        }
        if (this.isThreeRingAtom(atm)) {
            int count = 0;
            for (int i2 = 0; i2 < this.mMol.getConnAtoms(atm); ++i2) {
                conn[count] = this.mMol.getConnAtom(atm, i2);
                if (!this.isThreeRingAtom(conn[count])) continue;
                ++count;
            }
            if (count > 1) {
                if (this.mMol.getAtomicNo(conn[0]) == 6 && this.mMol.getAtomicNo(conn[1]) == 6) {
                    if (this.getAtomPi(conn[0]) != 0 || this.getAtomPi(conn[1]) != 0) {
                        return 700;
                    }
                    if (this.getAtomZ(conn[0]) == 1 && this.getAtomZ(conn[1]) == 1) {
                        if (this.mMol.isAllylicAtom(conn[0]) || this.mMol.isAllylicAtom(conn[1])) {
                            return 701;
                        }
                        return 703;
                    }
                    return 702;
                }
                return 189;
            }
        }
        for (i = 0; i < this.mMol.getConnAtoms(atm); ++i) {
            if (this.mMol.getConnBondOrder(atm, i) != 1 || this.mMol.getAtomicNo(connAtm = this.mMol.getConnAtom(atm, i)) != 6) continue;
            this.classCN(connAtm);
        }
        int[] tripleBnds = new int[1];
        int[] doubleBnds = new int[1];
        int nrofHets = this.getSortedHeteros(atm, hetAtm, tripleBnds, doubleBnds, -1);
        if (this.mMol.getAtomCharge(atm) == -1) {
            return -1;
        }
        if (this.mMol.getAtomCharge(atm) == 1) {
            switch (this.getAtomZ(atm)) {
                case 4: {
                    if (this.mMol.getConnAtoms(atm) == 2 && this.mMol.getAtomicNo(this.mMol.getConnAtom(atm, 0)) == 7 && this.mMol.getAtomicNo(this.mMol.getConnAtom(atm, 1)) == 7) {
                        int connAtm2 = this.getNextConn(this.mMol.getConnAtom(atm, 0), atm);
                        if (connAtm2 == -1) {
                            connAtm2 = this.getNextConn(this.mMol.getConnAtom(atm, 1), atm);
                        }
                        if (connAtm2 == -1) {
                            return -2;
                        }
                        if (this.hasDBondToHetero(connAtm2)) {
                            return 512;
                        }
                        if (this.mMol.getAtomicNo(connAtm2) != 6) {
                            return 513;
                        }
                        if (this.getAtomPi(connAtm2) != 0) {
                            return 514;
                        }
                        return 515;
                    }
                    if (this.mMol.getConnAtoms(atm) == 3 && this.mMol.getAtomicNo(this.mMol.getConnAtom(atm, 0)) == 8 && this.mMol.getAtomicNo(this.mMol.getConnAtom(atm, 1)) == 8 && this.mMol.getAtomicNo(this.mMol.getConnAtom(atm, 1)) == 8) {
                        for (int i3 = 0; i3 < 3; ++i3) {
                            int connAtm3 = this.mMol.getConnAtom(atm, i3);
                            if (this.mMol.getConnAtoms(connAtm3) != 1) continue;
                            this.mMol.setAtomMarker(connAtm3, false);
                        }
                        return 517;
                    }
                    return -1;
                }
                case 3: {
                    if (nrofHets == 3) {
                        return 531;
                    }
                    if (nrofHets == 2) {
                        if (this.mMol.getAtomicNo(hetAtm[0]) == 8 && this.mMol.getAtomicNo(hetAtm[1]) == 8 && this.mMol.getConnAtoms(hetAtm[1]) == 1) {
                            this.mMol.setAtomMarker(hetAtm[0], false);
                            this.mMol.setAtomMarker(hetAtm[1], false);
                            return 521;
                        }
                        if (this.mMol.getAtomicNo(hetAtm[0]) == 7 && this.mMol.getAtomicNo(hetAtm[1]) == 8) {
                            if (this.mMol.getConnAtoms(hetAtm[1]) == 1) {
                                this.mMol.setAtomMarker(hetAtm[1], false);
                            }
                            return 522;
                        }
                        return 523;
                    }
                    return 519;
                }
                case 2: {
                    return 530;
                }
                case 1: {
                    if (this.mMol.getAtomicNo(hetAtm[0]) == 8) {
                        if (this.mMol.getConnAtoms(hetAtm[0]) == 1) {
                            this.mMol.setAtomMarker(hetAtm[0], false);
                        }
                        switch (this.getAtomPi(atm)) {
                            case 2: {
                                return 527;
                            }
                        }
                        return 526;
                    }
                    return 529;
                }
            }
            switch (this.getAtomPi(atm)) {
                case 2: {
                    return 518;
                }
            }
            return 528;
        }
        switch (this.getAtomZ(atm)) {
            case 3: {
                if (tripleBnds[0] != 0) {
                    return -1;
                }
                if (doubleBnds[0] != 0) {
                    if (this.mMol.getAtomicNo(hetAtm[0]) == 7) {
                        if (this.mMol.getAtomicNo(hetAtm[1]) == 7) {
                            return 615;
                        }
                        if (this.mMol.getAtomicNo(hetAtm[1]) == 8) {
                            return 614;
                        }
                        return 613;
                    }
                    if (this.mMol.getAtomicNo(hetAtm[0]) == 8) {
                        this.mMol.setAtomMarker(hetAtm[0], false);
                        if (this.mMol.getAtomicNo(hetAtm[1]) == 7) {
                            return 608;
                        }
                        if (this.mMol.getAtomicNo(hetAtm[1]) == 8) {
                            return 609;
                        }
                        return 610;
                    }
                    return 611;
                }
                return 612;
            }
            case 2: {
                if (doubleBnds[0] != 0) {
                    if (this.mMol.getAtomicNo(hetAtm[0]) == 7) {
                        if (this.mMol.getAtomCharge(hetAtm[0]) == 1) {
                            return -1;
                        }
                        return 616;
                    }
                    if (this.mMol.getAtomicNo(hetAtm[0]) == 8) {
                        this.mMol.setAtomMarker(hetAtm[0], false);
                        return 617;
                    }
                    return 618;
                }
                return 619;
            }
            case 1: {
                if (this.mMol.getAtomicNo(hetAtm[0]) == 7) {
                    switch (this.getAtomSigma(atm)) {
                        case 2: {
                            return 620;
                        }
                        case 1: {
                            return 628;
                        }
                    }
                    return 624;
                }
                if (this.mMol.getAtomicNo(hetAtm[0]) == 8) {
                    switch (this.getAtomSigma(atm)) {
                        case 2: {
                            if (this.mMol.getConnAtoms(hetAtm[0]) == 1) {
                                this.mMol.setAtomMarker(hetAtm[0], false);
                                return 622;
                            }
                            return 623;
                        }
                        case 1: {
                            if (this.mMol.getConnAtoms(hetAtm[0]) == 1) {
                                this.mMol.setAtomMarker(hetAtm[0], false);
                                return 630;
                            }
                            return 631;
                        }
                    }
                    return 625;
                }
                switch (this.getAtomSigma(atm)) {
                    case 2: {
                        return 621;
                    }
                    case 1: {
                        return 629;
                    }
                }
                return 626;
            }
        }
        if (this.mMol.getConnBondOrder(atm, 0) == 3) {
            int connAtm4 = this.mMol.getConnAtom(atm, 0);
            int nextConn = this.getNextConn(connAtm4, atm);
            if (nextConn == -1) {
                return 476;
            }
            if (this.mMol.isElectronegative(nextConn)) {
                return 477;
            }
            if (this.mMol.isElectropositive(nextConn)) {
                if (this.mMol.getAtomicNo(nextConn) == 5 || this.mMol.getAtomicNo(nextConn) == 14) {
                    return 478;
                }
                return 479;
            }
            if (this.getAtomPi(nextConn) != 0) {
                return 472;
            }
            switch (this.getAtomZ(nextConn)) {
                case 0: {
                    return 473;
                }
                case 1: {
                    return 474;
                }
            }
            return 475;
        }
        int acyl = 0;
        for (int i4 = 0; i4 < this.mMol.getConnAtoms(atm); ++i4) {
            if (!this.hasDBondToHetero(this.mMol.getConnAtom(atm, i4))) continue;
            ++acyl;
        }
        switch (this.getAtomSigma(atm)) {
            case 3: {
                switch (acyl) {
                    case 0: {
                        return 632;
                    }
                    case 1: {
                        return 637;
                    }
                }
                return 639;
            }
            case 2: {
                switch (acyl) {
                    case 0: {
                        return 633;
                    }
                    case 1: {
                        return 636;
                    }
                }
                return 638;
            }
        }
        if (acyl != 0) {
            return 635;
        }
        return 634;
    }

    private void classCN(int atm) {
        if (this.mMol.isAromaticAtom(atm)) {
            this.storeEClass(576);
            return;
        }
        if (this.hasDBondToHetero(atm)) {
            this.storeEClass(584);
            return;
        }
        if (this.getAtomZ(atm) == 1) {
            if (this.getAtomPi(atm) != 0) {
                if (this.getAtomSigma(atm) == 1) {
                    this.storeEClass(578);
                } else {
                    this.storeEClass(579);
                }
                return;
            }
            if (this.mMol.isAllylicAtom(atm)) {
                this.storeEClass(583);
            }
            switch (this.getAtomSigma(atm)) {
                case 3: {
                    this.storeEClass(580);
                    return;
                }
                case 2: {
                    this.storeEClass(581);
                    return;
                }
            }
            this.storeEClass(582);
            return;
        }
        if (this.getAtomZ(atm) == 2) {
            if (this.getAtomPi(atm) != 0) {
                this.storeEClass(577);
                return;
            }
            switch (this.getAtomSigma(atm)) {
                case 2: {
                    this.storeEClass(585);
                    return;
                }
                case 1: {
                    this.storeEClass(586);
                    return;
                }
            }
            this.storeEClass(587);
            return;
        }
        if (this.getAtomZ(atm) == 3) {
            if (this.getAtomSigma(atm) != 0) {
                this.storeEClass(588);
            } else {
                this.storeEClass(589);
            }
            return;
        }
        this.storeEClass(590);
    }

    private int classO(int atm) {
        int class2;
        int[] base = new int[]{0, 21, 41, 60, 78, 95, 111, 126, 140, 153, 165, 176, 186, 195, 203, 210, 216, 221, 225, 228, 230, 231};
        int[] alcClass = new int[]{848, 863, 850, 851, 852, 853, 854, 855, 856, 857, 858, 859, 860, 861, 862, 911, 991, 975, 927, 1007, 1023, 943};
        int[] etherClass = new int[]{836, 768, 820, 821, 832, 833, 834, 835, 788, 484, 486, 487, 752, 753, 944, 896, 976, 960, 912, 992, 1008, 928, 769, 805, 804, 772, 773, 774, 775, 792, 776, 778, 779, 780, 781, 945, 897, 977, 961, 913, 993, 1009, 929, 816, 817, 824, 825, 826, 827, 790, 809, 813, 815, 801, 803, 807, 898, 978, 962, 914, 994, 1010, 930, 818, 828, 829, 830, 831, 791, 808, 812, 814, 800, 802, 806, 899, 979, 963, 915, 995, 1011, 931, 837, 838, 840, 841, 784, 480, 488, 492, 504, 508, 948, 900, 980, 964, 916, 996, 1012, 932, 839, 842, 844, 785, 481, 489, 493, 505, 509, 949, 901, 981, 965, 917, 997, 1013, 933, 845, 846, 786, 482, 490, 494, 506, 510, 950, 902, 982, 966, 918, 998, 1014, 934, 847, 787, 483, 491, 495, 507, 511, 951, 903, 983, 967, 919, 999, 1015, 935, 789, 798, 797, 796, 794, 795, 952, 904, 984, 968, 920, 1000, 1016, 936, 496, 498, 500, 760, 764, 953, 905, 985, 969, 921, 1001, 1017, 937, 499, 502, 762, 766, 954, 906, 986, 970, 922, 1002, 1018, 938, 503, 763, 767, 955, 907, 987, 971, 923, 1003, 1019, 939, 756, 758, 956, 908, 988, 972, 924, 1004, 1020, 940, 759, 957, 909, 989, 973, 925, 1005, 1021, 941, 958, 910, 990, 974, 926, 1006, 1022, 942, 874, 880, 888, 883, 864, 872, 892, 885, 884, 881, 869, 877, 886, 890, 889, 868, 876, 891, 882, 865, 873, 893, 870, 871, 866, 878, 879, 894};
        this.mMol.setAtomMarker(atm, false);
        if (this.mMol.getConnAtoms(atm) == 0) {
            return -2;
        }
        if (this.mMol.isAromaticAtom(atm)) {
            return 186;
        }
        if (this.mMol.getConnAtoms(atm) == 1) {
            if (this.mMol.getConnBondOrder(atm, 0) == 2) {
                return -1;
            }
            int class1 = this.classAtmO(this.mMol.getConnAtom(atm, 0));
            return alcClass[class1];
        }
        int connAtm1 = this.mMol.getConnAtom(atm, 0);
        int connAtm2 = this.mMol.getConnAtom(atm, 1);
        if (this.isThreeRingAtom(atm)) {
            if (this.mMol.getAtomicNo(connAtm1) == 6 && this.mMol.getAtomicNo(connAtm2) == 6) {
                if (this.getAtomPi(connAtm1) != 0 || this.getAtomPi(connAtm2) != 0) {
                    return 696;
                }
                if (this.getAtomZ(connAtm1) == 1 && this.getAtomZ(connAtm2) == 1) {
                    if (this.mMol.isAllylicAtom(connAtm1) || this.mMol.isAllylicAtom(connAtm2)) {
                        return 697;
                    }
                    return 699;
                }
                return 698;
            }
            return 189;
        }
        int class1 = this.classAtmO(connAtm1);
        if (class1 > (class2 = this.classAtmO(connAtm2))) {
            int temp = class1;
            class1 = class2;
            class2 = temp;
        }
        return etherClass[base[class1] + class2];
    }

    private int classAtmO(int atm) {
        if (this.mMol.getAtomicNo(atm) == 6) {
            if (this.mMol.isAromaticAtom(atm)) {
                return 0;
            }
            if (this.hasDBondToHetero(atm)) {
                return 1;
            }
            if (this.getAtomZ(atm) == 1) {
                if (this.getAtomPi(atm) != 0) {
                    if (this.getAtomSigma(atm) == 1) {
                        return 2;
                    }
                    return 3;
                }
                switch (this.getAtomSigma(atm)) {
                    case 3: {
                        return 4;
                    }
                    case 2: {
                        return 5;
                    }
                    case 1: {
                        return 6;
                    }
                }
                return 7;
            }
            if (this.getAtomZ(atm) == 2) {
                if (this.getAtomPi(atm) != 0) {
                    return 8;
                }
                switch (this.getAtomSigma(atm)) {
                    case 2: {
                        return 9;
                    }
                    case 1: {
                        return 10;
                    }
                }
                return 11;
            }
            if (this.getAtomZ(atm) == 3) {
                if (this.getAtomSigma(atm) != 0) {
                    return 12;
                }
                return 13;
            }
            return 14;
        }
        switch (this.mMol.getAtomicNo(atm)) {
            case 5: {
                return 15;
            }
            case 7: {
                return 16;
            }
            case 8: {
                return 17;
            }
            case 14: {
                return 18;
            }
            case 15: {
                return 19;
            }
            case 16: {
                return 20;
            }
        }
        return 21;
    }

    private int classC(int atm) {
        int[][] alkyneClass = new int[][]{{-1, 192, 194, 193, 195}, {192, 200, 202, 201, 203}, {194, 202, 196, 197, 198}, {193, 201, 197, 204, 205}, {195, 203, 198, 205, 199}};
        this.mMol.setAtomMarker(atm, false);
        if (this.isThreeRingAtom(atm)) {
            int[] member = new int[3];
            this.getRingMembers(atm, 3, false, member);
            if (this.mMol.getAtomicNo(member[1]) != 6 || this.mMol.getAtomicNo(member[2]) != 6) {
                return -2;
            }
            boolean vinyl = false;
            boolean stab = false;
            boolean allyl = false;
            for (int i = 0; i < 3; ++i) {
                this.mMol.setAtomMarker(member[i], false);
                if (this.getAtomPi(member[i]) != 0) {
                    vinyl = true;
                }
                if (this.mMol.isStabilizedAtom(member[i])) {
                    stab = true;
                }
                if (!this.mMol.isAllylicAtom(member[i])) continue;
                allyl = true;
            }
            if (vinyl) {
                return 228;
            }
            if (stab) {
                return 230;
            }
            if (allyl) {
                return 231;
            }
            return 229;
        }
        if (this.getAtomPi(atm) == 0) {
            if (this.mMol.getAtomParity(atm) == 0) {
                return -2;
            }
            if (this.getAtomSigma(atm) + this.getAtomZ(atm) == 4) {
                return 240;
            }
            if (this.mMol.isStabilizedAtom(atm)) {
                return 241;
            }
            if (this.mMol.isAllylicAtom(atm)) {
                return 242;
            }
            return 243;
        }
        int[] member = new int[16];
        int nrofPiConns = this.getPiConnCarbs(atm, member);
        if (this.getAtomPi(atm) == 2 && nrofPiConns == 1) {
            this.mMol.setAtomMarker(member[0], false);
            int class1 = this.classAcetylen(atm, member[0]);
            int class2 = this.classAcetylen(member[0], atm);
            if (class1 == 5 || class2 == 5) {
                return 206;
            }
            if (class1 == 6 || class2 == 6) {
                return 207;
            }
            return alkyneClass[class1][class2];
        }
        if (this.bondToMet(atm)) {
            return -1;
        }
        for (int i = 0; i < nrofPiConns; ++i) {
            if (!this.bondToMet(member[i])) continue;
            return -1;
        }
        if (this.getAtomPi(atm) == 2) {
            boolean stab = false;
            for (int i = 0; i < 2; ++i) {
                if (this.mMol.isStabilizedAtom(member[i])) {
                    stab = true;
                }
                this.mMol.setAtomMarker(member[i], false);
            }
            if (this.getAtomZ(member[0]) != 0 || this.getAtomZ(member[1]) != 0) {
                if (stab) {
                    return 232;
                }
                return 233;
            }
            if (stab) {
                return 234;
            }
            return 235;
        }
        if (this.getAtomPi(member[0]) == 2) {
            return -1;
        }
        this.mMol.setAtomMarker(member[0], false);
        if (this.mMol.isAromaticAtom(atm)) {
            int[] aromAtms = new int[16];
            int aroms = this.getRingMembers(atm, 0, true, aromAtms);
            if (aroms == 0) {
                return -2;
            }
            boolean stab = false;
            boolean hetero = false;
            for (int i = 0; i < aroms; ++i) {
                this.mMol.setAtomMarker(aromAtms[i], false);
                for (int j = 0; j < this.mMol.getConnAtoms(aromAtms[i]); ++j) {
                    int connAtm = this.mMol.getConnAtom(aromAtms[i], j);
                    if (this.mMol.isAromaticAtom(connAtm)) continue;
                    if (this.hasDBondToHetero(connAtm)) {
                        stab = true;
                        continue;
                    }
                    if (!this.mMol.isElectronegative(connAtm)) continue;
                    hetero = true;
                }
            }
            if (stab) {
                this.storeEClass(236);
            }
            if (hetero) {
                this.storeEClass(237);
            }
            if (!stab && !hetero) {
                return 238;
            }
            return -1;
        }
        member[1] = atm;
        int vinyl = 0;
        int stab = 0;
        int hetero = 0;
        int alkyl = 0;
        int phenyl = 0;
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < this.mMol.getConnAtoms(member[i]); ++j) {
                int connAtm = this.mMol.getConnAtom(member[i], j);
                if (this.mMol.isElectropositive(connAtm) || connAtm == member[1 - i]) continue;
                if (this.mMol.isAromaticAtom(connAtm)) {
                    ++phenyl;
                    continue;
                }
                if (this.hasDBondToHetero(connAtm)) {
                    ++stab;
                    continue;
                }
                if (this.mMol.isElectronegative(connAtm)) {
                    ++hetero;
                    continue;
                }
                if (this.getAtomPi(connAtm) != 0) {
                    ++vinyl;
                    continue;
                }
                ++alkyl;
            }
        }
        if (hetero > 2) {
            if (stab != 0) {
                return 223;
            }
            return 224;
        }
        if (hetero == 2) {
            if (stab != 0) {
                return 222;
            }
            return 225;
        }
        if (stab > 2) {
            return 216;
        }
        if (stab == 2) {
            if (hetero != 0) {
                return 220;
            }
            return 217;
        }
        if (hetero == 1) {
            if (stab == 1) {
                return 221;
            }
            if (vinyl + alkyl + phenyl > 1) {
                return 227;
            }
            return 226;
        }
        if (stab == 1) {
            if (vinyl + alkyl + phenyl > 1) {
                return 218;
            }
            return 219;
        }
        switch (vinyl + alkyl + phenyl) {
            case 4: {
                if (alkyl == 4) {
                    return 214;
                }
                return 215;
            }
            case 3: {
                if (alkyl == 3) {
                    return 212;
                }
                return 213;
            }
            case 2: {
                if (alkyl == 2) {
                    return 210;
                }
                return 211;
            }
        }
        if (alkyl == 1) {
            return 208;
        }
        return 209;
    }

    private int classAcetylen(int atm, int other) {
        if (this.mMol.getConnAtoms(atm) == 1) {
            return 0;
        }
        int nextConn = this.getNextConn(atm, other);
        if (this.mMol.isAromaticAtom(nextConn)) {
            return 1;
        }
        if (this.mMol.isElectronegative(nextConn)) {
            return 2;
        }
        if (this.mMol.isElectropositive(nextConn)) {
            if (this.mMol.getAtomicNo(nextConn) == 5) {
                return 5;
            }
            return 6;
        }
        if (this.getAtomPi(nextConn) != 0) {
            return 3;
        }
        return 4;
    }

    private void storeEClass(int eClass) {
        if (eClass == -1) {
            return;
        }
        if (eClass == -2) {
            return;
        }
        Integer count = this.mFunctionalGroupCountMap.get(eClass);
        this.mFunctionalGroupCountMap.put(eClass, count == null ? 1 : count + 1);
    }

    private int getPiConnCarbs(int atm, int[] member) {
        int count = 0;
        for (int i = 0; i < this.mMol.getConnAtoms(atm); ++i) {
            int connAtm;
            if (this.mMol.getConnBondOrder(atm, i) <= 1 || this.mMol.getAtomicNo(connAtm = this.mMol.getConnAtom(atm, i)) != 6) continue;
            member[count++] = connAtm;
        }
        return count;
    }

    private int getRingMembers(int atom, int ringSize, boolean aromatic, int[] member) {
        RingCollection ringSet = this.mMol.getRingSet();
        member[0] = atom;
        for (int i = 0; i < ringSet.getSize(); ++i) {
            if (ringSet.getRingSize(i) != ringSize && ringSize != 0 || !ringSet.isAromatic(i) && aromatic) continue;
            int[] ringAtom = ringSet.getRingAtoms(i);
            for (int j = 0; j < ringAtom.length; ++j) {
                if (ringAtom[j] != atom) continue;
                int no = 1;
                for (int k = 0; k < ringAtom.length; ++k) {
                    if (ringAtom[k] == atom) continue;
                    member[no++] = ringAtom[k];
                }
                return ringAtom.length;
            }
        }
        return 0;
    }

    private boolean hasDBondToHetero(int atom) {
        for (int i = 0; i < this.mMol.getConnAtoms(atom); ++i) {
            if (this.mMol.getConnBondOrder(atom, i) != 2 || !this.mMol.isElectronegative(this.mMol.getConnAtom(atom, i))) continue;
            return true;
        }
        return false;
    }

    private int getCarbons(int atm, int[] carbon) {
        int carbons = 0;
        for (int i = 0; i < this.mMol.getConnAtoms(atm); ++i) {
            int connAtm = this.mMol.getConnAtom(atm, i);
            if (this.mMol.getAtomicNo(connAtm) != 6) continue;
            carbon[carbons++] = connAtm;
        }
        return carbons;
    }

    private int getHeteros(int atm, int[] hetAtm, int notThisOne) {
        int heteros = 0;
        for (int i = 0; i < this.mMol.getConnAtoms(atm); ++i) {
            int connAtm = this.mMol.getConnAtom(atm, i);
            if (connAtm == notThisOne || !this.mMol.isElectronegative(connAtm)) continue;
            hetAtm[heteros++] = connAtm;
        }
        return heteros;
    }

    private int getSortedHeteros(int atm, int[] hetAtm, int[] tripleBnds, int[] doubleBnds, int notThisOne) {
        int connAtm;
        int i;
        int heteros = 0;
        for (i = 0; i < this.mMol.getConnAtoms(atm); ++i) {
            if (this.mMol.getConnBondOrder(atm, i) != 3 || (connAtm = this.mMol.getConnAtom(atm, i)) == notThisOne || !this.mMol.isElectronegative(connAtm)) continue;
            hetAtm[heteros++] = connAtm;
        }
        tripleBnds[0] = heteros;
        for (i = 0; i < this.mMol.getConnAtoms(atm); ++i) {
            if (this.mMol.getConnBondOrder(atm, i) != 2 || (connAtm = this.mMol.getConnAtom(atm, i)) == notThisOne || !this.mMol.isElectronegative(connAtm)) continue;
            hetAtm[heteros++] = connAtm;
        }
        doubleBnds[0] = heteros - tripleBnds[0];
        for (i = 0; i < this.mMol.getConnAtoms(atm); ++i) {
            if (this.mMol.getConnBondOrder(atm, i) != 1 || (connAtm = this.mMol.getConnAtom(atm, i)) == notThisOne || !this.mMol.isElectronegative(connAtm)) continue;
            hetAtm[heteros++] = connAtm;
        }
        return heteros;
    }

    private int getNextConn(int atm, int notThisOne) {
        for (int i = 0; i < this.mMol.getConnAtoms(atm); ++i) {
            if (this.mMol.getConnAtom(atm, i) == notThisOne) continue;
            return this.mMol.getConnAtom(atm, i);
        }
        return -1;
    }

    private boolean checkAnhydride(int hetAtm, int notThisOne) {
        for (int i = 0; i < this.mMol.getConnAtoms(hetAtm); ++i) {
            int connAtm = this.mMol.getConnAtom(hetAtm, i);
            if (connAtm == notThisOne || !this.hasDBondToHetero(connAtm)) continue;
            return true;
        }
        return false;
    }

    private boolean bondToMet(int atm) {
        for (int i = 0; i < this.mMol.getConnAtoms(atm); ++i) {
            if (!this.mMol.isMetalAtom(this.mMol.getConnAtom(atm, i))) continue;
            return true;
        }
        return false;
    }

    private boolean isQuinone(int atm) {
        int i;
        int[] members = new int[6];
        int[] hetAtm = new int[16];
        if (this.getRingMembers(atm, 6, false, members) != 6) {
            return false;
        }
        boolean secCOfound = false;
        for (i = 1; i < 6; ++i) {
            if (this.mMol.getAtomicNo(members[i]) != 6) {
                return false;
            }
            if (this.getAtomPi(members[i]) != 0) continue;
            if ((i & 1) == 0) {
                return false;
            }
            if (secCOfound) {
                return false;
            }
            if (this.getAtomZ(members[i]) != 2) {
                return false;
            }
            if (this.getHeteros(members[i], hetAtm, -1) != 1) {
                return false;
            }
            if (this.mMol.getAtomicNo(hetAtm[0]) != 8) {
                return false;
            }
            secCOfound = true;
        }
        if (!secCOfound) {
            return false;
        }
        for (i = 1; i < 6; ++i) {
            this.mMol.setAtomMarker(members[i], false);
        }
        return true;
    }

    private boolean isThreeRingAtom(int atom) {
        return this.mMol.getAtomRingSize(atom) == 3;
    }

    private int getAtomPi(int atom) {
        int pi = 0;
        for (int i = 0; i < this.mMol.getConnAtoms(atom); ++i) {
            if (this.mMol.getAtomicNo(this.mMol.getConnAtom(atom, i)) != 6) continue;
            pi += this.mMol.getConnBondOrder(atom, i) - 1;
        }
        return pi;
    }

    private int getAtomSigma(int atom) {
        int sigma = 0;
        for (int i = 0; i < this.mMol.getConnAtoms(atom); ++i) {
            if (this.mMol.getAtomicNo(this.mMol.getConnAtom(atom, i)) != 6) continue;
            ++sigma;
        }
        return sigma;
    }

    private int getAtomZ(int atom) {
        int z = 0;
        for (int i = 0; i < this.mMol.getConnAtoms(atom); ++i) {
            if (!this.mMol.isElectronegative(this.mMol.getConnAtom(atom, i))) continue;
            z += this.mMol.getConnBondOrder(atom, i);
        }
        return z;
    }
}

