/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.reaction;

import com.actelion.research.chem.SSSearcher;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.reaction.CommonSubGraphHelper;
import com.actelion.research.chem.reaction.IReactionMapper;
import com.actelion.research.chem.reaction.Reaction;
import java.util.ArrayList;
import java.util.Arrays;

public class MCSReactionMapper
implements IReactionMapper {
    private static int[] COLORTABLE = new int[]{0, 64, 128, 192, 256, 320, 384};
    static final int PRODUCTFLAG = 200;
    static final int REACTANTFLAG_ATOMNUMBER = 105;
    static final int PRODUCTFLAG_ATOMNUMBER = 106;
    static final int REACTANTFLAG = 100;
    private int mapIndex = 0;
    private static int colorIndex = 1;

    public static int getNextColor() {
        ++colorIndex;
        if ((colorIndex %= COLORTABLE.length) == 0) {
            ++colorIndex;
        }
        return COLORTABLE[colorIndex];
    }

    public Reaction matchReaction(Reaction reaction) {
        return this.mapReaction(reaction, null);
    }

    @Override
    public Reaction mapReaction(Reaction reaction, SSSearcher sss) {
        this.mapIndex = 0;
        try {
            CommonSubGraphHelper.Result mcsResult = CommonSubGraphHelper.getMCS(reaction, null, sss);
            while (mcsResult != null) {
                int atomMass;
                int t;
                int atom;
                int i;
                int color = MCSReactionMapper.getNextColor();
                StereoMolecule fragment = mcsResult.getMolecule();
                fragment.setFragment(true);
                StereoMolecule target = reaction.getReactant(mcsResult.getReactant());
                int[] matchList = this.findMatches(fragment, target, sss);
                if (matchList == null || matchList.length <= 0) break;
                this.applyMaps(fragment, target, matchList);
                for (i = 0; i < matchList.length; ++i) {
                    atom = matchList[i];
                    t = 100 + target.getAtomicNo(atom);
                    target.setAtomList(atom, new int[]{t});
                    atomMass = target.getAtomMass(atom);
                    target.setAtomicNo(atom, 105);
                    target.setAtomMass(atom, atomMass);
                }
                target = reaction.getProduct(mcsResult.getProduct());
                fragment.setFragment(true);
                matchList = this.findMatches(fragment, target, sss);
                this.applySourceMapOnTarget(fragment, target, matchList);
                for (i = 0; i < matchList.length; ++i) {
                    atom = matchList[i];
                    t = 200 + target.getAtomicNo(atom);
                    target.setAtomList(atom, new int[]{t});
                    atomMass = target.getAtomMass(atom);
                    target.setAtomicNo(atom, 106);
                    target.setAtomMass(atom, atomMass);
                }
                System.out.println(mcsResult);
                mcsResult = CommonSubGraphHelper.getMCS(reaction, null, sss);
            }
            for (int i = 0; i < reaction.getMolecules(); ++i) {
                StereoMolecule mol = reaction.getMolecule(i);
                for (int j = 0; j < mol.getAllAtoms(); ++j) {
                    if (mol.getAtomicNo(j) == 105) {
                        if (mol.getAtomList(j) == null) continue;
                        int atomMass = mol.getAtomMass(j);
                        mol.setAtomicNo(j, mol.getAtomList(j)[0] - 100);
                        mol.setAtomMass(j, atomMass);
                        mol.setAtomList(j, null);
                        continue;
                    }
                    if (mol.getAtomicNo(j) != 106 || mol.getAtomList(j) == null) continue;
                    int atomMass = mol.getAtomMass(j);
                    mol.setAtomicNo(j, mol.getAtomList(j)[0] - 200);
                    mol.setAtomMass(j, atomMass);
                    mol.setAtomList(j, null);
                }
            }
            reaction.setFragment(false);
            return reaction;
        }
        catch (Exception e1) {
            e1.printStackTrace();
            return null;
        }
    }

    public void resetFragments(Reaction rxn) {
        for (int i = 0; i < rxn.getMolecules(); ++i) {
            rxn.getMolecule(i).setFragment(false);
        }
    }

    public void removeMapping(Reaction reaction) {
        for (int i = 0; i < reaction.getMolecules(); ++i) {
            StereoMolecule mol = reaction.getMolecule(i);
            for (int j = 0; j < mol.getAllAtoms(); ++j) {
                mol.setAtomMapNo(j, 0, false);
            }
        }
    }

    private int[] findMatches(StereoMolecule fragment, StereoMolecule molecule, SSSearcher searcher) {
        searcher.setMol(fragment, molecule);
        int a = searcher.findFragmentInMolecule(4, 8);
        ArrayList<int[]> matchList = searcher.getMatchList();
        if (matchList != null && matchList.size() != 0) {
            return matchList.get(0);
        }
        return null;
    }

    private int[] highlightQuery(StereoMolecule fragment, StereoMolecule molecule, int color, SSSearcher searcher) {
        searcher.setMol(fragment, molecule);
        int a = searcher.findFragmentInMolecule(4, 8);
        ArrayList<int[]> matchList = searcher.getMatchList();
        if (matchList != null && matchList.size() != 0) {
            for (int[] matching : matchList) {
                for (int k = 0; k < matching.length; ++k) {
                    molecule.setAtomColor(matching[k], color);
                }
            }
            return matchList.get(0);
        }
        return null;
    }

    private void applyMaps(StereoMolecule fragment, StereoMolecule molecule, int[] matchList) {
        for (int atom = 0; atom < matchList.length; ++atom) {
            fragment.setAtomMapNo(atom, ++this.mapIndex, true);
            molecule.setAtomMapNo(matchList[atom], this.mapIndex, true);
        }
    }

    private void applySourceMapOnTarget(StereoMolecule source, StereoMolecule target, int[] matchList) {
        for (int atom = 0; atom < matchList.length; ++atom) {
            int map = source.getAtomMapNo(atom);
            target.setAtomMapNo(matchList[atom], map, true);
        }
    }

    private boolean validateMapping(Reaction reaction) {
        int reactants = reaction.getReactants();
        int products = reaction.getProducts();
        int[][] rMaps = new int[reactants][];
        int[][] pMaps = new int[products][];
        for (int r = 0; r < reactants; ++r) {
            StereoMolecule src = reaction.getReactant(r);
            rMaps[r] = this.getMappingNos(src);
        }
        for (int p = 0; p < products; ++p) {
            StereoMolecule target = reaction.getProduct(p);
            pMaps[p] = this.getMappingNos(target);
        }
        return this.matchMappings(rMaps, pMaps);
    }

    private boolean matchMappings(int[][] rMaps, int[][] pMaps) {
        for (int i = 0; i < rMaps.length; ++i) {
            for (int sourceMapNo : rMaps[i]) {
                if (sourceMapNo == 0) continue;
                boolean found = false;
                for (int j = 0; j < pMaps.length; ++j) {
                    for (int targetMapNo : pMaps[j]) {
                        if (sourceMapNo != targetMapNo) continue;
                        found = true;
                    }
                }
                if (found) continue;
                return false;
            }
        }
        return true;
    }

    private int[] getMappingNos(StereoMolecule molecule) {
        int[] ret = new int[molecule.getAllAtoms()];
        int atoms = molecule.getAllAtoms();
        for (int atom = 0; atom < atoms; ++atom) {
            ret[atoms] = molecule.getAtomMapNo(atom);
        }
        return ret;
    }

    private void remove(StereoMolecule fragment, StereoMolecule reactant, StereoMolecule product) {
        StereoMolecule[] candidates;
        SSSearcher searcher = new SSSearcher();
        for (StereoMolecule candidate : candidates = new StereoMolecule[]{reactant, product}) {
            searcher.setMol(fragment, candidate);
            searcher.findFragmentInMolecule(4, 8);
            ArrayList<int[]> matchList = searcher.getMatchList();
            if (matchList == null || matchList.size() == 0) continue;
            int count = 0;
            for (int[] matching : matchList) {
                for (int k = 0; k < matching.length; ++k) {
                    ++count;
                }
            }
            int[] remove = new int[count];
            int idx = 0;
            for (int[] matching : matchList) {
                for (int k = 0; k < matching.length; ++k) {
                    remove[idx++] = matching[k];
                }
            }
            Arrays.sort(remove);
            for (int i = remove.length - 1; i >= 0; --i) {
                candidate.deleteAtom(remove[i]);
            }
        }
    }
}

