/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.reaction;

import com.actelion.research.chem.DrawingObjectList;
import com.actelion.research.chem.Molecule;
import com.actelion.research.chem.StereoMolecule;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;

public class Reaction
implements Serializable {
    static final long serialVersionUID = 537316094L;
    private ArrayList<StereoMolecule> mReactant = new ArrayList();
    private ArrayList<StereoMolecule> mProduct = new ArrayList();
    private ArrayList<StereoMolecule> mCatalyst = new ArrayList();
    private DrawingObjectList mDrawingObjectList;
    private String mName;
    private int mMaxMapNo = -1;
    private boolean mIsFragment = false;

    public Reaction() {
    }

    public Reaction(String name) {
        this();
        this.mName = name;
    }

    public void clear() {
        this.mReactant.clear();
        this.mProduct.clear();
        this.mCatalyst.clear();
        this.mDrawingObjectList = null;
        this.mMaxMapNo = -1;
    }

    public void removeCatalysts() {
        this.mCatalyst.clear();
    }

    public void removeAtomMapping(boolean keepManualMapping) {
        for (StereoMolecule mol : this.mReactant) {
            mol.removeAtomMapping(keepManualMapping);
        }
        for (StereoMolecule mol : this.mProduct) {
            mol.removeAtomMapping(keepManualMapping);
        }
    }

    public void removeDrawingObjects() {
        this.mDrawingObjectList = null;
    }

    public boolean isEmpty() {
        for (StereoMolecule mol : this.mReactant) {
            if (mol.getAllAtoms() == 0) continue;
            return false;
        }
        for (StereoMolecule mol : this.mProduct) {
            if (mol.getAllAtoms() == 0) continue;
            return false;
        }
        for (StereoMolecule mol : this.mCatalyst) {
            if (mol.getAllAtoms() == 0) continue;
            return false;
        }
        return true;
    }

    public void setFragment(boolean f) {
        this.mIsFragment = f;
        for (StereoMolecule mol : this.mReactant) {
            mol.setFragment(f);
        }
        for (StereoMolecule mol : this.mProduct) {
            mol.setFragment(f);
        }
    }

    public boolean isFragment() {
        return this.mIsFragment || this.determineFragment();
    }

    private boolean determineFragment() {
        for (StereoMolecule mol : this.mReactant) {
            if (!mol.isFragment()) continue;
            return true;
        }
        for (StereoMolecule mol : this.mProduct) {
            if (!mol.isFragment()) continue;
            return true;
        }
        return false;
    }

    public Reaction(Reaction rxn) {
        this();
        int i;
        int p;
        int r;
        int n = rxn == null ? 0 : (r = rxn.mReactant == null ? 0 : rxn.mReactant.size());
        int n2 = rxn == null ? 0 : (p = rxn.mProduct == null ? 0 : rxn.mProduct.size());
        int c = rxn == null ? 0 : (rxn.mCatalyst == null ? 0 : rxn.mCatalyst.size());
        for (i = 0; i < r; ++i) {
            this.mReactant.add(new StereoMolecule(rxn.getReactant(i)));
        }
        for (i = 0; i < p; ++i) {
            this.mProduct.add(new StereoMolecule(rxn.getProduct(i)));
        }
        for (i = 0; i < c; ++i) {
            this.mCatalyst.add(new StereoMolecule(rxn.getCatalyst(i)));
        }
        this.mDrawingObjectList = new DrawingObjectList(rxn.getDrawingObjects());
        if (rxn.mName != null) {
            this.mName = rxn.mName;
        }
        this.mIsFragment = rxn.isFragment();
    }

    public Reaction(StereoMolecule[] mol, int reactantCount) {
        this();
        if (mol != null) {
            int i;
            for (i = 0; i < reactantCount; ++i) {
                this.mReactant.add(mol[i]);
            }
            for (i = reactantCount; i < mol.length; ++i) {
                this.mProduct.add(mol[i]);
            }
        }
        this.mIsFragment = this.determineFragment();
    }

    public StereoMolecule getReactant(int no) {
        return this.mReactant.get(no);
    }

    public int getReactants() {
        return this.mReactant.size();
    }

    public StereoMolecule getProduct(int no) {
        return this.mProduct.get(no);
    }

    public int getProducts() {
        return this.mProduct.size();
    }

    public StereoMolecule getCatalyst(int no) {
        return this.mCatalyst.get(no);
    }

    public int getCatalysts() {
        return this.mCatalyst.size();
    }

    public int getMolecules() {
        return this.mReactant.size() + this.mProduct.size();
    }

    public StereoMolecule getMolecule(int no) {
        return no < this.mReactant.size() ? this.mReactant.get(no) : this.mProduct.get(no - this.mReactant.size());
    }

    public void addReactant(StereoMolecule reactant) {
        this.mReactant.add(reactant);
        this.mMaxMapNo = -1;
    }

    public void addReactant(StereoMolecule reactant, int position) {
        this.mReactant.add(position, reactant);
        this.mMaxMapNo = -1;
    }

    public void addProduct(StereoMolecule product) {
        this.mProduct.add(product);
        this.mMaxMapNo = -1;
    }

    public void addProduct(StereoMolecule product, int position) {
        this.mProduct.add(position, product);
        this.mMaxMapNo = -1;
    }

    public void addCatalyst(StereoMolecule catalyst) {
        this.mCatalyst.add(catalyst);
    }

    public void addCatalyst(StereoMolecule catalyst, int position) {
        this.mCatalyst.add(position, catalyst);
    }

    public String getName() {
        return this.mName == null ? "" : this.mName;
    }

    public void setName(String name) {
        this.mName = name;
    }

    public DrawingObjectList getDrawingObjects() {
        return this.mDrawingObjectList;
    }

    public void setDrawingObjects(DrawingObjectList l) {
        this.mDrawingObjectList = l;
    }

    public double getAverageBondLength() {
        int bondCount = 0;
        double avbl = 0.0;
        for (int i = 0; i < this.getMolecules(); ++i) {
            StereoMolecule mol = this.getMolecule(i);
            if (mol.getAllBonds() == 0) continue;
            bondCount += mol.getAllBonds();
            avbl += mol.getAverageBondLength() * (double)mol.getAllBonds();
        }
        return bondCount == 0 ? Molecule.getDefaultAverageBondLength() : avbl / (double)bondCount;
    }

    public boolean isReactionLayoutRequired() {
        if (this.getMolecules() <= 1) {
            return false;
        }
        double avbl = this.getAverageBondLength();
        Rectangle2D.Double[] r = new Rectangle2D.Double[this.getMolecules()];
        for (int i = 0; i < this.getMolecules(); ++i) {
            r[i] = this.getMolecule(i).getBounds(null);
            if (r[i] == null) continue;
            for (int j = 0; j < i; ++j) {
                if (r[j] == null) continue;
                if (r[i].x + r[i].width >= r[j].x && r[i].x <= r[j].x + r[j].width) {
                    return true;
                }
                if (!(r[i].y + r[i].height >= r[j].y) || !(r[i].y <= r[j].y + r[j].height)) continue;
                return true;
            }
            if (i == 0 || r[i - 1] == null) continue;
            if (r[i].x - r[i - 1].x - r[i].width > 5.0 * avbl) {
                return true;
            }
            if (!(r[i].y - r[i - 1].y - r[i].height > 5.0 * avbl)) continue;
            return true;
        }
        return false;
    }

    public boolean isPerfectlyMapped() {
        int mapNo;
        int atom;
        int atoms = 0;
        for (StereoMolecule reactant : this.mReactant) {
            reactant.ensureHelperArrays(1);
            atoms += reactant.getAtoms();
        }
        for (StereoMolecule product : this.mProduct) {
            product.ensureHelperArrays(1);
            atoms -= product.getAtoms();
        }
        if (atoms != 0) {
            return false;
        }
        int maxMapNo = this.getHighestMapNo();
        boolean[] isUsed = new boolean[maxMapNo + 1];
        for (StereoMolecule reactant : this.mReactant) {
            for (atom = 0; atom < reactant.getAtoms(); ++atom) {
                mapNo = reactant.getAtomMapNo(atom);
                if (isUsed[mapNo]) {
                    return false;
                }
                isUsed[mapNo] = true;
            }
        }
        for (StereoMolecule product : this.mProduct) {
            product.ensureHelperArrays(1);
            for (atom = 0; atom < product.getAtoms(); ++atom) {
                mapNo = product.getAtomMapNo(atom);
                if (mapNo >= maxMapNo || !isUsed[mapNo]) {
                    return false;
                }
                isUsed[mapNo] = false;
            }
        }
        return true;
    }

    public int getHighestMapNo() {
        if (this.mMaxMapNo != -1) {
            return this.mMaxMapNo;
        }
        this.mMaxMapNo = 0;
        for (int i = 0; i < this.getMolecules(); ++i) {
            StereoMolecule mol = this.getMolecule(i);
            for (int atom = 0; atom < mol.getAllAtoms(); ++atom) {
                if (this.mMaxMapNo >= mol.getAtomMapNo(atom)) continue;
                this.mMaxMapNo = mol.getAtomMapNo(atom);
            }
        }
        return this.mMaxMapNo;
    }

    public void validateMapping() throws Exception {
        int i;
        StereoMolecule product;
        int mapNo;
        StereoMolecule reactant;
        int maxMapNo = this.getHighestMapNo();
        boolean[] mapNoInReactant = new boolean[maxMapNo + 1];
        for (int i2 = 0; i2 < this.mReactant.size(); ++i2) {
            reactant = this.mReactant.get(i2);
            for (int j = 0; j < reactant.getAllAtoms(); ++j) {
                mapNo = reactant.getAtomMapNo(j);
                if (mapNo == 0) continue;
                if (mapNoInReactant[mapNo]) {
                    throw new Exception("Duplicate mapping no in reactants");
                }
                mapNoInReactant[mapNo] = true;
            }
        }
        boolean[] mapNoInProduct = new boolean[maxMapNo + 1];
        for (int i3 = 0; i3 < this.mProduct.size(); ++i3) {
            product = this.mProduct.get(i3);
            for (int j = 0; j < product.getAllAtoms(); ++j) {
                int mapNo2 = product.getAtomMapNo(j);
                if (mapNo2 == 0) continue;
                if (mapNoInProduct[mapNo2]) {
                    throw new Exception("Duplicate mapping no in products");
                }
                mapNoInProduct[mapNo2] = true;
            }
        }
        int[] newMapNo = new int[maxMapNo + 1];
        mapNo = 0;
        for (i = 1; i <= maxMapNo; ++i) {
            if (!mapNoInReactant[i] || !mapNoInProduct[i]) continue;
            newMapNo[i] = ++mapNo;
        }
        if (mapNo != maxMapNo) {
            int j;
            for (i = 0; i < this.mReactant.size(); ++i) {
                reactant = this.mReactant.get(i);
                for (j = 0; j < reactant.getAllAtoms(); ++j) {
                    reactant.setAtomMapNo(j, newMapNo[reactant.getAtomMapNo(j)], reactant.isAutoMappedAtom(j));
                }
            }
            for (i = 0; i < this.mProduct.size(); ++i) {
                product = this.mProduct.get(i);
                for (j = 0; j < product.getAllAtoms(); ++j) {
                    product.setAtomMapNo(j, newMapNo[product.getAtomMapNo(j)], product.isAutoMappedAtom(j));
                }
            }
        }
    }

    public boolean[] getReactionCenterMapNos() {
        if (this.getReactants() == 0 || this.getProducts() == 0) {
            return null;
        }
        int maxMapNo = this.getHighestMapNo();
        if (maxMapNo == 0) {
            return null;
        }
        int[][] mapNo2Atom = new int[this.getProducts()][];
        for (int i = 0; i < this.getProducts(); ++i) {
            StereoMolecule product = this.getProduct(i);
            product.ensureHelperArrays(15);
            mapNo2Atom[i] = new int[maxMapNo + 1];
            Arrays.fill(mapNo2Atom[i], -1);
            int atom = 0;
            while (atom < product.getAllAtoms()) {
                int mapNo = product.getAtomMapNo(atom);
                if (mapNo != 0 && mapNo2Atom[i][mapNo] != -1) {
                    return null;
                }
                mapNo2Atom[i][mapNo] = atom++;
            }
        }
        boolean[] isReactionCenter = new boolean[maxMapNo + 1];
        for (int i = 0; i < this.getReactants(); ++i) {
            StereoMolecule reactant = this.getReactant(i);
            reactant.ensureHelperArrays(15);
            block3: for (int rAtom = 0; rAtom < reactant.getAllAtoms(); ++rAtom) {
                int mapNo = reactant.getAtomMapNo(rAtom);
                if (mapNo == 0 || isReactionCenter[mapNo]) continue;
                for (int j = 0; j < this.getProducts(); ++j) {
                    int pAtom = mapNo2Atom[j][mapNo];
                    if (pAtom == -1) continue;
                    StereoMolecule product = this.getProduct(j);
                    if (reactant.getConnAtoms(rAtom) != product.getConnAtoms(pAtom)) {
                        isReactionCenter[mapNo] = true;
                        continue block3;
                    }
                    if (reactant.getAtomParity(rAtom) != product.getAtomParity(pAtom)) {
                        isReactionCenter[mapNo] = true;
                        continue block3;
                    }
                    for (int k = 0; k < reactant.getConnAtoms(rAtom); ++k) {
                        int connMapNo = reactant.getAtomMapNo(reactant.getConnAtom(rAtom, k));
                        if (connMapNo == 0) {
                            isReactionCenter[mapNo] = true;
                            continue;
                        }
                        int rBond = reactant.getConnBond(rAtom, k);
                        boolean connMapNoFound = false;
                        for (int l = 0; l < product.getConnAtoms(pAtom); ++l) {
                            int productConnMapNo = product.getAtomMapNo(product.getConnAtom(pAtom, l));
                            if (productConnMapNo == 0) {
                                isReactionCenter[mapNo] = true;
                                break;
                            }
                            if (productConnMapNo != connMapNo) continue;
                            connMapNoFound = true;
                            int pBond = product.getConnBond(pAtom, l);
                            if (!(reactant.isDelocalizedBond(rBond) ^ product.isDelocalizedBond(pBond)) && (reactant.isDelocalizedBond(rBond) || reactant.getBondOrder(rBond) == product.getBondOrder(pBond) && reactant.getBondParity(rBond) == product.getBondParity(pBond))) break;
                            isReactionCenter[mapNo] = true;
                            isReactionCenter[connMapNo] = true;
                            break;
                        }
                        if (connMapNoFound) continue;
                        isReactionCenter[mapNo] = true;
                    }
                }
            }
        }
        return isReactionCenter;
    }

    public int getReactionCenterAtoms(int moleculeNo, boolean[] isReactionCenterMapNo, boolean[] isReactionCenterAtom, int[] reactionCenterAtom) {
        StereoMolecule mol = this.getMolecule(moleculeNo);
        if (isReactionCenterAtom == null) {
            isReactionCenterAtom = new boolean[mol.getAllAtoms()];
        }
        int atomCount = 0;
        for (int atom = 0; atom < mol.getAllAtoms(); ++atom) {
            if (!isReactionCenterMapNo[mol.getAtomMapNo(atom)]) continue;
            isReactionCenterAtom[atom] = true;
            if (reactionCenterAtom != null) {
                reactionCenterAtom[atomCount] = atom;
            }
            ++atomCount;
        }
        for (int bond = 0; bond < mol.getAllBonds(); ++bond) {
            int atom1 = mol.getBondAtom(0, bond);
            int atom2 = mol.getBondAtom(1, bond);
            if (!(mol.getAtomMapNo(atom1) == 0 ^ mol.getAtomMapNo(atom2) == 0)) continue;
            if (!isReactionCenterAtom[atom1]) {
                isReactionCenterAtom[atom1] = true;
                if (reactionCenterAtom != null) {
                    reactionCenterAtom[atomCount] = atom1;
                }
                ++atomCount;
            }
            if (isReactionCenterAtom[atom2]) continue;
            isReactionCenterAtom[atom2] = true;
            if (reactionCenterAtom != null) {
                reactionCenterAtom[atomCount] = atom2;
            }
            ++atomCount;
        }
        return atomCount;
    }

    public Reaction getMergedCopy() {
        int i;
        Reaction mergedReaction = new Reaction();
        if (this.mReactant.size() != 0) {
            StereoMolecule reactant = new StereoMolecule(this.mReactant.get(0));
            for (i = 1; i < this.mReactant.size(); ++i) {
                reactant.addMolecule(this.mReactant.get(i));
            }
            mergedReaction.addReactant(reactant);
        }
        if (this.mProduct.size() != 0) {
            StereoMolecule product = new StereoMolecule(this.mProduct.get(0));
            for (i = 1; i < this.mProduct.size(); ++i) {
                product.addMolecule(this.mProduct.get(i));
            }
            mergedReaction.addProduct(product);
        }
        return mergedReaction;
    }
}

