/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.reaction;

import com.actelion.research.chem.AbstractDrawingObject;
import com.actelion.research.chem.DepictorTransformation;
import com.actelion.research.chem.Molecule;
import com.actelion.research.gui.generic.GenericDrawContext;
import com.actelion.research.gui.generic.GenericPoint;
import com.actelion.research.gui.generic.GenericPolygon;
import com.actelion.research.gui.generic.GenericRectangle;
import com.actelion.research.util.ColorHelper;

public class ReactionArrow
extends AbstractDrawingObject {
    public static final String TYPE_STRING = "arrow";
    private static final int PART_NONE = 0;
    private static final int PART_ARROW_START = 1;
    private static final int PART_ARROW_END = 2;
    private static final int PART_ARROW = 3;
    int mHiliteStatus;

    public ReactionArrow() {
        this.mPoint = new GenericPoint[2];
        this.mPoint[0] = new GenericPoint();
        this.mPoint[1] = new GenericPoint();
        this.mHiliteStatus = 0;
    }

    public ReactionArrow(String descriptorDetail) {
        this();
        int index2;
        int index1 = 0;
        while (index1 != -1 && (index2 = descriptorDetail.indexOf("=\"", index1)) != -1) {
            String value;
            String key = descriptorDetail.substring(index1 + 1, index2);
            index1 = descriptorDetail.indexOf("\"", index2 + 2);
            String string = value = index1 == -1 ? descriptorDetail.substring(index2 + 1) : descriptorDetail.substring(index2 + 1, index1);
            if (key.equals("x1")) {
                try {
                    this.mPoint[0].x = Float.parseFloat(value);
                }
                catch (NumberFormatException numberFormatException) {}
                continue;
            }
            if (key.equals("y1")) {
                try {
                    this.mPoint[0].y = Float.parseFloat(value);
                }
                catch (NumberFormatException numberFormatException) {}
                continue;
            }
            if (key.equals("x2")) {
                try {
                    this.mPoint[1].x = Float.parseFloat(value);
                }
                catch (NumberFormatException numberFormatException) {}
                continue;
            }
            if (!key.equals("y2")) continue;
            try {
                this.mPoint[1].y = Float.parseFloat(value);
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    @Override
    public String getTypeString() {
        return TYPE_STRING;
    }

    @Override
    public String getDescriptorDetail() {
        StringBuilder detail = new StringBuilder();
        detail.append(" x1=\"" + this.mPoint[0].x + "\"");
        detail.append(" y1=\"" + this.mPoint[0].y + "\"");
        detail.append(" x2=\"" + this.mPoint[1].x + "\"");
        detail.append(" y2=\"" + this.mPoint[1].y + "\"");
        return detail.toString();
    }

    @Override
    public AbstractDrawingObject clone() {
        ReactionArrow arrow = new ReactionArrow();
        arrow.mPoint[0].x = this.mPoint[0].x;
        arrow.mPoint[0].y = this.mPoint[0].y;
        arrow.mPoint[1].x = this.mPoint[1].x;
        arrow.mPoint[1].y = this.mPoint[1].y;
        arrow.mIsSelected = this.mIsSelected;
        return arrow;
    }

    public float getLength() {
        int dx = (int)(this.mPoint[1].x - this.mPoint[0].x);
        int dy = (int)(this.mPoint[1].y - this.mPoint[0].y);
        return (float)Math.sqrt(dx * dx + dy * dy);
    }

    public void setCoordinates(double x1, double y1, double x2, double y2) {
        this.mPoint[0].x = x1;
        this.mPoint[0].y = y1;
        this.mPoint[1].x = x2;
        this.mPoint[1].y = y2;
    }

    @Override
    public void translate(double x, double y) {
        switch (this.mHiliteStatus) {
            case 1: {
                this.mPoint[0].x = this.mTransformationValue1[0] + x - this.mTransformationReferenceX;
                this.mPoint[0].y = this.mTransformationValue2[0] + y - this.mTransformationReferenceY;
                break;
            }
            case 2: {
                this.mPoint[1].x = this.mTransformationValue1[1] + x - this.mTransformationReferenceX;
                this.mPoint[1].y = this.mTransformationValue2[1] + y - this.mTransformationReferenceY;
                break;
            }
            default: {
                super.translate(x, y);
            }
        }
    }

    @Override
    public void draw(GenericDrawContext context, DepictorTransformation t) {
        context.setRGB(this.mIsSelected ? ColorHelper.getContrastColor(0xFF0000, context.getBackgroundRGB()) : context.getForegroundRGB());
        double x1 = t == null ? this.mPoint[0].x : t.transformX(this.mPoint[0].x);
        double y1 = t == null ? this.mPoint[0].y : t.transformY(this.mPoint[0].y);
        double x2 = t == null ? this.mPoint[1].x : t.transformX(this.mPoint[1].x);
        double y2 = t == null ? this.mPoint[1].y : t.transformY(this.mPoint[1].y);
        double dx = x2 - x1;
        double dy = y2 - y1;
        context.setLineWidth(Math.max(1.0f, 0.02f * (float)Math.sqrt(dx * dx + dy * dy)));
        context.drawLine(x1, y1, x2, y2);
        GenericPolygon p = new GenericPolygon(4);
        p.addPoint(x2 + dx / 40.0, y2 + dy / 40.0);
        p.addPoint(x2 - dx / 5.0 + dy / 10.0, y2 - dy / 5.0 - dx / 10.0);
        p.addPoint(x2 - dx / 20.0, y2 - dy / 20.0);
        p.addPoint(x2 - dx / 5.0 - dy / 10.0, y2 - dy / 5.0 + dx / 10.0);
        context.fillPolygon(p);
    }

    @Override
    public void hilite(GenericDrawContext context) {
        context.setRGB(context.getSelectionBackgroundRGB());
        switch (this.mHiliteStatus) {
            case 1: {
                context.fillCircle(this.mPoint[0].x - 8.0, this.mPoint[0].y - 8.0, 16.0);
                break;
            }
            case 2: {
                context.fillCircle(this.mPoint[1].x - 8.0, this.mPoint[1].y - 8.0, 16.0);
                break;
            }
            case 3: {
                double length = this.getLength();
                double f = Math.max(length / 8.0, 3.0);
                double angle = Molecule.getAngle(this.mPoint[0].x, this.mPoint[0].y, this.mPoint[1].x, this.mPoint[1].y);
                double dx = f * Math.cos(angle);
                double dy = -f * Math.sin(angle);
                GenericPolygon p = new GenericPolygon(4);
                p.addPoint(this.mPoint[0].x + dx, this.mPoint[0].y + dy);
                p.addPoint(this.mPoint[1].x + dx, this.mPoint[1].y + dy);
                p.addPoint(this.mPoint[1].x - dx, this.mPoint[1].y - dy);
                p.addPoint(this.mPoint[0].x - dx, this.mPoint[0].y - dy);
                context.fillPolygon(p);
            }
        }
    }

    @Override
    public boolean contains(double x, double y) {
        return this.findPart(x, y) != 0;
    }

    @Override
    public boolean checkHiliting(double x, double y) {
        this.mHiliteStatus = this.findPart(x, y);
        return this.mHiliteStatus != 0;
    }

    @Override
    public void clearHiliting() {
        this.mHiliteStatus = 0;
    }

    private int findPart(double x, double y) {
        double distanceToStart = Math.sqrt((this.mPoint[0].x - x) * (this.mPoint[0].x - x) + (this.mPoint[0].y - y) * (this.mPoint[0].y - y));
        if (distanceToStart < 8.0) {
            return 1;
        }
        double distanceToEnd = Math.sqrt((this.mPoint[1].x - x) * (this.mPoint[1].x - x) + (this.mPoint[1].y - y) * (this.mPoint[1].y - y));
        if (distanceToEnd < 8.0) {
            return 2;
        }
        double arrowLength = Math.sqrt((this.mPoint[1].x - this.mPoint[0].x) * (this.mPoint[1].x - this.mPoint[0].x) + (this.mPoint[1].y - this.mPoint[0].y) * (this.mPoint[1].y - this.mPoint[0].y));
        if (distanceToStart + distanceToEnd < arrowLength + 5.0) {
            return 3;
        }
        return 0;
    }

    @Override
    public GenericRectangle getBoundingRect(GenericDrawContext context) {
        double length = this.getLength();
        double f = Math.max(length / 8.0, 3.0);
        double angle = Molecule.getAngle(this.mPoint[0].x, this.mPoint[0].y, this.mPoint[1].x, this.mPoint[1].y);
        double dx = Math.abs(f * Math.cos(angle));
        double dy = Math.abs(f * Math.sin(angle));
        GenericRectangle bounds = new GenericRectangle();
        if (this.mPoint[0].x < this.mPoint[1].x) {
            bounds.x = this.mPoint[0].x - dx;
            bounds.width = this.mPoint[1].x - this.mPoint[0].x + 2.0 * dx;
        } else {
            bounds.x = this.mPoint[1].x - dx;
            bounds.width = this.mPoint[0].x - this.mPoint[1].x + 2.0 * dx;
        }
        if (this.mPoint[0].y < this.mPoint[1].y) {
            bounds.y = this.mPoint[0].y - dy;
            bounds.height = this.mPoint[1].y - this.mPoint[0].y + 2.0 * dy;
        } else {
            bounds.y = this.mPoint[1].y - dy;
            bounds.height = this.mPoint[0].y - this.mPoint[1].y + 2.0 * dy;
        }
        return bounds;
    }

    public boolean isOnProductSide(double x, double y) {
        double dx = this.mPoint[1].x - this.mPoint[0].x;
        double dy = this.mPoint[1].y - this.mPoint[0].y;
        double mx = (this.mPoint[0].x + this.mPoint[1].x) / 2.0;
        double my = (this.mPoint[0].y + this.mPoint[1].y) / 2.0;
        if (dx == 0.0) {
            return dy < 0.0 ^ y > my;
        }
        if (dy == 0.0) {
            return dx < 0.0 ^ x > mx;
        }
        double m = -dx / dy;
        double sx = (this.mPoint[0].x + m * m * x - m * y + m * this.mPoint[0].y) / (1.0 + m * m);
        return dx < 0.0 ^ sx > mx;
    }
}

