/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.reaction;

import com.actelion.research.chem.Canonizer;
import com.actelion.research.chem.DrawingObjectList;
import com.actelion.research.chem.IDCodeParser;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.reaction.Reaction;
import com.actelion.research.util.ArrayUtils;
import java.util.ArrayList;

public class ReactionEncoder {
    public static final char MOLECULE_DELIMITER = ' ';
    public static final char PRODUCT_IDENTIFIER = '!';
    public static final char CATALYST_DELIMITER = '+';
    public static final char OBJECT_DELIMITER = '#';
    public static final String MOLECULE_DELIMITER_STRING = " ";
    public static final String OBJECT_DELIMITER_STRING = "#";
    public static final int INCLUDE_MAPPING = 1;
    public static final int INCLUDE_COORDS = 2;
    public static final int INCLUDE_DRAWING_OBJECTS = 4;
    public static final int INCLUDE_CATALYSTS = 8;
    public static final int INCLUDE_ALL = 15;
    public static final int INCLUDE_RXN_CODE_ONLY = 0;
    public static final int INCLUDE_DEFAULT = 3;
    public static final int RETAIN_REACTANT_AND_PRODUCT_ORDER = 16;

    private ReactionEncoder() {
    }

    public static String[] encode(Reaction reaction, boolean keepAbsoluteCoordinates) {
        return ReactionEncoder.encode(reaction, keepAbsoluteCoordinates, true);
    }

    private static String[] encode(Reaction reaction, boolean keepAbsoluteCoordinates, boolean sortByIDCode) {
        int j;
        String maxString;
        int index;
        int i;
        if (reaction == null || reaction.getReactants() == 0 || reaction.getProducts() == 0) {
            return null;
        }
        String[] idcode = new String[reaction.getMolecules()];
        String[] mapping = new String[reaction.getMolecules()];
        String[] coords = new String[reaction.getMolecules()];
        for (int i2 = 0; i2 < reaction.getMolecules(); ++i2) {
            StereoMolecule mol = reaction.getMolecule(i2);
            if (mol.isFragment() && i2 < reaction.getReactants()) {
                for (int atom = 0; atom < mol.getAllAtoms(); ++atom) {
                    mol.setAtomQueryFeature(atom, -1073741824L, false);
                }
            }
            Canonizer canonizer = new Canonizer(mol);
            idcode[i2] = canonizer.getIDCode();
            if (idcode[i2] == null) {
                return null;
            }
            mapping[i2] = canonizer.getEncodedMapping();
            coords[i2] = canonizer.getEncodedCoordinates(keepAbsoluteCoordinates);
        }
        StringBuilder idcodeSequence = new StringBuilder();
        StringBuilder coordsSequence = new StringBuilder();
        StringBuilder mappingSequence = new StringBuilder();
        for (i = 0; i < reaction.getReactants(); ++i) {
            index = i;
            if (sortByIDCode) {
                maxString = "";
                index = -1;
                for (j = 0; j < reaction.getReactants(); ++j) {
                    if (maxString.compareTo(idcode[j]) >= 0) continue;
                    maxString = idcode[j];
                    index = j;
                }
            }
            if (i > 0) {
                idcodeSequence.append(' ');
                mappingSequence.append(' ');
                coordsSequence.append(' ');
            }
            idcodeSequence.append(idcode[index]);
            mappingSequence.append(mapping[index]);
            coordsSequence.append(coords[index]);
            idcode[index] = "";
        }
        idcodeSequence.append('!');
        mappingSequence.append(' ');
        coordsSequence.append(' ');
        for (i = reaction.getReactants(); i < reaction.getMolecules(); ++i) {
            index = i;
            if (sortByIDCode) {
                maxString = "";
                index = -1;
                for (j = reaction.getReactants(); j < reaction.getMolecules(); ++j) {
                    if (maxString.compareTo(idcode[j]) >= 0) continue;
                    maxString = idcode[j];
                    index = j;
                }
            }
            if (i > reaction.getReactants()) {
                idcodeSequence.append(' ');
                mappingSequence.append(' ');
                coordsSequence.append(' ');
            }
            idcodeSequence.append(idcode[index]);
            mappingSequence.append(mapping[index]);
            coordsSequence.append(coords[index]);
            idcode[index] = "";
        }
        String[] result = new String[5];
        result[0] = idcodeSequence.toString();
        if (mappingSequence.length() > reaction.getMolecules() - 1) {
            result[1] = mappingSequence.toString();
        }
        if (coordsSequence.length() > reaction.getMolecules() - 1) {
            result[2] = coordsSequence.toString();
        }
        if (reaction.getDrawingObjects() != null) {
            result[3] = reaction.getDrawingObjects().toString();
        }
        if (reaction.getCatalysts() != 0) {
            result[4] = ReactionEncoder.encodeCatalysts(reaction, keepAbsoluteCoordinates);
        }
        return result;
    }

    private static String encodeCatalysts(Reaction reaction, boolean keepAbsoluteCoordinates) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < reaction.getCatalysts(); ++i) {
            if (sb.length() != 0) {
                sb.append('+');
            }
            Canonizer canonizer = new Canonizer(reaction.getCatalyst(i));
            sb.append(canonizer.getIDCode());
            if (!keepAbsoluteCoordinates) continue;
            sb.append(MOLECULE_DELIMITER_STRING);
            sb.append(canonizer.getEncodedCoordinates(true));
        }
        return sb.toString();
    }

    public static String encode(Reaction reaction, boolean keepAbsoluteCoordinates, int mode) {
        String[] result = ReactionEncoder.encode(reaction, keepAbsoluteCoordinates, (mode & 0x10) == 0);
        if (result == null) {
            return null;
        }
        StringBuffer buf = new StringBuffer(result[0]);
        if (mode != 0) {
            buf.append('#');
            if ((mode & 1) != 0 && result.length > 1 && result[1] != null) {
                buf.append(result[1]);
            }
        }
        if ((mode &= 0xFFFFFFFE) != 0) {
            buf.append('#');
            if ((mode & 2) != 0 && result.length > 2 && result[2] != null) {
                buf.append(result[2]);
            }
        }
        if ((mode &= 0xFFFFFFFD) != 0) {
            buf.append('#');
            if ((mode & 4) != 0 && result.length > 3 && result[3] != null) {
                buf.append(result[3]);
            }
        }
        if ((mode &= 0xFFFFFFFB) != 0) {
            buf.append('#');
            if ((mode & 8) != 0 && result.length > 4 && result[4] != null) {
                buf.append(result[4]);
            }
        }
        return buf.toString();
    }

    public static Reaction decode(String rxnCode, String rxnMapping, String rxnCoords, String rxnObjects, String rxnCatalysts, boolean ensureCoordinates, Reaction rxn) {
        if (rxnCode == null || rxnCode.length() == 0) {
            return null;
        }
        boolean isProduct = false;
        int idcodeIndex = 0;
        int mappingIndex = 0;
        int coordsIndex = 0;
        int productIndex = rxnCode.indexOf(33);
        if (productIndex == -1) {
            return null;
        }
        if (rxn == null) {
            rxn = new Reaction();
        } else {
            rxn.clear();
        }
        while (idcodeIndex != -1) {
            if (idcodeIndex > productIndex) {
                isProduct = true;
            }
            int delimiterIndex = rxnCode.indexOf(32, idcodeIndex);
            if (!(isProduct || delimiterIndex <= productIndex && delimiterIndex != -1)) {
                delimiterIndex = productIndex;
            }
            String idcode = null;
            if (delimiterIndex == -1) {
                idcode = rxnCode.substring(idcodeIndex);
                idcodeIndex = -1;
            } else {
                idcode = rxnCode.substring(idcodeIndex, delimiterIndex);
                idcodeIndex = delimiterIndex + 1;
            }
            String mapping = null;
            if (rxnMapping != null && rxnMapping.length() != 0) {
                delimiterIndex = rxnMapping.indexOf(32, mappingIndex);
                if (delimiterIndex == -1) {
                    mapping = rxnMapping.substring(mappingIndex);
                } else {
                    mapping = rxnMapping.substring(mappingIndex, delimiterIndex);
                    mappingIndex = delimiterIndex + 1;
                }
            }
            String coords = null;
            if (rxnCoords != null && rxnCoords.length() != 0) {
                delimiterIndex = rxnCoords.indexOf(32, coordsIndex);
                if (delimiterIndex == -1) {
                    coords = rxnCoords.substring(coordsIndex);
                } else {
                    coords = rxnCoords.substring(coordsIndex, delimiterIndex);
                    coordsIndex = delimiterIndex + 1;
                }
            }
            IDCodeParser parser = new IDCodeParser(ensureCoordinates);
            StereoMolecule mol = parser.getCompactMolecule(idcode, coords);
            if (mapping != null) {
                parser.parseMapping(mapping.getBytes());
            }
            if (isProduct) {
                rxn.addProduct(mol);
                continue;
            }
            rxn.addReactant(mol);
        }
        if (rxnObjects != null && rxnObjects.length() != 0) {
            rxn.setDrawingObjects(new DrawingObjectList(rxnObjects));
        }
        if (rxnCatalysts != null && rxnCatalysts.length() != 0) {
            IDCodeParser parser = new IDCodeParser(ensureCoordinates);
            int index1 = 0;
            int index2 = rxnCatalysts.indexOf(43);
            while (index2 != -1) {
                rxn.addCatalyst(parser.getCompactMolecule(rxnCatalysts.substring(index1, index2)));
                index1 = index2 + 1;
                index2 = rxnCatalysts.indexOf(43, index1);
            }
            rxn.addCatalyst(parser.getCompactMolecule(rxnCatalysts.substring(index1)));
        }
        return rxn;
    }

    public static Reaction decode(byte[] rxnCode, byte[] rxnMapping, byte[] rxnCoords, String rxnObjects, byte[] rxnCatalysts, boolean ensureCoordinates) {
        if (rxnCode == null || rxnCode.length == 0) {
            return null;
        }
        boolean isProduct = false;
        int idcodeIndex = 0;
        int mappingIndex = 0;
        int coordsIndex = 0;
        int productIndex = ReactionEncoder.indexOf(rxnCode, '!');
        if (productIndex == -1) {
            return null;
        }
        Reaction rxn = new Reaction();
        while (idcodeIndex != -1) {
            if (idcodeIndex > productIndex) {
                isProduct = true;
            }
            int delimiterIndex = ReactionEncoder.indexOf(rxnCode, ' ', idcodeIndex);
            if (!(isProduct || delimiterIndex <= productIndex && delimiterIndex != -1)) {
                delimiterIndex = productIndex;
            }
            int idcodeStart = idcodeIndex;
            idcodeIndex = delimiterIndex == -1 ? -1 : delimiterIndex + 1;
            int mappingStart = -1;
            if (rxnMapping != null && mappingIndex < rxnMapping.length) {
                mappingStart = rxnMapping[mappingIndex] == 32 ? -1 : mappingIndex;
                delimiterIndex = ReactionEncoder.indexOf(rxnMapping, ' ', mappingIndex);
                if (delimiterIndex != -1) {
                    mappingIndex = delimiterIndex + 1;
                }
            }
            int coordsStart = -1;
            if (rxnCoords != null && rxnCoords.length != 0) {
                coordsStart = coordsIndex;
                delimiterIndex = ReactionEncoder.indexOf(rxnCoords, ' ', coordsIndex);
                if (delimiterIndex != -1) {
                    coordsIndex = delimiterIndex + 1;
                }
            }
            IDCodeParser parser = new IDCodeParser(ensureCoordinates);
            parser.neglectSpaceDelimitedCoordinates();
            StereoMolecule mol = parser.getCompactMolecule(rxnCode, rxnCoords, idcodeStart, coordsStart);
            if (mappingStart != -1) {
                parser.parseMapping(rxnMapping, mappingStart);
            }
            if (isProduct) {
                rxn.addProduct(mol);
                continue;
            }
            rxn.addReactant(mol);
        }
        if (rxnObjects != null && rxnObjects.length() != 0) {
            rxn.setDrawingObjects(new DrawingObjectList(rxnObjects));
        }
        if (rxnCatalysts != null && rxnCatalysts.length != 0) {
            IDCodeParser parser = new IDCodeParser(ensureCoordinates);
            int index1 = 0;
            int index2 = ReactionEncoder.indexOf(rxnCatalysts, '+');
            while (index2 != -1) {
                rxn.addCatalyst(parser.getCompactMolecule(rxnCatalysts, index1));
                index1 = index2 + 1;
                index2 = ReactionEncoder.indexOf(rxnCatalysts, '+', index1);
            }
            rxn.addCatalyst(parser.getCompactMolecule(rxnCatalysts, index1));
        }
        return rxn;
    }

    private static int indexOf(byte[] bytes, char ch) {
        for (int i = 0; i < bytes.length; ++i) {
            if (bytes[i] != ch) continue;
            return i;
        }
        return -1;
    }

    private static int indexOf(byte[] bytes, char ch, int start) {
        for (int i = start; i < bytes.length; ++i) {
            if (bytes[i] != ch) continue;
            return i;
        }
        return -1;
    }

    public static Reaction decode(String s, boolean ensureCoordinates) {
        return ReactionEncoder.decode(s, ensureCoordinates, null);
    }

    public static Reaction decode(String s, boolean ensureCoordinates, Reaction rxn) {
        if (s == null) {
            return null;
        }
        String rxnCode = s;
        String rxnMapping = null;
        String rxnCoords = null;
        String rxnObjects = null;
        String rxnCatalysts = null;
        int index1 = s.indexOf(35);
        if (index1 == -1) {
            rxnCode = s;
        } else {
            rxnCode = s.substring(0, index1);
            int index2 = s.indexOf(35, index1 + 1);
            if (index2 == -1) {
                rxnMapping = s.substring(index1 + 1);
            } else {
                rxnMapping = s.substring(index1 + 1, index2);
                int index3 = s.indexOf(35, index2 + 1);
                if (index3 == -1) {
                    rxnCoords = s.substring(index2 + 1);
                } else {
                    rxnCoords = s.substring(index2 + 1, index3);
                    int index4 = s.indexOf(35, index3 + 1);
                    if (index4 == -1) {
                        rxnObjects = s.substring(index3 + 1);
                    } else {
                        rxnObjects = s.substring(index3 + 1, index4);
                        rxnCatalysts = s.substring(index4 + 1);
                    }
                }
            }
        }
        return ReactionEncoder.decode(rxnCode, rxnMapping, rxnCoords, rxnObjects, rxnCatalysts, ensureCoordinates, rxn);
    }

    public static Reaction decode(String s, int includeOptions, Reaction rxn) {
        if (s == null) {
            return null;
        }
        String rxnCode = s;
        String rxnMapping = null;
        String rxnCoords = null;
        String rxnObjects = null;
        String rxnCatalysts = null;
        int index1 = s.indexOf(35);
        if (index1 == -1) {
            rxnCode = s;
        } else {
            rxnCode = s.substring(0, index1);
            int index2 = s.indexOf(35, index1 + 1);
            if (index2 == -1) {
                rxnMapping = s.substring(index1 + 1);
            } else {
                rxnMapping = s.substring(index1 + 1, index2);
                int index3 = s.indexOf(35, index2 + 1);
                if (index3 == -1) {
                    rxnCoords = s.substring(index2 + 1);
                } else {
                    rxnCoords = s.substring(index2 + 1, index3);
                    int index4 = s.indexOf(35, index3 + 1);
                    if (index4 == -1) {
                        rxnObjects = s.substring(index3 + 1);
                    } else {
                        rxnObjects = s.substring(index3 + 1, index4);
                        rxnCatalysts = s.substring(index4 + 1);
                    }
                }
            }
        }
        return ReactionEncoder.decode(rxnCode, (includeOptions & 1) != 0 ? rxnMapping : null, (includeOptions & 2) != 0 ? rxnCoords : null, (includeOptions & 4) != 0 ? rxnObjects : null, (includeOptions & 8) != 0 ? rxnCatalysts : null, false, rxn);
    }

    public static StereoMolecule[] decodeMolecules(String s, boolean includeCoords, boolean includeMapping, boolean includeReactants, boolean includeProducts) {
        if (s == null) {
            return null;
        }
        byte[] rxnCode = null;
        byte[] rxnMapping = null;
        byte[] rxnCoords = null;
        int index1 = s.indexOf(35);
        if (index1 == -1) {
            rxnCode = s.getBytes();
        } else {
            rxnCode = s.substring(0, index1).getBytes();
            if (includeMapping || includeCoords) {
                int index2 = s.indexOf(35, index1 + 1);
                if (index2 == -1) {
                    if (includeMapping) {
                        rxnMapping = s.substring(index1 + 1).getBytes();
                    }
                } else {
                    if (includeMapping) {
                        rxnMapping = s.substring(index1 + 1, index2).getBytes();
                    }
                    if (includeCoords) {
                        int index3 = s.indexOf(35, index2 + 1);
                        rxnCoords = index3 == -1 ? s.substring(index2 + 1).getBytes() : s.substring(index2 + 1, index3).getBytes();
                    }
                }
            }
        }
        return ReactionEncoder.decodeMolecules(rxnCode, rxnCoords, rxnMapping, includeReactants, includeProducts);
    }

    public static StereoMolecule[] decodeMolecules(byte[] rxnBytes, byte[] coords, byte[] mapping, boolean includeReactants, boolean includeProducts) {
        if (rxnBytes == null || rxnBytes.length == 0) {
            return null;
        }
        int reactantEnd = ArrayUtils.indexOf(rxnBytes, (byte)33);
        if (reactantEnd <= 0) {
            return null;
        }
        int productIndex = reactantEnd + 1;
        int productEnd = ArrayUtils.indexOf(rxnBytes, (byte)35, productIndex);
        if (productEnd == -1) {
            productEnd = rxnBytes.length;
        }
        if (productIndex == productEnd) {
            return null;
        }
        int coordsIndex = 0;
        if (coords == null && (coordsIndex = 1 + ArrayUtils.indexOf(rxnBytes, (byte)35, productEnd + 1)) != 0) {
            coords = rxnBytes;
        }
        if (coords != null && !includeReactants) {
            int i;
            int reactantCount = 1;
            for (i = 0; i < reactantEnd; ++i) {
                if (rxnBytes[i] != 32) continue;
                ++reactantCount;
            }
            for (i = 0; reactantCount != 0 && i < coords.length; ++i) {
                if (coords[i] != 32) continue;
                coordsIndex = i + 1;
                --reactantCount;
            }
        }
        int mappingIndex = 0;
        if (mapping != null && !includeReactants) {
            int i;
            int reactantCount = 1;
            for (i = 0; i < reactantEnd; ++i) {
                if (rxnBytes[i] != 32) continue;
                ++reactantCount;
            }
            for (i = 0; reactantCount != 0 && i < mapping.length; ++i) {
                if (mapping[i] != 32) continue;
                mappingIndex = i + 1;
                --reactantCount;
            }
        }
        ArrayList<StereoMolecule> moleculeList = new ArrayList<StereoMolecule>();
        if (includeReactants) {
            int reactantIndex = 0;
            do {
                IDCodeParser parser = new IDCodeParser();
                parser.neglectSpaceDelimitedCoordinates();
                StereoMolecule reactant = parser.getCompactMolecule(rxnBytes, coords, reactantIndex, coordsIndex);
                if (reactant.getAllAtoms() != 0) {
                    moleculeList.add(reactant);
                }
                reactantIndex = 1 + ArrayUtils.indexOf(rxnBytes, (byte)32, reactantIndex);
                if (coords != null) {
                    coordsIndex = 1 + ArrayUtils.indexOf(coords, (byte)32, coordsIndex);
                }
                if (mapping == null) continue;
                parser.parseMapping(mapping, mappingIndex);
                mappingIndex = 1 + ArrayUtils.indexOf(mapping, (byte)32, mappingIndex);
            } while (reactantIndex != 0 && reactantIndex < reactantEnd);
        }
        if (includeProducts) {
            do {
                IDCodeParser parser = new IDCodeParser();
                parser.neglectSpaceDelimitedCoordinates();
                StereoMolecule product = parser.getCompactMolecule(rxnBytes, coords, productIndex, coordsIndex);
                if (product.getAllAtoms() != 0) {
                    moleculeList.add(product);
                }
                productIndex = 1 + ArrayUtils.indexOf(rxnBytes, (byte)32, productIndex);
                if (coords != null) {
                    coordsIndex = 1 + ArrayUtils.indexOf(coords, (byte)32, coordsIndex);
                }
                if (mapping == null) continue;
                parser.parseMapping(mapping, mappingIndex);
                mappingIndex = 1 + ArrayUtils.indexOf(mapping, (byte)32, mappingIndex);
            } while (productIndex != 0 && productIndex < productEnd);
        }
        return moleculeList.size() == 0 ? null : moleculeList.toArray(new StereoMolecule[0]);
    }

    public static StereoMolecule[] decodeCatalysts(byte[] rxnBytes) {
        if (rxnBytes == null || rxnBytes.length == 0) {
            return null;
        }
        int index = 0;
        for (int i = 0; i < 4; ++i) {
            if ((index = 1 + ArrayUtils.indexOf(rxnBytes, (byte)35, index)) != 0) continue;
            return null;
        }
        if (index == rxnBytes.length) {
            return null;
        }
        ArrayList<StereoMolecule> catalystList = new ArrayList<StereoMolecule>();
        while (index != 0 && index < rxnBytes.length) {
            StereoMolecule catalyst;
            int nextIndex = 1 + ArrayUtils.indexOf(rxnBytes, (byte)43, index);
            int coordsIndex = 1 + ArrayUtils.indexOf(rxnBytes, (byte)32, index);
            StereoMolecule stereoMolecule = catalyst = coordsIndex != 0 && (nextIndex == 0 || nextIndex > coordsIndex) ? new IDCodeParser().getCompactMolecule(rxnBytes, rxnBytes, index, coordsIndex) : new IDCodeParser().getCompactMolecule(rxnBytes, null, index, -1);
            if (catalyst.getAllAtoms() != 0) {
                catalystList.add(catalyst);
            }
            index = nextIndex;
        }
        return catalystList.size() == 0 ? null : catalystList.toArray(new StereoMolecule[0]);
    }
}

