/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.gui;

import com.actelion.research.chem.io.CompoundFileFilter;
import com.actelion.research.chem.io.CompoundFileHelper;
import com.actelion.research.gui.JFileChooserOverwrite;
import com.actelion.research.gui.hidpi.HiDPIHelper;
import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

public class FileHelper
extends CompoundFileHelper {
    private static final long TIME_OUT = 5000L;
    private Component mParent;

    public FileHelper(Component parent) {
        this.mParent = parent;
    }

    @Override
    public String selectOption(String message, String title, String[] option) {
        return (String)JOptionPane.showInputDialog(this.mParent, message, title, 3, null, option, option[0]);
    }

    @Override
    public void showMessage(String message) {
        JOptionPane.showMessageDialog(this.mParent, message);
    }

    public static File getFile(Component parent, String title, int filetypes) {
        return new FileHelper(parent).selectFileToOpen(title, filetypes);
    }

    public static ArrayList<File> getCompatibleFileList(File directory, int filetypes) {
        ArrayList<File> list = new ArrayList<File>();
        if (FileHelper.fileExists(directory)) {
            CompoundFileFilter ff = FileHelper.createFileFilter(filetypes, false);
            for (File file : directory.listFiles(pathname -> ff.accept(pathname))) {
                list.add(file);
            }
        }
        return list;
    }

    @Override
    public File selectFileToOpen(String title, int filetypes) {
        return this.selectFileToOpen(title, filetypes, null);
    }

    public File selectFileToOpen(String title, int filetypes, String initialFileName) {
        JFileChooser fileChooser = new JFileChooser();
        if (HiDPIHelper.getUIScaleFactor() > 1.0f) {
            fileChooser.setPreferredSize(new Dimension(fileChooser.getPreferredSize().width, HiDPIHelper.scale(fileChooser.getPreferredSize().height)));
        }
        fileChooser.setDialogTitle(title);
        fileChooser.setCurrentDirectory(FileHelper.getCurrentDirectory());
        if (filetypes == -2) {
            fileChooser.setFileSelectionMode(1);
        } else if (filetypes != -1) {
            fileChooser.setFileFilter(FileHelper.createFileFilter(filetypes, false));
        }
        if (initialFileName != null) {
            int index = initialFileName.lastIndexOf(File.separatorChar);
            if (index == -1) {
                fileChooser.setSelectedFile(new File(FileHelper.getCurrentDirectory(), initialFileName));
            } else {
                String directory = initialFileName.substring(0, index);
                if (new File(directory).exists()) {
                    fileChooser.setSelectedFile(new File(initialFileName));
                } else {
                    fileChooser.setSelectedFile(new File(FileHelper.getCurrentDirectory(), initialFileName.substring(index + 1)));
                }
            }
        }
        int option = fileChooser.showOpenDialog(this.mParent);
        FileHelper.setCurrentDirectory(fileChooser.getCurrentDirectory());
        if (option != 0) {
            return null;
        }
        File selectedFile = fileChooser.getSelectedFile();
        if (selectedFile.exists()) {
            return selectedFile;
        }
        if (selectedFile.getName().contains(".") || filetypes == -2) {
            return selectedFile;
        }
        ArrayList<String> list = this.getExtensionList(filetypes);
        for (String extension : list) {
            File file = new File(selectedFile.getPath() + extension);
            if (!file.exists()) continue;
            return file;
        }
        return selectedFile;
    }

    @Override
    public String selectFileToSave(String title, int filetype, String newFileName) {
        JFileChooserOverwrite fileChooser = new JFileChooserOverwrite();
        if (HiDPIHelper.getUIScaleFactor() > 1.0f) {
            fileChooser.setPreferredSize(new Dimension(fileChooser.getPreferredSize().width, HiDPIHelper.scale(fileChooser.getPreferredSize().height)));
        }
        fileChooser.setCurrentDirectory(FileHelper.getCurrentDirectory());
        fileChooser.setDialogTitle(title);
        fileChooser.setFileFilter(FileHelper.createFileFilter(filetype, true));
        fileChooser.setExtension(FileHelper.getExtension(filetype));
        if (newFileName == null) {
            fileChooser.setSelectedFile(new File(FileHelper.getCurrentDirectory(), "Untitled"));
        } else {
            int index = newFileName.lastIndexOf(File.separatorChar);
            if (index == -1) {
                fileChooser.setSelectedFile(new File(FileHelper.getCurrentDirectory(), newFileName));
            } else {
                String directory = newFileName.substring(0, index);
                if (new File(directory).exists()) {
                    fileChooser.setSelectedFile(new File(newFileName));
                } else {
                    fileChooser.setSelectedFile(new File(FileHelper.getCurrentDirectory(), newFileName.substring(index + 1)));
                }
            }
        }
        int option = fileChooser.showSaveDialog(this.mParent);
        FileHelper.setCurrentDirectory(fileChooser.getCurrentDirectory());
        return option != 0 ? null : fileChooser.getFile().getPath();
    }

    public static boolean fileExists(File file) {
        return FileHelper.fileExists(file, 5000L);
    }

    public static boolean fileExists(File file, long timeOutMillis) {
        AtomicBoolean exists = new AtomicBoolean(false);
        AtomicBoolean done = new AtomicBoolean(false);
        new Thread(() -> {
            exists.set(file.exists());
            done.set(true);
        }).start();
        long start = System.currentTimeMillis();
        do {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (!done.get() && System.currentTimeMillis() < start + timeOutMillis);
        return exists.get();
    }
}

