/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.gui;

import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

public class JFileChooserOverwrite
extends JFileChooser {
    private static final long serialVersionUID = 20150101L;
    private File mFile;
    private String mExtension = null;

    public void setExtension(String extension) {
        this.mExtension = extension;
    }

    public File getFile() {
        return this.mFile;
    }

    @Override
    public void approveSelection() {
        if (this.getSelectedFile() != null) {
            String filename = this.getSelectedFile().getPath();
            if (this.mExtension != null) {
                int dotIndex = filename.lastIndexOf(46);
                int slashIndex = filename.lastIndexOf(File.separator);
                if (dotIndex == -1 || dotIndex < slashIndex) {
                    filename = filename.concat(this.mExtension);
                } else if (!filename.substring(dotIndex).equalsIgnoreCase(this.mExtension)) {
                    JOptionPane.showMessageDialog(this, "uncompatible file name extension.");
                    return;
                }
            }
            this.mFile = new File(filename);
            if (this.mFile != null) {
                if (this.mFile.exists()) {
                    int answer = JOptionPane.showConfirmDialog(this, "This file already exists. Do you want to replace it?", "Warning", 2, 2);
                    if (answer == 0) {
                        super.approveSelection();
                    }
                } else {
                    super.approveSelection();
                }
            }
        }
    }
}

