/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.gui;

import com.actelion.research.chem.AbstractDepictor;
import com.actelion.research.chem.IDCodeParser;
import com.actelion.research.chem.IsomericSmilesCreator;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.name.StructureNameResolver;
import com.actelion.research.gui.StructureListener;
import com.actelion.research.gui.clipboard.IClipboardHandler;
import com.actelion.research.gui.dnd.MoleculeDragAdapter;
import com.actelion.research.gui.dnd.MoleculeDropAdapter;
import com.actelion.research.gui.dnd.MoleculeTransferable;
import com.actelion.research.gui.generic.GenericDepictor;
import com.actelion.research.gui.generic.GenericRectangle;
import com.actelion.research.gui.hidpi.HiDPIHelper;
import com.actelion.research.gui.swing.SwingDrawContext;
import com.actelion.research.util.ColorHelper;
import com.actelion.research.util.CursorHelper;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.UIManager;

public class JStructureView
extends JComponent
implements ActionListener,
MouseListener,
MouseMotionListener,
StructureListener {
    static final long serialVersionUID = 537268499L;
    private static final String ITEM_COPY = "Copy Structure";
    private static final String ITEM_COPY_SMILES = "Copy Structure As SMILES-String";
    private static final String ITEM_PASTE = "Paste Structure";
    private static final String ITEM_PASTE_WITH_NAME = "Paste Structure or Name";
    private static final String ITEM_CLEAR = "Clear Structure";
    private static final long WARNING_MILLIS = 1200L;
    private static final int DRAG_MARGIN = 12;
    private ArrayList<StructureListener> mListener;
    private String mIDCode;
    private StereoMolecule mMol;
    private StereoMolecule mDisplayMol;
    private GenericDepictor mDepictor;
    private boolean mShowBorder;
    private boolean mAllowFragmentStatusChangeOnPasteOrDrop;
    private boolean mIsDraggingThis;
    private boolean mIsEditable;
    private boolean mDisableBorder;
    private int mChiralTextPosition;
    private int mDisplayMode;
    private String[] mAtomText;
    private IClipboardHandler mClipboardHandler;
    protected MoleculeDropAdapter mDropAdapter = null;
    protected int mAllowedDragAction;
    protected int mAllowedDropAction;
    private String mWarningMessage;
    private int[] mAtomHiliteColor;
    private float[] mAtomHiliteRadius;

    public JStructureView() {
        this(null);
    }

    public JStructureView(StereoMolecule mol) {
        this(mol, 3, 3);
    }

    public JStructureView(StereoMolecule mol, StereoMolecule displayMol) {
        this(mol, displayMol, 3, 3);
    }

    public JStructureView(int dragAction, int dropAction) {
        this(null, dragAction, dropAction);
    }

    public JStructureView(StereoMolecule mol, int dragAction, int dropAction) {
        this(mol, null, dragAction, dropAction);
    }

    public JStructureView(StereoMolecule mol, StereoMolecule displayMol, int dragAction, int dropAction) {
        this.mMol = mol == null ? new StereoMolecule() : new StereoMolecule(mol);
        this.mDisplayMol = displayMol == null ? this.mMol : displayMol;
        this.mDisplayMode = 8;
        this.mIsEditable = false;
        this.updateBackground();
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.initializeDragAndDrop(dragAction, dropAction);
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.updateBackground();
    }

    public void setClipboardHandler(IClipboardHandler h) {
        this.mClipboardHandler = h;
    }

    public IClipboardHandler getClipboardHandler() {
        return this.mClipboardHandler;
    }

    public int getDisplayMode() {
        return this.mDisplayMode;
    }

    public void setDisplayMode(int mode) {
        if (this.mDisplayMode != mode) {
            this.mDisplayMode = mode;
            this.repaint();
        }
    }

    public void setDisableBorder(boolean b) {
        this.mDisableBorder = b;
    }

    public void setAtomText(String[] atomText) {
        this.mAtomText = atomText;
    }

    @Override
    public void setEnabled(boolean enable) {
        if (enable != this.isEnabled()) {
            this.updateBackground();
            this.repaint();
            if (this.mDropAdapter != null) {
                this.mDropAdapter.setActive(enable);
            }
        }
        super.setEnabled(enable);
    }

    public boolean isEditable() {
        return this.mIsEditable;
    }

    public void setEditable(boolean b) {
        if (this.mIsEditable != b) {
            this.mIsEditable = b;
        }
    }

    public void setAllowFragmentStatusChangeOnPasteOrDrop(boolean allow) {
        this.mAllowFragmentStatusChangeOnPasteOrDrop = allow;
    }

    public void setAtomHighlightColors(int[] argb, float[] radius) {
        this.mAtomHiliteColor = argb;
        this.mAtomHiliteRadius = radius;
        this.repaint();
    }

    public boolean canDrop() {
        return this.mIsEditable && this.isEnabled() && !this.mIsDraggingThis;
    }

    @Override
    public synchronized void paintComponent(Graphics g) {
        GenericRectangle rect;
        super.paintComponent(g);
        Dimension theSize = this.getSize();
        Insets insets = this.getInsets();
        theSize.width -= insets.left + insets.right;
        theSize.height -= insets.top + insets.bottom;
        if (theSize.width <= 0 || theSize.height <= 0) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        g2.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        Color fg = g2.getColor();
        Color bg = this.getBackground();
        g2.setColor(bg);
        g2.fill(new Rectangle(insets.left, insets.top, theSize.width, theSize.height));
        if (this.mShowBorder && !this.mDisableBorder && (rect = this.mDepictor.getBoundingRect()) != null) {
            g.setColor(ColorHelper.perceivedBrightness(bg) < 0.5f ? ColorHelper.brighter(bg, 0.85f) : ColorHelper.darker(bg, 0.85f));
            int arc = (int)Math.min(rect.height / 4.0, Math.min(rect.width / 4.0, (double)HiDPIHelper.scale(10.0f)));
            g.fillRoundRect((int)rect.x, (int)rect.y, (int)rect.width, (int)rect.height, arc, arc);
        }
        g2.setColor(fg);
        if (this.mDisplayMol != null && this.mDisplayMol.getAllAtoms() != 0) {
            this.mDepictor = new GenericDepictor(this.mDisplayMol);
            this.mDepictor.setDisplayMode(this.mDisplayMode);
            this.mDepictor.setAtomText(this.mAtomText);
            this.mDepictor.setAtomHighlightColors(this.mAtomHiliteColor, this.mAtomHiliteRadius);
            if (!this.isEnabled()) {
                this.mDepictor.setOverruleColor(ColorHelper.getContrastColor(Color.GRAY, bg), bg);
            } else {
                this.mDepictor.setForegroundColor(this.getForeground(), bg);
            }
            int avbl = HiDPIHelper.scale(24.0f);
            SwingDrawContext context = new SwingDrawContext((Graphics2D)g);
            this.mDepictor.validateView(context, new GenericRectangle(insets.left, insets.top, theSize.width, theSize.height), 0x10000 | this.mChiralTextPosition | avbl);
            this.mDepictor.paint(context);
        }
        if (this.mWarningMessage != null) {
            int fontSize = HiDPIHelper.scale(12.0f);
            g.setFont(this.getFont().deriveFont(1, fontSize));
            Color original = g.getColor();
            g.setColor(Color.RED);
            FontMetrics metrics = g.getFontMetrics();
            Rectangle2D bounds = metrics.getStringBounds(this.mWarningMessage, g);
            g.drawString(this.mWarningMessage, insets.left + (int)((double)theSize.width - bounds.getWidth()) / 2, insets.top + metrics.getHeight());
            g.setColor(original);
        }
    }

    public void setIDCode(String idcode) {
        this.setIDCode(idcode, null);
    }

    public synchronized void setIDCode(String idcode, String coordinates) {
        if (idcode != null && idcode.length() == 0) {
            idcode = null;
        }
        if (this.mIDCode == null && idcode == null) {
            return;
        }
        if (this.mIDCode != null && this.mIDCode.equals(idcode)) {
            return;
        }
        new IDCodeParser(true).parse(this.mMol, idcode, coordinates);
        this.mDisplayMol = this.mMol;
        this.mIDCode = idcode;
        this.repaint();
        this.informListeners();
    }

    @Override
    public synchronized void structureChanged(StereoMolecule mol) {
        if (mol == null) {
            this.mMol.clear();
        } else {
            mol.copyMolecule(this.mMol);
        }
        this.mDisplayMol = this.mMol;
        this.structureChanged();
    }

    public synchronized void structureChanged(StereoMolecule mol, StereoMolecule displayMol) {
        if (mol == null) {
            this.mMol.clear();
        } else {
            mol.copyMolecule(this.mMol);
        }
        this.mDisplayMol = displayMol;
        this.structureChanged();
    }

    public synchronized void structureChanged() {
        this.mIDCode = null;
        this.repaint();
        this.informListeners();
    }

    public StereoMolecule getMolecule() {
        return this.mMol;
    }

    public StereoMolecule getDisplayMolecule() {
        return this.mDisplayMol;
    }

    public AbstractDepictor getDepictor() {
        return this.mDepictor;
    }

    public void addStructureListener(StructureListener l) {
        if (this.mListener == null) {
            this.mListener = new ArrayList();
        }
        this.mListener.add(l);
    }

    public void removeStructureListener(StructureListener l) {
        if (this.mListener != null) {
            this.mListener.remove(l);
        }
    }

    public void setChiralDrawPosition(int p) {
        this.mChiralTextPosition = p;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.handlePopupTrigger(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.handlePopupTrigger(e);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        GenericRectangle bounds;
        int x = e.getX();
        int y = e.getY();
        boolean isInRect = false;
        if (this.mDepictor != null && (this.mAllowedDragAction & 1) != 0 && (bounds = this.shrink(this.mDepictor.getBoundingRect())) != null && bounds.contains(x, y)) {
            isInRect = true;
        }
        this.updateBorder(isInRect);
        this.setCursor(CursorHelper.getCursor(isInRect ? 2 : 11));
    }

    private GenericRectangle shrink(GenericRectangle rect) {
        int margin = HiDPIHelper.scale(12.0f);
        int marginX = Math.min(margin, (int)rect.width / 6);
        int marginY = Math.min(margin, (int)rect.height / 6);
        return new GenericRectangle((int)rect.x + marginX, (int)rect.y + marginY, (int)rect.width - 2 * marginX, (int)rect.height - 2 * marginY);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals(ITEM_COPY)) {
            this.mClipboardHandler.copyMolecule(this.mMol);
        }
        if (e.getActionCommand().equals(ITEM_COPY_SMILES)) {
            String smiles = new IsomericSmilesCreator(this.mMol).getSmiles();
            StringSelection data = new StringSelection(smiles);
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(data, data);
        }
        if (e.getActionCommand().startsWith(ITEM_PASTE) && this.mIsEditable) {
            int smartsMode = this.mAllowFragmentStatusChangeOnPasteOrDrop ? 1 : (this.mMol.isFragment() ? 2 : 0);
            StereoMolecule mol = this.mClipboardHandler.pasteMolecule(true, smartsMode);
            if (mol != null) {
                if (!this.mAllowFragmentStatusChangeOnPasteOrDrop) {
                    mol.setFragment(this.mMol.isFragment());
                }
                this.mMol = mol;
                this.mDisplayMol = mol;
                this.structureChanged();
            } else {
                this.showWarningMessage("No molecule on clipboard!");
            }
        }
        if (e.getActionCommand().equals(ITEM_CLEAR) && this.mIsEditable) {
            this.mMol.clear();
            this.mDisplayMol = this.mMol;
            this.structureChanged();
        }
    }

    protected void showWarningMessage(String msg) {
        this.mWarningMessage = msg;
        this.repaint();
        new Thread(() -> {
            try {
                Thread.sleep(1200L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.mWarningMessage = null;
            this.repaint();
        }).start();
    }

    private void updateBackground() {
        Color bg = UIManager.getColor(this.isEditable() && this.isEnabled() ? "TextField.background" : "TextField.inactiveBackground");
        if (bg != null) {
            this.setBackground(bg);
        }
    }

    private void handlePopupTrigger(MouseEvent e) {
        if (this.mMol != null && e.isPopupTrigger() && this.mClipboardHandler != null) {
            JPopupMenu popup = new JPopupMenu();
            JMenuItem item1 = new JMenuItem(ITEM_COPY);
            item1.addActionListener(this);
            item1.setEnabled(this.mMol.getAllAtoms() != 0);
            popup.add(item1);
            JMenuItem itemCopySmiles = new JMenuItem(ITEM_COPY_SMILES);
            itemCopySmiles.addActionListener(this);
            itemCopySmiles.setEnabled(this.mMol.getAllAtoms() != 0);
            popup.add(itemCopySmiles);
            if (this.mIsEditable) {
                String itemText = StructureNameResolver.getInstance() == null ? ITEM_PASTE : ITEM_PASTE_WITH_NAME;
                JMenuItem item2 = new JMenuItem(itemText);
                item2.addActionListener(this);
                popup.add(item2);
                popup.addSeparator();
                JMenuItem item3 = new JMenuItem(ITEM_CLEAR);
                item3.addActionListener(this);
                item3.setEnabled(this.mMol.getAllAtoms() != 0);
                popup.add(item3);
            }
            popup.show(this, e.getX(), e.getY());
        }
    }

    private void informListeners() {
        if (this.mListener != null) {
            for (int i = 0; i < this.mListener.size(); ++i) {
                this.mListener.get(i).structureChanged(this.mMol);
            }
        }
    }

    private void initializeDragAndDrop(int dragAction, int dropAction) {
        final JStructureView outer = this;
        this.mAllowedDragAction = dragAction;
        this.mAllowedDropAction = dropAction;
        this.mAllowFragmentStatusChangeOnPasteOrDrop = false;
        if (dragAction != 0) {
            new MoleculeDragAdapter(this){

                @Override
                public Transferable getTransferable(Point origin) {
                    return JStructureView.this.getMoleculeTransferable(origin);
                }

                @Override
                public void onDragEnter() {
                    outer.onDragEnter();
                }

                @Override
                public void dragIsValidAndStarts() {
                    JStructureView.this.mIsDraggingThis = true;
                }

                @Override
                public void onDragExit() {
                    outer.onDragExit();
                }

                @Override
                public void dragDropEnd(DragSourceDropEvent e) {
                    JStructureView.this.mIsDraggingThis = false;
                }
            };
        }
        if (dropAction != 0) {
            this.mDropAdapter = new MoleculeDropAdapter(){

                @Override
                public void onDropMolecule(StereoMolecule m, Point pt) {
                    if (m != null && JStructureView.this.canDrop()) {
                        boolean isFragment = JStructureView.this.mMol.isFragment();
                        JStructureView.this.mMol = new StereoMolecule(m);
                        JStructureView.this.mMol.removeAtomColors();
                        JStructureView.this.mMol.removeBondHiliting();
                        if (!JStructureView.this.mAllowFragmentStatusChangeOnPasteOrDrop) {
                            JStructureView.this.mMol.setFragment(isFragment);
                        }
                        JStructureView.this.mDisplayMol = JStructureView.this.mMol;
                        JStructureView.this.repaint();
                        JStructureView.this.informListeners();
                        JStructureView.this.onDrop();
                    }
                    JStructureView.this.updateBorder(false);
                }

                @Override
                public void dragEnter(DropTargetDragEvent e) {
                    boolean drop;
                    boolean bl = drop = JStructureView.this.canDrop() && this.isDropOK(e);
                    if (!drop) {
                        e.rejectDrag();
                    }
                }

                @Override
                public void dragExit(DropTargetEvent e) {
                }
            };
            new DropTarget(this, this.mAllowedDropAction, this.mDropAdapter, true);
        }
    }

    protected Transferable getMoleculeTransferable(Point pt) {
        return new MoleculeTransferable(this.mMol);
    }

    protected void onDragEnter() {
    }

    protected void onDragExit() {
    }

    protected void onDragOver() {
    }

    protected void onDrop() {
    }

    private void updateBorder(boolean showBorder) {
        if (this.mShowBorder != showBorder) {
            this.mShowBorder = showBorder;
            this.repaint();
        }
    }
}

