/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.gui.clipboard;

import com.actelion.research.chem.Depictor2D;
import com.actelion.research.chem.IDCodeParser;
import com.actelion.research.chem.MolfileParser;
import com.actelion.research.chem.SmilesParser;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.coords.CoordinateInventor;
import com.actelion.research.chem.dnd.ChemistryFlavors;
import com.actelion.research.chem.io.RXNFileCreator;
import com.actelion.research.chem.io.RXNFileParser;
import com.actelion.research.chem.name.StructureNameResolver;
import com.actelion.research.chem.reaction.Reaction;
import com.actelion.research.chem.reaction.ReactionEncoder;
import com.actelion.research.gui.clipboard.IClipboardHandler;
import com.actelion.research.gui.clipboard.ImageClipboardHandler;
import com.actelion.research.gui.clipboard.NativeClipboardAccessor;
import com.actelion.research.gui.clipboard.external.ChemDrawCDX;
import com.actelion.research.gui.dnd.MoleculeTransferable;
import com.actelion.research.gui.dnd.ReactionTransferable;
import com.actelion.research.gui.generic.GenericRectangle;
import com.actelion.research.gui.wmf.WMF;
import com.actelion.research.gui.wmf.WMFGraphics2D;
import com.actelion.research.util.Platform;
import com.actelion.research.util.Sketch;
import java.awt.Color;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.ArrayList;

public class ClipboardHandler
implements IClipboardHandler {
    private static final byte[] MDLSK = new byte[]{77, 68, 76, 83, 75, 0, 0};

    @Override
    public ArrayList<StereoMolecule> pasteMolecules() {
        return this.pasteMolecules(true, true, 1);
    }

    @Override
    public StereoMolecule pasteMolecule() {
        return this.pasteMolecule(true, 1);
    }

    @Override
    public StereoMolecule pasteMolecule(boolean prefer2D, int smartsMode) {
        ArrayList<StereoMolecule> molList = this.pasteMolecules(prefer2D, false, smartsMode);
        return molList.size() == 0 ? null : molList.get(0);
    }

    private ArrayList<StereoMolecule> pasteMolecules(boolean prefer2D, boolean allowMultiple, int smartsMode) {
        StereoMolecule mol;
        ArrayList<StereoMolecule> molList = new ArrayList<StereoMolecule>();
        StereoMolecule stereoMolecule = mol = Platform.isWindows() ? this.pasteMoleculeWindowsNative(prefer2D) : this.pasteMoleculeLinux();
        if (mol != null) {
            molList.add(mol);
        }
        if (molList.size() == 0) {
            Transferable t = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);
            String text = null;
            try {
                text = (String)t.getTransferData(DataFlavor.stringFlavor);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (text != null) {
                try {
                    mol = new MolfileParser().getCompactMolecule(text);
                    if (mol != null && mol.getAllAtoms() != 0) {
                        molList.add(mol);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ArrayList<String> unresolvedNameList = null;
                if (molList.size() == 0) {
                    BufferedReader reader = new BufferedReader(new StringReader(text));
                    try {
                        String line = reader.readLine();
                        while (line != null) {
                            line = line.trim();
                            try {
                                mol = new IDCodeParser(prefer2D).getCompactMolecule(line);
                            }
                            catch (Exception e) {
                                mol = null;
                            }
                            if (mol == null || mol.getAllAtoms() == 0) {
                                mol = new StereoMolecule();
                                try {
                                    new SmilesParser(smartsMode, false).parse(mol, line);
                                }
                                catch (Exception e) {
                                    mol = null;
                                }
                            }
                            if (mol == null || mol.getAllAtoms() == 0) {
                                mol = StructureNameResolver.resolveLocal(line);
                            }
                            if (!(mol != null && mol.getAllAtoms() != 0 || allowMultiple)) {
                                mol = StructureNameResolver.resolveRemote(line);
                            }
                            if (mol != null && mol.getAllAtoms() != 0) {
                                molList.add(mol);
                                if (!allowMultiple) {
                                    break;
                                }
                            } else if (allowMultiple) {
                                if (unresolvedNameList == null) {
                                    unresolvedNameList = new ArrayList<String>();
                                }
                                unresolvedNameList.add(line);
                            }
                            line = reader.readLine();
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (unresolvedNameList != null && unresolvedNameList.size() != 0) {
                    String[] idcodes;
                    for (String idcode : idcodes = StructureNameResolver.resolveRemote(unresolvedNameList.toArray(new String[0]))) {
                        try {
                            mol = new IDCodeParser(prefer2D).getCompactMolecule(idcode);
                            if (mol == null || mol.getAllAtoms() == 0) continue;
                            molList.add(mol);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }
        }
        if (prefer2D) {
            for (StereoMolecule m : molList) {
                if (!m.is3D()) continue;
                m.ensureHelperArrays(15);
                new CoordinateInventor().invent(m);
            }
        }
        System.out.println("returned mol(s): " + molList.size());
        return molList;
    }

    private StereoMolecule pasteMoleculeWindowsNative(boolean prefer2D) {
        StereoMolecule mol = null;
        byte[] buffer = NativeClipboardAccessor.getClipboardData("ACT_MOLECULE");
        if (buffer != null) {
            try {
                ObjectInputStream is = new ObjectInputStream(new ByteArrayInputStream(buffer));
                Object o = is.readObject();
                if (o instanceof StereoMolecule) {
                    mol = (StereoMolecule)o;
                }
                is.close();
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println("Parsing NC_SERIALIZEMOLECULE during clipboard paste: Exception " + e);
            }
        }
        System.out.println("Mol is " + mol);
        if (mol == null) {
            MolfileParser p;
            buffer = NativeClipboardAccessor.getClipboardData("MDLCT");
            if (!(buffer == null && (buffer = NativeClipboardAccessor.getClipboardData("MDL_MOL")) == null || (p = new MolfileParser()).parse(mol = new StereoMolecule(), new String(buffer)))) {
                mol = null;
                System.out.println("Error Parsing CTAB during clipboard paste");
            }
            if (mol == null && ((buffer = NativeClipboardAccessor.getClipboardData("MDLSK")) != null || (buffer = NativeClipboardAccessor.getClipboardData("MDLSK_EMBEDDED")) != null)) {
                try {
                    mol = new StereoMolecule();
                    if (!Sketch.createMolFromSketchBuffer(mol, buffer)) {
                        mol = null;
                    }
                }
                catch (IOException e) {
                    mol = null;
                    e.printStackTrace();
                    System.out.println("Parsing NC_SKETCH during clipboard paste: Exception " + e);
                }
            }
        }
        String clipboardText = null;
        if (mol == null && (buffer = NativeClipboardAccessor.getClipboardData("IDCODE")) != null) {
            clipboardText = new String(buffer);
            try {
                mol = new StereoMolecule();
                IDCodeParser parser = new IDCodeParser(prefer2D);
                parser.parse(mol, buffer);
                if (mol.getAllAtoms() == 0) {
                    mol = null;
                } else {
                    System.out.printf("NC_IDCODE '%s' successfully interpreted as idcode\n", clipboardText);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.printf("NC_IDCODE '%s' could not be parsed: " + e + "\n", clipboardText);
                mol = null;
            }
        }
        return mol;
    }

    private StereoMolecule pasteMoleculeLinux() {
        try {
            Transferable t = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);
            return (StereoMolecule)t.getTransferData(ChemistryFlavors.DF_SERIALIZED_MOLECULE);
        }
        catch (Exception e) {
            System.err.println("error getting clipboard data " + e);
            return null;
        }
    }

    @Override
    public Reaction pasteReaction() {
        Reaction rxn;
        Reaction reaction = rxn = Platform.isWindows() ? this.pasteReactionWindowsNative() : this.pasteReactionLinux();
        if (rxn == null) {
            Transferable t = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);
            String text = null;
            try {
                text = (String)t.getTransferData(DataFlavor.stringFlavor);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (text != null) {
                try {
                    rxn = ReactionEncoder.decode(text, true);
                    if (rxn != null && rxn.isEmpty()) {
                        rxn = null;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (rxn == null) {
                    try {
                        rxn = new RXNFileParser().getReaction(text);
                        if (rxn != null && rxn.isEmpty()) {
                            rxn = null;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (rxn == null) {
                    try {
                        rxn = new SmilesParser().parseReaction(text);
                        if (rxn != null && rxn.isEmpty()) {
                            rxn = null;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        return rxn;
    }

    public Reaction pasteReactionWindowsNative() {
        Reaction rxn = null;
        byte[] buffer = NativeClipboardAccessor.getClipboardData("ACT_REACTION");
        if (buffer != null) {
            try {
                ObjectInputStream is = new ObjectInputStream(new ByteArrayInputStream(buffer));
                Object o = is.readObject();
                if (o instanceof Reaction) {
                    rxn = (Reaction)o;
                }
                is.close();
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println("ClipboardHandler.pasteReaction(): Exception " + e);
            }
        } else {
            buffer = NativeClipboardAccessor.getClipboardData("MDLCT");
            if (buffer != null) {
                RXNFileParser p = new RXNFileParser();
                rxn = new Reaction();
                try {
                    if (!p.parse(rxn, new String(buffer))) {
                        rxn = null;
                    }
                }
                catch (Exception e) {
                    System.err.println("Error parsing Reaction Buffer " + e);
                    rxn = null;
                }
            } else {
                buffer = NativeClipboardAccessor.getClipboardData("MDLSK");
                if (buffer != null) {
                    try {
                        rxn = new Reaction();
                        if (!Sketch.createReactionFromSketchBuffer(rxn, buffer)) {
                            rxn = null;
                        }
                    }
                    catch (IOException e) {
                        rxn = null;
                    }
                }
            }
        }
        return rxn;
    }

    private Reaction pasteReactionLinux() {
        try {
            Transferable t = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);
            return (Reaction)t.getTransferData(ChemistryFlavors.DF_SERIALIZED_REACTION);
        }
        catch (Exception e) {
            System.err.println("error getting clipboard data " + e);
            return null;
        }
    }

    @Override
    public boolean copyMolecule(String molfile) {
        StereoMolecule m = new StereoMolecule();
        MolfileParser p = new MolfileParser();
        p.parse(m, molfile);
        return this.copyMolecule(m);
    }

    @Override
    public boolean copyMolecule(StereoMolecule mol) {
        if (!Platform.isWindows()) {
            MoleculeTransferable transferable = new MoleculeTransferable(mol);
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(transferable, transferable);
            return true;
        }
        boolean ok = false;
        try {
            StereoMolecule m = mol.getCompactCopy();
            for (int atom = 0; atom < m.getAllAtoms(); ++atom) {
                m.setAtomMapNo(atom, 0, false);
            }
            byte[] buffer = Sketch.createSketchFromMol(m);
            File temp = File.createTempFile("actnca", ".wmf");
            temp.deleteOnExit();
            String path = null;
            if (this.writeMol2Metafile(temp, m, buffer)) {
                path = temp.getAbsolutePath();
            }
            System.out.println("CopyMolecule");
            ChemDrawCDX cdx = new ChemDrawCDX();
            byte[] cdbuffer = cdx.getChemDrawBuffer(m);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(bos);
            out.writeObject(mol);
            out.close();
            bos.close();
            ok = NativeClipboardAccessor.copyMoleculeToClipboard(path, cdbuffer, bos.toByteArray());
            temp.delete();
        }
        catch (IOException e) {
            System.err.println("ClipboardHandler: Exception copying Molecule " + e);
        }
        return ok;
    }

    @Override
    public boolean copyReaction(Reaction r) {
        if (!Platform.isWindows()) {
            ReactionTransferable transferable = new ReactionTransferable(r);
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(transferable, transferable);
            return true;
        }
        boolean ok = false;
        try {
            ok = this.copyReactionToClipboard(null, r);
        }
        catch (IOException e) {
            System.err.println("ClipboardHandler: Exception Copying Reaction " + e);
        }
        return ok;
    }

    private Reaction makeRXNCopy(Reaction r) {
        Reaction rxn = new Reaction(r);
        int mols = rxn.getMolecules();
        for (int i = 0; i < mols; ++i) {
            rxn.getMolecule(i).ensureHelperArrays(31);
        }
        return rxn;
    }

    @Override
    public boolean copyReaction(String ctab) {
        boolean ok = false;
        try {
            Reaction rxn = new Reaction();
            RXNFileParser p = new RXNFileParser();
            p.parse(rxn, ctab);
            ok = this.copyReactionToClipboard(ctab, rxn);
        }
        catch (IOException e) {
            System.err.println("ClipboardHandler: Exception copying reaction " + e);
        }
        catch (Exception e) {
            System.err.println("ClipboardHandler: Exception copying reaction " + e);
        }
        return ok;
    }

    private boolean copyReactionToClipboard(String ctab, Reaction rxn) throws IOException {
        if (ctab == null) {
            RXNFileCreator mc = new RXNFileCreator(rxn);
            ctab = mc.getRXNfile();
        }
        ChemDrawCDX cdx = new ChemDrawCDX();
        byte[] cdxBuffer = cdx.getChemDrawBuffer(rxn);
        System.out.println("copyReactionToClipboard");
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(bos);
        out.writeObject(rxn);
        out.close();
        bos.close();
        return NativeClipboardAccessor.copyReactionToClipboard(ctab.getBytes(), cdxBuffer, bos.toByteArray());
    }

    private boolean writeMol2Metafile(File temp, StereoMolecule m, byte[] sketch) {
        boolean ok = false;
        try {
            ok = this.writeMol2Metafile(new FileOutputStream(temp), m, sketch);
        }
        catch (Exception e) {
            System.err.println("ClipboardHandler: Exception writing molfile " + e);
            e.printStackTrace();
        }
        return ok;
    }

    private boolean writeMol2Metafile(OutputStream out, StereoMolecule m, byte[] sketch) throws IOException {
        int w = 300;
        int h = 200;
        WMF wmf = new WMF();
        WMFGraphics2D g = new WMFGraphics2D(wmf, w, h, Color.black, Color.white);
        Depictor2D d = new Depictor2D(m);
        d.updateCoords(g, new GenericRectangle(0.0, 0.0, w, h), 65536);
        d.paint(g);
        if (sketch != null) {
            byte[] temp = new byte[MDLSK.length + sketch.length];
            System.arraycopy(MDLSK, 0, temp, 0, MDLSK.length);
            System.arraycopy(sketch, 0, temp, MDLSK.length, sketch.length);
            wmf.escape(15, temp);
        }
        wmf.writeWMF(out);
        out.close();
        return true;
    }

    public static boolean setClipBoardData(String format, byte[] buffer) {
        if (Platform.isWindows()) {
            return NativeClipboardAccessor.setClipBoardData(format, buffer);
        }
        return false;
    }

    public static boolean copyMetaFile(byte[] data) {
        return Platform.isWindows() ? ClipboardHandler.setClipBoardData("CF_METAFILEPICT", data) : false;
    }

    @Override
    public boolean copyImage(Image img) {
        return ImageClipboardHandler.copyImage(img);
    }

    @Override
    public Image pasteImage() {
        return ImageClipboardHandler.pasteImage();
    }

    public static Image getImage() {
        return ImageClipboardHandler.pasteImage();
    }

    public static void putImage(Image image) {
        ImageClipboardHandler.copyImage(image);
    }
}

