/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.gui.clipboard;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;

public class ImageClipboardHandler {
    public static Image pasteImage() {
        Clipboard systemClipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable clipboardContents = systemClipboard.getContents(null);
        if (clipboardContents == null) {
            return null;
        }
        try {
            if (clipboardContents.isDataFlavorSupported(DataFlavor.imageFlavor)) {
                Image image = (Image)clipboardContents.getTransferData(DataFlavor.imageFlavor);
                return image;
            }
        }
        catch (UnsupportedFlavorException ufe) {
            ufe.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return null;
    }

    public static boolean copyImage(Image image) {
        ImageSelection imageSelection = new ImageSelection(image);
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(imageSelection, imageSelection);
        return true;
    }

    public static void main(String[] args) {
        Image img = ImageClipboardHandler.pasteImage();
        System.out.println("Pasted image is " + img);
        ImageClipboardHandler.copyImage(img);
        System.out.println("Copied image...");
    }

    public static class ImageSelection
    implements Transferable,
    ClipboardOwner {
        private Image mImage;

        public ImageSelection(Image image) {
            this.mImage = image;
        }

        @Override
        public void lostOwnership(Clipboard clipboard, Transferable contents) {
            System.out.println("Lost ownership...");
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{DataFlavor.imageFlavor};
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return DataFlavor.imageFlavor.equals(flavor);
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (!DataFlavor.imageFlavor.equals(flavor)) {
                throw new UnsupportedFlavorException(flavor);
            }
            return this.mImage;
        }
    }
}

