/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.gui.clipboard.external;

import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.reaction.Reaction;
import com.actelion.research.gui.clipboard.NativeClipboardAccessor;
import com.actelion.research.util.LittleEndianDataOutputStream;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ChemDrawCDX {
    private static byte[] COLORTABLE = new byte[]{0, 3, 50, 0, 8, 0, -1, -1, -1, -1, -1, -1, 0, 0, 0, 0, 0, 0, -1, -1, 0, 0, 0, 0, -1, -1, -1, -1, 0, 0, 0, 0, -1, -1, 0, 0, 0, 0, -1, -1, -1, -1, 0, 0, 0, 0, -1, -1, -1, -1, 0, 0, -1, -1};
    private static final byte[] HEADER = new byte[]{86, 106, 67, 68, 48, 49, 48, 48, 4, 3, 2, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final boolean debug = false;
    public static final int kCDXObj_Page = 32769;
    public static final int kCDXObj_Group = 32770;
    public static final int kCDXObj_Fragment = 32771;
    public static final int kCDXObj_Node = 32772;
    public static final int kCDXObj_Bond = 32773;
    private static int NUM = 0;

    private static void debug(String s) {
    }

    public boolean parse(BufferedInputStream is) {
        return false;
    }

    public String build() {
        StringBuilder sb = new StringBuilder();
        return sb.toString();
    }

    public byte[] getChemDrawBuffer(StereoMolecule mol) {
        CDXDocument doc = new CDXDocument();
        doc.add(new CDPShowEnhAtomStereo(true));
        doc.add(new CDPShowAtomStereo(true));
        doc.add(new CDPShowBondStereo(true));
        CDXPage page = new CDXPage();
        CDXFragment frag = new CDXFragment();
        doc.add(page);
        ((CDXNode)page).add(frag);
        MolGeom g = this.getTransform(mol);
        this.writeMolecule(mol, frag, g);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        LittleEndianDataOutputStream l = new LittleEndianDataOutputStream(bos);
        this.write(l, doc);
        try {
            bos.close();
        }
        catch (IOException ex) {
            System.err.println("ChemDrawCDX::getChemDrawBuffer(): Error closing stream : " + ex);
        }
        return bos.toByteArray();
    }

    public byte[] getChemDrawBuffer(Reaction rxn) {
        CDXDocument doc = new CDXDocument();
        int r = rxn.getReactants();
        int p = rxn.getProducts();
        int mn = rxn.getMolecules();
        doc.add(new CDPShowEnhAtomStereo(true));
        doc.add(new CDPShowAtomStereo(true));
        doc.add(new CDPShowBondStereo(true));
        CDXPage page = new CDXPage();
        doc.add(page);
        MolGeom g = this.getTransform(rxn);
        int[] rids = new int[r];
        for (int i = 0; i < r; ++i) {
            StereoMolecule m = rxn.getReactant(i);
            CDXFragment frag = new CDXFragment();
            this.writeMolecule(m, frag, g);
            rids[i] = frag.getID();
            ((CDXNode)page).add(frag);
        }
        int[] pids = new int[p];
        for (int i = 0; i < p; ++i) {
            StereoMolecule m = rxn.getProduct(i);
            CDXFragment frag = new CDXFragment();
            this.writeMolecule(m, frag, g);
            pids[i] = frag.getID();
            ((CDXNode)page).add(frag);
        }
        CDXReactionStep step = new CDXReactionStep(rids, pids);
        ((CDXNode)page).add(step);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        LittleEndianDataOutputStream l = new LittleEndianDataOutputStream(bos);
        this.write(l, doc);
        try {
            bos.close();
        }
        catch (IOException ex) {
            System.err.println("ChemDrawCDX::getChemDrawBuffer(): Error closing stream : " + ex);
        }
        return bos.toByteArray();
    }

    private MolGeom getTransform(Reaction rxn) {
        double xmin = Double.MAX_VALUE;
        double xmax = Double.MIN_VALUE;
        double ymin = Double.MAX_VALUE;
        double ymax = Double.MIN_VALUE;
        double scale = Double.MAX_VALUE;
        int cnt = rxn.getMolecules();
        if (cnt < 1) {
            return new MolGeom(0.0, 0.0, 1.0);
        }
        for (int mi = 0; mi < cnt; ++mi) {
            StereoMolecule m = rxn.getMolecule(mi);
            m.ensureHelperArrays(31);
            int na = m.getAllAtoms();
            for (int i = 0; i < na; ++i) {
                double x = m.getAtomX(i);
                double y = m.getAtomY(i);
                xmin = Math.min(xmin, x);
                xmax = Math.max(xmax, x);
                ymin = Math.min(ymin, y);
                ymax = Math.max(ymax, y);
            }
            double dx = xmax - xmin;
            double dy = xmax - ymin;
            ChemDrawCDX.debug(String.format("Mofile dx = %f dy = %f", dx, dy));
            double xscale = 1.6777216E7 / dx;
            double yscale = 1.6777216E7 / dy;
            ChemDrawCDX.debug(String.format("Mofile scale x = %.16f y = %.16f", xscale, yscale));
            scale = Math.min(xscale, yscale);
        }
        return new MolGeom(xmin, ymin, scale);
    }

    private MolGeom getTransform(StereoMolecule mol) {
        StereoMolecule m = new StereoMolecule(mol);
        m.ensureHelperArrays(31);
        int na = m.getAllAtoms();
        double xmin = m.getAtomX(0);
        double xmax = m.getAtomX(0);
        double ymin = m.getAtomY(0);
        double ymax = m.getAtomY(0);
        for (int i = 1; i < na; ++i) {
            double x = m.getAtomX(i);
            double y = m.getAtomY(i);
            xmin = Math.min(xmin, x);
            xmax = Math.max(xmax, x);
            ymin = Math.min(ymin, y);
            ymax = Math.max(ymax, y);
        }
        double dx = xmax - xmin;
        double dy = xmax - ymin;
        ChemDrawCDX.debug(String.format("Mofile dx = %f dy = %f", dx, dy));
        double xscale = 1.048576E7 / dx;
        double yscale = 1.048576E7 / dy;
        ChemDrawCDX.debug(String.format("Mofile scale x = %.16f y = %.16f", xscale, yscale));
        return new MolGeom(xmin, ymin, Math.min(xscale, yscale));
    }

    private void writeMolecule(StereoMolecule mol, CDXNode frag, MolGeom g) {
        int i;
        StereoMolecule m = new StereoMolecule(mol);
        m.ensureHelperArrays(31);
        int na = m.getAllAtoms();
        int nb = m.getAllBonds();
        CDXAtom[] atoms = new CDXAtom[na];
        m.translateCoords((float)(-g.xmin), (float)(-g.ymin));
        m.scaleCoords((float)g.scale);
        boolean isMethane = na == 1 && m.getAtomicNo(0) == 6;
        for (i = 0; i < na; ++i) {
            double x = m.getAtomX(i);
            double y = m.getAtomY(i);
            ChemDrawCDX.debug(String.format("C Atom x = %.0f y = %.0f", x, y));
            CDXAtom atom = null;
            atom = isMethane ? new CDXMethane(0x100000 + (int)x, 0x100000 + (int)y) : new CDXAtom((short)m.getAtomicNo(i), 0x100000 + (int)x, 0x100000 + (int)y);
            if (m.isAtomStereoCenter(i)) {
                int grp = m.getAtomESRGroup(i);
                int esr = m.getAtomESRType(i);
                if (!m.isAtomConfigurationUnknown(i) && !m.getStereoProblem(i)) {
                    atom.setAtomESRStereo(esr);
                }
                ChemDrawCDX.debug("Group is " + grp);
                if (grp != -1) {
                    atom.setAtomESRGroup(grp + 1);
                }
                if (m.getAtomCIPParity(i) != 0) {
                    atom.setAtomCIP(m.getAtomCIPParity(i), m.getAtomPi(i) == 2, m.isAtomParityPseudo(i));
                }
                if (m.getAtomMass(i) != 0) {
                    atom.setAtomMass((short)m.getAtomMass(i));
                }
                if (m.getAtomCharge(i) != 0) {
                    atom.setAtomCharge((byte)m.getAtomCharge(i));
                }
                if (m.getAtomRadical(i) != 0) {
                    atom.setAtomRadical((byte)m.getAtomRadical(i));
                }
            }
            atoms[i] = atom;
            frag.add(atom);
        }
        for (i = 0; i < nb; ++i) {
            int a1 = m.getBondAtom(0, i);
            int a2 = m.getBondAtom(1, i);
            int o = m.getBondType(i);
            CDXBond b = new CDXBond(atoms[a1].getID(), atoms[a2].getID());
            b.setBondType(o);
            frag.add(b);
        }
    }

    public void dump(CDXNode tn) {
        tn.walk(new Functor(){

            @Override
            public void start(CDXNode n) {
                System.out.println(n.start());
            }

            @Override
            public void end(CDXNode n) {
                System.out.println(n.end());
            }
        });
    }

    public void write(final DataOutput d, CDXNode tn) {
        tn.walk(new Functor(){

            @Override
            public void start(CDXNode n) {
                try {
                    n.startWrite(d);
                }
                catch (IOException e) {
                    System.err.println("Error " + e);
                }
            }

            @Override
            public void end(CDXNode n) {
                try {
                    n.endWrite(d);
                }
                catch (IOException e) {
                    System.err.println("Error " + e);
                }
            }
        });
    }

    public void test() {
        CDXDocument doc = new CDXDocument();
        CDXPage page = new CDXPage();
        CDXFragment frag = new CDXFragment();
        CDXAtom at1 = new CDXAtom(7, 0, 0);
        CDXAtom at2 = new CDXAtom(8, 0x2000000, 11273146);
        CDXBond b1 = new CDXBond(at1.getID(), at2.getID());
        doc.add(page);
        ((CDXNode)page).add(frag);
        frag.add(at1);
        frag.add(at2);
        frag.add(b1);
        this.dump(doc);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        LittleEndianDataOutputStream l = new LittleEndianDataOutputStream(bos);
        this.write(l, doc);
        try {
            bos.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        byte[] buffer = bos.toByteArray();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < buffer.length; ++i) {
            byte b = buffer[i];
            if (i != 0) {
                sb.append(" ");
            }
            if (i > 0 && i % 16 == 0) {
                sb.append("\n");
            }
            sb.append(String.format("%02X", b & 0xFF));
        }
        System.out.println("\nByte Dump:\n" + sb);
        NativeClipboardAccessor.setClipBoardData("ChemDraw Interchange Format", buffer);
        try {
            BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream("d:\\dev\\console\\test.cdx"));
            l = new LittleEndianDataOutputStream(os);
            this.write(l, doc);
            os.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static /* synthetic */ int access$008() {
        return NUM++;
    }

    private static interface Functor {
        public void start(CDXNode var1);

        public void end(CDXNode var1);
    }

    public class CDPText
    extends CDPProperty {
        String s;

        CDPText(String s) {
            super(1792);
            this.s = s;
        }

        @Override
        public void write(DataOutput o) throws IOException {
            o.writeShort(this.type);
            o.writeShort((short)(2 + this.s.length()));
            o.writeShort(0);
            o.write(this.s.getBytes());
        }
    }

    public class CDPProducts
    extends CDPProperty {
        int[] elems;

        CDPProducts(int[] elems) {
            super(3074);
            this.elems = elems;
        }

        @Override
        public void write(DataOutput o) throws IOException {
            o.writeShort(this.type);
            o.writeShort(this.elems.length * 4);
            for (int e : this.elems) {
                o.writeInt(e);
            }
        }
    }

    public class CDPReactants
    extends CDPProperty {
        int[] elems;

        CDPReactants(int[] elems) {
            super(3073);
            this.elems = elems;
        }

        @Override
        public void write(DataOutput o) throws IOException {
            o.writeShort(this.type);
            o.writeShort(this.elems.length * 4);
            for (int e : this.elems) {
                o.writeInt(e);
            }
        }
    }

    public class CDPBondDisplay
    extends CDPProperty {
        short val;

        CDPBondDisplay(short val) {
            super(1537);
            this.val = val;
        }

        @Override
        public void write(DataOutput o) throws IOException {
            o.writeShort(this.type);
            o.writeShort(2);
            o.writeShort(this.val);
        }
    }

    public class CDPBondEnd
    extends CDPBondAttach {
        public CDPBondEnd(int ref) {
            super(1541, ref);
        }
    }

    public class CDPBondBegin
    extends CDPBondAttach {
        public CDPBondBegin(int ref) {
            super(1540, ref);
        }
    }

    public abstract class CDPBondAttach
    extends CDPProperty {
        int ref;

        public CDPBondAttach(int t, int ref) {
            super(t);
            this.ref = ref;
        }

        @Override
        public void write(DataOutput o) throws IOException {
            o.writeShort(this.type);
            o.writeShort(4);
            o.writeInt(this.ref);
        }
    }

    public class CDPElement
    extends CDPProperty {
        short ord;

        public CDPElement(short ord) {
            super(1026);
            this.ord = ord;
        }

        @Override
        public void write(DataOutput o) throws IOException {
            o.writeShort(this.type);
            o.writeShort(2);
            o.writeShort(this.ord);
        }
    }

    public class CDPBondType
    extends CDPProperty {
        short btype;

        CDPBondType(int bond) {
            super(1536);
            this.btype = (short)-1;
            switch (bond) {
                case 1: {
                    this.btype = 1;
                    break;
                }
                case 2: {
                    this.btype = (short)2;
                    break;
                }
                case 4: {
                    this.btype = (short)4;
                    break;
                }
                case 9: {
                    this.btype = 1;
                    break;
                }
                case 17: {
                    this.btype = 1;
                    break;
                }
                case 26: {
                    this.btype = (short)2;
                    break;
                }
                case 32: {
                    this.btype = 1;
                    break;
                }
                case 64: {
                    this.btype = (short)128;
                    break;
                }
            }
        }

        @Override
        public void write(DataOutput o) throws IOException {
            o.writeShort(this.type);
            o.writeShort(2);
            o.writeShort(this.btype);
        }

        public boolean equals(Object o) {
            return o instanceof CDPBondType;
        }

        public int hascode() {
            return this.type;
        }
    }

    public class CDPPoint2D
    extends CDPProperty {
        int x;
        int y;

        public CDPPoint2D(int x, int y) {
            super(512);
            this.x = x;
            this.y = y;
        }

        @Override
        public void write(DataOutput o) throws IOException {
            o.writeShort(this.type);
            o.writeShort(8);
            o.writeInt(this.y);
            o.writeInt(this.x);
        }
    }

    public class CDPAtomEnhGroup
    extends CDPProperty {
        short val;

        CDPAtomEnhGroup(short g) {
            super(1095);
            this.val = g;
        }

        @Override
        public void write(DataOutput o) throws IOException {
            o.writeShort(this.type);
            o.writeShort(2);
            o.writeShort(this.val);
        }
    }

    public class CDPShowBondStereo
    extends CDPProperty {
        byte val;

        CDPShowBondStereo(boolean v) {
            super(1549);
            this.val = v ? (byte)1 : 0;
        }

        @Override
        public void write(DataOutput o) throws IOException {
            o.writeShort(this.type);
            o.writeShort(1);
            o.writeByte(this.val);
        }
    }

    public class CDPShowAtomStereo
    extends CDPProperty {
        byte val;

        CDPShowAtomStereo(boolean v) {
            super(1083);
            this.val = v ? (byte)1 : 0;
        }

        @Override
        public void write(DataOutput o) throws IOException {
            o.writeShort(this.type);
            o.writeShort(1);
            o.writeByte(this.val);
        }
    }

    public class CDPShowEnhAtomStereo
    extends CDPProperty {
        byte val;

        CDPShowEnhAtomStereo(boolean v) {
            super(1093);
            this.val = v ? (byte)1 : 0;
        }

        @Override
        public void write(DataOutput o) throws IOException {
            o.writeShort(this.type);
            o.writeShort(1);
            o.writeByte(this.val);
        }
    }

    public class CDPAtomEnhStereoType
    extends CDPProperty {
        byte val;

        CDPAtomEnhStereoType(byte v) {
            super(1094);
            this.val = v;
        }

        @Override
        public void write(DataOutput o) throws IOException {
            o.writeShort(this.type);
            o.writeShort(1);
            o.writeByte(this.val);
        }
    }

    public class CDPAtomCIP
    extends CDPProperty {
        byte val;

        CDPAtomCIP(byte v) {
            super(1079);
            this.val = v;
        }

        @Override
        public void write(DataOutput o) throws IOException {
            o.writeShort(this.type);
            o.writeShort(1);
            o.writeByte(this.val);
        }
    }

    public class CDPAtomIsotope
    extends CDPProperty {
        short iso;

        CDPAtomIsotope(short iso) {
            super(1056);
            this.iso = iso;
        }

        @Override
        public void write(DataOutput o) throws IOException {
            o.writeShort(this.type);
            o.writeShort(2);
            o.writeShort(this.iso);
        }
    }

    public class CDPAtomRadical
    extends CDPProperty {
        byte rad;

        CDPAtomRadical(byte rad) {
            super(1058);
            this.rad = rad;
        }

        @Override
        public void write(DataOutput o) throws IOException {
            o.writeShort(this.type);
            o.writeShort(1);
            o.writeByte(this.rad);
        }
    }

    public class CDPAtomCharge
    extends CDPProperty {
        byte charge;

        CDPAtomCharge(byte charge) {
            super(1057);
            this.charge = charge;
        }

        @Override
        public void write(DataOutput o) throws IOException {
            o.writeShort(this.type);
            o.writeShort(1);
            o.writeByte(this.charge);
        }
    }

    private abstract class CDPProperty {
        protected int type;

        public CDPProperty(int type) {
            this.type = type;
        }

        public abstract void write(DataOutput var1) throws IOException;
    }

    public class CDXReactionStep
    extends CDXNode {
        public CDXReactionStep(int[] rids, int[] pids) {
            super(32782);
            CDPReactants rts = new CDPReactants(rids);
            CDPProducts pts = new CDPProducts(pids);
            this.add(rts);
            this.add(pts);
        }

        @Override
        public String start() {
            return this.startString();
        }

        @Override
        public String end() {
            return String.format("00 00", new Object[0]);
        }
    }

    private class CDXBond
    extends CDXNode {
        public CDXBond(int id1, int id2) {
            super(32773);
            this.add(new CDPBondBegin(id1));
            this.add(new CDPBondEnd(id2));
        }

        @Override
        public String start() {
            return this.startString();
        }

        public void setBondType(int type) {
            CDPBondType t = new CDPBondType(type);
            this.add(t);
            switch (type) {
                case 9: {
                    this.add(new CDPBondDisplay(3));
                    break;
                }
                case 17: {
                    this.add(new CDPBondDisplay(6));
                }
            }
        }

        @Override
        public String end() {
            return String.format("00 00", new Object[0]);
        }
    }

    private class CDXAtom
    extends CDXNode {
        public CDXAtom(short ord, int x, int y) {
            super(32772);
            this.add(new CDPPoint2D(x, y));
            this.add(new CDPElement(ord));
        }

        public void setAtomESRStereo(int stereo) {
            ChemDrawCDX.debug("setAtomESRStereo " + stereo);
            switch (stereo) {
                case 0: {
                    this.add(new CDPAtomEnhStereoType(2));
                    break;
                }
                case 1: {
                    this.add(new CDPAtomEnhStereoType(4));
                    break;
                }
                case 2: {
                    this.add(new CDPAtomEnhStereoType(5));
                    break;
                }
            }
        }

        public void setAtomESRGroup(int grp) {
            this.add(new CDPAtomEnhGroup((short)grp));
        }

        public void setAtomCIP(int parity, boolean pi, boolean pseudo) {
            if (!pi) {
                switch (parity) {
                    case 1: {
                        this.add(new CDPAtomCIP(pseudo ? (byte)4 : 2));
                        break;
                    }
                    case 2: {
                        this.add(new CDPAtomCIP(pseudo ? (byte)5 : 3));
                        break;
                    }
                    default: {
                        this.add(new CDPAtomCIP(6));
                    }
                }
            }
        }

        public void setAtomMass(short mass) {
            this.add(new CDPAtomIsotope(mass));
        }

        public void setAtomCharge(byte charge) {
            this.add(new CDPAtomCharge(charge));
        }

        public void setAtomRadical(byte rad) {
            this.add(new CDPAtomRadical(rad));
        }

        @Override
        public String start() {
            return this.startString();
        }

        @Override
        public String end() {
            return String.format("00 00", new Object[0]);
        }
    }

    private class CDXMethane
    extends CDXAtom {
        public CDXMethane(int x, int y) {
            super((short)6, x, y);
            this.add(new CDXText("CH4", x, y));
        }

        @Override
        public String start() {
            return this.startString();
        }

        @Override
        public String end() {
            return String.format("00 00", new Object[0]);
        }
    }

    private class CDXText
    extends CDXNode {
        String s;

        CDXText(String s, int x, int y) {
            super(32774);
            this.s = s;
            this.add(new CDPPoint2D(x, y));
            this.add(new CDPText(s));
        }

        @Override
        public String start() {
            return this.startString();
        }

        @Override
        public String end() {
            return String.format("00 00", new Object[0]);
        }
    }

    private class CDXFragment
    extends CDXNode {
        public CDXFragment() {
            super(32771);
        }

        @Override
        public String start() {
            return this.startString();
        }

        @Override
        public String end() {
            return String.format("00 00", new Object[0]);
        }
    }

    public class CDXPage
    extends CDXNode {
        public CDXPage() {
            super(32769);
        }

        @Override
        public String start() {
            return this.startString();
        }

        @Override
        public String end() {
            return String.format("00 00", new Object[0]);
        }
    }

    public class CDXDocument
    extends CDXNode {
        public CDXDocument() {
            super(1145268822);
        }

        @Override
        public void startWrite(DataOutput o) throws IOException {
            o.writeInt(this.type);
            o.writeInt(0x30303130);
            o.writeInt(16909060);
            o.writeLong(0L);
            o.writeLong(0L);
            o.write(COLORTABLE);
        }

        @Override
        public String start() {
            return this.startString();
        }

        @Override
        public String end() {
            return String.format("00 00", new Object[0]);
        }
    }

    private abstract class CDXNode {
        protected int id = ChemDrawCDX.access$008();
        protected int type;
        private List<CDXNode> children;
        protected Set<CDPProperty> properties;

        public CDXNode(int type) {
            this.type = type;
        }

        public int getID() {
            return this.id;
        }

        public abstract String start();

        public abstract String end();

        public void startWrite(DataOutput o) throws IOException {
            o.writeShort(this.type);
            o.writeInt(this.id);
            this.writeProperties(o);
        }

        public final void endWrite(DataOutput o) throws IOException {
            o.writeShort(0);
        }

        protected void writeProperties(DataOutput o) {
            if (this.properties != null) {
                for (CDPProperty p : this.properties) {
                    try {
                        p.write(o);
                    }
                    catch (IOException e) {
                        System.err.println("Error writin property: " + e);
                    }
                }
            }
        }

        public void walk(Functor functor) {
            functor.start(this);
            if (this.children != null) {
                for (CDXNode n : this.children) {
                    n.walk(functor);
                }
            }
            functor.end(this);
        }

        public void add(CDXNode node) {
            if (this.children == null) {
                this.children = new ArrayList<CDXNode>();
            }
            this.children.add(node);
        }

        public void add(CDPProperty prop) {
            if (this.properties == null) {
                this.properties = new HashSet<CDPProperty>();
            }
            if (this.properties.contains(prop)) {
                this.properties.remove(prop);
            }
            this.properties.add(prop);
        }

        protected String startString() {
            try {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                LittleEndianDataOutputStream l = new LittleEndianDataOutputStream(bos);
                this.startWrite(l);
                bos.close();
                byte[] buffer = bos.toByteArray();
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < buffer.length; ++i) {
                    byte b = buffer[i];
                    if (i != 0) {
                        sb.append(" ");
                    }
                    if (i > 0 && i % 8 == 0) {
                        sb.append("\n");
                    }
                    sb.append(String.format("%02X", b & 0xFF));
                }
                return sb.toString();
            }
            catch (IOException e) {
                System.err.println("Error: " + e);
                return "#";
            }
        }
    }

    class MolGeom {
        double xmin;
        double ymin;
        double scale;

        MolGeom(double x, double y, double s) {
            this.xmin = x;
            this.ymin = y;
            this.scale = s;
        }
    }
}

