/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.gui.dnd;

import com.actelion.research.chem.Depictor2D;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.dnd.ChemistryFlavors;
import com.actelion.research.gui.dnd.MoleculeTransferable;
import com.actelion.research.gui.generic.GenericRectangle;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceContext;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.image.BufferedImage;
import java.io.IOException;

public abstract class MoleculeDragAdapter
implements DragSourceListener {
    int mAllowedDragAction;
    Cursor cursor = null;

    public MoleculeDragAdapter(Component c) {
        DragSource.getDefaultDragSource().createDefaultDragGestureRecognizer(c, 3, new DGListener());
        this.mAllowedDragAction = 3;
    }

    public void allowDrag(boolean allow) {
        this.mAllowedDragAction = allow ? 3 : 0;
    }

    public abstract Transferable getTransferable(Point var1);

    public void onDragEnter() {
    }

    public void onDragOver() {
    }

    public void onDragExit() {
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent e) {
    }

    @Override
    public final void dragEnter(DragSourceDragEvent e) {
        DragSourceContext context = e.getDragSourceContext();
        int dropAction = e.getDropAction();
        if ((dropAction & this.mAllowedDragAction) != 0) {
            context.setCursor(DragSource.DefaultCopyDrop);
        } else {
            context.setCursor(DragSource.DefaultCopyNoDrop);
        }
        this.onDragEnter();
    }

    @Override
    public final void dragOver(DragSourceDragEvent e) {
        this.onDragOver();
    }

    @Override
    public final void dragExit(DragSourceEvent e) {
        this.onDragExit();
    }

    @Override
    public final void dropActionChanged(DragSourceDragEvent e) {
        DragSourceContext context = e.getDragSourceContext();
        int dropAction = e.getDropAction();
        if ((dropAction & this.mAllowedDragAction) != 0) {
            context.setCursor(DragSource.DefaultCopyDrop);
        } else {
            context.setCursor(DragSource.DefaultCopyNoDrop);
        }
    }

    protected void onDragBegin(DragGestureEvent e) {
        Transferable transferable;
        this.cursor = null;
        if ((e.getDragAction() & this.mAllowedDragAction) != 0 && (transferable = this.getTransferable(e.getDragOrigin())) != null) {
            try {
                Image img = null;
                if (DragSource.isDragImageSupported() && (img = this.drawDragImage(transferable, 400, 400)) != null) {
                    e.startDrag(DragSource.DefaultCopyDrop, img, new Point(200, 200), transferable, this);
                } else {
                    e.startDrag(this.cursor, transferable, this);
                }
                this.dragIsValidAndStarts();
            }
            catch (InvalidDnDOperationException idoe) {
                System.err.println(idoe);
            }
        }
    }

    public Image drawDragImage(Transferable transferable, int width, int height) {
        if (transferable instanceof MoleculeTransferable) {
            try {
                MoleculeTransferable t = (MoleculeTransferable)transferable;
                Object o = t.getTransferData(ChemistryFlavors.DF_SERIALIZED_MOLECULE);
                if (o instanceof StereoMolecule) {
                    StereoMolecule mol = (StereoMolecule)o;
                    Depictor2D depict = new Depictor2D(mol);
                    BufferedImage img = new BufferedImage(width, height, 2);
                    Graphics2D g = (Graphics2D)img.getGraphics();
                    g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    g.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
                    depict.validateView(g, new GenericRectangle(0.0, 0.0, width, height), 65536);
                    depict.paint(g);
                    return img;
                }
            }
            catch (IOException e1) {
                System.err.println(e1);
            }
            catch (UnsupportedFlavorException e1) {
                System.err.println(e1);
            }
        }
        return null;
    }

    public void dragIsValidAndStarts() {
    }

    class DGListener
    implements DragGestureListener {
        DGListener() {
        }

        @Override
        public void dragGestureRecognized(DragGestureEvent e) {
            MoleculeDragAdapter.this.onDragBegin(e);
        }
    }
}

