/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.gui.dnd;

import com.actelion.research.chem.IDCodeParser;
import com.actelion.research.chem.Molecule;
import com.actelion.research.chem.MolfileParser;
import com.actelion.research.chem.SmilesParser;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.dnd.ChemistryFlavors;
import com.actelion.research.chem.name.StructureNameResolver;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;

public class MoleculeDropAdapter
implements DropTargetListener {
    public static final boolean debug = false;
    private boolean active_ = true;
    private final int mAllowedDropAction = 3;

    public void onDropMolecule(StereoMolecule m, Point pt) {
        this.DEBUG("MoleculeDropAdapter.onDropMolecule(). Override this! " + m);
    }

    @Override
    public void dragEnter(DropTargetDragEvent e) {
        this.DEBUG("DragEnter");
    }

    @Override
    public void dragOver(DropTargetDragEvent e) {
        this.DEBUG("DragOver");
    }

    public void setActive(boolean active) {
        this.active_ = active;
    }

    public boolean isActive() {
        return this.active_;
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent e) {
        this.DEBUG("dropActionChanged");
    }

    @Override
    public void dragExit(DropTargetEvent e) {
        this.DEBUG("dragExit");
    }

    @Override
    public void drop(DropTargetDropEvent e) {
        if (this.active_) {
            ClassLoader cl = this.getClass().getClassLoader();
            this.DEBUG("MoleculeDropAdapter   ClassLoader " + cl);
            this.DEBUG("MoleculeDropAdapter   Ignoring setContextclassloader!!!");
            this.DEBUG("MoleculeDropAdapter " + e);
            try {
                Transferable tr = e.getTransferable();
                this.DEBUG("Transferable is " + tr);
                DataFlavor chosen = this.chooseDropFlavor(e);
                StereoMolecule mol = null;
                if (chosen != null) {
                    e.acceptDrop(3);
                    this.DEBUG("Chose is " + chosen);
                    Object o = tr.getTransferData(chosen);
                    this.DEBUG("Object is " + o);
                    mol = this.createFromDataFlavor(chosen, o);
                    if (mol != null) {
                        this.onDropMolecule(mol, e.getLocation());
                        e.dropComplete(true);
                    } else {
                        System.err.println("Drop failed: " + e);
                        e.dropComplete(false);
                    }
                    return;
                }
                System.err.println("Drop failed: " + e);
                e.rejectDrop();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public DataFlavor[] getFlavors() {
        return ChemistryFlavors.MOLECULE_FLAVORS;
    }

    protected StereoMolecule createFromDataFlavor(DataFlavor chosen, Object o) throws Exception {
        StereoMolecule mol = null;
        if (chosen.equals(ChemistryFlavors.DF_SERIALIZED_MOLECULE) && o instanceof Molecule) {
            mol = new StereoMolecule((Molecule)o);
        } else if (chosen.equals(ChemistryFlavors.DF_MDLMOLFILE) && o instanceof String) {
            mol = new StereoMolecule();
            new MolfileParser().parse(mol, (String)o);
        } else if (chosen.equals(ChemistryFlavors.DF_SMILES) && o instanceof String) {
            mol = new StereoMolecule();
            new SmilesParser().parse(mol, ((String)o).getBytes());
        } else if (chosen.equals(ChemistryFlavors.DF_IDCODE) && o instanceof String) {
            mol = new StereoMolecule();
            new IDCodeParser(true).parse(mol, ((String)o).getBytes());
        } else if (chosen.equals(DataFlavor.stringFlavor) && o instanceof String) {
            try {
                mol = new StereoMolecule();
                new IDCodeParser(true).parse(mol, ((String)o).getBytes());
            }
            catch (Throwable t) {
                mol = StructureNameResolver.resolve((String)o);
            }
            if (mol == null) {
                System.err.println("Unable to instantiate from text flavor: " + o);
            }
        } else {
            System.err.println("Unable to instantiate flavor: " + chosen);
        }
        return mol;
    }

    protected boolean isDragFlavorSupported(DropTargetDragEvent e) {
        for (int i = 0; i < ChemistryFlavors.MOLECULE_FLAVORS.length; ++i) {
            if (!e.isDataFlavorSupported(ChemistryFlavors.MOLECULE_FLAVORS[i])) continue;
            return true;
        }
        return false;
    }

    protected DataFlavor chooseDropFlavor(DropTargetDropEvent e) {
        for (int i = 0; i < ChemistryFlavors.MOLECULE_FLAVORS.length; ++i) {
            if (!e.isDataFlavorSupported(ChemistryFlavors.MOLECULE_FLAVORS[i])) continue;
            return ChemistryFlavors.MOLECULE_FLAVORS[i];
        }
        return null;
    }

    public boolean isDropOK(DropTargetDragEvent e) {
        if (!this.isDragFlavorSupported(e)) {
            return false;
        }
        return (e.getDropAction() & 3) != 0;
    }

    private void DEBUG(String s) {
    }
}

