/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.gui.dnd;

import com.actelion.research.chem.Canonizer;
import com.actelion.research.chem.IsomericSmilesCreator;
import com.actelion.research.chem.MolfileCreator;
import com.actelion.research.chem.MolfileV3Creator;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.dnd.ChemistryFlavors;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;

public class MoleculeTransferable
implements Transferable,
ClipboardOwner {
    protected StereoMolecule mMol;

    public MoleculeTransferable(StereoMolecule mol) {
        this.mMol = mol;
    }

    @Override
    public synchronized DataFlavor[] getTransferDataFlavors() {
        return ChemistryFlavors.MOLECULE_FLAVORS;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        for (DataFlavor f : ChemistryFlavors.MOLECULE_FLAVORS) {
            if (!f.equals(flavor)) continue;
            return true;
        }
        return false;
    }

    @Override
    public synchronized Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (flavor.equals(ChemistryFlavors.DF_SERIALIZED_MOLECULE)) {
            return new StereoMolecule(this.mMol);
        }
        if (flavor.equals(ChemistryFlavors.DF_MDLMOLFILEV3)) {
            return new MolfileV3Creator(this.mMol).getMolfile();
        }
        if (flavor.equals(ChemistryFlavors.DF_MDLMOLFILE)) {
            return new MolfileCreator(this.mMol).getMolfile();
        }
        if (flavor.equals(ChemistryFlavors.DF_SMILES)) {
            return new IsomericSmilesCreator(this.mMol).getSmiles();
        }
        if (flavor.equals(ChemistryFlavors.DF_IDCODE) || flavor.equals(DataFlavor.stringFlavor)) {
            Canonizer canonizer = new Canonizer(this.mMol);
            return String.format("%s %s", canonizer.getIDCode(), canonizer.getEncodedCoordinates(true));
        }
        throw new UnsupportedFlavorException(flavor);
    }

    public String toString() {
        return "MoleculeTransferable";
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }
}

