/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.gui.dnd;

import com.actelion.research.chem.IsomericSmilesCreator;
import com.actelion.research.chem.dnd.ChemistryFlavors;
import com.actelion.research.chem.reaction.Reaction;
import com.actelion.research.chem.reaction.ReactionEncoder;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;

public class ReactionTransferable
implements Transferable,
ClipboardOwner {
    protected Reaction mReaction;

    public ReactionTransferable(Reaction rxn) {
        this.mReaction = rxn;
    }

    @Override
    public synchronized DataFlavor[] getTransferDataFlavors() {
        return ChemistryFlavors.REACTION_FLAVORS;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        if (flavor.equals(ChemistryFlavors.DF_REACTION_SMILES)) {
            return false;
        }
        for (DataFlavor f : ChemistryFlavors.REACTION_FLAVORS) {
            if (!f.equals(flavor)) continue;
            return true;
        }
        return false;
    }

    @Override
    public synchronized Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (flavor.equals(ChemistryFlavors.DF_SERIALIZED_REACTION)) {
            Reaction rxn = new Reaction(this.mReaction);
            rxn.removeDrawingObjects();
            return rxn;
        }
        if (flavor.equals(ChemistryFlavors.DF_REACTION_SMILES)) {
            return IsomericSmilesCreator.createReactionSmiles(this.mReaction);
        }
        if (flavor.equals(DataFlavor.stringFlavor)) {
            return ReactionEncoder.encode(this.mReaction, true);
        }
        throw new UnsupportedFlavorException(flavor);
    }

    public String toString() {
        return "ReactionTransferable";
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }
}

