/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.gui.editor;

import com.actelion.research.chem.ExtendedMolecule;
import com.actelion.research.chem.Molecule;
import com.actelion.research.gui.generic.GenericActionEvent;
import com.actelion.research.gui.generic.GenericCheckBox;
import com.actelion.research.gui.generic.GenericComboBox;
import com.actelion.research.gui.generic.GenericDialog;
import com.actelion.research.gui.generic.GenericEventListener;
import com.actelion.research.gui.generic.GenericLabel;
import com.actelion.research.gui.generic.GenericTextField;
import com.actelion.research.gui.generic.GenericUIHelper;
import com.actelion.research.gui.hidpi.HiDPIHelper;
import java.util.Arrays;

public class AtomQueryFeatureDialogBuilder
implements GenericEventListener<GenericActionEvent> {
    public static final String[] RING_SIZE_SHORT_TEXT = new String[]{"", "r0", "r", "r3", "r3-4", "r3-5", "r3-6", "r3-7", "r4", "r4-5", "r4-6", "r4-7", "r>3", "r5", "r5-6", "r5-7", "r>4", "r6", "r6-7", "r>5", "r7", "r>6", "r>7"};
    private static final String[] RING_SIZE_OPTIONS = new String[]{"any", "is not in a ring", "is in any ring", "3 members", "3-4 members", "3-5 members", "3-6 members", "3-7 members", "4 members", "4-5 members", "4-6 members", "4-7 members", "> 3 members", "5 members", "5-6 members", "5-7 members", "> 4 members", "6 members", "6-7 members", "> 5 members", "7 members", "> 6 members", "> 7 members"};
    public static final long[] RING_SIZE_VALUES = new long[]{0L, 0x100000000L, 0x7E00000000L, 0x200000000L, 0x600000000L, 0xE00000000L, 0x1E00000000L, 0x3E00000000L, 0x400000000L, 0xC00000000L, 0x1C00000000L, 0x3C00000000L, 0x7C00000000L, 0x800000000L, 0x1800000000L, 0x3800000000L, 0x7800000000L, 0x1000000000L, 0x3000000000L, 0x7000000000L, 0x2000000000L, 0x6000000000L, 0x4000000000L};
    private GenericDialog mDialog;
    private GenericLabel mLabelAtomList;
    private GenericTextField mTFAtomList;
    private GenericCheckBox mCBAny;
    private GenericCheckBox mCBBlocked;
    private GenericCheckBox mCBSubstituted;
    private GenericCheckBox mCBMatchStereo;
    private GenericCheckBox mCBExcludeGroup;
    private GenericComboBox mChoiceArom;
    private GenericComboBox mChoiceRingState;
    private GenericComboBox mChoiceSmallRingSize;
    private GenericComboBox mChoiceRingSize;
    private GenericComboBox mChoiceCharge;
    private GenericComboBox mChoiceNeighbours;
    private GenericComboBox mChoiceHydrogen;
    private GenericComboBox mChoicePi;
    private GenericComboBox mChoiceReactionParityHint;
    private ExtendedMolecule mMol;
    private int mAtom;
    private long mRingSizeCustomValue;
    private boolean mOKSelected;

    public AtomQueryFeatureDialogBuilder(GenericUIHelper dialogHelper, ExtendedMolecule mol, int atom, boolean includeReactionHints) {
        this.mDialog = dialogHelper.createDialog(mol.isSelectedAtom(atom) ? "Atom Query Features (Multiple)" : "Atom Query Features", this);
        this.build(mol, atom, includeReactionHints);
    }

    public boolean showDialog() {
        this.mOKSelected = false;
        this.mDialog.showDialog();
        return this.mOKSelected;
    }

    private void build(ExtendedMolecule mol, int atom, boolean includeReactionHints) {
        this.mMol = mol;
        this.mAtom = atom;
        int gap = HiDPIHelper.scale(8.0f);
        int[] gap1 = new int[]{gap, gap / 2, gap * 3 / 2, gap / 2, gap / 2, gap / 2, gap / 2, gap / 2, gap / 2, gap / 2, gap * 3 / 2, gap / 4, gap / 4, gap / 4};
        int[] gap2 = new int[]{gap * 3 / 2, gap / 2};
        int[] hLayout = new int[]{gap, -2, gap, -2, gap};
        int[] vLayout = new int[1 + 2 * gap1.length + (includeReactionHints ? 2 * gap2.length : 0)];
        int index = 0;
        for (int g : gap1) {
            vLayout[index++] = g;
            vLayout[index++] = -2;
        }
        if (includeReactionHints) {
            for (int g : gap2) {
                vLayout[index++] = g;
                vLayout[index++] = -2;
            }
        }
        vLayout[index++] = gap;
        this.mDialog.setLayout(hLayout, vLayout);
        this.mCBAny = this.mDialog.createCheckBox("Any atomic number");
        this.mCBAny.addEventConsumer(this);
        this.mDialog.add(this.mCBAny, 1, 1, 3, 1);
        this.mLabelAtomList = this.mDialog.createLabel("Excluded atoms:");
        this.mTFAtomList = this.mDialog.createTextField(16, 1);
        this.mDialog.add(this.mLabelAtomList, 1, 3);
        this.mDialog.add(this.mTFAtomList, 3, 3);
        this.mChoiceArom = this.mDialog.createComboBox();
        this.mChoiceArom.addItem("any");
        this.mChoiceArom.addItem("is aromatic");
        this.mChoiceArom.addItem("is not aromatic");
        this.mDialog.add(this.mDialog.createLabel("Aromaticity:"), 1, 5);
        this.mDialog.add(this.mChoiceArom, 3, 5);
        this.mChoiceRingState = this.mDialog.createComboBox();
        this.mChoiceRingState.addItem("any");
        this.mChoiceRingState.addItem("none (not in a ring)");
        this.mChoiceRingState.addItem("at least 2");
        this.mChoiceRingState.addItem("exactly 2");
        this.mChoiceRingState.addItem("exactly 3");
        this.mChoiceRingState.addItem("more than 3");
        this.mDialog.add(this.mDialog.createLabel("Ring bonds:"), 1, 7);
        this.mDialog.add(this.mChoiceRingState, 3, 7);
        this.mChoiceSmallRingSize = this.mDialog.createComboBox();
        this.mChoiceSmallRingSize.addItem("any");
        this.mChoiceSmallRingSize.addItem("3 members");
        this.mChoiceSmallRingSize.addItem("4 members");
        this.mChoiceSmallRingSize.addItem("5 members");
        this.mChoiceSmallRingSize.addItem("6 members");
        this.mChoiceSmallRingSize.addItem("7 members");
        this.mDialog.add(this.mDialog.createLabel("Smallest ring size:"), 1, 9);
        this.mDialog.add(this.mChoiceSmallRingSize, 3, 9);
        this.mChoiceRingSize = this.mDialog.createComboBox();
        for (String option : RING_SIZE_OPTIONS) {
            this.mChoiceRingSize.addItem(option);
        }
        this.mDialog.add(this.mDialog.createLabel("Any ring size:"), 1, 11);
        this.mDialog.add(this.mChoiceRingSize, 3, 11);
        this.mChoiceCharge = this.mDialog.createComboBox();
        this.mChoiceCharge.addItem("any");
        this.mChoiceCharge.addItem("not charged");
        this.mChoiceCharge.addItem("has negative charge");
        this.mChoiceCharge.addItem("has positive charge");
        this.mDialog.add(this.mDialog.createLabel("Charge:"), 1, 13);
        this.mDialog.add(this.mChoiceCharge, 3, 13);
        this.mChoiceNeighbours = this.mDialog.createComboBox();
        this.mChoiceNeighbours.addItem("any");
        this.mChoiceNeighbours.addItem("exactly 1");
        this.mChoiceNeighbours.addItem("exactly 2");
        this.mChoiceNeighbours.addItem("exactly 3");
        this.mChoiceNeighbours.addItem("less than 3");
        this.mChoiceNeighbours.addItem("less than 4");
        this.mChoiceNeighbours.addItem("more than 1");
        this.mChoiceNeighbours.addItem("more than 2");
        this.mChoiceNeighbours.addItem("more than 3");
        this.mDialog.add(this.mDialog.createLabel("Non-H neighbours:"), 1, 15);
        this.mDialog.add(this.mChoiceNeighbours, 3, 15);
        this.mChoiceHydrogen = this.mDialog.createComboBox();
        this.mChoiceHydrogen.addItem("any");
        this.mChoiceHydrogen.addItem("none");
        this.mChoiceHydrogen.addItem("exactly 1");
        this.mChoiceHydrogen.addItem("exactly 2");
        this.mChoiceHydrogen.addItem("at least 1");
        this.mChoiceHydrogen.addItem("at least 2");
        this.mChoiceHydrogen.addItem("at least 3");
        this.mChoiceHydrogen.addItem("less than 2");
        this.mChoiceHydrogen.addItem("less than 3");
        this.mDialog.add(this.mDialog.createLabel("Hydrogen count:"), 1, 17);
        this.mDialog.add(this.mChoiceHydrogen, 3, 17);
        this.mChoicePi = this.mDialog.createComboBox();
        this.mChoicePi.addItem("any");
        this.mChoicePi.addItem("none");
        this.mChoicePi.addItem("exactly 1");
        this.mChoicePi.addItem("exactly 2");
        this.mChoicePi.addItem("at least 1");
        this.mDialog.add(this.mDialog.createLabel("Pi-electron count:"), 1, 19);
        this.mDialog.add(this.mChoicePi, 3, 19);
        this.mCBBlocked = this.mDialog.createCheckBox("prohibit further substitution");
        this.mCBBlocked.addEventConsumer(this);
        this.mDialog.add(this.mCBBlocked, 1, 21, 3, 21);
        this.mCBSubstituted = this.mDialog.createCheckBox("require further substitution");
        this.mCBSubstituted.addEventConsumer(this);
        this.mDialog.add(this.mCBSubstituted, 1, 23, 3, 23);
        this.mCBMatchStereo = this.mDialog.createCheckBox("match stereo center");
        this.mDialog.add(this.mCBMatchStereo, 1, 25, 3, 25);
        this.mCBExcludeGroup = this.mDialog.createCheckBox("is part of exclude group");
        this.mDialog.add(this.mCBExcludeGroup, 1, 27, 3, 27);
        if (includeReactionHints) {
            this.mDialog.add(this.mDialog.createLabel("Stereo center hint for product:"), 1, 29, 3, 29);
            this.mChoiceReactionParityHint = this.mDialog.createComboBox();
            this.mChoiceReactionParityHint.addItem("Copy from generic product");
            this.mChoiceReactionParityHint.addItem("Keep reactant configuration");
            this.mChoiceReactionParityHint.addItem("Invert reactant configuration");
            this.mChoiceReactionParityHint.addItem("Racemise configuration");
            this.mDialog.add(this.mChoiceReactionParityHint, 1, 31, 3, 31);
        }
        this.mMol.ensureHelperArrays(31);
        this.setInitialStates();
    }

    @Override
    public void eventHappened(GenericActionEvent e) {
        if (e.getWhat() == 0) {
            this.setQueryFeatures();
            this.mOKSelected = true;
            this.mDialog.disposeDialog();
        } else if (e.getWhat() == 1) {
            this.mDialog.disposeDialog();
        } else if (e.getSource() == this.mCBAny) {
            if (e.getValue() == 1) {
                this.mTFAtomList.setText("");
                this.mLabelAtomList.setText("Excluded atoms:");
            } else {
                this.mTFAtomList.setText(this.mMol.getAtomLabel(this.mAtom));
                this.mLabelAtomList.setText("Allowed atoms:");
            }
        } else if (e.getSource() == this.mCBBlocked) {
            this.mCBSubstituted.setSelected(false);
            this.mChoiceNeighbours.setSelectedIndex(0);
        } else if (e.getSource() == this.mCBSubstituted) {
            this.mCBBlocked.setSelected(false);
        }
    }

    private void setInitialStates() {
        long queryFeatures = this.mMol.getAtomQueryFeatures(this.mAtom);
        if ((queryFeatures & 1L) != 0L) {
            this.mCBAny.setSelected(true);
            this.mLabelAtomList.setText("Excluded atoms:");
        } else {
            this.mLabelAtomList.setText("Allowed atoms:");
        }
        this.mTFAtomList.setText(this.mMol.getAtomList(this.mAtom) == null ? "" : this.mMol.getAtomListString(this.mAtom));
        long aromState = queryFeatures & 6L;
        if (aromState == 2L) {
            this.mChoiceArom.setSelectedIndex(1);
        } else if (aromState == 4L) {
            this.mChoiceArom.setSelectedIndex(2);
        } else {
            this.mChoiceArom.setSelectedIndex(0);
        }
        long ringState = queryFeatures & 0x78L;
        if (ringState == 112L) {
            this.mChoiceRingState.setSelectedIndex(1);
        } else if (ringState == 8L) {
            this.mChoiceRingState.setSelectedIndex(2);
        } else if (ringState == 104L) {
            this.mChoiceRingState.setSelectedIndex(3);
        } else if (ringState == 88L) {
            this.mChoiceRingState.setSelectedIndex(4);
        } else if (ringState == 56L) {
            this.mChoiceRingState.setSelectedIndex(5);
        } else {
            this.mChoiceRingState.setSelectedIndex(0);
        }
        int smallRingSize = (int)((queryFeatures & 0x1C00000L) >> 22);
        this.mChoiceSmallRingSize.setSelectedIndex(smallRingSize == 0 ? 0 : smallRingSize - 2);
        long ringSize = queryFeatures & 0x7F00000000L;
        int index = -1;
        for (int i = 0; i < RING_SIZE_VALUES.length; ++i) {
            if (ringSize != RING_SIZE_VALUES[i]) continue;
            index = i;
            break;
        }
        if (index != -1) {
            this.mChoiceRingSize.setSelectedIndex(index);
        } else {
            StringBuilder customOption = new StringBuilder("Custom:");
            if ((ringSize & 0x100000000L) != 0L) {
                customOption.append(" 0");
            }
            if ((ringSize & 0x200000000L) != 0L) {
                customOption.append(" 3");
            }
            if ((ringSize & 0x400000000L) != 0L) {
                customOption.append(" 4");
            }
            if ((ringSize & 0x800000000L) != 0L) {
                customOption.append(" 5");
            }
            if ((ringSize & 0x1000000000L) != 0L) {
                customOption.append(" 6");
            }
            if ((ringSize & 0x2000000000L) != 0L) {
                customOption.append(" 7");
            }
            if ((ringSize & 0x4000000000L) != 0L) {
                customOption.append(" >=8");
            }
            this.mRingSizeCustomValue = ringSize;
            this.mChoiceRingSize.addItem(customOption.toString());
            this.mChoiceRingSize.setSelectedIndex(RING_SIZE_VALUES.length);
        }
        long neighbourFeatures = queryFeatures & 0x3E0000L;
        if (neighbourFeatures == 0x3A0000L) {
            this.mChoiceNeighbours.setSelectedIndex(1);
        } else if (neighbourFeatures == 0x360000L) {
            this.mChoiceNeighbours.setSelectedIndex(2);
        } else if (neighbourFeatures == 0x2E0000L) {
            this.mChoiceNeighbours.setSelectedIndex(3);
        } else if (neighbourFeatures == 0x300000L) {
            this.mChoiceNeighbours.setSelectedIndex(4);
        } else if (neighbourFeatures == 0x200000L) {
            this.mChoiceNeighbours.setSelectedIndex(5);
        } else if (neighbourFeatures == 393216L) {
            this.mChoiceNeighbours.setSelectedIndex(6);
        } else if (neighbourFeatures == 917504L) {
            this.mChoiceNeighbours.setSelectedIndex(7);
        } else if (neighbourFeatures == 0x1E0000L) {
            this.mChoiceNeighbours.setSelectedIndex(8);
        } else {
            this.mChoiceNeighbours.setSelectedIndex(0);
        }
        long chargeFeatures = queryFeatures & 0xE000000L;
        if (chargeFeatures == 0xA000000L) {
            this.mChoiceCharge.setSelectedIndex(1);
        } else if (chargeFeatures == 0xC000000L) {
            this.mChoiceCharge.setSelectedIndex(2);
        } else if (chargeFeatures == 0x6000000L) {
            this.mChoiceCharge.setSelectedIndex(3);
        } else {
            this.mChoiceCharge.setSelectedIndex(0);
        }
        long hydrogenFeatures = queryFeatures & 0x780L;
        if (hydrogenFeatures == 1792L) {
            this.mChoiceHydrogen.setSelectedIndex(1);
        } else if (hydrogenFeatures == 1664L) {
            this.mChoiceHydrogen.setSelectedIndex(2);
        } else if (hydrogenFeatures == 1408L) {
            this.mChoiceHydrogen.setSelectedIndex(3);
        } else if (hydrogenFeatures == 128L) {
            this.mChoiceHydrogen.setSelectedIndex(4);
        } else if (hydrogenFeatures == 384L) {
            this.mChoiceHydrogen.setSelectedIndex(5);
        } else if (hydrogenFeatures == 896L) {
            this.mChoiceHydrogen.setSelectedIndex(6);
        } else if (hydrogenFeatures == 1536L) {
            this.mChoiceHydrogen.setSelectedIndex(7);
        } else if (hydrogenFeatures == 1024L) {
            this.mChoiceHydrogen.setSelectedIndex(8);
        } else {
            this.mChoiceHydrogen.setSelectedIndex(0);
        }
        long piFeatures = queryFeatures & 0x1C000L;
        if (piFeatures == 98304L) {
            this.mChoicePi.setSelectedIndex(1);
        } else if (piFeatures == 81920L) {
            this.mChoicePi.setSelectedIndex(2);
        } else if (piFeatures == 49152L) {
            this.mChoicePi.setSelectedIndex(3);
        } else if (piFeatures == 16384L) {
            this.mChoicePi.setSelectedIndex(4);
        } else {
            this.mChoicePi.setSelectedIndex(0);
        }
        if ((queryFeatures & 0x800L) != 0L) {
            this.mCBBlocked.setSelected(true);
        }
        if ((queryFeatures & 0x1000L) != 0L) {
            this.mCBSubstituted.setSelected(true);
        }
        if ((queryFeatures & 0x2000L) != 0L) {
            this.mCBMatchStereo.setSelected(true);
        }
        if ((queryFeatures & 0x20000000L) != 0L) {
            this.mCBExcludeGroup.setSelected(true);
        }
        if (this.mChoiceReactionParityHint != null) {
            long rxnStereo = queryFeatures & 0xFFFFFFFFC0000000L;
            if (rxnStereo == 0x40000000L) {
                this.mChoiceReactionParityHint.setSelectedIndex(1);
            } else if (rxnStereo == Integer.MIN_VALUE) {
                this.mChoiceReactionParityHint.setSelectedIndex(2);
            } else if (rxnStereo == -1073741824L) {
                this.mChoiceReactionParityHint.setSelectedIndex(3);
            } else {
                this.mChoiceReactionParityHint.setSelectedIndex(0);
            }
        }
    }

    private void setQueryFeatures() {
        int[] atomList = this.createAtomList();
        if (this.mMol.isSelectedAtom(this.mAtom)) {
            for (int atom = 0; atom < this.mMol.getAllAtoms(); ++atom) {
                if (!this.mMol.isSelectedAtom(atom)) continue;
                this.setQueryFeatures(atom, atomList);
            }
        } else {
            this.setQueryFeatures(this.mAtom, atomList);
        }
    }

    private void setQueryFeatures(int atom, int[] atomList) {
        int ringSizeIndex;
        long queryFeatures = 0L;
        if (this.mCBAny.isSelected()) {
            queryFeatures |= 1L;
            this.mMol.setAtomList(atom, atomList, true);
        } else {
            this.mMol.setAtomList(atom, atomList, false);
        }
        if (!this.mMol.isAromaticAtom(atom)) {
            if (this.mChoiceArom.getSelectedIndex() == 1) {
                queryFeatures |= 2L;
            } else if (this.mChoiceArom.getSelectedIndex() == 2) {
                queryFeatures |= 4L;
            }
        }
        int ringBonds = 0;
        for (int i = 0; i < this.mMol.getConnAtoms(atom); ++i) {
            if (!this.mMol.isRingBond(this.mMol.getConnBond(atom, i))) continue;
            ++ringBonds;
        }
        switch (this.mChoiceRingState.getSelectedIndex()) {
            case 1: {
                if (ringBonds != 0) break;
                queryFeatures |= 0x70L;
                break;
            }
            case 2: {
                queryFeatures |= 8L;
                break;
            }
            case 3: {
                if (ringBonds >= 3) break;
                queryFeatures |= 0x68L;
                break;
            }
            case 4: {
                if (ringBonds >= 4) break;
                queryFeatures |= 0x58L;
                break;
            }
            case 5: {
                queryFeatures |= 0x38L;
            }
        }
        if (this.mChoiceSmallRingSize.getSelectedIndex() != 0) {
            queryFeatures |= (long)(this.mChoiceSmallRingSize.getSelectedIndex() + 2) << 22;
        }
        if ((ringSizeIndex = this.mChoiceRingSize.getSelectedIndex()) == RING_SIZE_VALUES.length) {
            queryFeatures |= this.mRingSizeCustomValue;
        } else if (ringSizeIndex != 0) {
            queryFeatures |= RING_SIZE_VALUES[ringSizeIndex];
        }
        switch (this.mChoiceCharge.getSelectedIndex()) {
            case 1: {
                queryFeatures |= 0xA000000L;
                break;
            }
            case 2: {
                queryFeatures |= 0xC000000L;
                break;
            }
            case 3: {
                queryFeatures |= 0x6000000L;
            }
        }
        switch (this.mChoiceNeighbours.getSelectedIndex()) {
            case 1: {
                if (this.mMol.getConnAtoms(atom) == 1) {
                    queryFeatures |= 0x800L;
                    break;
                }
                if (this.mMol.getConnAtoms(atom) >= 1) break;
                queryFeatures |= 0x3A0000L;
                break;
            }
            case 2: {
                if (this.mMol.getConnAtoms(atom) == 2) {
                    queryFeatures |= 0x800L;
                    break;
                }
                if (this.mMol.getConnAtoms(atom) >= 2) break;
                queryFeatures |= 0x360000L;
                break;
            }
            case 3: {
                if (this.mMol.getConnAtoms(atom) == 3) {
                    queryFeatures |= 0x800L;
                    break;
                }
                if (this.mMol.getConnAtoms(atom) >= 3) break;
                queryFeatures |= 0x2E0000L;
                break;
            }
            case 4: {
                if (this.mMol.getConnAtoms(atom) == 2) {
                    queryFeatures |= 0x800L;
                    break;
                }
                if (this.mMol.getConnAtoms(atom) >= 2) break;
                queryFeatures |= 0x300000L;
                break;
            }
            case 5: {
                if (this.mMol.getConnAtoms(atom) == 3) {
                    queryFeatures |= 0x800L;
                    break;
                }
                if (this.mMol.getConnAtoms(atom) >= 3) break;
                queryFeatures |= 0x200000L;
                break;
            }
            case 6: {
                if (this.mMol.getConnAtoms(atom) == 1) {
                    queryFeatures |= 0x1000L;
                    break;
                }
                if (this.mMol.getConnAtoms(atom) >= 1) break;
                queryFeatures |= 0x60000L;
                break;
            }
            case 7: {
                if (this.mMol.getConnAtoms(atom) == 2) {
                    queryFeatures |= 0x1000L;
                    break;
                }
                if (this.mMol.getConnAtoms(atom) >= 2) break;
                queryFeatures |= 0xE0000L;
                break;
            }
            case 8: {
                if (this.mMol.getConnAtoms(atom) == 3) {
                    queryFeatures |= 0x1000L;
                    break;
                }
                if (this.mMol.getConnAtoms(atom) >= 3) break;
                queryFeatures |= 0x1E0000L;
            }
        }
        switch (this.mChoiceHydrogen.getSelectedIndex()) {
            case 1: {
                queryFeatures |= 0x700L;
                break;
            }
            case 2: {
                queryFeatures |= 0x680L;
                break;
            }
            case 3: {
                queryFeatures |= 0x580L;
                break;
            }
            case 4: {
                queryFeatures |= 0x80L;
                break;
            }
            case 5: {
                queryFeatures |= 0x180L;
                break;
            }
            case 6: {
                queryFeatures |= 0x380L;
                break;
            }
            case 7: {
                queryFeatures |= 0x600L;
                break;
            }
            case 8: {
                queryFeatures |= 0x400L;
            }
        }
        switch (this.mChoicePi.getSelectedIndex()) {
            case 1: {
                queryFeatures |= 0x18000L;
                break;
            }
            case 2: {
                queryFeatures |= 0x14000L;
                break;
            }
            case 3: {
                queryFeatures |= 0xC000L;
                break;
            }
            case 4: {
                queryFeatures |= 0x4000L;
            }
        }
        if (this.mCBBlocked.isSelected() && (this.mMol.getFreeValence(atom) > 0 || this.mMol.getAtomCharge(atom) == 0 && (this.mMol.getAtomicNo(atom) == 5 || this.mMol.isNitrogenFamily(atom) || this.mMol.isChalcogene(atom)))) {
            queryFeatures |= 0x800L;
        }
        if (this.mCBSubstituted.isSelected() && (this.mMol.getFreeValence(atom) > 0 || this.mMol.getAtomCharge(atom) == 0 && (this.mMol.getAtomicNo(atom) == 5 || this.mMol.isNitrogenFamily(atom) || this.mMol.isChalcogene(atom)))) {
            queryFeatures |= 0x1000L;
        }
        if (this.mCBMatchStereo.isSelected()) {
            queryFeatures |= 0x2000L;
        }
        if (this.mCBExcludeGroup.isSelected()) {
            queryFeatures |= 0x20000000L;
        }
        if (this.mChoiceReactionParityHint != null) {
            switch (this.mChoiceReactionParityHint.getSelectedIndex()) {
                case 1: {
                    queryFeatures |= 0x40000000L;
                    break;
                }
                case 2: {
                    queryFeatures |= Integer.MIN_VALUE;
                    break;
                }
                case 3: {
                    queryFeatures |= 0xFFFFFFFFC0000000L;
                }
            }
        }
        this.mMol.setAtomQueryFeature(atom, -1L, false);
        this.mMol.setAtomQueryFeature(atom, queryFeatures, true);
    }

    private int[] createAtomList() {
        int delimiterIndex;
        String listString = this.mTFAtomList.getText();
        if (listString.length() == 0) {
            return null;
        }
        int[] list = null;
        do {
            String label;
            if ((delimiterIndex = listString.indexOf(44)) == -1) {
                label = listString;
            } else {
                label = listString.substring(0, delimiterIndex);
                listString = delimiterIndex == listString.length() - 1 ? "" : listString.substring(delimiterIndex + 1);
            }
            int atomicNo = Molecule.getAtomicNoFromLabel(label);
            if (atomicNo == 0) continue;
            if (atomicNo == 1) {
                this.mDialog.showMessage("'H' cannot be part of an atom list and is removed.");
                continue;
            }
            if (list == null) {
                list = new int[]{atomicNo};
                continue;
            }
            boolean found = false;
            for (int i = 0; i < list.length; ++i) {
                if (atomicNo != list[i]) continue;
                found = true;
                break;
            }
            if (found) continue;
            int[] newList = new int[list.length + 1];
            for (int i = 0; i < list.length; ++i) {
                newList[i] = list[i];
            }
            newList[list.length] = atomicNo;
            list = newList;
        } while (delimiterIndex != -1);
        if (list != null) {
            Arrays.sort(list);
        }
        return list;
    }
}

