/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.gui.editor;

import com.actelion.research.chem.ExtendedMolecule;
import com.actelion.research.gui.generic.GenericActionEvent;
import com.actelion.research.gui.generic.GenericCheckBox;
import com.actelion.research.gui.generic.GenericComboBox;
import com.actelion.research.gui.generic.GenericDialog;
import com.actelion.research.gui.generic.GenericEventListener;
import com.actelion.research.gui.generic.GenericUIHelper;

public class BondQueryFeatureDialogBuilder
implements GenericEventListener<GenericActionEvent> {
    private GenericDialog mDialog;
    private ExtendedMolecule mMol;
    private int mBond;
    private int mFirstSpanItem;
    private GenericCheckBox mCBSingle;
    private GenericCheckBox mCBDouble;
    private GenericCheckBox mCBTriple;
    private GenericCheckBox mCBDelocalized;
    private GenericCheckBox mCBMetalLigand;
    private GenericCheckBox mCBIsBridge;
    private GenericCheckBox mCBMatchStereo;
    private GenericComboBox mComboBoxRing;
    private GenericComboBox mComboBoxRingSize;
    private GenericComboBox mComboBoxMinAtoms;
    private GenericComboBox mComboBoxMaxAtoms;
    private boolean mOKSelected;

    public BondQueryFeatureDialogBuilder(GenericUIHelper dialogHelper, ExtendedMolecule mol, int bond) {
        this.mDialog = dialogHelper.createDialog(mol.isSelectedAtom(mol.getBondAtom(0, bond)) && mol.isSelectedAtom(mol.getBondAtom(1, bond)) ? "Bond Query Features (Multiple)" : "Bond Query Features", this);
        this.build(mol, bond);
    }

    public boolean showDialog() {
        this.mOKSelected = false;
        this.mDialog.showDialog();
        return this.mOKSelected;
    }

    private void build(ExtendedMolecule mol, int bond) {
        this.mMol = mol;
        this.mBond = bond;
        int[] hLayout = new int[]{8, -1, -2, -2, 8};
        int[] vLayout = new int[]{8, -2, -2, -2, -2, -2, 8, -2, 8, -2, 8, -2, 16, -2, 4, -2, 4, -2, 16};
        this.mDialog.setLayout(hLayout, vLayout);
        this.mCBSingle = this.mDialog.createCheckBox("Single");
        this.mDialog.add(this.mCBSingle, 1, 1, 3, 1);
        this.mCBDouble = this.mDialog.createCheckBox("Double");
        this.mDialog.add(this.mCBDouble, 1, 2, 3, 2);
        this.mCBTriple = this.mDialog.createCheckBox("Triple");
        this.mDialog.add(this.mCBTriple, 1, 3, 3, 3);
        this.mCBDelocalized = this.mDialog.createCheckBox("Delocalized");
        this.mDialog.add(this.mCBDelocalized, 1, 4, 3, 4);
        this.mCBMetalLigand = this.mDialog.createCheckBox("Coordinate (0-order)");
        this.mDialog.add(this.mCBMetalLigand, 1, 5, 3, 5);
        this.mComboBoxRing = this.mDialog.createComboBox();
        this.mComboBoxRing.addItem("any ring state");
        this.mComboBoxRing.addItem("is not in a ring");
        this.mComboBoxRing.addItem("is any ring bond");
        this.mComboBoxRing.addItem("is non-aromatic ring bond");
        this.mComboBoxRing.addItem("is aromatic bond");
        this.mComboBoxRing.addEventConsumer(this);
        this.mDialog.add(this.mComboBoxRing, 1, 7, 3, 7);
        this.mComboBoxRingSize = this.mDialog.createComboBox();
        this.mComboBoxRingSize.addItem("any ring size");
        this.mComboBoxRingSize.addItem("is in 3-membered ring");
        this.mComboBoxRingSize.addItem("is in 4-membered ring");
        this.mComboBoxRingSize.addItem("is in 5-membered ring");
        this.mComboBoxRingSize.addItem("is in 6-membered ring");
        this.mComboBoxRingSize.addItem("is in 7-membered ring");
        this.mDialog.add(this.mComboBoxRingSize, 1, 9, 3, 9);
        this.mCBMatchStereo = this.mDialog.createCheckBox("Match Stereo Configuration");
        this.mCBMatchStereo.setSelected((mol.getBondQueryFeatures(bond) & 0x40000) != 0);
        this.mCBMatchStereo.addEventConsumer(this);
        this.mDialog.add(this.mCBMatchStereo, 1, 11, 3, 11);
        this.mCBIsBridge = this.mDialog.createCheckBox("Is atom bridge between");
        this.mCBIsBridge.addEventConsumer(this);
        this.mDialog.add(this.mCBIsBridge, 1, 13, 3, 13);
        this.mComboBoxMinAtoms = this.mDialog.createComboBox();
        int itemCount = 16;
        for (int i = 0; i < itemCount; ++i) {
            this.mComboBoxMinAtoms.addItem("" + i);
        }
        this.mDialog.add(this.mComboBoxMinAtoms, 2, 15);
        this.mDialog.add(this.mDialog.createLabel(" and"), 3, 15);
        this.mComboBoxMinAtoms.addEventConsumer(this);
        this.mComboBoxMaxAtoms = this.mDialog.createComboBox();
        this.populateComboBoxMaxAtoms(0);
        this.mDialog.add(this.mComboBoxMaxAtoms, 2, 17);
        this.mDialog.add(this.mDialog.createLabel(" atoms"), 3, 17);
        this.mMol.ensureHelperArrays(7);
        this.setInitialStates();
    }

    @Override
    public void eventHappened(GenericActionEvent e) {
        int minAtoms;
        if (e.getWhat() == 1) {
            this.mDialog.disposeDialog();
        } else if (e.getWhat() == 0) {
            this.setQueryFeatures();
            this.mOKSelected = true;
            this.mDialog.disposeDialog();
        } else if (e.getSource() == this.mCBIsBridge || e.getSource() == this.mComboBoxRing) {
            this.enableItems();
        } else if (e.getSource() == this.mComboBoxMinAtoms && this.mFirstSpanItem != (minAtoms = this.mComboBoxMinAtoms.getSelectedIndex())) {
            int maxAtoms = this.mFirstSpanItem + this.mComboBoxMaxAtoms.getSelectedIndex();
            int itemCount = this.populateComboBoxMaxAtoms(minAtoms);
            if (maxAtoms < minAtoms) {
                this.mComboBoxMaxAtoms.setSelectedIndex(0);
            } else if (maxAtoms < minAtoms + itemCount) {
                this.mComboBoxMaxAtoms.setSelectedIndex(maxAtoms - minAtoms);
            } else {
                this.mComboBoxMaxAtoms.setSelectedIndex(itemCount - 1);
            }
            this.mFirstSpanItem = minAtoms;
        }
    }

    private void setInitialStates() {
        int bondOrder;
        int queryFeatures = this.mMol.getBondQueryFeatures(this.mBond);
        int n = bondOrder = this.mMol.getBondType(this.mBond) == 64 || this.mMol.isDelocalizedBond(this.mBond) ? 4 : this.mMol.getBondOrder(this.mBond);
        if ((queryFeatures & 1) != 0 || bondOrder == 1) {
            this.mCBSingle.setSelected(true);
        }
        if ((queryFeatures & 2) != 0 || bondOrder == 2) {
            this.mCBDouble.setSelected(true);
        }
        if ((queryFeatures & 4) != 0 || bondOrder == 3) {
            this.mCBTriple.setSelected(true);
        }
        if ((queryFeatures & 8) != 0 || bondOrder == 4) {
            this.mCBDelocalized.setSelected(true);
        }
        if ((queryFeatures & 0x10) != 0 || bondOrder == 0) {
            this.mCBMetalLigand.setSelected(true);
        }
        if ((queryFeatures & 0x40000) != 0) {
            this.mCBMatchStereo.setSelected(true);
        }
        int ringState = queryFeatures & 0x60;
        int aromState = queryFeatures & 0x180000;
        if (ringState == 32) {
            this.mComboBoxRing.setSelectedIndex(1);
        } else if (aromState == 524288) {
            this.mComboBoxRing.setSelectedIndex(4);
        } else if (ringState == 64) {
            if (aromState == 0) {
                this.mComboBoxRing.setSelectedIndex(2);
            } else if (aromState == 0x100000) {
                this.mComboBoxRing.setSelectedIndex(3);
            } else {
                this.mComboBoxRing.setSelectedIndex(0);
            }
        } else {
            this.mComboBoxRing.setSelectedIndex(0);
        }
        int ringSize = (queryFeatures & 0x38000) >> 15;
        this.mComboBoxRingSize.setSelectedIndex(ringSize == 0 ? 0 : ringSize - 2);
        if ((queryFeatures & 0x7F80) != 0) {
            this.mCBIsBridge.setSelected(true);
            int minAtoms = (queryFeatures & 0x780) >> 7;
            int atomSpan = (queryFeatures & 0x7800) >> 11;
            this.mComboBoxMinAtoms.setSelectedIndex(minAtoms);
            this.populateComboBoxMaxAtoms(minAtoms);
            this.mComboBoxMaxAtoms.setSelectedIndex(atomSpan);
        } else {
            this.mComboBoxMaxAtoms.setSelectedIndex(0);
        }
        this.enableItems();
    }

    private int populateComboBoxMaxAtoms(int minAtoms) {
        this.mComboBoxMaxAtoms.removeAllItems();
        int itemCount = 16;
        for (int i = 0; i < itemCount; ++i) {
            this.mComboBoxMaxAtoms.addItem("" + (minAtoms + i));
        }
        return itemCount;
    }

    private void enableItems() {
        boolean bridgeIsSelected = this.mCBIsBridge.isSelected();
        this.mCBSingle.setEnabled(!bridgeIsSelected);
        this.mCBDouble.setEnabled(!bridgeIsSelected);
        this.mCBTriple.setEnabled(!bridgeIsSelected);
        this.mCBDelocalized.setEnabled(!bridgeIsSelected);
        this.mCBMetalLigand.setEnabled(!bridgeIsSelected);
        this.mCBMatchStereo.setEnabled(!bridgeIsSelected && this.mMol.getBondOrder(this.mBond) == 2 && this.mMol.getBondParity(this.mBond) != 0 && this.mMol.getBondParity(this.mBond) != 3);
        this.mComboBoxRing.setEnabled(!bridgeIsSelected);
        this.mComboBoxRingSize.setEnabled(!bridgeIsSelected && this.mComboBoxRing.getSelectedIndex() != 1);
        this.mComboBoxMinAtoms.setEnabled(bridgeIsSelected);
        this.mComboBoxMaxAtoms.setEnabled(bridgeIsSelected);
    }

    private void setQueryFeatures() {
        if (this.isSelectedBond(this.mBond)) {
            for (int bond = 0; bond < this.mMol.getAllBonds(); ++bond) {
                if (!this.isSelectedBond(bond)) continue;
                this.setQueryFeatures(bond);
            }
        } else {
            this.setQueryFeatures(this.mBond);
        }
    }

    private void setQueryFeatures(int bond) {
        int queryFeatures = 0;
        if (this.mCBIsBridge.isSelected()) {
            int minAtoms = this.mComboBoxMinAtoms.getSelectedIndex();
            int atomSpan = this.mComboBoxMaxAtoms.getSelectedIndex();
            queryFeatures |= minAtoms << 7;
            queryFeatures |= atomSpan << 11;
            queryFeatures &= 0xFFFFFFE0;
        } else {
            int implicitSize;
            int ringSize;
            int bondOrder = -1;
            if (this.mCBSingle.isSelected()) {
                this.mMol.setBondType(bond, 1);
                bondOrder = 1;
            } else if (this.mCBDelocalized.isSelected() && !this.mMol.isDelocalizedBond(bond)) {
                this.mMol.setBondType(bond, 64);
                bondOrder = 4;
            } else if (this.mCBDouble.isSelected()) {
                this.mMol.setBondType(bond, 2);
                bondOrder = 2;
            } else if (this.mCBTriple.isSelected()) {
                this.mMol.setBondType(bond, 4);
                bondOrder = 3;
            } else if (this.mCBMetalLigand.isSelected()) {
                this.mMol.setBondType(bond, 32);
                bondOrder = 0;
            }
            if (this.mCBSingle.isSelected() && bondOrder != 1) {
                queryFeatures |= 1;
            }
            if (this.mCBDouble.isSelected() && bondOrder != 2) {
                queryFeatures |= 2;
            }
            if (this.mCBTriple.isSelected() && bondOrder != 3) {
                queryFeatures |= 4;
            }
            if (this.mCBDelocalized.isSelected() && bondOrder != 4) {
                queryFeatures |= 8;
            }
            if (this.mCBMetalLigand.isSelected() && bondOrder != 0) {
                queryFeatures |= 0x10;
            }
            if (this.mCBMatchStereo.isSelected()) {
                queryFeatures |= 0x40000;
            }
            if (this.mComboBoxRing.getSelectedIndex() != 0) {
                if (this.mComboBoxRing.getSelectedIndex() == 1) {
                    if (!this.mMol.isRingBond(bond)) {
                        queryFeatures |= 0x20;
                    }
                } else if (this.mComboBoxRing.getSelectedIndex() == 2) {
                    if (!this.mMol.isRingBond(bond)) {
                        queryFeatures |= 0x40;
                    }
                } else if (this.mComboBoxRing.getSelectedIndex() == 3) {
                    if (!this.mMol.isAromaticBond(bond)) {
                        queryFeatures |= 0x100040;
                    }
                } else if (this.mComboBoxRing.getSelectedIndex() == 4 && !this.mMol.isAromaticBond(bond)) {
                    queryFeatures |= 0x80000;
                }
            }
            if (this.mComboBoxRingSize.getSelectedIndex() != 0 && (ringSize = this.mComboBoxRingSize.getSelectedIndex() + 2) != (implicitSize = this.mMol.getBondRingSize(bond))) {
                queryFeatures |= ringSize << 15;
            }
        }
        this.mMol.setBondQueryFeature(bond, 0x1FFFFF, false);
        this.mMol.setBondQueryFeature(bond, queryFeatures, true);
    }

    private boolean isSelectedBond(int bond) {
        return this.mMol.isSelectedAtom(this.mMol.getBondAtom(0, bond)) && this.mMol.isSelectedAtom(this.mMol.getBondAtom(1, bond));
    }
}

