/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.gui.editor;

import com.actelion.research.chem.Molecule;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.gui.editor.GenericEditorArea;
import com.actelion.research.gui.generic.GenericActionEvent;
import com.actelion.research.gui.generic.GenericComboBox;
import com.actelion.research.gui.generic.GenericDialog;
import com.actelion.research.gui.generic.GenericEventListener;
import com.actelion.research.gui.generic.GenericTextField;
import com.actelion.research.gui.generic.GenericUIHelper;
import javax.swing.JTextField;

public class CustomAtomDialogBuilder
implements GenericEventListener<GenericActionEvent> {
    private static final String[] RADICAL_STATES = new String[]{"None", "One electron (duplet)", "Two electrons (triplet)", "Two electrons (singulet)"};
    private GenericEditorArea mEditorArea;
    private GenericDialog mDialog;
    private StereoMolecule mMol;
    private int mAtom;
    private int mOldAtomicNo;
    private int mOldAtomMass;
    private int mOldAtomValence;
    private int mOldAtomRadical;
    private String mOldCustomLabel;
    private GenericTextField mTextFieldLabel;
    private GenericTextField mTextFieldMass;
    private GenericTextField mTextFieldValence;
    private GenericComboBox mComboBoxRadical;
    private boolean mOKSelected;

    public CustomAtomDialogBuilder(GenericUIHelper dialogHelper, GenericEditorArea editorArea, int atomicNo, int mass, int valence, int radical, String label) {
        this.mDialog = dialogHelper.createDialog("Atom Properties", this);
        this.mEditorArea = editorArea;
        this.mAtom = -1;
        this.mOldAtomicNo = atomicNo;
        this.mOldAtomMass = mass;
        this.mOldAtomValence = valence;
        this.mOldAtomRadical = radical;
        this.mOldCustomLabel = label;
        this.build();
    }

    public CustomAtomDialogBuilder(GenericUIHelper dialogHelper, GenericEditorArea editorArea, StereoMolecule mol, int atom) {
        this.mDialog = dialogHelper.createDialog("Atom Properties", this);
        this.mEditorArea = editorArea;
        this.mMol = mol;
        this.mAtom = atom;
        this.mOldAtomicNo = this.mMol.getAtomicNo(atom);
        this.mOldAtomMass = this.mMol.getAtomMass(atom);
        this.mOldAtomValence = this.mMol.getAtomAbnormalValence(atom);
        this.mOldAtomRadical = this.mMol.getAtomRadical(atom);
        this.mOldCustomLabel = this.mMol.getAtomCustomLabel(atom);
        this.build();
    }

    public boolean showDialog() {
        this.mOKSelected = false;
        this.mDialog.showDialog();
        return this.mOKSelected;
    }

    private void build() {
        int state;
        String[] label;
        int[] hLayout = new int[]{8, -2, 8, -2, 8};
        int[] vLayout = new int[]{8, -2, 4, -2, 12, -2, 4, -2, 12, -2, 4, -2, 12, -2, 8};
        this.mDialog.setLayout(hLayout, vLayout);
        this.mTextFieldLabel = this.mDialog.createTextField(1, 1);
        this.mTextFieldLabel.addEventConsumer(this);
        this.mDialog.add(this.mDialog.createLabel("Atom Label:"), 1, 1);
        this.mDialog.add(this.mTextFieldLabel, 3, 1);
        this.mDialog.add(this.mDialog.createLabel("(examples: 'D', 'Li', 'Cys', 'R12', 'R3@C')"), 1, 3, 3, 3);
        this.mTextFieldMass = this.mDialog.createTextField(1, 1);
        this.mTextFieldMass.addEventConsumer(this);
        this.mDialog.add(this.mDialog.createLabel("Atom Mass:"), 1, 5);
        this.mDialog.add(this.mTextFieldMass, 3, 5);
        this.mDialog.add(this.mDialog.createLabel("(empty for natural abundance)"), 1, 7, 3, 7);
        this.mTextFieldValence = this.mDialog.createTextField(1, 1);
        this.mTextFieldValence.addEventConsumer(this);
        this.mDialog.add(this.mDialog.createLabel("Abnormal Valence:"), 1, 9);
        this.mDialog.add(this.mTextFieldValence, 3, 9);
        this.mDialog.add(this.mDialog.createLabel("(empty for default valence)"), 1, 11, 3, 11);
        if (this.mAtom == -1) {
            label = Molecule.cAtomLabel[this.mOldAtomicNo];
            this.mTextFieldLabel.setText((String)(this.mOldCustomLabel == null ? label : this.mOldCustomLabel + "@" + (String)label));
            if (this.mOldAtomMass != 0) {
                this.mTextFieldMass.setText("" + this.mOldAtomMass);
            }
            if (this.mOldAtomValence != -1) {
                this.mTextFieldValence.setText("" + this.mOldAtomValence);
            }
        } else {
            label = this.mMol.getAtomLabel(this.mAtom);
            String customLabel = this.mMol.getAtomCustomLabel(this.mAtom);
            this.mTextFieldLabel.setText((String)(customLabel == null ? label : customLabel + "@" + (String)label));
            if (this.mMol.getAtomMass(this.mAtom) != 0) {
                this.mTextFieldMass.setText("" + this.mMol.getAtomMass(this.mAtom));
            }
            if (this.mMol.getAtomAbnormalValence(this.mAtom) != -1) {
                this.mTextFieldValence.setText("" + this.mMol.getAtomAbnormalValence(this.mAtom));
            }
        }
        this.mComboBoxRadical = this.mDialog.createComboBox();
        for (String s : RADICAL_STATES) {
            this.mComboBoxRadical.addItem(s);
        }
        int n = state = this.mAtom == -1 ? this.mOldAtomRadical : this.mMol.getAtomRadical(this.mAtom);
        this.mComboBoxRadical.setSelectedIndex(state == 32 ? 1 : (state == 48 ? 2 : (state == 16 ? 3 : 0)));
        this.mDialog.add(this.mDialog.createLabel("Radical State:"), 1, 13);
        this.mDialog.add(this.mComboBoxRadical, 3, 13);
    }

    @Override
    public void eventHappened(GenericActionEvent e) {
        if (e.getSource() instanceof JTextField) {
            this.processAtomLabel(false);
        } else if (e.getWhat() == 1) {
            if (this.mAtom != -1) {
                this.mMol.setAtomicNo(this.mAtom, this.mOldAtomicNo);
                this.mMol.setAtomMass(this.mAtom, this.mOldAtomMass);
                this.mMol.setAtomAbnormalValence(this.mAtom, this.mOldAtomValence);
                this.mMol.setAtomRadical(this.mAtom, this.mOldAtomRadical);
                this.mMol.setAtomCustomLabel(this.mAtom, this.mOldCustomLabel);
            }
            this.mDialog.disposeDialog();
        } else if (e.getWhat() == 0) {
            this.processAtomLabel(true);
            this.mDialog.disposeDialog();
        }
    }

    private void processAtomLabel(boolean updateDefault) {
        int atomicNo;
        int index;
        String text = this.mTextFieldLabel.getText();
        String customLabel = null;
        if (text.length() != 0 && (index = text.indexOf(64)) != -1) {
            customLabel = text.substring(0, index);
            text = text.substring(index + 1);
        }
        if (text.length() != 0 && ((atomicNo = Molecule.getAtomicNoFromLabel(text)) != 0 || text.equals("?"))) {
            int radical;
            int mass = 0;
            if (this.mTextFieldMass.getText().length() != 0) {
                try {
                    mass = Integer.parseInt(this.mTextFieldMass.getText());
                    if (mass < Molecule.cRoundedMass[atomicNo] - 18 || mass > Molecule.cRoundedMass[atomicNo] + 12) {
                        this.mDialog.showMessage("Your mass is out of range!");
                        return;
                    }
                }
                catch (NumberFormatException nfe) {
                    this.mDialog.showMessage("Your mass is not a number!");
                    return;
                }
            }
            int valence = -1;
            if (this.mTextFieldValence.getText().length() != 0) {
                try {
                    valence = Integer.parseInt(this.mTextFieldValence.getText());
                    if (valence < 0 || valence > 15) {
                        this.mDialog.showMessage("Your valence is out of range!");
                        return;
                    }
                }
                catch (NumberFormatException nfe) {
                    this.mDialog.showMessage("Your valence is not a number!");
                    return;
                }
            }
            int n = this.mComboBoxRadical.getSelectedIndex() == 1 ? 32 : (this.mComboBoxRadical.getSelectedIndex() == 2 ? 48 : (radical = this.mComboBoxRadical.getSelectedIndex() == 3 ? 16 : 0));
            if (updateDefault) {
                this.mEditorArea.setCustomAtom(atomicNo, mass, valence, radical, customLabel);
            }
            if (this.mAtom != -1) {
                this.mMol.changeAtom(this.mAtom, atomicNo, mass, valence, radical);
                this.mMol.setAtomCustomLabel(this.mAtom, customLabel);
            }
            this.mOKSelected = true;
            this.mDialog.disposeDialog();
        }
    }
}

