/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.gui.editor;

import com.actelion.research.chem.AbstractDrawingObject;
import com.actelion.research.chem.DepictorTransformation;
import com.actelion.research.chem.DrawingObjectList;
import com.actelion.research.chem.ExtendedDepictor;
import com.actelion.research.chem.MarkushStructure;
import com.actelion.research.chem.Molecule;
import com.actelion.research.chem.NamedSubstituents;
import com.actelion.research.chem.SSSearcher;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.TextDrawingObject;
import com.actelion.research.chem.coords.CoordinateInventor;
import com.actelion.research.chem.io.RDFileParser;
import com.actelion.research.chem.io.RXNFileParser;
import com.actelion.research.chem.name.StructureNameResolver;
import com.actelion.research.chem.reaction.IReactionMapper;
import com.actelion.research.chem.reaction.MCSReactionMapper;
import com.actelion.research.chem.reaction.Reaction;
import com.actelion.research.chem.reaction.ReactionArrow;
import com.actelion.research.gui.FileHelper;
import com.actelion.research.gui.LookAndFeelHelper;
import com.actelion.research.gui.clipboard.IClipboardHandler;
import com.actelion.research.gui.editor.AtomQueryFeatureDialogBuilder;
import com.actelion.research.gui.editor.BondQueryFeatureDialogBuilder;
import com.actelion.research.gui.editor.CustomAtomDialogBuilder;
import com.actelion.research.gui.editor.EditorEvent;
import com.actelion.research.gui.editor.TextDrawingObjectDialogBuilder;
import com.actelion.research.gui.generic.GenericActionEvent;
import com.actelion.research.gui.generic.GenericCanvas;
import com.actelion.research.gui.generic.GenericDepictor;
import com.actelion.research.gui.generic.GenericDrawContext;
import com.actelion.research.gui.generic.GenericEvent;
import com.actelion.research.gui.generic.GenericEventListener;
import com.actelion.research.gui.generic.GenericKeyEvent;
import com.actelion.research.gui.generic.GenericMouseEvent;
import com.actelion.research.gui.generic.GenericPoint;
import com.actelion.research.gui.generic.GenericPolygon;
import com.actelion.research.gui.generic.GenericPopupMenu;
import com.actelion.research.gui.generic.GenericRectangle;
import com.actelion.research.gui.generic.GenericShape;
import com.actelion.research.gui.generic.GenericUIHelper;
import com.actelion.research.gui.hidpi.HiDPIHelper;
import com.actelion.research.util.ColorHelper;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.TreeMap;

public class GenericEditorArea
implements GenericEventListener {
    public static final int MODE_MULTIPLE_FRAGMENTS = 1;
    public static final int MODE_MARKUSH_STRUCTURE = 2;
    public static final int MODE_REACTION = 4;
    public static final int MODE_DRAWING_OBJECTS = 8;
    private static final int MAX_CONNATOMS = 8;
    private static final int MIN_BOND_LENGTH_SQUARE = 100;
    private static final int KEY_IS_ATOM_LABEL = 1;
    private static final int KEY_IS_SUBSTITUENT = 2;
    private static final int KEY_IS_VALID_START = 3;
    private static final int KEY_IS_INVALID = 4;
    private static final int RGB_BLUE = -16776961;
    private static final int RGB_RED = -65536;
    private static final int RGB_DARK_RED = -8388608;
    private static final int RGB_BLACK = -16777216;
    private static final int RGB_GRAY = -8355712;
    private static final String ITEM_COPY_STRUCTURE = "Copy Structure";
    private static final String ITEM_COPY_REACTION = "Copy Reaction";
    private static final String ITEM_PASTE_STRUCTURE = "Paste Structure";
    private static final String ITEM_PASTE_REACTION = "Paste Reaction";
    private static final String ITEM_PASTE_WITH_NAME = "Paste Structure or Name";
    private static final String ITEM_LOAD_REACTION = "Open Reaction File...";
    private static final String ITEM_ADD_AUTO_MAPPING = "Auto-Map Reaction";
    private static final String ITEM_REMOVE_MAPPING = "Remove Manual Atom Mapping";
    private static final String ITEM_FLIP_HORIZONTALLY = "Flip Horizontally";
    private static final String ITEM_FLIP_VERTICALLY = "Flip Vertically";
    private static final String ITEM_FLIP_ROTATE180 = "Rotate 180\u00b0";
    private static final String ITEM_SHOW_ATOM_BOND_NUMBERS = "Show Atom & Bond Numbers";
    private static final String ITEM_SHOW_SYMMETRY = "Show Symmetry";
    private static final String ITEM_SHOW_NORMAL = "Show Normal";
    private static final long WARNING_MILLIS = 1200L;
    private static final float FRAGMENT_MAX_CLICK_DISTANCE = 24.0f;
    private static final float FRAGMENT_GROUPING_DISTANCE = 1.4f;
    private static final float FRAGMENT_CLEANUP_DISTANCE = 1.5f;
    private static final float DEFAULT_ARROW_LENGTH = 0.08f;
    protected static final int UPDATE_NONE = 0;
    protected static final int UPDATE_REDRAW = 1;
    protected static final int UPDATE_CHECK_VIEW = 2;
    protected static final int UPDATE_CHECK_COORDS = 3;
    protected static final int UPDATE_SCALE_COORDS = 4;
    protected static final int UPDATE_SCALE_COORDS_USE_FRAGMENTS = 5;
    protected static final int UPDATE_INVENT_COORDS = 6;
    private static final int DEFAULT_SELECTION_BACKGROUND = -8346432;
    private static final int cRequestNone = 0;
    private static final int cRequestNewBond = 1;
    private static final int cRequestNewChain = 2;
    private static final int cRequestMoveSingle = 3;
    private static final int cRequestMoveSelected = 4;
    private static final int cRequestLassoSelect = 5;
    private static final int cRequestSelectRect = 6;
    private static final int cRequestZoomAndRotate = 7;
    private static final int cRequestMapAtoms = 8;
    private static final int cRequestCopySelected = 9;
    private static final int cRequestMoveObject = 10;
    private static final int cRequestCopyObject = 11;
    private static IReactionMapper sMapper;
    private int mMode;
    private int mChainAtoms;
    private int mCurrentTool;
    private int mCustomAtomicNo;
    private int mCustomAtomMass;
    private int mCustomAtomValence;
    private int mCustomAtomRadical;
    private int mCurrentHiliteAtom;
    private int mCurrentHiliteBond;
    private int mPendingRequest;
    private int mEventsScheduled;
    private int mCurrentCursor;
    private int mReactantCount;
    private int mUpdateMode;
    private int mDisplayMode;
    private int mAtom1;
    private int mAtom2;
    private int[] mChainAtom;
    private int[] mFragmentNo;
    private int[] mHiliteBondSet;
    private double mX1;
    private double mY1;
    private double mX2;
    private double mY2;
    private double mWidth;
    private double mHeight;
    private double[] mX;
    private double[] mY;
    private double[] mChainAtomX;
    private double[] mChainAtomY;
    private boolean mAltIsDown;
    private boolean mShiftIsDown;
    private boolean mMouseIsDown;
    private boolean mIsAddingToSelection;
    private boolean mAtomColorSupported;
    private boolean mAllowQueryFeatures;
    private boolean[] mIsSelectedAtom;
    private boolean[] mIsSelectedObject;
    private String mCustomAtomLabel;
    private String mWarningMessage;
    private String mAtomKeyStrokeSuggestion;
    private String[] mAtomText;
    private ExtendedDepictor mDepictor;
    private StereoMolecule mMol;
    private Molecule mUndoMol;
    private StereoMolecule[] mFragment;
    private DrawingObjectList mDrawingObjectList;
    private DrawingObjectList mUndoDrawingObjectList;
    private AbstractDrawingObject mCurrentHiliteObject;
    private GenericPolygon mLassoRegion;
    private ArrayList<GenericEventListener> mListeners;
    private IClipboardHandler mClipboardHandler;
    private StringBuilder mAtomKeyStrokeBuffer;
    private GenericUIHelper mUIHelper;
    private GenericCanvas mCanvas;

    public GenericEditorArea(StereoMolecule mol, int mode, GenericUIHelper helper, GenericCanvas canvas) {
        this.mMol = mol;
        this.mMode = mode;
        this.mUIHelper = helper;
        this.mCanvas = canvas;
        this.mListeners = new ArrayList();
        this.mCurrentTool = 5;
        this.mCurrentHiliteAtom = -1;
        this.mCurrentHiliteBond = -1;
        this.mCurrentHiliteObject = null;
        this.mAtom1 = -1;
        this.mCustomAtomicNo = 6;
        this.mCustomAtomMass = 0;
        this.mCustomAtomValence = -1;
        this.mCustomAtomRadical = 0;
        this.mCustomAtomLabel = null;
        this.mAllowQueryFeatures = true;
        this.mPendingRequest = 0;
        this.mCurrentCursor = 11;
        this.mAtomKeyStrokeBuffer = new StringBuilder();
        if ((this.mMode & 6) != 0) {
            this.mMode |= 1;
        }
        if ((this.mMode & 0xC) != 0) {
            this.mDrawingObjectList = new DrawingObjectList();
        }
        this.mUpdateMode = 4;
    }

    public GenericUIHelper getUIHelper() {
        return this.mUIHelper;
    }

    public void setClipboardHandler(IClipboardHandler h) {
        this.mClipboardHandler = h;
    }

    private void update(int mode) {
        this.mUpdateMode = Math.max(this.mUpdateMode, mode);
        this.mCanvas.repaint();
    }

    public static void setReactionMapper(IReactionMapper mapper) {
        sMapper = mapper;
    }

    public void paintContent(GenericDrawContext context) {
        if (this.mWidth != this.mCanvas.getCanvasWidth() || this.mHeight != this.mCanvas.getCanvasHeight()) {
            this.mWidth = this.mCanvas.getCanvasWidth();
            this.mHeight = this.mCanvas.getCanvasHeight();
            if (this.mUpdateMode < 3) {
                this.mUpdateMode = 3;
            }
        }
        int background = context.getBackgroundRGB();
        int foreground = context.getForegroundRGB();
        context.setRGB(background);
        context.fillRectangle(0.0, 0.0, this.mWidth, this.mHeight);
        if ((this.mMode & 4) != 0 && this.mDrawingObjectList.size() == 0) {
            float mx = 0.5f * (float)this.mWidth;
            float my = 0.5f * (float)this.mHeight;
            float dx = 0.04f * (float)this.mWidth;
            ReactionArrow arrow = new ReactionArrow();
            arrow.setCoordinates(mx - dx, my, mx + dx, my);
            arrow.setDeletable(false);
            this.mDrawingObjectList.add(arrow);
        }
        boolean isScaledView = false;
        if (this.mUpdateMode != 0) {
            if ((this.mMode & 1) != 0 && this.mUpdateMode != 5) {
                this.analyzeFragmentMembership();
            }
            this.mDepictor = (this.mMode & 4) != 0 ? new ExtendedDepictor(new Reaction(this.mFragment, this.mReactantCount), this.mDrawingObjectList, false) : ((this.mMode & 2) != 0 ? new ExtendedDepictor(this.mFragment, this.mReactantCount, this.mDrawingObjectList) : ((this.mMode & 1) != 0 ? new ExtendedDepictor(this.mFragment, this.mDrawingObjectList) : new ExtendedDepictor(this.mMol, this.mDrawingObjectList)));
            this.mDepictor.setForegroundColor(foreground, background);
            this.mDepictor.setFragmentNoColor((this.mMode & 1) == 0 ? 0 : (LookAndFeelHelper.isDarkLookAndFeel() ? ColorHelper.brighter(background, 0.85f) : ColorHelper.darker(background, 0.85f)));
            this.mDepictor.setDisplayMode(this.mDisplayMode | 8 | (this.mCurrentTool == 19 ? 80 : 0));
            if ((this.mMode & 7) == 0) {
                this.mDepictor.getMoleculeDepictor(0).setAtomText(this.mAtomText);
            }
            switch (this.mUpdateMode) {
                case 4: 
                case 5: 
                case 6: {
                    this.cleanupCoordinates(context);
                    break;
                }
                case 3: {
                    DepictorTransformation t1 = this.mDepictor.updateCoords(context, new GenericRectangle(0.0, 0.0, this.mWidth, this.mHeight), 0);
                    if (t1 == null || (this.mMode & 1) == 0) break;
                    t1.applyTo(this.mMol);
                    break;
                }
                case 2: {
                    DepictorTransformation t2 = this.mDepictor.validateView(context, new GenericRectangle(0.0, 0.0, this.mWidth, this.mHeight), 0);
                    isScaledView = t2 != null && !t2.isVoidTransformation();
                }
            }
            this.mUpdateMode = 0;
        }
        if (this.mDepictor != null) {
            this.mDepictor.paintFragmentNumbers(context);
        }
        if (!isScaledView) {
            this.drawHiliting(context);
        }
        if (this.mDepictor != null) {
            this.mDepictor.paintStructures(context);
            this.mDepictor.paintDrawingObjects(context);
        }
        if (this.mCurrentHiliteAtom != -1 && this.mAtomKeyStrokeBuffer.length() != 0) {
            int x = (int)this.mMol.getAtomX(this.mCurrentHiliteAtom);
            int y = (int)this.mMol.getAtomY(this.mCurrentHiliteAtom);
            String s = this.mAtomKeyStrokeBuffer.toString();
            int validity = this.getAtomKeyStrokeValidity(s);
            context.setRGB(validity == 1 ? foreground : (validity == 2 ? -16776961 : -8355712));
            if (validity == 1) {
                s = Molecule.cAtomLabel[Molecule.getAtomicNoFromLabel(s)];
            } else if (validity == 2) {
                s = this.mAtomKeyStrokeSuggestion.substring(0, s.length());
            }
            int fontSize = 3 * context.getFontSize() / 2;
            context.setFont(fontSize, false, false);
            context.drawString(x, y, s);
            if (validity == 4) {
                context.setRGB(-65536);
                context.drawCenteredString((double)x + context.getBounds(s).getWidth() / 2.0, y + fontSize, "<unknown>");
            }
            if (validity == 2) {
                context.setRGB(-8355712);
                context.drawString((double)x + context.getBounds(s).getWidth(), y, this.mAtomKeyStrokeSuggestion.substring(s.length()));
            }
        }
        context.setRGB(foreground);
        switch (this.mPendingRequest) {
            case 1: {
                int y2;
                int x2;
                int x1 = (int)this.mX1;
                int y1 = (int)this.mY1;
                if (this.mCurrentHiliteAtom == -1 || this.mCurrentHiliteAtom == this.mAtom1) {
                    x2 = (int)this.mX2;
                    y2 = (int)this.mY2;
                } else {
                    x2 = (int)this.mMol.getAtomX(this.mCurrentHiliteAtom);
                    y2 = (int)this.mMol.getAtomY(this.mCurrentHiliteAtom);
                }
                switch (this.mCurrentTool) {
                    case 5: {
                        context.drawLine(x1, y1, x2, y2);
                        break;
                    }
                    case 6: {
                        int xdiff = (y1 - y2) / 9;
                        int ydiff = (x2 - x1) / 9;
                        GenericPolygon p = new GenericPolygon(3);
                        p.addPoint(x1, y1);
                        p.addPoint(x2 + xdiff, y2 + ydiff);
                        p.addPoint(x2 - xdiff, y2 - ydiff);
                        context.fillPolygon(p);
                        break;
                    }
                    case 23: {
                        int xdiff = x2 - x1;
                        int ydiff = y2 - y1;
                        for (int i = 2; i < 17; i += 2) {
                            int xx1 = x1 + i * xdiff / 17 - i * ydiff / 128;
                            int yy1 = y1 + i * ydiff / 17 + i * xdiff / 128;
                            int xx2 = x1 + i * xdiff / 17 + i * ydiff / 128;
                            int yy2 = y1 + i * ydiff / 17 - i * xdiff / 128;
                            context.drawLine(xx1, yy1, xx2, yy2);
                        }
                        break;
                    }
                }
                break;
            }
            case 2: {
                if (this.mChainAtoms > 0) {
                    context.drawLine((int)this.mX1, (int)this.mY1, (int)this.mChainAtomX[0], (int)this.mChainAtomY[0]);
                }
                if (this.mChainAtoms <= 1) break;
                for (int i = 1; i < this.mChainAtoms; ++i) {
                    context.drawLine((int)this.mChainAtomX[i - 1], (int)this.mChainAtomY[i - 1], (int)this.mChainAtomX[i], (int)this.mChainAtomY[i]);
                }
                break;
            }
            case 5: {
                context.setRGB(GenericEditorArea.lassoColor(context));
                context.drawPolygon(this.mLassoRegion);
                context.setRGB(foreground);
                break;
            }
            case 6: {
                int x = this.mX1 < this.mX2 ? (int)this.mX1 : (int)this.mX2;
                int y = this.mY1 < this.mY2 ? (int)this.mY1 : (int)this.mY2;
                int w = (int)Math.abs(this.mX2 - this.mX1);
                int h = (int)Math.abs(this.mY2 - this.mY1);
                context.setRGB(GenericEditorArea.lassoColor(context));
                context.drawRectangle(x, y, w, h);
                context.setRGB(foreground);
                break;
            }
            case 8: {
                int x2;
                int y2;
                int x1 = (int)this.mX1;
                int y1 = (int)this.mY1;
                if (this.mCurrentHiliteAtom == -1 || this.mCurrentHiliteAtom == this.mAtom1) {
                    x2 = (int)this.mX2;
                    y2 = (int)this.mY2;
                } else {
                    x2 = (int)this.mMol.getAtomX(this.mCurrentHiliteAtom);
                    y2 = (int)this.mMol.getAtomY(this.mCurrentHiliteAtom);
                }
                context.setRGB(GenericEditorArea.mapToolColor(context));
                context.drawLine(x1, y1, x2, y2);
                context.setRGB(foreground);
            }
        }
        if (this.mWarningMessage != null) {
            context.setFont(12, true, false);
            int saveRGB = context.getRGB();
            context.setRGB(-65536);
            context.drawCenteredString(this.mWidth / 2.0, context.getFontSize(), this.mWarningMessage);
            context.setRGB(saveRGB);
        }
    }

    public static int lassoColor(GenericDrawContext context) {
        int selectionColor = GenericEditorArea.selectionColor(context);
        return ColorHelper.createColor(selectionColor, LookAndFeelHelper.isDarkLookAndFeel() ? 0.65f : 0.35f);
    }

    public static int selectionColor(GenericDrawContext context) {
        int selectionColor = context.getSelectionBackgroundRGB();
        return selectionColor != 0 ? selectionColor : -8346432;
    }

    public static int mapToolColor(GenericDrawContext context) {
        int background = context.getBackgroundRGB();
        return ColorHelper.getContrastColor(-8388608, background);
    }

    public static int chainHiliteColor(GenericDrawContext context) {
        int background = context.getBackgroundRGB();
        int selectionColor = GenericEditorArea.selectionColor(context);
        return ColorHelper.intermediateColor(selectionColor, background, 0.5f);
    }

    private void drawHiliting(GenericDrawContext context) {
        if (this.mHiliteBondSet != null) {
            context.setRGB(GenericEditorArea.chainHiliteColor(context));
            for (int i = 0; i < this.mHiliteBondSet.length; ++i) {
                this.hiliteBond(context, this.mHiliteBondSet[i]);
            }
        }
        if (this.mCurrentHiliteAtom != -1) {
            int mapNo;
            context.setRGB(GenericEditorArea.selectionColor(context));
            this.hiliteAtom(context, this.mCurrentHiliteAtom);
            if (this.mCurrentTool == 19 && (mapNo = this.mMol.getAtomMapNo(this.mCurrentHiliteAtom)) != 0) {
                for (int atom = 0; atom < this.mMol.getAtoms(); ++atom) {
                    if (atom == this.mCurrentHiliteAtom || this.mMol.getAtomMapNo(atom) != mapNo) continue;
                    this.hiliteAtom(context, atom);
                }
            }
        }
        if (this.mCurrentHiliteBond != -1) {
            context.setRGB(GenericEditorArea.selectionColor(context));
            this.hiliteBond(context, this.mCurrentHiliteBond);
        }
        if (this.mCurrentHiliteObject != null) {
            this.mCurrentHiliteObject.hilite(context);
        }
    }

    private void hiliteAtom(GenericDrawContext context, int atom) {
        int radius = (int)((double)0.32f * this.mMol.getAverageBondLength());
        int x = (int)this.mMol.getAtomX(atom);
        int y = (int)this.mMol.getAtomY(atom);
        context.fillCircle(x - radius, y - radius, 2 * radius);
    }

    private void hiliteBond(GenericDrawContext context, int bond) {
        int width = (int)((double)0.32f * this.mMol.getAverageBondLength());
        int x1 = (int)this.mMol.getAtomX(this.mMol.getBondAtom(0, bond));
        int y1 = (int)this.mMol.getAtomY(this.mMol.getBondAtom(0, bond));
        int x2 = (int)this.mMol.getAtomX(this.mMol.getBondAtom(1, bond));
        int y2 = (int)this.mMol.getAtomY(this.mMol.getBondAtom(1, bond));
        float oldWidth = context.getLineWidth();
        context.setLineWidth(width);
        context.drawLine(x1, y1, x2, y2);
        context.setLineWidth(oldWidth);
    }

    public void addDrawAreaListener(GenericEventListener<EditorEvent> l) {
        this.mListeners.add(l);
    }

    protected void buttonPressed(int button) {
        switch (button) {
            case 0: {
                this.clearAll();
                return;
            }
            case 1: {
                this.storeState();
                this.updateAndFireEvent(6);
                return;
            }
            case 17: {
                this.restoreState();
                this.updateAndFireEvent(2);
                return;
            }
        }
    }

    public void clearAll() {
        if (this.mDrawingObjectList != null) {
            this.mDrawingObjectList.clear();
            this.update(1);
        }
        this.storeState();
        boolean isFragment = this.mMol.isFragment();
        this.mMol.clear();
        this.mMol.setFragment(isFragment);
        if (this.mUndoMol.getAllAtoms() != 0) {
            this.updateAndFireEvent(1);
        } else {
            this.update(1);
        }
    }

    public void toolChanged(int newTool) {
        if (this.mCurrentTool != newTool) {
            if (this.mCurrentTool == 19 || newTool == 19) {
                this.update(1);
            }
            this.mCurrentTool = newTool;
        }
    }

    public void setCustomAtom(int atomicNo, int mass, int valence, int radical, String customLabel) {
        this.mCustomAtomicNo = atomicNo;
        this.mCustomAtomMass = mass;
        this.mCustomAtomValence = valence;
        this.mCustomAtomRadical = radical;
        this.mCustomAtomLabel = customLabel;
    }

    public void eventHappened(GenericEvent e) {
        if (e instanceof GenericActionEvent) {
            this.eventHappened((GenericActionEvent)e);
        } else if (e instanceof GenericKeyEvent) {
            this.eventHappened((GenericKeyEvent)e);
        } else if (e instanceof GenericMouseEvent) {
            this.eventHappened((GenericMouseEvent)e);
        }
    }

    private void eventHappened(GenericActionEvent e) {
        String command = e.getMessage();
        if (command.equals(ITEM_COPY_STRUCTURE) || command.equals(ITEM_COPY_REACTION)) {
            this.copy();
        } else if (command.equals(ITEM_PASTE_REACTION)) {
            this.pasteReaction();
        } else if (command.startsWith(ITEM_PASTE_STRUCTURE)) {
            this.pasteMolecule();
        } else if (command.equals(ITEM_LOAD_REACTION)) {
            this.openReaction();
        } else if (command.equals(ITEM_ADD_AUTO_MAPPING)) {
            this.autoMapReaction();
            this.updateAndFireEvent(Math.max(this.mUpdateMode, 1));
        } else if (command.equals(ITEM_REMOVE_MAPPING)) {
            this.removeManualMapping();
        } else if (command.equals(ITEM_FLIP_HORIZONTALLY)) {
            this.flip(true);
        } else if (command.equals(ITEM_FLIP_VERTICALLY)) {
            this.flip(false);
        } else if (command.equals(ITEM_FLIP_ROTATE180)) {
            this.rotate180();
        } else if (command.startsWith("atomColor")) {
            int index = command.indexOf(58);
            int atom = Integer.parseInt(command.substring(9, index));
            int color = Integer.parseInt(command.substring(index + 1));
            if (this.mMol.isSelectedAtom(atom)) {
                for (int i = 0; i < this.mMol.getAtoms(); ++i) {
                    if (!this.mMol.isSelectedAtom(i)) continue;
                    this.mMol.setAtomColor(i, color);
                }
            } else {
                this.mMol.setAtomColor(atom, color);
            }
        } else if (command.equals(ITEM_SHOW_ATOM_BOND_NUMBERS)) {
            this.setDisplayMode(6);
        } else if (command.equals(ITEM_SHOW_SYMMETRY)) {
            this.setDisplayMode(256);
        } else if (command.equals(ITEM_SHOW_NORMAL)) {
            this.setDisplayMode(this.mCurrentTool == 19 ? 16 : 0);
        }
    }

    private void removeManualMapping() {
        boolean changed = false;
        for (int atom = 0; atom < this.mMol.getAtoms(); ++atom) {
            if (this.mMol.getAtomMapNo(atom) == 0 || this.mMol.isAutoMappedAtom(atom)) continue;
            if (!changed) {
                this.storeState();
                changed = true;
            }
            this.mMol.setAtomMapNo(atom, 0, false);
        }
        if (changed) {
            this.autoMapReaction();
            this.updateAndFireEvent(Math.max(this.mUpdateMode, 1));
        }
    }

    private boolean analyseCopy(boolean doCopy) {
        boolean isReaction = (this.mMode & 4) != 0;
        boolean selectionFound = false;
        boolean isBothSideSelection = false;
        boolean isOnProductSide = false;
        ReactionArrow arrow = null;
        for (int atom = 0; atom < this.mMol.getAllAtoms(); ++atom) {
            if (!this.mMol.isSelectedAtom(atom)) continue;
            if (!selectionFound) {
                selectionFound = true;
                if (!isReaction) break;
                arrow = (ReactionArrow)this.mDrawingObjectList.get(0);
                isOnProductSide = arrow.isOnProductSide(this.mMol.getAtomX(atom), this.mMol.getAtomY(atom));
                continue;
            }
            if (isOnProductSide == arrow.isOnProductSide(this.mMol.getAtomX(atom), this.mMol.getAtomY(atom))) continue;
            isBothSideSelection = true;
            break;
        }
        if (!doCopy) {
            return isReaction && (isBothSideSelection || !selectionFound);
        }
        if (isReaction) {
            if (isBothSideSelection) {
                this.copyReaction(true);
                return true;
            }
            if (selectionFound) {
                this.copyMolecule(true);
                return false;
            }
            this.copyReaction(false);
            return true;
        }
        this.copyMolecule(selectionFound);
        return false;
    }

    private void copy() {
        this.analyseCopy(true);
    }

    private boolean copyReaction(boolean selectionOnly) {
        Reaction rxn;
        Reaction reaction = rxn = selectionOnly ? this.getSelectedReaction() : this.getReaction();
        if (rxn != null && this.mClipboardHandler != null) {
            return this.mClipboardHandler.copyReaction(rxn);
        }
        return false;
    }

    private Reaction getSelectedReaction() {
        Reaction rxn = new Reaction();
        for (int i = 0; i < this.mFragment.length; ++i) {
            StereoMolecule selectedMol = this.getSelectedCopy(this.mFragment[i]);
            if (selectedMol == null) continue;
            if (i < this.mReactantCount) {
                rxn.addReactant(selectedMol);
                continue;
            }
            rxn.addProduct(selectedMol);
        }
        return rxn;
    }

    private StereoMolecule getSelectedCopy(StereoMolecule sourceMol) {
        int atomCount = 0;
        for (int atom = 0; atom < sourceMol.getAllAtoms(); ++atom) {
            if (!sourceMol.isSelectedAtom(atom)) continue;
            ++atomCount;
        }
        if (atomCount == 0) {
            return null;
        }
        int bondCount = 0;
        for (int bond = 0; bond < sourceMol.getAllBonds(); ++bond) {
            if (!sourceMol.isSelectedBond(bond)) continue;
            ++bondCount;
        }
        boolean[] includeAtom = new boolean[sourceMol.getAllAtoms()];
        for (int atom = 0; atom < sourceMol.getAllAtoms(); ++atom) {
            includeAtom[atom] = sourceMol.isSelectedAtom(atom);
        }
        StereoMolecule destMol = new StereoMolecule(atomCount, bondCount);
        sourceMol.copyMoleculeByAtoms(destMol, includeAtom, false, null);
        return destMol;
    }

    private boolean copyMolecule(boolean selectionOnly) {
        if (this.mMol.getAllAtoms() != 0 && this.mClipboardHandler != null) {
            return this.mClipboardHandler.copyMolecule(selectionOnly ? this.getSelectedCopy(this.mMol) : this.mMol);
        }
        return false;
    }

    private void paste() {
        if ((this.mMode & 4) != 0 && this.pasteReaction()) {
            return;
        }
        this.pasteMolecule();
    }

    private boolean pasteReaction() {
        boolean ret = false;
        if (this.mClipboardHandler != null) {
            Reaction rxn = this.mClipboardHandler.pasteReaction();
            if (rxn != null) {
                for (int i = 0; i < rxn.getMolecules(); ++i) {
                    rxn.getMolecule(i).setFragment(this.mMol.isFragment());
                }
                this.storeState();
                this.setReaction(rxn);
                ret = true;
            } else {
                this.showWarningMessage("No reaction on clipboard!");
            }
        }
        return ret;
    }

    private boolean pasteMolecule() {
        if (this.mClipboardHandler != null) {
            StereoMolecule mol = this.mClipboardHandler.pasteMolecule();
            if (this.addPastedOrDropped(mol, null)) {
                return true;
            }
            this.showWarningMessage("No molecule on clipboard!");
        }
        return false;
    }

    public boolean addPastedOrDropped(StereoMolecule mol, GenericPoint p) {
        if (mol == null || mol.getAllAtoms() == 0) {
            return false;
        }
        if (mol.getAllBonds() != 0) {
            new GenericDepictor(mol).updateCoords(this.mCanvas.getDrawContext(), new GenericRectangle(0.0, 0.0, this.mCanvas.getCanvasWidth(), this.mCanvas.getCanvasHeight()), 65536 + (int)this.mMol.getAverageBondLength());
        }
        this.storeState();
        mol.removeAtomColors();
        mol.removeBondHiliting();
        if (this.mMol.getAllAtoms() == 0) {
            boolean isFragment = this.mMol.isFragment();
            mol.copyMolecule(this.mMol);
            this.mMol.setFragment(isFragment);
            this.updateAndFireEvent(4);
        } else {
            if (p != null) {
                mol.translateCoords(p.x - this.mCanvas.getCanvasWidth() / 2.0, p.y - this.mCanvas.getCanvasHeight() / 2.0);
            }
            int originalAtoms = this.mMol.getAllAtoms();
            this.mMol.addMolecule(mol);
            for (int atom = 0; atom < this.mMol.getAllAtoms(); ++atom) {
                this.mMol.setAtomSelection(atom, atom >= originalAtoms);
            }
            this.updateAndFireEvent(3);
        }
        return true;
    }

    private void openReaction() {
        File rxnFile = this.mUIHelper.openChemistryFile(true);
        if (rxnFile != null) {
            try {
                Reaction reaction = null;
                if (FileHelper.getFileType(rxnFile.getName()) == 256) {
                    reaction = new RXNFileParser().getReaction(rxnFile);
                } else {
                    RDFileParser rdfParser = new RDFileParser(rxnFile);
                    if (rdfParser.isReactionNext()) {
                        reaction = rdfParser.getNextReaction();
                    }
                }
                if (reaction != null) {
                    for (int i = 0; i < reaction.getMolecules(); ++i) {
                        reaction.getMolecule(i).setFragment(this.mMol.isFragment());
                    }
                    this.storeState();
                    this.setReaction(reaction);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void showWarningMessage(String msg) {
        this.mWarningMessage = msg;
        this.mCanvas.repaint();
        new Thread(() -> {
            try {
                Thread.sleep(1200L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.mWarningMessage = null;
            this.mCanvas.repaint();
        }).start();
    }

    private void eventHappened(GenericMouseEvent e) {
        if (e.getWhat() == 1) {
            if (this.mCurrentHiliteAtom != -1 && this.mAtomKeyStrokeBuffer.length() != 0) {
                this.expandAtomKeyStrokes(this.mAtomKeyStrokeBuffer.toString());
            }
            this.mAtomKeyStrokeBuffer.setLength(0);
            if (e.isPopupTrigger()) {
                this.handlePopupTrigger(e.getX(), e.getY());
                return;
            }
            if (e.getButton() == 1) {
                if (e.getClickCount() == 2) {
                    return;
                }
                this.mMouseIsDown = true;
                this.updateCursor();
                this.mousePressedButton1(e);
            }
        }
        if (e.getWhat() == 2) {
            if (e.isPopupTrigger()) {
                this.handlePopupTrigger(e.getX(), e.getY());
                return;
            }
            if (e.getButton() == 1) {
                if (e.getClickCount() == 2) {
                    this.handleDoubleClick(e.getX(), e.getY());
                    return;
                }
                this.mMouseIsDown = false;
                this.updateCursor();
                this.mouseReleasedButton1();
            }
        }
        if (e.getWhat() == 4) {
            this.mUIHelper.grabFocus();
            this.updateCursor();
        }
        if (e.getWhat() == 6) {
            int y;
            this.mMouseIsDown = false;
            int x = e.getX();
            if (this.trackHiliting(x, y = e.getY(), false)) {
                this.mCanvas.repaint();
            }
            this.updateCursor();
        }
        if (e.getWhat() == 7) {
            this.mMouseIsDown = true;
            this.mX2 = e.getX();
            this.mY2 = e.getY();
            boolean repaintNeeded = this.trackHiliting(this.mX2, this.mY2, true);
            switch (this.mPendingRequest) {
                case 2: {
                    int i;
                    double lastY;
                    double lastX;
                    if (this.mChainAtoms > 0) {
                        lastX = this.mChainAtomX[this.mChainAtoms - 1];
                        lastY = this.mChainAtomY[this.mChainAtoms - 1];
                    } else {
                        lastX = 0.0;
                        lastY = 0.0;
                    }
                    double avbl = this.mMol.getAverageBondLength();
                    double s0 = (int)avbl;
                    double s1 = (int)(0.866 * avbl);
                    double s2 = (int)(0.5 * avbl);
                    double dx = this.mX2 - this.mX1;
                    double dy = this.mY2 - this.mY1;
                    if (Math.abs(dy) > Math.abs(dx)) {
                        this.mChainAtoms = (int)(2.0 * Math.abs(dy) / (s0 + s2));
                        if (Math.abs(dy) % (s0 + s2) > s0) {
                            ++this.mChainAtoms;
                        }
                        this.mChainAtomX = new double[this.mChainAtoms];
                        this.mChainAtomY = new double[this.mChainAtoms];
                        if (this.mX2 < this.mX1) {
                            s1 = -s1;
                        }
                        if (this.mY2 < this.mY1) {
                            s0 = -s0;
                            s2 = -s2;
                        }
                        for (i = 0; i < this.mChainAtoms; ++i) {
                            this.mChainAtomX[i] = this.mX1 + (double)((i + 1) / 2) * s1;
                            this.mChainAtomY[i] = this.mY1 + (double)((i + 1) / 2) * (s0 + s2);
                            if ((i & 1) != 0) continue;
                            int n = i;
                            this.mChainAtomY[n] = this.mChainAtomY[n] + s0;
                        }
                    } else {
                        this.mChainAtoms = (int)(Math.abs(dx) / s1);
                        this.mChainAtomX = new double[this.mChainAtoms];
                        this.mChainAtomY = new double[this.mChainAtoms];
                        if (this.mX2 < this.mX1) {
                            s1 = -s1;
                        }
                        if (this.mY2 < this.mY1) {
                            s2 = -s2;
                        }
                        for (i = 0; i < this.mChainAtoms; ++i) {
                            this.mChainAtomX[i] = this.mX1 + (double)(i + 1) * s1;
                            this.mChainAtomY[i] = this.mY1;
                            if ((i & 1) != 0) continue;
                            int n = i;
                            this.mChainAtomY[n] = this.mChainAtomY[n] + s2;
                        }
                    }
                    if (this.mChainAtoms > 0) {
                        this.mChainAtom = new int[this.mChainAtoms];
                        for (i = 0; i < this.mChainAtoms; ++i) {
                            this.mChainAtom[i] = this.mMol.findAtom(this.mChainAtomX[i], this.mChainAtomY[i]);
                            if (this.mChainAtom[i] == -1) continue;
                            this.mChainAtomX[i] = this.mMol.getAtomX(this.mChainAtom[i]);
                            this.mChainAtomY[i] = this.mMol.getAtomY(this.mChainAtom[i]);
                        }
                        if (this.mChainAtomX[this.mChainAtoms - 1] == lastX && this.mChainAtomY[this.mChainAtoms - 1] == lastY) break;
                        repaintNeeded = true;
                        break;
                    }
                    if (lastX == 0.0 && lastY == 0.0) break;
                    repaintNeeded = true;
                    break;
                }
                case 1: {
                    if ((this.mX2 - this.mX1) * (this.mX2 - this.mX1) + (this.mY2 - this.mY1) * (this.mY2 - this.mY1) < 100.0) {
                        this.suggestNewX2AndY2(this.mAtom1);
                    }
                    repaintNeeded = true;
                    break;
                }
                case 3: {
                    this.mMol.setAtomX(this.mAtom1, this.mX[this.mAtom1] + this.mX2 - this.mX1);
                    this.mMol.setAtomY(this.mAtom1, this.mY[this.mAtom1] + this.mY2 - this.mY1);
                    if (this.mAtom2 != -1) {
                        this.mMol.setAtomX(this.mAtom2, this.mX[this.mAtom2] + this.mX2 - this.mX1);
                        this.mMol.setAtomY(this.mAtom2, this.mY[this.mAtom2] + this.mY2 - this.mY1);
                    }
                    this.update(2);
                    break;
                }
                case 9: {
                    this.duplicateSelected();
                    this.mPendingRequest = 4;
                }
                case 4: {
                    if (this.mDrawingObjectList != null) {
                        for (AbstractDrawingObject drawingObject : this.mDrawingObjectList) {
                            if (!drawingObject.isSelected()) continue;
                            drawingObject.translate(this.mX2, this.mY2);
                        }
                    }
                    for (int i = 0; i < this.mMol.getAllAtoms(); ++i) {
                        if (!this.mMol.isSelectedAtom(i)) continue;
                        this.mMol.setAtomX(i, this.mX[i] + this.mX2 - this.mX1);
                        this.mMol.setAtomY(i, this.mY[i] + this.mY2 - this.mY1);
                    }
                    this.update(2);
                    break;
                }
                case 11: {
                    this.mDrawingObjectList.add(this.mCurrentHiliteObject.clone());
                    this.mPendingRequest = 10;
                }
                case 10: {
                    this.mCurrentHiliteObject.translate(this.mX2, this.mY2);
                    this.update(2);
                    break;
                }
                case 7: {
                    boolean selectedOnly;
                    boolean selectedAtomsFound = false;
                    for (int atom = 0; atom < this.mMol.getAllAtoms() && !selectedAtomsFound; ++atom) {
                        selectedAtomsFound = this.mMol.isSelectedAtom(atom);
                    }
                    boolean selectedObjectsFound = false;
                    if (this.mDrawingObjectList != null) {
                        for (int i = 0; i < this.mDrawingObjectList.size() && !selectedObjectsFound; ++i) {
                            selectedObjectsFound = ((AbstractDrawingObject)this.mDrawingObjectList.get(i)).isSelected();
                        }
                    }
                    double magnification = Math.abs(this.mY2 - this.mY1) < 20.0 ? 1.0 : Math.exp((this.mY2 - this.mY1) / 100.0);
                    double angleChange = Math.abs(this.mX2 - this.mX1) < 20.0 ? 0.0 : (this.mX2 - this.mX1) / 50.0;
                    boolean bl = selectedOnly = selectedAtomsFound || selectedObjectsFound;
                    if (this.mDrawingObjectList != null && (!selectedOnly || selectedObjectsFound)) {
                        for (int i = 0; i < this.mDrawingObjectList.size(); ++i) {
                            if (selectedOnly && !((AbstractDrawingObject)this.mDrawingObjectList.get(i)).isSelected()) continue;
                            ((AbstractDrawingObject)this.mDrawingObjectList.get(i)).zoomAndRotate(magnification, angleChange);
                        }
                        this.update(2);
                    }
                    if (selectedOnly && !selectedAtomsFound) break;
                    this.mMol.zoomAndRotate(magnification, angleChange, selectedOnly);
                    this.update(2);
                    break;
                }
                case 5: 
                case 6: {
                    int i;
                    GenericShape selectedShape = null;
                    if (this.mPendingRequest == 5) {
                        if (Math.abs(this.mX2 - this.mLassoRegion.getX(this.mLassoRegion.getSize() - 1)) < 3.0 && Math.abs(this.mY2 - this.mLassoRegion.getY(this.mLassoRegion.getSize() - 1)) < 3.0) break;
                        this.mLassoRegion.removeLastPoint();
                        this.mLassoRegion.addPoint(this.mX2, this.mY2);
                        this.mLassoRegion.addPoint(this.mX1, this.mY1);
                        selectedShape = this.mLassoRegion;
                    } else {
                        selectedShape = new GenericRectangle(Math.min(this.mX1, this.mX2), Math.min(this.mY1, this.mY2), Math.abs(this.mX2 - this.mX1), Math.abs(this.mY2 - this.mY1));
                    }
                    if (this.mDrawingObjectList != null) {
                        for (i = 0; i < this.mDrawingObjectList.size(); ++i) {
                            AbstractDrawingObject object = (AbstractDrawingObject)this.mDrawingObjectList.get(i);
                            boolean isSelected = object.isSurroundedBy(selectedShape);
                            if (this.mIsAddingToSelection && this.mIsSelectedObject[i] || isSelected == object.isSelected()) continue;
                            object.setSelected(isSelected);
                            this.mUpdateMode = Math.max(this.mUpdateMode, 1);
                        }
                    }
                    for (i = 0; i < this.mMol.getAllAtoms(); ++i) {
                        boolean isSelected = selectedShape.contains((int)this.mMol.getAtomX(i), (int)this.mMol.getAtomY(i));
                        if (this.mIsAddingToSelection && this.mIsSelectedAtom[i] || isSelected == this.mMol.isSelectedAtom(i)) continue;
                        this.mMol.setAtomSelection(i, isSelected);
                        this.mUpdateMode = Math.max(this.mUpdateMode, 1);
                    }
                    repaintNeeded = true;
                    break;
                }
                case 8: {
                    repaintNeeded = true;
                }
            }
            if (repaintNeeded) {
                this.mCanvas.repaint();
            }
        }
    }

    public void showHelpDialog() {
        this.mUIHelper.showHelpDialog("/html/editor/editor.html", "Structure Editor Help");
    }

    private void eventHappened(GenericKeyEvent e) {
        if (e.getWhat() == 1) {
            if (e.getKey() == -3) {
                this.mShiftIsDown = true;
                this.updateCursor();
            }
            if (e.getKey() == -2) {
                this.mAltIsDown = true;
                this.updateCursor();
            }
            if (e.getKey() == -1) {
                this.updateCursor();
            }
            if (e.isCtrlDown() && e.getKey() == 122) {
                this.restoreState();
                this.updateAndFireEvent(2);
            } else if (e.getKey() == -4) {
                this.storeState();
                if (this.mCurrentTool == 19) {
                    boolean found = false;
                    for (int atom = 0; atom < this.mMol.getAllAtoms(); ++atom) {
                        if (this.mMol.getAtomMapNo(atom) == 0) continue;
                        this.mMol.setAtomMapNo(atom, 0, false);
                        found = true;
                    }
                    if (found) {
                        this.updateAndFireEvent(1);
                    }
                } else if (!this.deleteHilited() && this.mMol.deleteSelectedAtoms()) {
                    this.updateAndFireEvent(1);
                }
            } else {
                if (e.getKey() == -6 || this.mCurrentHiliteAtom == -1 && e.getKey() == 63) {
                    this.showHelpDialog();
                    return;
                }
                if (this.mCurrentHiliteBond != -1) {
                    int ch = e.getKey();
                    if (ch == 113 && this.mMol.isFragment()) {
                        this.showBondQFDialog(this.mCurrentHiliteBond);
                    } else if (ch == 118) {
                        if (this.mMol.addRingToBond(this.mCurrentHiliteBond, 3, false)) {
                            this.updateAndFireEvent(3);
                        }
                    } else if (ch >= 52 && ch <= 55) {
                        if (this.mMol.addRingToBond(this.mCurrentHiliteBond, ch - 48, false)) {
                            this.updateAndFireEvent(3);
                        }
                    } else if (ch == 97 || ch == 98) {
                        if (this.mMol.addRingToBond(this.mCurrentHiliteBond, 6, true)) {
                            this.updateAndFireEvent(3);
                        }
                    } else {
                        boolean bondChanged;
                        boolean bl = ch == 48 ? this.changeHighlightedBond(32) : (ch == 49 ? this.changeHighlightedBond(1) : (ch == 50 ? this.changeHighlightedBond(2) : (ch == 51 ? this.changeHighlightedBond(4) : (ch == 117 ? this.changeHighlightedBond(17) : (ch == 100 ? this.changeHighlightedBond(9) : (ch == 99 ? this.changeHighlightedBond(26) : (bondChanged = ch == 109 ? this.changeHighlightedBond(32) : false)))))));
                        if (bondChanged) {
                            this.updateAndFireEvent(1);
                        }
                    }
                } else if (this.mCurrentHiliteAtom != -1) {
                    boolean isFirst;
                    int ch = e.getKey();
                    boolean bl = isFirst = this.mAtomKeyStrokeBuffer.length() == 0;
                    if (isFirst && (ch == 43 || ch == 45)) {
                        this.storeState();
                        if (this.mMol.changeAtomCharge(this.mCurrentHiliteAtom, ch == 43)) {
                            this.updateAndFireEvent(3);
                        }
                    } else if (isFirst && ch == 46) {
                        this.storeState();
                        int newRadical = this.mMol.getAtomRadical(this.mCurrentHiliteAtom) == 32 ? 0 : 32;
                        this.mMol.setAtomRadical(this.mCurrentHiliteAtom, newRadical);
                        this.updateAndFireEvent(3);
                    } else if (isFirst && ch == 58) {
                        this.storeState();
                        int newRadical = this.mMol.getAtomRadical(this.mCurrentHiliteAtom) == 48 ? 16 : (this.mMol.getAtomRadical(this.mCurrentHiliteAtom) == 16 ? 0 : 48);
                        this.mMol.setAtomRadical(this.mCurrentHiliteAtom, newRadical);
                        this.updateAndFireEvent(3);
                    } else if (isFirst && ch == 108) {
                        this.mAtomKeyStrokeBuffer.append("Cl");
                        this.update(1);
                    } else if (isFirst && ch == 113 && this.mMol.isFragment()) {
                        this.showAtomQFDialog(this.mCurrentHiliteAtom);
                    } else if (isFirst && ch == 63) {
                        this.storeState();
                        if (this.mMol.changeAtom(this.mCurrentHiliteAtom, 0, 0, -1, 0)) {
                            this.updateAndFireEvent(3);
                        }
                    } else if (isFirst && ch > 48 && ch <= 57) {
                        if (this.mMol.getFreeValence(this.mCurrentHiliteAtom) > 0) {
                            this.storeState();
                            int chainAtoms = ch - 47;
                            int atom1 = this.mCurrentHiliteAtom;
                            int hydrogenCount = this.mMol.getAllAtoms() - this.mMol.getAtoms();
                            for (int i = 1; i < chainAtoms; ++i) {
                                this.suggestNewX2AndY2(atom1);
                                int atom2 = this.mMol.addAtom(this.mX2, this.mY2);
                                if (atom2 == -1) break;
                                this.mMol.addBond(atom1, atom2);
                                atom1 = atom2 - hydrogenCount;
                                this.mMol.ensureHelperArrays(1);
                            }
                            this.updateAndFireEvent(3);
                        }
                    } else if (!isFirst && e.getKey() == -7) {
                        this.mAtomKeyStrokeBuffer.setLength(0);
                        this.update(1);
                    } else if (!isFirst && e.getKey() == -5) {
                        this.mAtomKeyStrokeBuffer.setLength(this.mAtomKeyStrokeBuffer.length() - 1);
                        this.update(1);
                    } else if (ch >= 65 && ch <= 90 || ch >= 97 && ch <= 122 || ch >= 48 && ch <= 57 || ch == 45) {
                        this.mAtomKeyStrokeBuffer.append((char)ch);
                        this.update(1);
                    } else if (ch == 10 || ch == 13) {
                        this.expandAtomKeyStrokes(this.mAtomKeyStrokeBuffer.toString());
                    }
                } else if (this.mCurrentHiliteAtom == -1 && this.mCurrentHiliteBond == -1 && (this.mMode & 7) == 0) {
                    int ch = e.getKey();
                    if (ch == 104) {
                        this.flip(true);
                    }
                    if (ch == 118) {
                        this.flip(false);
                    }
                }
            }
        }
        if (e.getWhat() == 2) {
            if (e.getKey() == -3) {
                this.mShiftIsDown = false;
                this.updateCursor();
            }
            if (e.getKey() == -2) {
                this.mAltIsDown = false;
                this.updateCursor();
            }
            if (e.getKey() == -1) {
                this.updateCursor();
            }
            if (e.isMenuShortcut()) {
                if (e.getKey() == 99) {
                    this.copy();
                } else if (e.getKey() == 118) {
                    this.paste();
                }
            }
        }
    }

    private boolean changeHighlightedBond(int type) {
        this.storeState();
        return this.mMol.changeBond(this.mCurrentHiliteBond, type);
    }

    private void handlePopupTrigger(int x, int y) {
        GenericPopupMenu popup = null;
        if (this.mClipboardHandler != null) {
            popup = this.mUIHelper.createPopupMenu(this);
            String item1 = this.analyseCopy(false) ? ITEM_COPY_REACTION : ITEM_COPY_STRUCTURE;
            popup.addItem(item1, null, this.mMol.getAllAtoms() != 0);
            if ((this.mMode & 4) != 0) {
                popup.addItem(ITEM_PASTE_REACTION, null, true);
            }
            String item3 = StructureNameResolver.getInstance() == null ? ITEM_PASTE_STRUCTURE : ITEM_PASTE_WITH_NAME;
            popup.addItem(item3, null, true);
            if ((this.mMode & 4) != 0) {
                popup.addItem(ITEM_LOAD_REACTION, null, true);
            }
        }
        if ((this.mMode & 4) != 0 && this.mCurrentTool == 19) {
            if (popup == null) {
                popup = this.mUIHelper.createPopupMenu(this);
            } else {
                popup.addSeparator();
            }
            popup.addItem(ITEM_ADD_AUTO_MAPPING, null, true);
            popup.addItem(ITEM_REMOVE_MAPPING, null, true);
        }
        if (this.mCurrentTool == 18) {
            if (popup == null) {
                popup = this.mUIHelper.createPopupMenu(this);
            } else {
                popup.addSeparator();
            }
            popup.addItem(ITEM_FLIP_HORIZONTALLY, null, true);
            popup.addItem(ITEM_FLIP_VERTICALLY, null, true);
            popup.addItem(ITEM_FLIP_ROTATE180, null, true);
        }
        if (this.mAtomColorSupported && this.mCurrentHiliteAtom != -1) {
            int atomColor = this.mMol.getAtomColor(this.mCurrentHiliteAtom);
            if (popup == null) {
                popup = this.mUIHelper.createPopupMenu(this);
            } else {
                popup.addSeparator();
            }
            popup.startSubMenu("Set Atom Color");
            popup.addRadioButtonItem("\t  ", "atomColor" + this.mCurrentHiliteAtom + ":" + 0, -16777216, atomColor == 0);
            popup.addRadioButtonItem("\t  ", "atomColor" + this.mCurrentHiliteAtom + ":" + 64, -14655233, atomColor == 64);
            popup.addRadioButtonItem("\t  ", "atomColor" + this.mCurrentHiliteAtom + ":" + 448, -6291456, atomColor == 448);
            popup.addRadioButtonItem("\t  ", "atomColor" + this.mCurrentHiliteAtom + ":" + 128, -65536, atomColor == 128);
            popup.addRadioButtonItem("\t  ", "atomColor" + this.mCurrentHiliteAtom + ":" + 384, -16744448, atomColor == 384);
            popup.addRadioButtonItem("\t  ", "atomColor" + this.mCurrentHiliteAtom + ":" + 192, -16711936, atomColor == 192);
            popup.addRadioButtonItem("\t  ", "atomColor" + this.mCurrentHiliteAtom + ":" + 256, -4194049, atomColor == 256);
            popup.addRadioButtonItem("\t  ", "atomColor" + this.mCurrentHiliteAtom + ":" + 320, -24576, atomColor == 320);
            popup.endSubMenu();
        }
        if (System.getProperty("development") != null) {
            if (popup == null) {
                popup = this.mUIHelper.createPopupMenu(this);
            } else {
                popup.addSeparator();
            }
            popup.addItem(ITEM_SHOW_ATOM_BOND_NUMBERS, null, true);
            popup.addItem(ITEM_SHOW_SYMMETRY, null, true);
            popup.addItem(ITEM_SHOW_NORMAL, null, true);
        }
        if (popup != null) {
            popup.show(x, y);
        }
    }

    private void handleDoubleClick(int x, int y) {
        int atom = this.mMol.findAtom(x, y);
        int bond = this.mMol.findBond(x, y);
        if (this.mCurrentTool == 2) {
            if (this.mMol.isFragment()) {
                if (atom != -1) {
                    this.showAtomQFDialog(atom);
                } else if (bond != -1) {
                    this.showBondQFDialog(bond);
                } else if (this.mCurrentHiliteObject != null) {
                    if (!this.mShiftIsDown) {
                        for (int i = 0; i < this.mMol.getAllAtoms(); ++i) {
                            this.mMol.setAtomSelection(i, false);
                        }
                        for (AbstractDrawingObject ado : this.mDrawingObjectList) {
                            ado.setSelected(false);
                        }
                    }
                    this.mCurrentHiliteObject.setSelected(true);
                    this.update(1);
                }
            } else {
                int rootAtom = -1;
                if (atom != -1) {
                    rootAtom = atom;
                } else if (bond != -1) {
                    rootAtom = this.mMol.getBondAtom(0, bond);
                }
                if (rootAtom != -1 || this.mCurrentHiliteObject != null) {
                    if (!this.mShiftIsDown) {
                        for (int i = 0; i < this.mMol.getAllAtoms(); ++i) {
                            this.mMol.setAtomSelection(i, false);
                        }
                        if (this.mDrawingObjectList != null) {
                            for (AbstractDrawingObject drawingObject : this.mDrawingObjectList) {
                                drawingObject.setSelected(false);
                            }
                        }
                    }
                    if (rootAtom != -1) {
                        if ((this.mMode & 1) != 0) {
                            int fragment = this.mFragmentNo[rootAtom];
                            for (int i = 0; i < this.mMol.getAllAtoms(); ++i) {
                                if (this.mFragmentNo[i] != fragment) continue;
                                this.mMol.setAtomSelection(i, true);
                            }
                        } else {
                            int[] fragmentMember = this.mMol.getFragmentAtoms(rootAtom);
                            for (int i = 0; i < fragmentMember.length; ++i) {
                                this.mMol.setAtomSelection(fragmentMember[i], true);
                            }
                        }
                    } else {
                        this.mCurrentHiliteObject.setSelected(true);
                    }
                    this.update(1);
                }
            }
        } else if (this.mCurrentTool == 18) {
            int fragment = -2;
            if ((this.mMode & 1) != 0) {
                fragment = this.findFragment(x, y);
            }
            if (fragment != -1) {
                double minX = 2.147483647E9;
                double maxX = -2.147483648E9;
                for (int i = 0; i < this.mMol.getAllAtoms(); ++i) {
                    if (fragment != -2 && this.mFragmentNo[i] != fragment) continue;
                    if (minX > this.mMol.getAtomX(i)) {
                        minX = this.mMol.getAtomX(i);
                    }
                    if (!(maxX < this.mMol.getAtomX(i))) continue;
                    maxX = this.mMol.getAtomX(i);
                }
                if (maxX > minX) {
                    int i;
                    double centerX = (maxX + minX) / 2.0;
                    for (i = 0; i < this.mMol.getAllAtoms(); ++i) {
                        if (fragment != -2 && this.mFragmentNo[i] != fragment) continue;
                        this.mMol.setAtomX(i, 2.0 * centerX - this.mMol.getAtomX(i));
                    }
                    block12: for (i = 0; i < this.mMol.getAllBonds(); ++i) {
                        if (fragment != -2 && this.mFragmentNo[this.mMol.getBondAtom(0, i)] != fragment) continue;
                        switch (this.mMol.getBondType(i)) {
                            case 17: {
                                this.mMol.setBondType(i, 9);
                                continue block12;
                            }
                            case 9: {
                                this.mMol.setBondType(i, 17);
                            }
                        }
                    }
                }
                this.updateAndFireEvent(1);
            }
        } else if (this.mCurrentTool == 33) {
            this.mUIHelper.showMessage("To change current custom atom properties hold 'Ctrl'\nwhile clicking an atom with the left mouse button.");
        }
    }

    private void showAtomQFDialog(int atom) {
        if (this.mAllowQueryFeatures) {
            this.storeState();
            boolean showReactionHints = (this.mMode & 4) != 0;
            AtomQueryFeatureDialogBuilder builder = new AtomQueryFeatureDialogBuilder(this.mUIHelper, this.mMol, atom, showReactionHints);
            if (builder.showDialog()) {
                this.updateAndFireEvent(1);
            }
        }
    }

    private void showBondQFDialog(int bond) {
        if (this.mAllowQueryFeatures) {
            this.storeState();
            BondQueryFeatureDialogBuilder builder = new BondQueryFeatureDialogBuilder(this.mUIHelper, this.mMol, bond);
            if (builder.showDialog()) {
                this.updateAndFireEvent(1);
            }
        }
    }

    public void showCustomAtomDialog(int atom) {
        CustomAtomDialogBuilder builder;
        this.storeState();
        CustomAtomDialogBuilder customAtomDialogBuilder = builder = atom == -1 ? new CustomAtomDialogBuilder(this.mUIHelper, this, this.mCustomAtomicNo, this.mCustomAtomMass, this.mCustomAtomValence, this.mCustomAtomRadical, this.mCustomAtomLabel) : new CustomAtomDialogBuilder(this.mUIHelper, this, this.mMol, atom);
        if (builder.showDialog() && atom != -1) {
            this.updateAndFireEvent(1);
        }
    }

    private void mousePressedButton1(GenericMouseEvent gme) {
        this.mX1 = gme.getX();
        this.mY1 = gme.getY();
        switch (this.mCurrentTool) {
            case 18: {
                double x = this.mX1;
                double y = this.mY1;
                this.mAtom1 = this.mMol.findAtom(this.mX1, this.mY1);
                if (this.mAtom1 != -1) {
                    this.mX1 = this.mMol.getAtomX(this.mAtom1);
                    this.mY1 = this.mMol.getAtomY(this.mAtom1);
                }
                this.mMol.zoomAndRotateInit(x, y);
                if (this.mDrawingObjectList != null) {
                    for (AbstractDrawingObject drawingObject : this.mDrawingObjectList) {
                        drawingObject.zoomAndRotateInit(x, y);
                    }
                }
                this.storeState();
                this.mPendingRequest = 7;
                break;
            }
            case 2: {
                int i;
                int bondClicked;
                this.mPendingRequest = 0;
                this.mAtom1 = this.mMol.findAtom(this.mX1, this.mY1);
                if (this.mAtom1 != -1) {
                    this.mAtom2 = -1;
                    this.mX1 = this.mMol.getAtomX(this.mAtom1);
                    this.mY1 = this.mMol.getAtomY(this.mAtom1);
                    this.mPendingRequest = this.mMol.isSelectedAtom(this.mAtom1) ? (this.mShiftIsDown ? 9 : 4) : 3;
                }
                if (this.mPendingRequest == 0 && (bondClicked = this.mMol.findBond(this.mX1, this.mY1)) != -1) {
                    this.mAtom1 = this.mMol.getBondAtom(0, bondClicked);
                    this.mAtom2 = this.mMol.getBondAtom(1, bondClicked);
                    this.mPendingRequest = this.mMol.isSelectedBond(bondClicked) ? (this.mShiftIsDown ? 9 : 4) : 3;
                }
                if (this.mPendingRequest == 0 && this.mCurrentHiliteObject != null) {
                    if (this.mCurrentHiliteObject.isSelected()) {
                        this.mPendingRequest = this.mShiftIsDown ? 9 : 4;
                    } else {
                        int n = this.mPendingRequest = this.mShiftIsDown && !(this.mCurrentHiliteObject instanceof ReactionArrow) ? 11 : 10;
                    }
                }
                if (this.mPendingRequest != 0) {
                    this.mX = new double[this.mMol.getAllAtoms()];
                    this.mY = new double[this.mMol.getAllAtoms()];
                    for (i = 0; i < this.mMol.getAllAtoms(); ++i) {
                        this.mX[i] = this.mMol.getAtomX(i);
                        this.mY[i] = this.mMol.getAtomY(i);
                    }
                    if (this.mDrawingObjectList != null) {
                        for (AbstractDrawingObject drawingObject : this.mDrawingObjectList) {
                            drawingObject.translateInit(this.mX1, this.mY1);
                        }
                    }
                    this.storeState();
                    break;
                }
                this.mIsSelectedAtom = new boolean[this.mMol.getAllAtoms()];
                if (this.mDrawingObjectList != null) {
                    this.mIsSelectedObject = new boolean[this.mDrawingObjectList.size()];
                }
                this.mIsAddingToSelection = gme.isShiftDown();
                for (i = 0; i < this.mMol.getAllAtoms(); ++i) {
                    this.mIsSelectedAtom[i] = this.mMol.isSelectedAtom(i);
                }
                if (this.mDrawingObjectList != null) {
                    for (i = 0; i < this.mDrawingObjectList.size(); ++i) {
                        this.mIsSelectedObject[i] = ((AbstractDrawingObject)this.mDrawingObjectList.get(i)).isSelected();
                    }
                }
                if (gme.isAltDown()) {
                    this.mPendingRequest = 6;
                    break;
                }
                this.mLassoRegion = new GenericPolygon();
                this.mLassoRegion.addPoint(this.mX1, this.mY1);
                this.mLassoRegion.addPoint(this.mX1, this.mY1);
                this.mPendingRequest = 5;
                break;
            }
            case 4: {
                this.storeState();
                this.deleteAt(this.mX1, this.mY1);
                break;
            }
            case 3: {
                int theAtom = this.mMol.findAtom(this.mX1, this.mY1);
                if (theAtom == -1) break;
                this.storeState();
                this.mMol.setAtomConfigurationUnknown(theAtom, !this.mMol.isAtomConfigurationUnknown(theAtom));
                this.updateAndFireEvent(1);
                break;
            }
            case 101: 
            case 102: 
            case 103: {
                if (this.mCurrentHiliteBond == -1 || !this.qualifiesForESR(this.mCurrentHiliteBond)) break;
                this.storeState();
                this.setESRInfo(this.mCurrentHiliteBond, this.mCurrentTool == 101 ? 0 : (this.mCurrentTool == 103 ? 1 : 2));
                this.updateAndFireEvent(1);
                break;
            }
            case 5: 
            case 6: 
            case 23: {
                this.mAtom1 = this.mMol.findAtom(this.mX1, this.mY1);
                if (this.mAtom1 == -1) {
                    int bond = this.mMol.findBond(this.mX1, this.mY1);
                    if (bond != -1) {
                        this.storeState();
                        int bondType = 127;
                        if (this.mCurrentTool == 6) {
                            bondType = 17;
                        } else if (this.mCurrentTool == 23) {
                            bondType = 9;
                        }
                        if (!this.mMol.changeBond(bond, bondType)) break;
                        this.updateAndFireEvent(1);
                        break;
                    }
                } else {
                    if (this.mMol.getAllConnAtomsPlusMetalBonds(this.mAtom1) == 8) {
                        return;
                    }
                    this.mX1 = this.mMol.getAtomX(this.mAtom1);
                    this.mY1 = this.mMol.getAtomY(this.mAtom1);
                }
                this.mPendingRequest = 1;
                this.suggestNewX2AndY2(this.mAtom1);
                this.mCanvas.repaint();
                break;
            }
            case 22: {
                this.mAtom1 = this.mMol.findAtom(this.mX1, this.mY1);
                if (this.mAtom1 != -1) {
                    if (this.mMol.getAllConnAtomsPlusMetalBonds(this.mAtom1) == 8) {
                        return;
                    }
                    this.mX1 = this.mMol.getAtomX(this.mAtom1);
                    this.mY1 = this.mMol.getAtomY(this.mAtom1);
                }
                this.mPendingRequest = 2;
                this.mChainAtoms = 0;
                break;
            }
            case 7: {
                this.storeState();
                if (!this.mMol.addRing(this.mX1, this.mY1, 3, false)) break;
                this.updateAndFireEvent(3);
                break;
            }
            case 24: {
                this.storeState();
                if (!this.mMol.addRing(this.mX1, this.mY1, 4, false)) break;
                this.updateAndFireEvent(3);
                break;
            }
            case 8: {
                this.storeState();
                if (!this.mMol.addRing(this.mX1, this.mY1, 5, false)) break;
                this.updateAndFireEvent(3);
                break;
            }
            case 25: {
                this.storeState();
                if (!this.mMol.addRing(this.mX1, this.mY1, 6, false)) break;
                this.updateAndFireEvent(3);
                break;
            }
            case 9: {
                this.storeState();
                if (!this.mMol.addRing(this.mX1, this.mY1, 7, false)) break;
                this.updateAndFireEvent(3);
                break;
            }
            case 26: {
                this.storeState();
                if (!this.mMol.addRing(this.mX1, this.mY1, 6, true)) break;
                this.updateAndFireEvent(3);
                break;
            }
            case 10: {
                this.storeState();
                if (!this.mMol.changeAtomCharge(this.mX1, this.mY1, true)) break;
                this.updateAndFireEvent(3);
                break;
            }
            case 27: {
                this.storeState();
                if (!this.mMol.changeAtomCharge(this.mX1, this.mY1, false)) break;
                this.updateAndFireEvent(3);
                break;
            }
            case 16: {
                this.storeState();
                if (!this.mMol.addOrChangeAtom(this.mX1, this.mY1, 1, 0, -1, 0, null)) break;
                this.updateAndFireEvent(3);
                break;
            }
            case 11: {
                this.storeState();
                if (!this.mMol.addOrChangeAtom(this.mX1, this.mY1, 6, 0, -1, 0, null)) break;
                this.updateAndFireEvent(3);
                break;
            }
            case 12: {
                this.storeState();
                if (!this.mMol.addOrChangeAtom(this.mX1, this.mY1, 7, 0, -1, 0, null)) break;
                this.updateAndFireEvent(3);
                break;
            }
            case 13: {
                this.storeState();
                if (!this.mMol.addOrChangeAtom(this.mX1, this.mY1, 8, 0, -1, 0, null)) break;
                this.updateAndFireEvent(3);
                break;
            }
            case 28: {
                this.storeState();
                if (!this.mMol.addOrChangeAtom(this.mX1, this.mY1, 14, 0, -1, 0, null)) break;
                this.updateAndFireEvent(3);
                break;
            }
            case 29: {
                this.storeState();
                if (!this.mMol.addOrChangeAtom(this.mX1, this.mY1, 15, 0, -1, 0, null)) break;
                this.updateAndFireEvent(3);
                break;
            }
            case 30: {
                this.storeState();
                if (!this.mMol.addOrChangeAtom(this.mX1, this.mY1, 16, 0, -1, 0, null)) break;
                this.updateAndFireEvent(3);
                break;
            }
            case 14: {
                this.storeState();
                if (!this.mMol.addOrChangeAtom(this.mX1, this.mY1, 9, 0, -1, 0, null)) break;
                this.updateAndFireEvent(3);
                break;
            }
            case 31: {
                this.storeState();
                if (!this.mMol.addOrChangeAtom(this.mX1, this.mY1, 17, 0, -1, 0, null)) break;
                this.updateAndFireEvent(3);
                break;
            }
            case 15: {
                this.storeState();
                if (!this.mMol.addOrChangeAtom(this.mX1, this.mY1, 35, 0, -1, 0, null)) break;
                this.updateAndFireEvent(3);
                break;
            }
            case 32: {
                this.storeState();
                if (!this.mMol.addOrChangeAtom(this.mX1, this.mY1, 53, 0, -1, 0, null)) break;
                this.updateAndFireEvent(3);
                break;
            }
            case 33: {
                if (gme.isControlDown()) {
                    int atom = this.mMol.findAtom(this.mX1, this.mY1);
                    if (atom == -1) break;
                    this.showCustomAtomDialog(atom);
                    break;
                }
                this.storeState();
                if (!this.mMol.addOrChangeAtom(this.mX1, this.mY1, this.mCustomAtomicNo, this.mCustomAtomMass, this.mCustomAtomValence, this.mCustomAtomRadical, this.mCustomAtomLabel)) break;
                this.updateAndFireEvent(3);
                break;
            }
            case 19: {
                this.mAtom1 = this.mMol.findAtom(this.mX1, this.mY1);
                if (this.mAtom1 == -1 || this.mAtom1 >= this.mMol.getAtoms()) break;
                this.mX1 = this.mMol.getAtomX(this.mAtom1);
                this.mY1 = this.mMol.getAtomY(this.mAtom1);
                this.mPendingRequest = 8;
                break;
            }
            case 21: {
                TextDrawingObject object = null;
                if (this.mCurrentHiliteObject == null) {
                    object = new TextDrawingObject();
                    object.setCoordinates(this.mX1, this.mY1);
                    this.mDrawingObjectList.add(object);
                } else if (this.mCurrentHiliteObject instanceof TextDrawingObject) {
                    object = (TextDrawingObject)this.mCurrentHiliteObject;
                }
                this.editTextObject(object);
                this.storeState();
                this.update(3);
            }
        }
    }

    private void mouseReleasedButton1() {
        int pendingRequest = this.mPendingRequest;
        this.mPendingRequest = 0;
        switch (pendingRequest) {
            case 1: {
                int stopAtom = this.mMol.findAtom(this.mX2, this.mY2);
                if (stopAtom != -1 && this.mMol.getAllConnAtomsPlusMetalBonds(stopAtom) == 8) {
                    return;
                }
                this.storeState();
                if (this.mAtom1 == -1) {
                    this.mAtom1 = this.mMol.addAtom(this.mX1, this.mY1);
                }
                if (stopAtom == -1) {
                    stopAtom = this.mMol.addAtom(this.mX2, this.mY2);
                }
                if (this.mAtom1 != -1 && stopAtom != -1) {
                    int bondType;
                    int n = bondType = this.mMol.isMetalAtom(this.mAtom1) || this.mMol.isMetalAtom(stopAtom) ? 32 : 1;
                    if (this.mCurrentTool == 6) {
                        bondType = 17;
                    }
                    if (this.mCurrentTool == 23) {
                        bondType = 9;
                    }
                    this.mMol.addOrChangeBond(this.mAtom1, stopAtom, bondType);
                }
                this.updateAndFireEvent(3);
                break;
            }
            case 2: {
                this.storeState();
                if (this.mChainAtoms > 0) {
                    if (this.mAtom1 == -1) {
                        this.mAtom1 = this.mMol.addAtom(this.mX1, this.mY1);
                    }
                    if (this.mChainAtom[0] == -1) {
                        this.mChainAtom[0] = this.mMol.addAtom(this.mChainAtomX[0], this.mChainAtomY[0]);
                    }
                    if (this.mChainAtom[0] != -1) {
                        this.mMol.addBond(this.mAtom1, this.mChainAtom[0]);
                    }
                }
                if (this.mChainAtoms > 1) {
                    for (int i = 1; i < this.mChainAtoms; ++i) {
                        if (this.mChainAtom[i] == -1) {
                            this.mChainAtom[i] = this.mMol.addAtom(this.mChainAtomX[i], this.mChainAtomY[i]);
                        }
                        if (this.mChainAtom[i] == -1) continue;
                        this.mMol.addBond(this.mChainAtom[i - 1], this.mChainAtom[i]);
                    }
                }
                this.updateAndFireEvent(3);
                break;
            }
            case 3: 
            case 4: 
            case 7: {
                this.updateAndFireEvent(3);
                break;
            }
            case 10: {
                this.update(3);
                break;
            }
            case 5: 
            case 6: {
                boolean selectionChanged = false;
                for (int i = 0; i < this.mMol.getAllAtoms(); ++i) {
                    if (this.mIsSelectedAtom[i] == this.mMol.isSelectedAtom(i)) continue;
                    selectionChanged = true;
                    break;
                }
                this.mCanvas.repaint();
                if (!selectionChanged) break;
                this.fireEventLater(new EditorEvent(this, 2, true));
                break;
            }
            case 8: {
                boolean mapNoChanged = false;
                int atom2 = this.mCurrentHiliteAtom;
                int mapNoAtom1 = this.mMol.getAtomMapNo(this.mAtom1);
                if (atom2 == -1) {
                    this.storeState();
                    if (mapNoAtom1 != 0) {
                        mapNoChanged = true;
                        for (int atom = 0; atom < this.mMol.getAtoms(); ++atom) {
                            if (this.mMol.getAtomMapNo(atom) != mapNoAtom1) continue;
                            this.mMol.setAtomMapNo(atom, 0, false);
                        }
                        this.autoMapReaction();
                    }
                } else {
                    this.storeState();
                    mapNoChanged = true;
                    if (this.mAtom1 == atom2) {
                        int mapNo = this.mMol.getAtomMapNo(this.mAtom1);
                        for (int atom = 0; atom < this.mMol.getAtoms(); ++atom) {
                            if (this.mMol.getAtomMapNo(atom) != mapNo) continue;
                            this.mMol.setAtomMapNo(atom, 0, false);
                        }
                    } else {
                        int mapNoAtom2 = this.mMol.getAtomMapNo(atom2);
                        for (int atom = 0; atom < this.mMol.getAtoms(); ++atom) {
                            if (this.mMol.getAtomMapNo(atom) != mapNoAtom1 && this.mMol.getAtomMapNo(atom) != mapNoAtom2) continue;
                            this.mMol.setAtomMapNo(atom, 0, false);
                        }
                        int freeMapNo = 1;
                        for (int atom = 0; atom < this.mMol.getAtoms(); ++atom) {
                            if (this.mMol.getAtomMapNo(atom) != freeMapNo) continue;
                            ++freeMapNo;
                            atom = -1;
                        }
                        this.mMol.setAtomMapNo(this.mAtom1, freeMapNo, false);
                        this.mMol.setAtomMapNo(atom2, freeMapNo, false);
                    }
                    this.autoMapReaction();
                }
                if (mapNoChanged) {
                    this.updateAndFireEvent(Math.max(this.mUpdateMode, 1));
                }
                this.mCanvas.repaint();
            }
        }
    }

    private void autoMapReaction() {
        int fragment;
        int atom;
        if (sMapper == null) {
            sMapper = new MCSReactionMapper();
        }
        SSSearcher sss = new SSSearcher(){

            @Override
            public boolean areAtomsSimilar(int moleculeAtom, int fragmentAtom) {
                if (this.mMolecule.getAtomicNo(moleculeAtom) == this.mFragment.getAtomicNo(fragmentAtom)) {
                    if (this.mMolecule.getAtomMass(moleculeAtom) != this.mFragment.getAtomMass(fragmentAtom)) {
                        return false;
                    }
                    if (this.mMolecule.isAromaticAtom(moleculeAtom) || this.mFragment.isAromaticAtom(fragmentAtom)) {
                        return true;
                    }
                }
                return super.areAtomsSimilar(moleculeAtom, fragmentAtom);
            }

            @Override
            public boolean areBondsSimilar(int moleculeBond, int fragmentBond) {
                if (this.mMolecule.isAromaticBond(moleculeBond) || this.mMolecule.isDelocalizedBond(moleculeBond) || this.mFragment.isAromaticBond(fragmentBond) || this.mFragment.isDelocalizedBond(fragmentBond)) {
                    return true;
                }
                return super.areBondsSimilar(moleculeBond, fragmentBond);
            }
        };
        Reaction rxn = this.getReaction();
        TreeMap<Integer, Integer> oldToNewMapNo = new TreeMap<Integer, Integer>();
        int nextMapNo = 1;
        int fakeAtomMassBase = 512;
        int[] fragmentAtom = new int[this.mFragment.length];
        for (atom = 0; atom < this.mMol.getAllAtoms(); ++atom) {
            fragment = this.mFragmentNo[atom];
            this.mFragment[fragment].setAtomMapNo(fragmentAtom[fragment], 0, false);
            if (this.mMol.getAtomMapNo(atom) != 0 && !this.mMol.isAutoMappedAtom(atom)) {
                int manualMapNo = this.mMol.getAtomMapNo(atom);
                Integer newMapNo = (Integer)oldToNewMapNo.get(-manualMapNo);
                if (newMapNo == null) {
                    newMapNo = new Integer(nextMapNo++);
                    oldToNewMapNo.put(-manualMapNo, newMapNo);
                }
                this.mFragment[fragment].setAtomMass(fragmentAtom[fragment], 512 + newMapNo);
            }
            int n = fragment;
            fragmentAtom[n] = fragmentAtom[n] + 1;
        }
        if ((rxn = sMapper.mapReaction(rxn, sss)) != null) {
            fragmentAtom = new int[this.mFragment.length];
            for (atom = 0; atom < this.mMol.getAllAtoms(); ++atom) {
                boolean hasFakeAtomMass;
                fragment = this.mFragmentNo[atom];
                boolean bl = hasFakeAtomMass = this.mFragment[fragment].getAtomMass(fragmentAtom[fragment]) > 512;
                if (hasFakeAtomMass) {
                    int newMapNo = this.mFragment[fragment].getAtomMass(fragmentAtom[fragment]) - 512;
                    this.mFragment[fragment].setAtomMass(fragmentAtom[fragment], this.mMol.getAtomMass(atom));
                    this.mMol.setAtomMapNo(atom, newMapNo, false);
                    this.mFragment[fragment].setAtomMapNo(fragmentAtom[fragment], newMapNo, false);
                } else {
                    int generatedMapNo = this.mFragment[fragment].getAtomMapNo(fragmentAtom[fragment]);
                    Integer newMapNo = 0;
                    if (generatedMapNo != 0 && (newMapNo = (Integer)oldToNewMapNo.get(generatedMapNo)) == null) {
                        newMapNo = new Integer(nextMapNo++);
                        oldToNewMapNo.put(generatedMapNo, newMapNo);
                    }
                    this.mMol.setAtomMapNo(atom, newMapNo, true);
                    this.mFragment[fragment].setAtomMapNo(fragmentAtom[fragment], newMapNo, true);
                }
                int n = fragment;
                fragmentAtom[n] = fragmentAtom[n] + 1;
            }
        } else {
            fragmentAtom = new int[this.mFragment.length];
            for (atom = 0; atom < this.mMol.getAllAtoms(); ++atom) {
                fragment = this.mFragmentNo[atom];
                this.mFragment[fragment].setAtomMass(fragmentAtom[fragment], this.mMol.getAtomMass(atom));
                this.mFragment[fragment].setAtomMapNo(fragmentAtom[fragment], this.mMol.getAtomMapNo(atom), this.mMol.isAutoMappedAtom(atom));
                int n = fragment;
                fragmentAtom[n] = fragmentAtom[n] + 1;
            }
        }
    }

    private boolean qualifiesForESR(int stereoBond) {
        return this.mMol.isStereoBond(stereoBond) && (this.getESRAtom(stereoBond) != -1 || this.getESRBond(stereoBond) != -1);
    }

    private int getESRAtom(int stereoBond) {
        int atom = this.mMol.getBondAtom(0, stereoBond);
        if (this.mMol.getAtomParity(atom) != 0) {
            return this.mMol.isAtomParityPseudo(atom) || this.mMol.getAtomParity(atom) != 1 && this.mMol.getAtomParity(atom) != 2 ? -1 : atom;
        }
        if (this.mMol.getAtomPi(atom) == 1) {
            for (int i = 0; i < this.mMol.getConnAtoms(atom); ++i) {
                int connAtom;
                if (this.mMol.getConnBondOrder(atom, i) != 2 || this.mMol.getAtomPi(connAtom = this.mMol.getConnAtom(atom, i)) != 2 || this.mMol.getAtomParity(connAtom) != 1 && this.mMol.getAtomParity(connAtom) != 2) continue;
                return connAtom;
            }
        }
        return -1;
    }

    private int getESRBond(int stereoBond) {
        int bond = this.mMol.findBINAPChiralityBond(this.mMol.getBondAtom(0, stereoBond));
        if (bond != -1 && this.mMol.getBondParity(bond) != 1 && this.mMol.getBondParity(bond) != 2) {
            bond = -1;
        }
        return bond;
    }

    private void setESRInfo(int stereoBond, int type) {
        int bond;
        int group = -1;
        int atom = this.getESRAtom(stereoBond);
        int n = bond = atom == -1 ? this.getESRBond(stereoBond) : -1;
        if (type != 0) {
            int grp;
            int i;
            int maxGroup = -1;
            for (i = 0; i < this.mMol.getAtoms(); ++i) {
                if (i == atom || this.mMol.getAtomESRType(i) != type || this.mMol.isSelectedBond(stereoBond) && this.mMol.isSelectedAtom(i) || maxGroup >= (grp = this.mMol.getAtomESRGroup(i))) continue;
                maxGroup = grp;
            }
            for (i = 0; i < this.mMol.getBonds(); ++i) {
                if (i == bond || this.mMol.getBondESRType(i) != type || this.mMol.isSelectedBond(stereoBond) && this.mMol.isSelectedBond(i) || maxGroup >= (grp = this.mMol.getBondESRGroup(i))) continue;
                maxGroup = grp;
            }
            if ((atom == -1 ? this.mMol.getBondESRType(bond) : this.mMol.getAtomESRType(atom)) != type) {
                group = Math.min(maxGroup + 1, 31);
            } else {
                int n2 = group = atom == -1 ? this.mMol.getBondESRGroup(bond) : this.mMol.getAtomESRGroup(atom);
                if (this.mMol.isSelectedBond(stereoBond)) {
                    int i2;
                    boolean selectedShareOneGroup = true;
                    for (i2 = 0; i2 < this.mMol.getAtoms(); ++i2) {
                        if (i2 == atom || !this.mMol.isSelectedAtom(i2) || this.mMol.getAtomESRType(i2) != type || this.mMol.getAtomESRGroup(i2) == group) continue;
                        selectedShareOneGroup = false;
                        break;
                    }
                    for (i2 = 0; i2 < this.mMol.getBonds(); ++i2) {
                        if (i2 == bond || !this.mMol.isSelectedBond(i2) || this.mMol.getBondESRType(i2) != type || this.mMol.getBondESRGroup(i2) == group) continue;
                        selectedShareOneGroup = false;
                        break;
                    }
                    if (selectedShareOneGroup) {
                        if (group <= maxGroup) {
                            if (++group == 32) {
                                group = 0;
                            }
                        } else {
                            group = 0;
                        }
                    }
                } else if (group <= maxGroup) {
                    if (++group == 32) {
                        group = 0;
                    }
                } else {
                    group = 0;
                }
            }
        }
        if (this.mMol.isSelectedBond(stereoBond)) {
            for (int i = 0; i < this.mMol.getBonds(); ++i) {
                if (!this.mMol.isSelectedBond(i) || !this.mMol.isStereoBond(i)) continue;
                int a = this.getESRAtom(i);
                int b = this.getESRBond(i);
                if (a != -1) {
                    this.mMol.setAtomESR(a, type, group);
                    continue;
                }
                if (b == -1) continue;
                this.mMol.setBondESR(b, type, group);
            }
        } else if (atom != -1) {
            this.mMol.setAtomESR(atom, type, group);
        } else if (bond != -1) {
            this.mMol.setBondESR(bond, type, group);
        }
    }

    private int findFragment(double x, double y) {
        int fragment = -1;
        double minDistance = Double.MAX_VALUE;
        for (int atom = 0; atom < this.mMol.getAllAtoms(); ++atom) {
            double dy;
            double dx = this.mX1 - this.mMol.getAtomX(atom);
            double distance = Math.sqrt(dx * dx + (dy = this.mY1 - this.mMol.getAtomY(atom)) * dy);
            if (!(distance < 24.0) || !(minDistance > distance)) continue;
            minDistance = distance;
            fragment = this.mFragmentNo[atom];
        }
        return fragment;
    }

    private void suggestNewX2AndY2(int atom) {
        double newAngle = 2.0943951023931953;
        if (atom != -1) {
            int i;
            double[] angle = new double[9];
            for (i = 0; i < this.mMol.getAllConnAtomsPlusMetalBonds(atom); ++i) {
                angle[i] = this.mMol.getBondAngle(atom, this.mMol.getConnAtom(atom, i));
            }
            if (this.mMol.getAllConnAtomsPlusMetalBonds(atom) == 1) {
                newAngle = angle[0] < -2.6179938779914944 ? 1.0471975511965976 : (angle[0] < -1.5707963267948966 ? 2.0943951023931953 : (angle[0] < -0.5235987755982988 ? 1.0471975511965976 : (angle[0] < 0.0 ? 2.0943951023931953 : (angle[0] < 0.5235987755982988 ? -2.0943951023931953 : (angle[0] < 1.5707963267948966 ? -1.0471975511965976 : (angle[0] < 2.6179938779914944 ? -2.0943951023931953 : -1.0471975511965976))))));
            } else {
                for (i = this.mMol.getAllConnAtomsPlusMetalBonds(atom) - 1; i > 0; --i) {
                    for (int j = 0; j < i; ++j) {
                        if (!(angle[j] > angle[j + 1])) continue;
                        double temp = angle[j];
                        angle[j] = angle[j + 1];
                        angle[j + 1] = temp;
                    }
                }
                angle[this.mMol.getAllConnAtomsPlusMetalBonds((int)atom)] = angle[0] + Math.PI * 2;
                int largestNo = 0;
                double largestDiff = 0.0;
                for (int i2 = 0; i2 < this.mMol.getAllConnAtomsPlusMetalBonds(atom); ++i2) {
                    double angleDiff = angle[i2 + 1] - angle[i2];
                    if (!(largestDiff < angleDiff)) continue;
                    largestDiff = angleDiff;
                    largestNo = i2;
                }
                newAngle = (angle[largestNo] + angle[largestNo + 1]) / 2.0;
            }
        }
        double avbl = this.mMol.getAverageBondLength();
        this.mX2 = (atom == -1 ? this.mX1 : this.mMol.getAtomX(atom)) + avbl * (double)((float)Math.sin(newAngle));
        this.mY2 = (atom == -1 ? this.mY1 : this.mMol.getAtomY(atom)) + avbl * (double)((float)Math.cos(newAngle));
    }

    private boolean areAtomsMappingCompatible(int atom1, int atom2) {
        if (this.mMol.isFragment()) {
            boolean isAny2;
            int[] atomList2;
            if ((this.mMol.getAtomQueryFeatures(atom1) & 0x20000000L) != 0L || (this.mMol.getAtomQueryFeatures(atom1) & 0x20000000L) != 0L) {
                return false;
            }
            int[] atomList1 = this.mMol.getAtomList(atom1);
            if (atomList1 == null ^ (atomList2 = this.mMol.getAtomList(atom2)) == null) {
                return false;
            }
            if (atomList1 != null) {
                if (atomList1.length != atomList2.length) {
                    return false;
                }
                for (int i = 0; i < atomList1.length; ++i) {
                    if (atomList1[i] == atomList2[i]) continue;
                    return false;
                }
            }
            boolean isAny1 = (this.mMol.getAtomQueryFeatures(atom1) & 1L) != 0L;
            boolean bl = isAny2 = (this.mMol.getAtomQueryFeatures(atom2) & 1L) != 0L;
            if (isAny1 != isAny2) {
                return false;
            }
        }
        return this.mMol.getAtomicNo(atom1) == this.mMol.getAtomicNo(atom2);
    }

    private boolean trackHiliting(double x, double y, boolean isDragging) {
        boolean repaintNeeded;
        int theAtom = this.mMol.findAtom(x, y);
        int theBond = -1;
        if (isDragging && this.mPendingRequest == 8 && theAtom != -1 && (!this.areAtomsMappingCompatible(this.mAtom1, theAtom) || this.mMol.getAtomMapNo(this.mAtom1) != 0 && this.mMol.getAtomMapNo(this.mAtom1) == this.mMol.getAtomMapNo(theAtom) && !this.mMol.isAutoMappedAtom(this.mAtom1) || this.shareSameReactionSide(this.mAtom1, theAtom))) {
            theAtom = -1;
        }
        if (theAtom != -1) {
            if (this.mCurrentTool == 101 || this.mCurrentTool == 103 || this.mCurrentTool == 102) {
                theBond = this.mMol.getStereoBond(theAtom);
                theAtom = -1;
            } else if (this.mCurrentTool == 19 && theAtom >= this.mMol.getAtoms()) {
                theAtom = -1;
            }
        }
        if (theBond == -1 && theAtom == -1 && this.mCurrentTool != 22 && this.mCurrentTool != 19 && this.mCurrentTool != 3 && this.mCurrentTool != 10 && this.mCurrentTool != 27 && this.mCurrentTool != 16 && this.mCurrentTool != 11 && this.mCurrentTool != 12 && this.mCurrentTool != 13 && this.mCurrentTool != 28 && this.mCurrentTool != 29 && this.mCurrentTool != 30 && this.mCurrentTool != 14 && this.mCurrentTool != 31 && this.mCurrentTool != 15 && this.mCurrentTool != 32 && this.mCurrentTool != 33) {
            theBond = this.mMol.findBond(x, y);
        }
        if (!(theBond == -1 || this.mCurrentTool != 101 && this.mCurrentTool != 103 && this.mCurrentTool != 102 || this.qualifiesForESR(theBond))) {
            theBond = -1;
        }
        AbstractDrawingObject hiliteObject = this.mCurrentHiliteObject;
        if (!isDragging && this.mDrawingObjectList != null) {
            hiliteObject = null;
            if (theAtom == -1 && theBond == -1 && (this.mCurrentTool == 2 || this.mCurrentTool == 4 || this.mCurrentTool == 21)) {
                for (AbstractDrawingObject theObject : this.mDrawingObjectList) {
                    if (this.mCurrentTool != 2 && (this.mCurrentTool != 4 || theObject instanceof ReactionArrow) && (this.mCurrentTool != 21 || !(theObject instanceof TextDrawingObject)) || !theObject.checkHiliting(x, y)) continue;
                    hiliteObject = theObject;
                    if (this.mCurrentHiliteObject == null || this.mCurrentHiliteObject == theObject) break;
                    this.mCurrentHiliteObject.clearHiliting();
                    break;
                }
            }
        }
        boolean bl = repaintNeeded = this.mCurrentHiliteAtom != theAtom || this.mCurrentHiliteBond != theBond || this.mCurrentHiliteObject != hiliteObject || hiliteObject != null;
        if (this.mCurrentHiliteAtom != theAtom) {
            if (this.mCurrentHiliteAtom != -1 && this.mAtomKeyStrokeBuffer.length() != 0) {
                this.expandAtomKeyStrokes(this.mAtomKeyStrokeBuffer.toString());
            }
            this.mCurrentHiliteAtom = theAtom;
            this.mAtomKeyStrokeBuffer.setLength(0);
            this.fireEventLater(new EditorEvent(this, 4, true));
        }
        if (this.mCurrentHiliteBond != theBond) {
            this.mCurrentHiliteBond = theBond;
            this.fireEventLater(new EditorEvent(this, 8, true));
        }
        this.mCurrentHiliteObject = hiliteObject;
        return repaintNeeded;
    }

    private int getAtomKeyStrokeValidity(String s) {
        if (Molecule.getAtomicNoFromLabel(s) != 0) {
            return 1;
        }
        this.mAtomKeyStrokeSuggestion = NamedSubstituents.identify(s);
        if (this.mAtomKeyStrokeSuggestion == null) {
            return this.isValidAtomKeyStrokeStart(s) ? 3 : 4;
        }
        if (this.mAtomKeyStrokeSuggestion.length() == 0) {
            return 3;
        }
        return 2;
    }

    private boolean isValidAtomKeyStrokeStart(String s) {
        if (s.length() < 3) {
            for (int i = 1; i < Molecule.cAtomLabel.length; ++i) {
                if (!Molecule.cAtomLabel[i].startsWith(s)) continue;
                return true;
            }
        }
        return false;
    }

    private void expandAtomKeyStrokes(String keyStrokes) {
        StereoMolecule substituent;
        this.mAtomKeyStrokeBuffer.setLength(0);
        int atomicNo = Molecule.getAtomicNoFromLabel(keyStrokes);
        if (atomicNo != 0) {
            this.storeState();
            if (this.mMol.changeAtom(this.mCurrentHiliteAtom, atomicNo, 0, -1, 0)) {
                this.updateAndFireEvent(3);
                return;
            }
        }
        if (this.mAtomKeyStrokeSuggestion != null && this.mAtomKeyStrokeSuggestion.length() != 0) {
            keyStrokes = this.mAtomKeyStrokeSuggestion;
        }
        if ((substituent = NamedSubstituents.getSubstituent(keyStrokes)) != null) {
            this.storeState();
            StereoMolecule fragment = new StereoMolecule();
            fragment.addFragment(this.mMol, this.mCurrentHiliteAtom, null);
            double sourceAVBL = fragment.getAverageBondLength();
            int firstAtomInFragment = fragment.getAllAtoms();
            for (int atom = 0; atom < fragment.getAllAtoms(); ++atom) {
                fragment.setAtomMarker(atom, true);
            }
            fragment.addSubstituent(substituent, 0);
            new CoordinateInventor(4).invent(fragment);
            double dx = this.mMol.getAtomX(this.mCurrentHiliteAtom) - sourceAVBL * fragment.getAtomX(0);
            double dy = this.mMol.getAtomY(this.mCurrentHiliteAtom) - sourceAVBL * fragment.getAtomY(0);
            int firstAtomInMol = this.mMol.getAllAtoms();
            this.mMol.addSubstituent(substituent, this.mCurrentHiliteAtom);
            int substituentAtoms = this.mMol.getAllAtoms() - firstAtomInMol;
            for (int i = 0; i < substituentAtoms; ++i) {
                this.mMol.setAtomX(firstAtomInMol + i, sourceAVBL * fragment.getAtomX(firstAtomInFragment + i) + dx);
                this.mMol.setAtomY(firstAtomInMol + i, sourceAVBL * fragment.getAtomY(firstAtomInFragment + i) + dy);
            }
            this.mMol.setStereoBondsFromParity();
            this.updateAndFireEvent(3);
        }
    }

    private AbstractDrawingObject findDrawingObject(double x, double y, String type, boolean forDeletion) {
        if (this.mDrawingObjectList != null) {
            for (AbstractDrawingObject drawingObject : this.mDrawingObjectList) {
                if (type != null && (!type.equals(drawingObject.getTypeString()) || forDeletion) && !drawingObject.isDeletable() || !drawingObject.contains(x, y)) continue;
                return drawingObject;
            }
        }
        return null;
    }

    private void editTextObject(TextDrawingObject object) {
        new TextDrawingObjectDialogBuilder(this.mUIHelper, object);
        boolean nonWhiteSpaceFound = false;
        for (int i = 0; i < object.getText().length(); ++i) {
            if (Character.isWhitespace(object.getText().charAt(i))) continue;
            nonWhiteSpaceFound = true;
            break;
        }
        if (!nonWhiteSpaceFound) {
            this.mDrawingObjectList.remove(object);
        }
        this.mCanvas.repaint();
    }

    private boolean shareSameReactionSide(int atom1, int atom2) {
        ReactionArrow arrow = (ReactionArrow)this.mDrawingObjectList.get(0);
        return !(arrow.isOnProductSide(this.mMol.getAtomX(atom1), this.mMol.getAtomY(atom1)) ^ arrow.isOnProductSide(this.mMol.getAtomX(atom2), this.mMol.getAtomY(atom2)));
    }

    protected void restoreState() {
        if (this.mUndoMol == null) {
            return;
        }
        this.mUndoMol.copyMolecule(this.mMol);
        this.mDrawingObjectList = this.mUndoDrawingObjectList == null ? null : new DrawingObjectList(this.mUndoDrawingObjectList);
    }

    public void storeState() {
        if (this.mUndoMol == null) {
            this.mUndoMol = new Molecule();
        }
        this.mMol.copyMolecule(this.mUndoMol);
        this.mUndoDrawingObjectList = this.mDrawingObjectList == null ? null : new DrawingObjectList(this.mDrawingObjectList);
    }

    private boolean deleteHilited() {
        if (this.mCurrentHiliteAtom != -1) {
            this.mMol.deleteAtom(this.mCurrentHiliteAtom);
            this.mCurrentHiliteAtom = -1;
            this.updateAndFireEvent(1);
            return true;
        }
        if (this.mCurrentHiliteBond != -1) {
            this.mMol.deleteBondAndSurrounding(this.mCurrentHiliteBond);
            this.mCurrentHiliteBond = -1;
            this.updateAndFireEvent(1);
            return true;
        }
        if (this.mCurrentHiliteObject != null && this.mCurrentHiliteObject.isDeletable()) {
            this.mDrawingObjectList.remove(this.mCurrentHiliteObject);
            this.mCurrentHiliteObject = null;
            this.update(1);
            return true;
        }
        return false;
    }

    private boolean deleteAt(double x, double y) {
        if (this.mMol.deleteAtomOrBond(x, y)) {
            this.updateAndFireEvent(1);
            return true;
        }
        AbstractDrawingObject drawingObject = this.findDrawingObject(x, y, null, true);
        if (drawingObject != null) {
            this.mDrawingObjectList.remove(drawingObject);
            this.mCurrentHiliteObject = null;
            this.update(1);
            return true;
        }
        return false;
    }

    private void duplicateSelected() {
        int atom;
        int atomCount = 0;
        for (int atom2 = 0; atom2 < this.mMol.getAllAtoms(); ++atom2) {
            if (!this.mMol.isSelectedAtom(atom2)) continue;
            ++atomCount;
        }
        int originalAtoms = this.mMol.getAllAtoms();
        int originalBonds = this.mMol.getAllBonds();
        this.mX = Arrays.copyOf(this.mX, this.mX.length + atomCount);
        this.mY = Arrays.copyOf(this.mY, this.mY.length + atomCount);
        int[] atomMap = new int[this.mMol.getAllAtoms()];
        int esrGroupCountAND = this.mMol.renumberESRGroups(1);
        int esrGroupCountOR = this.mMol.renumberESRGroups(2);
        for (atom = 0; atom < originalAtoms; ++atom) {
            if (!this.mMol.isSelectedAtom(atom)) continue;
            int newAtom = this.mMol.getAllAtoms();
            this.mX[newAtom] = this.mX[atom];
            this.mY[newAtom] = this.mY[atom];
            atomMap[atom] = newAtom;
            this.mMol.copyAtom(this.mMol, atom, esrGroupCountAND, esrGroupCountOR);
        }
        for (int bond = 0; bond < originalBonds; ++bond) {
            if (!this.mMol.isSelectedBond(bond)) continue;
            this.mMol.copyBond(this.mMol, bond, esrGroupCountAND, esrGroupCountOR, atomMap, false);
        }
        for (atom = 0; atom < originalAtoms; ++atom) {
            this.mMol.setAtomSelection(atom, false);
        }
        for (atom = originalAtoms; atom < this.mMol.getAllAtoms(); ++atom) {
            this.mMol.setAtomMapNo(atom, 0, false);
        }
        if (this.mDrawingObjectList != null) {
            for (int i = this.mDrawingObjectList.size() - 1; i >= 0; --i) {
                AbstractDrawingObject object = (AbstractDrawingObject)this.mDrawingObjectList.get(i);
                if (!object.isSelected() || object instanceof ReactionArrow) continue;
                this.mDrawingObjectList.add(object.clone());
            }
        }
    }

    private void fireEventLater(EditorEvent e) {
        int what = e.getWhat();
        if ((what & this.mEventsScheduled) == 0) {
            this.mUIHelper.runLater(() -> {
                this.mEventsScheduled &= ~what;
                for (GenericEventListener l : this.mListeners) {
                    l.eventHappened(e);
                }
            });
            this.mEventsScheduled |= what;
        }
    }

    public void moleculeChanged() {
        this.update(4);
        this.fireEventLater(new EditorEvent(this, 1, false));
    }

    private void updateAndFireEvent(int updateMode) {
        this.update(updateMode);
        this.fireEventLater(new EditorEvent(this, 1, true));
    }

    public StereoMolecule getMolecule() {
        return this.mMol;
    }

    public void setMolecule(StereoMolecule theMolecule) {
        if (this.mMol == theMolecule) {
            return;
        }
        this.mMol = theMolecule;
        this.mMode = 0;
        this.mDrawingObjectList = null;
        this.storeState();
        this.moleculeChanged();
    }

    public StereoMolecule[] getFragments() {
        return this.mFragment;
    }

    public void setFragments(StereoMolecule[] fragment) {
        this.mMol.clear();
        this.mFragment = fragment;
        for (int i = 0; i < fragment.length; ++i) {
            this.mMol.addMolecule(this.mFragment[i]);
        }
        this.storeState();
        this.mFragmentNo = new int[this.mMol.getAllAtoms()];
        int atom = 0;
        for (int f = 0; f < this.mFragment.length; ++f) {
            for (int j = 0; j < this.mFragment[f].getAllAtoms(); ++j) {
                this.mFragmentNo[atom++] = f;
            }
        }
        this.mMode = 1;
        this.mDrawingObjectList = null;
        this.update(5);
        this.fireEventLater(new EditorEvent(this, 1, false));
    }

    public Reaction getReaction() {
        if ((this.mMode & 4) == 0 || this.mFragment == null) {
            return null;
        }
        Reaction rxn = new Reaction();
        for (int i = 0; i < this.mFragment.length; ++i) {
            if (i < this.mReactantCount) {
                rxn.addReactant(this.mFragment[i]);
                continue;
            }
            rxn.addProduct(this.mFragment[i]);
        }
        return rxn;
    }

    public Reaction getReactionAndDrawings() {
        Reaction rxn = this.getReaction();
        if (rxn != null) {
            rxn.setDrawingObjects(this.getDrawingObjects());
        }
        return rxn;
    }

    public void setReaction(Reaction rxn) {
        this.mMol.clear();
        this.mFragment = new StereoMolecule[rxn.getMolecules()];
        this.mReactantCount = rxn.getReactants();
        for (int i = 0; i < rxn.getMolecules(); ++i) {
            this.mFragment[i] = rxn.getMolecule(i);
            this.mMol.addMolecule(this.mFragment[i]);
        }
        this.mMol.setFragment(rxn.isFragment());
        this.storeState();
        this.mFragmentNo = new int[this.mMol.getAllAtoms()];
        int atom = 0;
        for (int f = 0; f < this.mFragment.length; ++f) {
            for (int j = 0; j < this.mFragment[f].getAllAtoms(); ++j) {
                this.mFragmentNo[atom++] = f;
            }
        }
        this.mDrawingObjectList = new DrawingObjectList();
        this.mMode = 5;
        this.update(5);
        this.fireEventLater(new EditorEvent(this, 1, false));
    }

    public MarkushStructure getMarkushStructure() {
        if ((this.mMode & 2) == 0) {
            return null;
        }
        MarkushStructure markush = new MarkushStructure();
        for (int i = 0; i < this.mFragment.length; ++i) {
            if (i < this.mReactantCount) {
                markush.addCore(this.mFragment[i]);
                continue;
            }
            markush.addRGroup(this.mFragment[i]);
        }
        return markush;
    }

    public void setMarkushStructure(MarkushStructure markush) {
        this.mMol.clear();
        this.mFragment = new StereoMolecule[markush.getCoreCount() + markush.getRGroupCount()];
        this.mReactantCount = markush.getCoreCount();
        boolean isFragment = false;
        for (int i = 0; i < markush.getCoreCount() + markush.getRGroupCount(); ++i) {
            this.mFragment[i] = i < markush.getCoreCount() ? markush.getCoreStructure(i) : markush.getRGroup(i - markush.getCoreCount());
            isFragment |= this.mFragment[i].isFragment();
            this.mMol.addMolecule(this.mFragment[i]);
        }
        this.mMol.setFragment(isFragment);
        this.storeState();
        this.mFragmentNo = new int[this.mMol.getAllAtoms()];
        int atom = 0;
        for (int f = 0; f < this.mFragment.length; ++f) {
            for (int j = 0; j < this.mFragment[f].getAllAtoms(); ++j) {
                this.mFragmentNo[atom++] = f;
            }
        }
        this.mMode = 3;
        this.update(5);
        this.fireEventLater(new EditorEvent(this, 1, false));
    }

    public int getDisplayMode() {
        return this.mDisplayMode;
    }

    public void setDisplayMode(int dMode) {
        this.mDisplayMode = dMode;
        this.update(1);
    }

    public void setAllowQueryFeatures(boolean allow) {
        if (this.mAllowQueryFeatures != allow) {
            this.mAllowQueryFeatures = allow;
            if (!allow) {
                this.mMol.removeQueryFeatures();
            }
        }
    }

    public void setAtomText(String[] atomText) {
        this.mAtomText = atomText;
    }

    public DrawingObjectList getDrawingObjects() {
        return this.mDrawingObjectList;
    }

    public void setDrawingObjects(DrawingObjectList drawingObjectList) {
        this.mDrawingObjectList = drawingObjectList;
        this.storeState();
        this.update(4);
    }

    public int getMode() {
        return this.mMode;
    }

    public int getHiliteAtom() {
        return this.mCurrentHiliteAtom;
    }

    public int getHiliteBond() {
        return this.mCurrentHiliteBond;
    }

    public void setHiliteBondSet(int[] bondSet) {
        this.mHiliteBondSet = bondSet;
        this.update(1);
    }

    public void setReactionMode(boolean rxn) {
        if (rxn) {
            StereoMolecule[] m = this.getFragments();
            if (m == null) {
                this.setReaction(new Reaction(new StereoMolecule[]{new StereoMolecule(this.getMolecule())}, 1));
            } else {
                this.mMode = 5;
                Reaction r = this.getReaction();
                this.setReaction(r);
            }
        } else {
            this.mMode &= 0xFFFFFFFB;
        }
    }

    protected void setUpdateMode(int mode) {
        this.mUpdateMode = mode;
    }

    public boolean isAtomColorSupported() {
        return this.mAtomColorSupported;
    }

    public void setAtomColorSupported(boolean acs) {
        this.mAtomColorSupported = acs;
    }

    private void cleanupCoordinates(GenericDrawContext context) {
        boolean selectedOnly;
        int selectedAtomCount = 0;
        for (int atom = 0; atom < this.mMol.getAllAtoms(); ++atom) {
            if (!this.mMol.isSelectedAtom(atom)) continue;
            ++selectedAtomCount;
        }
        boolean bl = selectedOnly = selectedAtomCount != 0 && selectedAtomCount != this.mMol.getAllAtoms();
        if ((this.mMode & 1) != 0) {
            this.cleanupMultiFragmentCoordinates(context, selectedOnly);
        } else {
            this.cleanupMoleculeCoordinates(context, selectedOnly);
        }
    }

    private void cleanupMoleculeCoordinates(GenericDrawContext context, boolean selectedOnly) {
        if (this.mUpdateMode == 6) {
            if (selectedOnly) {
                for (int atom = 0; atom < this.mMol.getAllAtoms(); ++atom) {
                    this.mMol.setAtomMarker(atom, !this.mMol.isSelectedAtom(atom));
                }
            }
            new CoordinateInventor(selectedOnly ? 4 : 0).invent(this.mMol);
            if (selectedOnly) {
                this.mMol.removeAtomMarkers();
            }
        }
        this.mDepictor.updateCoords(context, new GenericRectangle(0.0, 0.0, this.mCanvas.getCanvasWidth(), this.mCanvas.getCanvasHeight()), this.maxUpdateMode());
    }

    private void cleanupMultiFragmentCoordinates(GenericDrawContext context, boolean selectedOnly) {
        if (selectedOnly && this.mUpdateMode == 6) {
            int[] fragmentAtom = new int[this.mFragment.length];
            for (int atom = 0; atom < this.mMol.getAllAtoms(); ++atom) {
                int fragment = this.mFragmentNo[atom];
                this.mFragment[fragment].setAtomMarker(fragmentAtom[fragment], !this.mMol.isSelectedAtom(atom));
                int n = fragment;
                fragmentAtom[n] = fragmentAtom[n] + 1;
            }
        }
        GenericRectangle[] boundingRect = new GenericRectangle[this.mFragment.length];
        for (int fragment = 0; fragment < this.mFragment.length; ++fragment) {
            if (this.mUpdateMode == 6) {
                new CoordinateInventor(selectedOnly ? 4 : 0).invent(this.mFragment[fragment]);
                this.mFragment[fragment].setStereoBondsFromParity();
            }
            GenericDepictor d = new GenericDepictor(this.mFragment[fragment]);
            d.updateCoords(context, null, 65536);
            boundingRect[fragment] = d.getBoundingRect();
        }
        double spacing = 36.0;
        double avbl = this.mMol.getAverageBondLength();
        double arrowWidth = (this.mMode & 4) == 0 ? 0.0 : (this.mUpdateMode == 5 ? (double)0.08f * this.mCanvas.getCanvasWidth() : (double)(((ReactionArrow)this.mDrawingObjectList.get(0)).getLength() * 24.0f) / avbl);
        double rawX = 0.5 * spacing;
        for (int fragment = 0; fragment <= this.mFragment.length; ++fragment) {
            if ((this.mMode & 4) != 0 && fragment == this.mReactantCount) {
                ((ReactionArrow)this.mDrawingObjectList.get(0)).setCoordinates(rawX - spacing / 2.0, this.mCanvas.getCanvasHeight() / 2.0, rawX - spacing / 2.0 + arrowWidth, this.mCanvas.getCanvasHeight() / 2.0);
                rawX += arrowWidth;
            }
            if (fragment == this.mFragment.length) break;
            double dx = rawX - boundingRect[fragment].x;
            double dy = 0.5 * (this.mCanvas.getCanvasHeight() - boundingRect[fragment].height) - boundingRect[fragment].y;
            this.mFragment[fragment].translateCoords(dx, dy);
            rawX += spacing + boundingRect[fragment].width;
        }
        this.mDepictor.updateCoords(context, new GenericRectangle(0.0, 0.0, this.mCanvas.getCanvasWidth(), this.mCanvas.getCanvasHeight()), this.maxUpdateMode());
        int[] fragmentAtom = new int[this.mFragment.length];
        for (int atom = 0; atom < this.mMol.getAllAtoms(); ++atom) {
            int fragment = this.mFragmentNo[atom];
            this.mMol.setAtomX(atom, this.mFragment[fragment].getAtomX(fragmentAtom[fragment]));
            this.mMol.setAtomY(atom, this.mFragment[fragment].getAtomY(fragmentAtom[fragment]));
            int n = fragment;
            fragmentAtom[n] = fragmentAtom[n] + 1;
        }
        this.mMol.setStereoBondsFromParity();
    }

    private void analyzeFragmentMembership() {
        this.mMol.ensureHelperArrays(15);
        int[] fragmentNo = new int[this.mMol.getAllAtoms()];
        int fragments = this.mMol.getFragmentNumbers(fragmentNo, false, true);
        fragments = this.joinCloseFragments(fragmentNo, fragments);
        this.sortFragmentsByPosition(fragmentNo, fragments);
        this.mFragmentNo = fragmentNo;
        this.mFragment = this.mMol.getFragments(fragmentNo, fragments);
    }

    private int joinCloseFragments(int[] fragmentNo, int fragments) {
        if (fragments < 2) {
            return fragments;
        }
        boolean[][] mergeFragments = new boolean[fragments][];
        for (int i = 1; i < fragments; ++i) {
            mergeFragments[i] = new boolean[i];
        }
        double avbl = this.mMol.getAverageBondLength();
        for (int atom1 = 1; atom1 < this.mMol.getAllAtoms(); ++atom1) {
            for (int atom2 = 0; atom2 < atom1; ++atom2) {
                int fragment2;
                int fragment1;
                double dy;
                double dx = this.mMol.getAtomX(atom2) - this.mMol.getAtomX(atom1);
                double distance = Math.sqrt(dx * dx + (dy = this.mMol.getAtomY(atom2) - this.mMol.getAtomY(atom1)) * dy);
                if (!(distance < (double)1.4f * avbl) || (fragment1 = fragmentNo[atom1]) == (fragment2 = fragmentNo[atom2])) continue;
                if (fragment1 > fragment2) {
                    mergeFragments[fragment1][fragment2] = true;
                    continue;
                }
                mergeFragments[fragment2][fragment1] = true;
            }
        }
        int[] newFragmentIndex = new int[fragments];
        for (int fragment = 0; fragment < fragments; ++fragment) {
            newFragmentIndex[fragment] = fragment;
        }
        int mergeCount = 0;
        for (int i = 1; i < fragments; ++i) {
            for (int j = 0; j < i; ++j) {
                int index2;
                int index1;
                if (!mergeFragments[i][j] || (index1 = newFragmentIndex[i]) == (index2 = newFragmentIndex[j])) continue;
                ++mergeCount;
                int minIndex = Math.min(index1, index2);
                int maxIndex = Math.max(index1, index2);
                for (int k = 0; k < fragments; ++k) {
                    if (newFragmentIndex[k] == maxIndex) {
                        newFragmentIndex[k] = minIndex;
                        continue;
                    }
                    if (newFragmentIndex[k] <= maxIndex) continue;
                    int n = k;
                    newFragmentIndex[n] = newFragmentIndex[n] - 1;
                }
            }
        }
        for (int atom = 0; atom < this.mMol.getAllAtoms(); ++atom) {
            fragmentNo[atom] = newFragmentIndex[fragmentNo[atom]];
        }
        return fragments - mergeCount;
    }

    private void sortFragmentsByPosition(int[] fragmentNo, int fragments) {
        int[][] fragmentDescriptor = new int[fragments][(this.mMode & 6) != 0 ? 2 : 1];
        for (int fragment = 0; fragment < fragments; ++fragment) {
            fragmentDescriptor[fragment][0] = fragment;
        }
        Point[] fragmentCOG = this.calculateFragmentCenterOfGravity(fragmentNo, fragments);
        if ((this.mMode & 4) != 0) {
            this.mReactantCount = 0;
            ReactionArrow arrow = (this.mMode & 4) != 0 ? (ReactionArrow)this.mDrawingObjectList.get(0) : null;
            for (int fragment = 0; fragment < fragments; ++fragment) {
                int n = fragmentDescriptor[fragment][1] = arrow.isOnProductSide(fragmentCOG[fragment].x, fragmentCOG[fragment].y) ? 1 : 0;
                if (fragmentDescriptor[fragment][1] != 0) continue;
                ++this.mReactantCount;
            }
        } else if ((this.mMode & 2) != 0) {
            this.mReactantCount = fragments;
            for (int atom = 0; atom < this.mMol.getAllAtoms(); ++atom) {
                if (this.mMol.getAtomicNo(atom) != 0 || fragmentDescriptor[fragmentNo[atom]][1] != 0) continue;
                fragmentDescriptor[fragmentNo[atom]][1] = 1;
                --this.mReactantCount;
            }
        }
        final Point[] cog = fragmentCOG;
        Arrays.sort(fragmentDescriptor, new Comparator<int[]>(){

            @Override
            public int compare(int[] fragmentDescriptor1, int[] fragmentDescriptor2) {
                if ((GenericEditorArea.this.mMode & 6) != 0 && fragmentDescriptor1[1] != fragmentDescriptor2[1]) {
                    return fragmentDescriptor1[1] == 0 ? -1 : 1;
                }
                return cog[fragmentDescriptor1[0]].x + cog[fragmentDescriptor1[0]].y < cog[fragmentDescriptor2[0]].x + cog[fragmentDescriptor2[0]].y ? -1 : 1;
            }
        });
        int[] newFragmentIndex = new int[fragments];
        Point[] centerOfGravity = new Point[fragments];
        for (int fragment = 0; fragment < fragments; ++fragment) {
            int oldIndex = fragmentDescriptor[fragment][0];
            newFragmentIndex[oldIndex] = fragment;
            centerOfGravity[fragment] = fragmentCOG[oldIndex];
        }
        fragmentCOG = centerOfGravity;
        for (int atom1 = 0; atom1 < this.mMol.getAllAtoms(); ++atom1) {
            fragmentNo[atom1] = newFragmentIndex[fragmentNo[atom1]];
        }
    }

    private Point[] calculateFragmentCenterOfGravity(int[] fragmentNo, int fragments) {
        int fragment;
        Point[] fragmentCOG = new Point[fragments];
        int[] fragmentAtoms = new int[fragments];
        for (fragment = 0; fragment < fragments; ++fragment) {
            fragmentCOG[fragment] = new Point(0, 0);
        }
        for (int atom = 0; atom < this.mMol.getAllAtoms(); ++atom) {
            fragmentCOG[fragmentNo[atom]].x = (int)((double)fragmentCOG[fragmentNo[atom]].x + this.mMol.getAtomX(atom));
            fragmentCOG[fragmentNo[atom]].y = (int)((double)fragmentCOG[fragmentNo[atom]].y + this.mMol.getAtomY(atom));
            int n = fragmentNo[atom];
            fragmentAtoms[n] = fragmentAtoms[n] + 1;
        }
        for (fragment = 0; fragment < fragments; ++fragment) {
            fragmentCOG[fragment].x /= fragmentAtoms[fragment];
            fragmentCOG[fragment].y /= fragmentAtoms[fragment];
        }
        return fragmentCOG;
    }

    private void updateCursor() {
        int cursor = -1;
        switch (this.mCurrentTool) {
            case 18: {
                cursor = 9;
                break;
            }
            case 2: {
                if (this.mCurrentHiliteAtom != -1 && this.mMol.isSelectedAtom(this.mCurrentHiliteAtom) || this.mCurrentHiliteBond != -1 && this.mMol.isSelectedBond(this.mCurrentHiliteBond)) {
                    cursor = this.mMouseIsDown ? 4 : (this.mShiftIsDown ? 3 : 2);
                    break;
                }
                if (this.mCurrentHiliteAtom != -1 || this.mCurrentHiliteBond != -1) {
                    cursor = 11;
                    break;
                }
                if (this.mCurrentHiliteObject != null) {
                    cursor = this.mMouseIsDown ? 4 : (this.mShiftIsDown && !(this.mCurrentHiliteObject instanceof ReactionArrow) ? 3 : 2);
                    break;
                }
                cursor = this.mShiftIsDown ? (this.mAltIsDown ? 8 : 6) : (this.mAltIsDown ? 7 : 5);
                break;
            }
            case 4: {
                cursor = 1;
                break;
            }
            case 22: {
                cursor = 0;
                break;
            }
            case 21: {
                cursor = 12;
                break;
            }
            default: {
                cursor = 11;
            }
        }
        if (this.mCurrentCursor != cursor) {
            this.mCurrentCursor = cursor;
            this.mUIHelper.setCursor(cursor);
        }
    }

    private int maxUpdateMode() {
        return 65536 + HiDPIHelper.scale(24.0f);
    }

    private Point2D calculateCenterOfGravity(boolean selectedOnly) {
        int atoms = 0;
        double sumx = 0.0;
        double sumy = 0.0;
        for (int atom = 0; atom < this.mMol.getAllAtoms(); ++atom) {
            if (selectedOnly && !this.mMol.isSelectedAtom(atom)) continue;
            sumx += this.mMol.getAtomX(atom);
            sumy += this.mMol.getAtomY(atom);
            ++atoms;
        }
        return atoms > 1 ? new Point2D.Double(sumx / (double)atoms, sumy / (double)atoms) : null;
    }

    private void rotate180() {
        Point2D cog;
        boolean selectedOnly = false;
        for (int atom = 0; atom < this.mMol.getAllAtoms(); ++atom) {
            if (!this.mMol.isSelectedAtom(atom)) continue;
            selectedOnly = true;
            break;
        }
        if ((cog = this.calculateCenterOfGravity(selectedOnly)) != null) {
            this.storeState();
            for (int atom = 0; atom < this.mMol.getAllAtoms(); ++atom) {
                if (selectedOnly && !this.mMol.isSelectedAtom(atom)) continue;
                this.mMol.setAtomX(atom, 2.0 * cog.getX() - this.mMol.getAtomX(atom));
                this.mMol.setAtomY(atom, 2.0 * cog.getY() - this.mMol.getAtomY(atom));
            }
            this.update(1);
        }
    }

    private void flip(boolean horiz) {
        Point2D cog;
        boolean selectedOnly = false;
        for (int atom = 0; atom < this.mMol.getAllAtoms(); ++atom) {
            if (!this.mMol.isSelectedAtom(atom)) continue;
            selectedOnly = true;
            break;
        }
        if ((cog = this.calculateCenterOfGravity(selectedOnly)) != null) {
            this.storeState();
            for (int atom = 0; atom < this.mMol.getAllAtoms(); ++atom) {
                if (selectedOnly && !this.mMol.isSelectedAtom(atom)) continue;
                if (horiz) {
                    this.mMol.setAtomX(atom, 2.0 * cog.getX() - this.mMol.getAtomX(atom));
                    continue;
                }
                this.mMol.setAtomY(atom, 2.0 * cog.getY() - this.mMol.getAtomY(atom));
            }
            for (int bond = 0; bond < this.mMol.getAllBonds(); ++bond) {
                if (selectedOnly && !this.mMol.isSelectedBond(bond)) continue;
                if (this.mMol.getBondType(bond) == 17) {
                    this.mMol.setBondType(bond, 9);
                    continue;
                }
                if (this.mMol.getBondType(bond) != 9) continue;
                this.mMol.setBondType(bond, 17);
            }
            this.update(1);
        }
    }
}

