/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.gui.editor;

import com.actelion.research.gui.LookAndFeelHelper;
import com.actelion.research.gui.editor.GenericEditorArea;
import com.actelion.research.gui.generic.GenericCanvas;
import com.actelion.research.gui.generic.GenericDrawContext;
import com.actelion.research.gui.generic.GenericEventListener;
import com.actelion.research.gui.generic.GenericImage;
import com.actelion.research.gui.generic.GenericMouseEvent;
import com.actelion.research.gui.hidpi.HiDPIHelper;
import com.actelion.research.util.ColorHelper;

public class GenericEditorToolbar
implements GenericEventListener<GenericMouseEvent> {
    protected static final int cButtonsPerColumn = 17;
    protected static final int cImageOversize = 4;
    protected static final int cButtonClear = 0;
    protected static final int cButtonCleanStructure = 1;
    public static final int cToolLassoPointer = 2;
    protected static final int cToolUnknownParity = 3;
    protected static final int cToolDelete = 4;
    protected static final int cToolStdBond = 5;
    protected static final int cToolUpBond = 6;
    protected static final int cTool3Ring = 7;
    protected static final int cTool5Ring = 8;
    protected static final int cTool7Ring = 9;
    protected static final int cToolPosCharge = 10;
    protected static final int cToolAtomC = 11;
    protected static final int cToolAtomN = 12;
    protected static final int cToolAtomO = 13;
    protected static final int cToolAtomF = 14;
    protected static final int cToolAtomBr = 15;
    protected static final int cToolAtomH = 16;
    protected static final int cButtonUndo = 17;
    protected static final int cToolZoom = 18;
    protected static final int cToolMapper = 19;
    protected static final int cToolESR = 20;
    protected static final int cToolText = 21;
    protected static final int cToolChain = 22;
    protected static final int cToolDownBond = 23;
    protected static final int cTool4Ring = 24;
    protected static final int cTool6Ring = 25;
    protected static final int cToolAromRing = 26;
    protected static final int cToolNegCharge = 27;
    protected static final int cToolAtomSi = 28;
    protected static final int cToolAtomP = 29;
    protected static final int cToolAtomS = 30;
    protected static final int cToolAtomCl = 31;
    protected static final int cToolAtomI = 32;
    protected static final int cToolCustomAtom = 33;
    protected static final int cBorder = Math.round(HiDPIHelper.scale(2.0f));
    protected static final float cButtonSize = HiDPIHelper.getUIScaleFactor() * 21.0f;
    protected static final int cToolESRAbs = 101;
    protected static final int cToolESROr = 102;
    protected static final int cToolESRAnd = 103;
    private GenericCanvas mToolbarCanvas;
    private GenericEditorArea mArea;
    private GenericImage mImageNormal;
    private GenericImage mImageDisabled;
    private GenericImage mESRImageNormal;
    protected int mWidth;
    protected int mHeight;
    protected int mCurrentTool;
    protected int mSelectedButton;
    protected int mHighlightedButton;
    protected int mESRSelected;

    public GenericEditorToolbar(GenericCanvas toolbarCanvas, GenericEditorArea theArea) {
        this(toolbarCanvas, theArea, 0);
    }

    public GenericEditorToolbar(GenericCanvas toolbarCanvas, GenericEditorArea theArea, int mode) {
        this.mToolbarCanvas = toolbarCanvas;
        this.mArea = theArea;
        this.init(mode);
    }

    public int getWidth() {
        return this.mWidth;
    }

    public int getHeight() {
        return this.mHeight;
    }

    private void init(int mode) {
        this.mImageNormal = this.mArea.getUIHelper().createImage("editorButtons.png");
        if (LookAndFeelHelper.isDarkLookAndFeel()) {
            HiDPIHelper.adaptForLookAndFeel(this.mImageNormal);
        }
        this.mImageDisabled = this.mArea.getUIHelper().createImage("editorButtons.png");
        HiDPIHelper.disableImage(this.mImageDisabled);
        this.mWidth = 2 * cBorder + HiDPIHelper.scale(this.mImageNormal.getWidth() / 4);
        this.mHeight = 2 * cBorder + HiDPIHelper.scale(this.mImageNormal.getHeight() / 4);
        this.mESRImageNormal = this.mArea.getUIHelper().createImage("esrButtons.png");
        this.scaleImages();
        this.mCurrentTool = 5;
        this.mSelectedButton = -1;
        this.mHighlightedButton = -1;
    }

    private void scaleImages() {
        int width = HiDPIHelper.scale(this.mImageNormal.getWidth() / 4);
        int height = HiDPIHelper.scale(this.mImageNormal.getHeight() / 4);
        this.mImageDisabled.scale(width, height);
        this.mImageNormal.scale(width, height);
        width = HiDPIHelper.scale(this.mESRImageNormal.getWidth() / 4);
        height = HiDPIHelper.scale(this.mESRImageNormal.getHeight() / 4);
        this.mESRImageNormal.scale(width, height);
    }

    public void setCurrentTool(int tool) {
        if (this.mCurrentTool != tool) {
            this.mCurrentTool = tool;
            this.mArea.toolChanged(tool);
            this.mToolbarCanvas.repaint();
        }
    }

    public void paintContent(GenericDrawContext context) {
        int background = this.mToolbarCanvas.getBackgroundRGB();
        boolean isDark = (double)ColorHelper.perceivedBrightness(background) < 0.5;
        int highlightBackground = isDark ? ColorHelper.brighter(background, 0.6f) : ColorHelper.darker(background, 0.6f);
        int selectedBackground = isDark ? ColorHelper.brighter(background, 0.8f) : ColorHelper.darker(background, 0.8f);
        context.drawImage(this.mImageNormal, cBorder, cBorder);
        double[] l = this.getButtonLocation(20);
        context.drawImage(this.mESRImageNormal, 0.0, (float)this.mESRSelected * cButtonSize, l[0], l[1], cButtonSize, cButtonSize);
        if ((this.mArea.getMode() & 4) == 0) {
            this.drawButton(context, 19, -1, true);
        }
        if ((this.mArea.getMode() & 8) == 0) {
            this.drawButton(context, 21, -1, true);
        }
        this.drawButton(context, this.mCurrentTool, selectedBackground, false);
        if (this.mHighlightedButton != -1 && this.mHighlightedButton != this.mSelectedButton) {
            this.drawButton(context, this.mHighlightedButton, highlightBackground, false);
        }
        if (this.mSelectedButton != -1) {
            this.drawButton(context, this.mSelectedButton, 7167924, false);
        }
    }

    @Override
    public void eventHappened(GenericMouseEvent e) {
        if (e.getWhat() == 1) {
            int b = this.getButtonNo(e);
            if (!this.isSelectableButton(b)) {
                return;
            }
            if (b == 20) {
                ++this.mESRSelected;
                this.mESRSelected %= 3;
            }
            this.mSelectedButton = b;
            this.mToolbarCanvas.repaint();
        } else if (e.getWhat() == 2) {
            if (this.mSelectedButton == -1) {
                return;
            }
            int releasedButton = this.getButtonNo(e);
            if (releasedButton != this.mSelectedButton || this.mSelectedButton == 19 && (this.mArea.getMode() & 4) == 0 || this.mSelectedButton == 21 && (this.mArea.getMode() & 8) == 0) {
                this.mSelectedButton = -1;
                this.mToolbarCanvas.repaint();
                return;
            }
            this.mSelectedButton = -1;
            if (releasedButton == 0 || releasedButton == 1 || releasedButton == 17) {
                this.mToolbarCanvas.repaint();
                this.mArea.buttonPressed(releasedButton);
                return;
            }
            this.mCurrentTool = releasedButton;
            this.mToolbarCanvas.repaint();
            if (this.mCurrentTool == 20) {
                this.mArea.toolChanged(this.mESRSelected == 0 ? 101 : (this.mESRSelected == 1 ? 103 : 102));
            } else if (this.mCurrentTool == 33) {
                this.mArea.showCustomAtomDialog(-1);
                this.mArea.toolChanged(releasedButton);
            } else {
                this.mArea.toolChanged(releasedButton);
            }
        } else if (e.getWhat() == 6 || e.getWhat() == 5) {
            int b = this.getButtonNo(e);
            if (b == this.mSelectedButton) {
                b = -1;
            }
            if (b != this.mHighlightedButton) {
                this.mHighlightedButton = b;
                this.mToolbarCanvas.repaint();
            }
        }
    }

    protected int getButtonNo(GenericMouseEvent e) {
        int x = e.getX() - cBorder;
        int y = e.getY() - cBorder;
        if (x < 0 || (float)x >= 2.0f * cButtonSize || y < 0 || (float)y >= 17.0f * cButtonSize) {
            return -1;
        }
        int button = 17 * (int)((float)x / cButtonSize) + (int)((float)y / cButtonSize);
        return this.isSelectableButton(button) ? button : -1;
    }

    private boolean isSelectableButton(int b) {
        return !(b < 0 || b >= 34 || b == this.mCurrentTool && b != 20 && b != 33 || b == 19 && (this.mArea.getMode() & 4) == 0 || b == 21 && (this.mArea.getMode() & 8) == 0);
    }

    private void drawButton(GenericDrawContext context, int button, int background, boolean isDisabled) {
        double[] bl = this.getButtonLocation(button);
        if ((background |= Integer.MIN_VALUE) != -1) {
            context.setRGB(background);
            context.fillRectangle(bl[0], bl[1], cButtonSize, cButtonSize);
        }
        if (button == 20) {
            context.drawImage(this.mESRImageNormal, 0.0, (float)this.mESRSelected * cButtonSize, bl[0], bl[1], cButtonSize, cButtonSize);
        } else {
            context.drawImage(isDisabled ? this.mImageDisabled : this.mImageNormal, bl[0] - (double)cBorder, bl[1] - (double)cBorder, bl[0], bl[1], cButtonSize, cButtonSize);
        }
    }

    private double[] getButtonLocation(int button) {
        double[] p = new double[]{cButtonSize * (float)(button / 17) + (float)cBorder, cButtonSize * (float)(button % 17) + (float)cBorder};
        return p;
    }
}

