/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.gui.editor;

import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.gui.clipboard.ClipboardHandler;
import com.actelion.research.gui.dnd.MoleculeDropAdapter;
import com.actelion.research.gui.editor.GenericEditorArea;
import com.actelion.research.gui.generic.GenericCanvas;
import com.actelion.research.gui.generic.GenericDrawContext;
import com.actelion.research.gui.generic.GenericPoint;
import com.actelion.research.gui.swing.SwingDrawContext;
import com.actelion.research.gui.swing.SwingKeyHandler;
import com.actelion.research.gui.swing.SwingMouseHandler;
import com.actelion.research.gui.swing.SwingUIHelper;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.FlavorMap;
import java.awt.datatransfer.SystemFlavorMap;
import java.awt.dnd.DropTarget;
import java.util.Map;
import javax.swing.JPanel;

public class SwingEditorArea
extends JPanel
implements GenericCanvas {
    private static final int ALLOWED_DROP_ACTIONS = 3;
    private GenericEditorArea mDrawArea;
    private SwingKeyHandler mKeyHandler;

    public SwingEditorArea(StereoMolecule mol, int mode) {
        this.setFocusable(true);
        this.mDrawArea = new GenericEditorArea(mol, mode, new SwingUIHelper(this), this);
        this.initializeDragAndDrop(3);
        SwingMouseHandler mouseHandler = new SwingMouseHandler(this.mDrawArea);
        this.addMouseListener(mouseHandler);
        this.addMouseMotionListener(mouseHandler);
        mouseHandler.addListener(this.mDrawArea);
        this.mKeyHandler = new SwingKeyHandler(this.mDrawArea);
        this.addKeyListener(this.mKeyHandler);
        this.mKeyHandler.addListener(this.mDrawArea);
        this.getGenericDrawArea().setClipboardHandler(new ClipboardHandler());
    }

    public SwingKeyHandler getKeyHandler() {
        return this.mKeyHandler;
    }

    public GenericEditorArea getGenericDrawArea() {
        return this.mDrawArea;
    }

    @Override
    public GenericDrawContext getDrawContext() {
        return new SwingDrawContext((Graphics2D)this.getGraphics());
    }

    @Override
    public double getCanvasWidth() {
        return this.getWidth();
    }

    @Override
    public double getCanvasHeight() {
        return this.getHeight();
    }

    @Override
    public int getBackgroundRGB() {
        return this.getBackground().getRGB();
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        this.mDrawArea.paintContent(new SwingDrawContext((Graphics2D)g));
    }

    private void initializeDragAndDrop(int dropAction) {
        if (dropAction != 0) {
            MoleculeDropAdapter d = new MoleculeDropAdapter(){

                @Override
                public void onDropMolecule(StereoMolecule mol, Point p) {
                    SwingEditorArea.this.mDrawArea.addPastedOrDropped(mol, new GenericPoint(p.x, p.y));
                }
            };
            new DropTarget(this, dropAction, d, true, new OurFlavorMap());
        }
    }

    static class OurFlavorMap
    implements FlavorMap {
        OurFlavorMap() {
        }

        @Override
        public Map<DataFlavor, String> getNativesForFlavors(DataFlavor[] dfs) {
            FlavorMap m = SystemFlavorMap.getDefaultFlavorMap();
            return m.getNativesForFlavors(dfs);
        }

        @Override
        public Map<String, DataFlavor> getFlavorsForNatives(String[] natives) {
            FlavorMap m = SystemFlavorMap.getDefaultFlavorMap();
            return m.getFlavorsForNatives(natives);
        }
    }
}

