/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.gui.editor;

import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.reaction.Reaction;
import com.actelion.research.gui.editor.GenericEditorArea;
import com.actelion.research.gui.editor.SwingEditorArea;
import com.actelion.research.gui.editor.SwingEditorToolbar;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JPanel;

public class SwingEditorPanel
extends JPanel {
    static final long serialVersionUID = 539037955L;
    private SwingEditorToolbar mToolBar;
    private SwingEditorArea mArea;

    public SwingEditorPanel(StereoMolecule mol) {
        this(mol, 0);
    }

    public SwingEditorPanel(StereoMolecule mol, int mode) {
        this.initialize(mol, mode);
    }

    public SwingEditorPanel(StereoMolecule[] mol) {
        this.initialize(null, 1);
        this.mArea.getGenericDrawArea().setFragments(mol);
    }

    public SwingEditorPanel(Reaction rxn) {
        this.initialize(null, 4);
        this.mArea.getGenericDrawArea().setReaction(rxn);
    }

    private void initialize(StereoMolecule mol, int mode) {
        this.setLayout(new BorderLayout());
        this.mArea = new SwingEditorArea(mol != null ? mol : new StereoMolecule(), mode);
        this.add((Component)this.mArea, "Center");
        this.mToolBar = new SwingEditorToolbar(this.mArea, mode);
        this.add((Component)this.mToolBar, "West");
    }

    public GenericEditorArea getDrawArea() {
        return this.mArea.getGenericDrawArea();
    }

    public SwingEditorArea getSwingDrawArea() {
        return this.mArea;
    }

    public void cleanStructure() {
        this.mArea.getGenericDrawArea().toolChanged(1);
    }
}

