/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.gui.editor;

import com.actelion.research.chem.TextDrawingObject;
import com.actelion.research.gui.generic.GenericActionEvent;
import com.actelion.research.gui.generic.GenericComboBox;
import com.actelion.research.gui.generic.GenericDialog;
import com.actelion.research.gui.generic.GenericEventListener;
import com.actelion.research.gui.generic.GenericTextField;
import com.actelion.research.gui.generic.GenericUIHelper;

public class TextDrawingObjectDialogBuilder
implements GenericEventListener<GenericActionEvent> {
    static final long serialVersionUID = 537985829L;
    private static final int[] TEXT_STYLE = new int[]{0, 2, 1, 3};
    private static final String[] TEXT_STYLE_LIST = new String[]{"plain", "italic", "bold", "italics & bold"};
    private static final String[] TEXT_SIZE_LIST = new String[]{"8", "9", "10", "12", "14", "18", "24", "32"};
    private GenericDialog mDialog;
    private GenericTextField mTextArea;
    private TextDrawingObject mTextObject;
    private GenericComboBox mComboBoxTextSize;
    private GenericComboBox mComboBoxStyle;
    private boolean mOKSelected;

    public TextDrawingObjectDialogBuilder(GenericUIHelper dialogHelper, TextDrawingObject textObject) {
        this.mDialog = dialogHelper.createDialog("Edit Text", this);
        this.mTextObject = textObject;
        this.build();
    }

    public boolean showDialog() {
        this.mOKSelected = false;
        this.mDialog.showDialog();
        return this.mOKSelected;
    }

    private void build() {
        this.mComboBoxTextSize = this.mDialog.createComboBox();
        for (String item : TEXT_SIZE_LIST) {
            this.mComboBoxTextSize.addItem(item);
        }
        this.mComboBoxTextSize.setEditable(true);
        this.mComboBoxTextSize.setSelectedItem("" + (int)this.mTextObject.getSize());
        this.mComboBoxStyle = this.mDialog.createComboBox();
        for (String item : TEXT_STYLE_LIST) {
            this.mComboBoxStyle.addItem(item);
        }
        int styleIndex = 0;
        for (int i = 0; i < TEXT_STYLE.length; ++i) {
            if (this.mTextObject.getStyle() != TEXT_STYLE[i]) continue;
            styleIndex = i;
            break;
        }
        this.mComboBoxStyle.setSelectedIndex(styleIndex);
        int[] hLayout = new int[]{8, -2, 4, -2, 8};
        int[] vLayout = new int[]{8, -2, 4, -2, 8, -2, 8};
        this.mDialog.setLayout(hLayout, vLayout);
        this.mDialog.add(this.mDialog.createLabel("Text size:"), 1, 1);
        this.mDialog.add(this.mComboBoxTextSize, 3, 1);
        this.mDialog.add(this.mDialog.createLabel("Text style:"), 1, 3);
        this.mDialog.add(this.mComboBoxStyle, 3, 3);
        this.mTextArea = this.mDialog.createTextField(20, 3);
        this.mTextArea.setText(this.mTextObject.getText());
        this.mDialog.add(this.mTextArea, 1, 5, 3, 5);
    }

    @Override
    public void eventHappened(GenericActionEvent e) {
        if (e.getWhat() == 0) {
            int textSize;
            try {
                textSize = Integer.parseInt(this.mComboBoxTextSize.getSelectedItem());
            }
            catch (NumberFormatException nfe) {
                this.mDialog.showMessage("Illegal text size.");
                return;
            }
            int textStyle = TEXT_STYLE[this.mComboBoxStyle.getSelectedIndex()];
            this.mTextObject.setValues(this.mTextArea.getText(), textSize, textStyle);
            this.mOKSelected = true;
        }
        this.mDialog.disposeDialog();
    }
}

