/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.gui.generic;

import com.actelion.research.chem.AbstractDepictor;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.gui.generic.GenericDrawContext;
import com.actelion.research.gui.generic.GenericImage;
import com.actelion.research.gui.generic.GenericPolygon;
import com.actelion.research.gui.generic.GenericRectangle;

public class GenericDepictor
extends AbstractDepictor<GenericDrawContext> {
    private int mTextSize;
    private float mLineWidth;

    public GenericDepictor(StereoMolecule mol) {
        super(mol);
    }

    public GenericDepictor(StereoMolecule mol, int displayMode) {
        super(mol, displayMode);
    }

    @Override
    protected void init() {
        super.init();
        this.mLineWidth = 1.0f;
    }

    @Override
    protected void drawBlackLine(AbstractDepictor.DepictorLine theLine) {
        ((GenericDrawContext)this.mContext).drawLine(theLine.x1, theLine.y1, theLine.x2, theLine.y2);
    }

    @Override
    protected void drawDottedLine(AbstractDepictor.DepictorLine theLine) {
        ((GenericDrawContext)this.mContext).drawDottedLine(theLine.x1, theLine.y1, theLine.x2, theLine.y2);
    }

    @Override
    protected void drawString(String theString, double x, double y) {
        ((GenericDrawContext)this.mContext).drawCenteredString(x, y, theString);
    }

    @Override
    protected void drawPolygon(GenericPolygon p) {
        ((GenericDrawContext)this.mContext).fillPolygon(p);
    }

    @Override
    protected void fillCircle(double x, double y, double d) {
        ((GenericDrawContext)this.mContext).fillCircle(x, y, d);
    }

    @Override
    protected double getStringWidth(String theString) {
        return ((GenericDrawContext)this.mContext).getBounds(theString).getWidth();
    }

    @Override
    protected void setTextSize(int theSize) {
        this.mTextSize = theSize;
        if (this.mContext != null) {
            ((GenericDrawContext)this.mContext).setFont(theSize, false, false);
        }
    }

    @Override
    public int getTextSize() {
        return this.mTextSize;
    }

    @Override
    public void hiliteAtomBackgrounds(int[] atomARGB, float[] radius) {
        double avbl = this.getTransformation().getScaling() * this.getMolecule().getAverageBondLength();
        double maxRadius = radius == null ? 0.6 * avbl : 0.75 * avbl;
        GenericRectangle rect = this.simpleCalculateBounds();
        int imageX = (int)Math.floor(rect.x - maxRadius);
        int imageY = (int)Math.floor(rect.y - maxRadius);
        int imageW = (int)Math.ceil(rect.x + rect.width + maxRadius) - imageX + 1;
        int imageH = (int)Math.ceil(rect.y + rect.height + maxRadius) - imageY + 1;
        float[] imageARGB = new float[4 * imageW * imageH];
        float[] pixelARGB = new float[4];
        float[] background = this.getBackgroundColor().getRGBColorComponents(null);
        for (int atom = 0; atom < this.getMolecule().getAtoms(); ++atom) {
            if ((atomARGB[atom] & 0xFF000000) == 0) continue;
            int x0 = (int)Math.round(this.getAtomX(atom)) - imageX;
            int y0 = (int)Math.round(this.getAtomY(atom)) - imageY;
            float alpha = (float)((atomARGB[atom] & 0xFF000000) >>> 24) / 255.0f;
            pixelARGB[1] = (float)((atomARGB[atom] & 0xFF0000) >> 16) / 255.0f;
            pixelARGB[2] = (float)((atomARGB[atom] & 0xFF00) >> 8) / 255.0f;
            pixelARGB[3] = (float)(atomARGB[atom] & 0xFF) / 255.0f;
            if (alpha != 1.0f) {
                pixelARGB[1] = background[0] + alpha * (pixelARGB[1] - background[0]);
                pixelARGB[2] = background[1] + alpha * (pixelARGB[2] - background[1]);
                pixelARGB[3] = background[2] + alpha * (pixelARGB[3] - background[2]);
            }
            int atomRadius = radius == null ? (int)maxRadius : (int)(maxRadius * (double)radius[atom]);
            int atomSquare = atomRadius * atomRadius;
            for (int rx = 0; rx <= atomRadius; ++rx) {
                for (int ry = 0; ry <= atomRadius; ++ry) {
                    float squareDistance = rx * rx + ry * ry;
                    if (!(squareDistance <= (float)atomSquare)) continue;
                    pixelARGB[0] = 1.0f - (float)Math.sqrt(squareDistance) / (float)atomRadius;
                    if (rx != 0 && ry != 0) {
                        this.mixInColor(imageARGB, 4 * ((y0 - ry) * imageW + x0 - rx), pixelARGB);
                    }
                    if (ry != 0) {
                        this.mixInColor(imageARGB, 4 * ((y0 - ry) * imageW + x0 + rx), pixelARGB);
                    }
                    if (rx != 0) {
                        this.mixInColor(imageARGB, 4 * ((y0 + ry) * imageW + x0 - rx), pixelARGB);
                    }
                    this.mixInColor(imageARGB, 4 * ((y0 + ry) * imageW + x0 + rx), pixelARGB);
                }
            }
        }
        GenericImage image = ((GenericDrawContext)this.mContext).createARGBImage(imageW, imageH);
        int index = 0;
        for (int y = 0; y < imageH; ++y) {
            for (int x = 0; x < imageW; ++x) {
                int c = 0;
                if (imageARGB[index] != 0.0f) {
                    if (imageARGB[index] > 1.0f) {
                        float intensity = imageARGB[index++];
                        c = -16777216;
                        c += (int)(255.0f * imageARGB[index++] / intensity) << 16;
                        c += (int)(255.0f * imageARGB[index++] / intensity) << 8;
                        c += (int)(255.0f * imageARGB[index++] / intensity);
                    } else {
                        c = (int)(255.0f * imageARGB[index++]) << 24;
                        c += (int)(255.0f * imageARGB[index++]) << 16;
                        c += (int)(255.0f * imageARGB[index++]) << 8;
                        c += (int)(255.0f * imageARGB[index++]);
                    }
                } else {
                    index += 4;
                }
                image.setRGB(x, y, c);
            }
        }
        ((GenericDrawContext)this.mContext).drawImage(image, imageX, imageY);
    }

    private void mixInColor(float[] imageARGB, int index, float[] pixelARGB) {
        if (imageARGB[index] == 0.0f) {
            imageARGB[index++] = pixelARGB[0];
            imageARGB[index++] = pixelARGB[1];
            imageARGB[index++] = pixelARGB[2];
            imageARGB[index++] = pixelARGB[3];
        } else {
            float newIntensity;
            float oldIntensity = imageARGB[index];
            imageARGB[index] = newIntensity = imageARGB[index] + pixelARGB[0];
            imageARGB[++index] = (imageARGB[index] * oldIntensity + pixelARGB[1] * pixelARGB[0]) / newIntensity;
            imageARGB[++index] = (imageARGB[index] * oldIntensity + pixelARGB[2] * pixelARGB[0]) / newIntensity;
            imageARGB[++index] = (imageARGB[index] * oldIntensity + pixelARGB[3] * pixelARGB[0]) / newIntensity;
        }
    }

    @Override
    protected double getLineWidth() {
        return this.mLineWidth;
    }

    @Override
    protected void setLineWidth(double lineWidth) {
        this.mLineWidth = (float)lineWidth;
        ((GenericDrawContext)this.mContext).setLineWidth(this.mLineWidth);
    }

    @Override
    protected void setRGB(int rgb) {
        ((GenericDrawContext)this.mContext).setRGB(rgb);
    }
}

