/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.gui.generic;

import com.actelion.research.gui.generic.GenericShape;
import java.util.Arrays;

public class GenericPolygon
implements GenericShape {
    private double[] mX;
    private double[] mY;
    private int mIndex;

    public GenericPolygon(int size) {
        this.mX = new double[size];
        this.mY = new double[size];
        this.mIndex = 0;
    }

    public GenericPolygon() {
        this.mX = new double[64];
        this.mY = new double[64];
        this.mIndex = 0;
    }

    public void addPoint(double x, double y) {
        if (this.mIndex == this.mX.length) {
            this.mX = Arrays.copyOf(this.mX, 2 * this.mIndex);
            this.mY = Arrays.copyOf(this.mY, 2 * this.mIndex);
        }
        this.mX[this.mIndex] = x;
        this.mY[this.mIndex] = y;
        ++this.mIndex;
    }

    public void removeLastPoint() {
        if (this.mIndex > 0) {
            --this.mIndex;
        }
    }

    public void clear() {
        this.mIndex = 0;
    }

    @Override
    public boolean contains(double x, double y) {
        boolean result = false;
        int j = this.mIndex - 1;
        int i = 0;
        while (i < this.mIndex) {
            if (this.mY[i] > y != this.mY[j] > y && x < (this.mX[j] - this.mX[i]) * (y - this.mY[i]) / (this.mY[j] - this.mY[i]) + this.mX[i]) {
                result = !result;
            }
            j = i++;
        }
        return result;
    }

    public int getSize() {
        return this.mIndex;
    }

    public double getX(int i) {
        return this.mX[i];
    }

    public double getY(int i) {
        return this.mY[i];
    }

    public double[] getX() {
        return this.mX;
    }

    public double[] getY() {
        return this.mY;
    }
}

