/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.gui.generic;

import com.actelion.research.gui.generic.GenericShape;

public class GenericRectangle
implements GenericShape {
    public double x;
    public double y;
    public double width;
    public double height;

    public GenericRectangle() {
    }

    public GenericRectangle(double x, double y, double w, double h) {
        this.x = x;
        this.y = y;
        this.width = w;
        this.height = h;
    }

    @Override
    public boolean contains(double x, double y) {
        return x >= this.x && x <= this.x + this.width && y >= this.y && y <= this.y + this.height;
    }

    public boolean contains(GenericRectangle r) {
        return this.contains(r.x, r.y) && this.contains(r.x + r.width, r.y + r.height);
    }

    public void set(double x, double y, double w, double h) {
        this.x = x;
        this.y = y;
        this.width = w;
        this.height = h;
    }

    public GenericRectangle union(GenericRectangle r) {
        double x = Math.min(this.x, r.x);
        double y = Math.min(this.y, r.y);
        double w = Math.max(this.x + this.width, r.x + r.width) - x;
        double h = Math.max(this.y + this.height, r.y + r.height) - y;
        return new GenericRectangle(x, y, w, h);
    }

    public boolean intersects(GenericRectangle r) {
        return this.x < r.x + r.width && this.y < r.y + r.height && r.x < this.x + this.width && r.y < this.y + this.height;
    }

    public GenericRectangle intersection(GenericRectangle r) {
        if (!this.intersects(r)) {
            return null;
        }
        double x = Math.max(this.x, r.x);
        double y = Math.max(this.y, r.y);
        double w = Math.min(this.x + this.width, r.x + r.width) - x;
        double h = Math.min(this.y + this.height, r.y + r.height) - y;
        return new GenericRectangle(x, y, w, h);
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getWidth() {
        return this.width;
    }

    public double getHeight() {
        return this.height;
    }

    public double getCenterX(GenericRectangle r) {
        return r.getX() + r.getWidth() / 2.0;
    }

    public double getCenterY(GenericRectangle r) {
        return r.getY() + r.getHeight() / 2.0;
    }

    public String toString() {
        return "x:" + this.x + " y:" + this.y + " w:" + this.width + " h:" + this.height;
    }
}

