/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.gui.hidpi;

import com.actelion.research.gui.LookAndFeelHelper;
import com.actelion.research.gui.generic.GenericImage;
import com.actelion.research.util.ColorHelper;
import com.actelion.research.util.Platform;
import java.awt.Color;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.lang.reflect.Field;
import javax.swing.UIManager;

public class HiDPIHelper {
    private static final int[] BRIGHT_TO_DARK_LAF = new int[]{5258420, 11837695, 0, 0xE0E0E0};
    private static float sRetinaFactor = -1.0f;
    private static float sUIScaleFactor = -1.0f;

    public static float getRetinaScaleFactor() {
        block6: {
            if (Platform.isMacintosh()) {
                if (sRetinaFactor != -1.0f) {
                    return sRetinaFactor;
                }
                sRetinaFactor = 1.0f;
                GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
                GraphicsDevice device = env.getDefaultScreenDevice();
                try {
                    Field field = device.getClass().getDeclaredField("scale");
                    if (field == null) break block6;
                    field.setAccessible(true);
                    Object scale = field.get(device);
                    if (scale instanceof Integer) {
                        sRetinaFactor = ((Integer)scale).intValue();
                        break block6;
                    }
                    System.out.println("Unexpected content scale (not 1 nor 2): " + scale.toString());
                }
                catch (Throwable throwable) {}
            } else {
                GraphicsDevice sd = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
                sRetinaFactor = (float)sd.getDefaultConfiguration().getDefaultTransform().getScaleX();
            }
        }
        return sRetinaFactor;
    }

    public static float getUIScaleFactor() {
        if (sUIScaleFactor == -1.0f) {
            if (HiDPIHelper.getRetinaScaleFactor() != 1.0f) {
                sUIScaleFactor = 1.0f;
            } else {
                float f = 0.0f;
                String dpiFactor = System.getProperty("dpifactor");
                if (dpiFactor != null) {
                    try {
                        f = Float.parseFloat(dpiFactor);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                sUIScaleFactor = f != 0.0f ? f : (Platform.isMacintosh() ? 1.0f : (float)UIManager.getFont("Label.font").getSize() / 12.0f);
            }
        }
        return sUIScaleFactor;
    }

    public static int scale(float value) {
        return Math.round(HiDPIHelper.getUIScaleFactor() * value);
    }

    public static int scaleRetinaAndUI(float value) {
        return Math.round(HiDPIHelper.getUIScaleFactor() * HiDPIHelper.getRetinaScaleFactor() * value);
    }

    public static Color getThemeColor(int no) {
        return new Color(BRIGHT_TO_DARK_LAF[2 * no + (LookAndFeelHelper.isDarkLookAndFeel() ? 1 : 0)]);
    }

    public static void adaptForLookAndFeel(GenericImage image) {
        if (LookAndFeelHelper.isDarkLookAndFeel()) {
            HiDPIHelper.useSpotColorsForDarkLookAndFeel(image);
        }
    }

    public static void disableImage(GenericImage image) {
        Color gray = LookAndFeelHelper.isDarkLookAndFeel() ? ColorHelper.brighter(UIManager.getColor("Panel.background"), 0.8f) : ColorHelper.darker(UIManager.getColor("Panel.background"), 0.8f);
        int grayRGB = 0xFFFFFF & gray.getRGB();
        for (int x = 0; x < image.getWidth(); ++x) {
            for (int y = 0; y < image.getHeight(); ++y) {
                int argb = image.getRGB(x, y);
                image.setRGB(x, y, (0xFF000000 & argb) + grayRGB);
            }
        }
    }

    private static void useSpotColorsForDarkLookAndFeel(GenericImage image) {
        for (int x = 0; x < image.getWidth(); ++x) {
            for (int y = 0; y < image.getHeight(); ++y) {
                int argb = image.getRGB(x, y);
                int rgb = argb & 0xFFFFFF;
                for (int i = 0; i < BRIGHT_TO_DARK_LAF.length; i += 2) {
                    if (rgb != BRIGHT_TO_DARK_LAF[i]) continue;
                    rgb = BRIGHT_TO_DARK_LAF[i + 1];
                    break;
                }
                image.setRGB(x, y, (0xFF000000 & argb) + rgb);
            }
        }
    }
}

