/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.gui.hidpi;

import com.actelion.research.gui.hidpi.ColorUtils;
import com.actelion.research.gui.hidpi.HiDPIHelper;
import com.actelion.research.gui.hidpi.ScaledStyleSheet;
import java.awt.Color;
import java.awt.Font;
import java.io.StringReader;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.ImageView;
import javax.swing.text.html.StyleSheet;

public class ScaledEditorKit
extends HTMLEditorKit {
    private static StyleSheet defaultStyles;
    private static ScaledEditorKit kit;
    static ViewFactory basicHTMLViewFactory;

    public static float getFontScaleFactor() {
        return HiDPIHelper.getUIScaleFactor();
    }

    @Override
    public StyleSheet getStyleSheet() {
        if (defaultStyles == null) {
            defaultStyles = new StyleSheet();
            StringReader r = new StringReader("p { margin-top: 0; margin-bottom: 0; margin-left: 0; margin-right: 0 }body { margin-top: 0; margin-bottom: 0; margin-left: 0; margin-right: 0 }");
            try {
                defaultStyles.loadRules(r, null);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            r.close();
            defaultStyles.addStyleSheet(super.getStyleSheet());
        }
        return defaultStyles;
    }

    @Override
    public Document createDefaultDocument() {
        StyleSheet styles = this.getStyleSheet();
        ScaledStyleSheet ss = new ScaledStyleSheet();
        ss.addStyleSheet(styles);
        HTMLDocument doc = new HTMLDocument(ss);
        doc.setParser(this.getParser());
        doc.setAsynchronousLoadPriority(4);
        doc.setTokenThreshold(100);
        return doc;
    }

    Document createDefaultDocument(Font defaultFont, Color foreground) {
        StyleSheet styles = this.getStyleSheet();
        ScaledStyleSheet ss = new ScaledStyleSheet();
        ss.addStyleSheet(styles);
        HTMLDocument doc = new HTMLDocument(ss);
        doc.setPreservesUnknownTags(false);
        doc.getStyleSheet().addRule(this.displayPropertiesToCSS(defaultFont, foreground));
        doc.setParser(this.getParser());
        doc.setAsynchronousLoadPriority(Integer.MAX_VALUE);
        doc.setPreservesUnknownTags(false);
        return doc;
    }

    private String displayPropertiesToCSS(Font font, Color fg) {
        StringBuffer rule = new StringBuffer("body {");
        if (font != null) {
            rule.append(" font-family: ");
            rule.append(font.getFamily());
            rule.append(" ; ");
            rule.append(" font-size: ");
            int fontSize = Math.round((float)font.getSize() / ScaledEditorKit.getFontScaleFactor());
            rule.append(fontSize);
            rule.append("pt ;");
            if (font.isBold()) {
                rule.append(" font-weight: bold ; ");
            }
            if (font.isItalic()) {
                rule.append(" font-style: italic ; ");
            }
        }
        if (fg != null) {
            rule.append(" color: ").append(ColorUtils.colorToString(fg)).append(" ; ");
        }
        rule.append(" }");
        return rule.toString();
    }

    @Override
    public ViewFactory getViewFactory() {
        if (basicHTMLViewFactory == null) {
            basicHTMLViewFactory = new BasicHTMLViewFactory();
        }
        return basicHTMLViewFactory;
    }

    public static ScaledEditorKit create() {
        if (kit == null) {
            kit = new ScaledEditorKit();
        }
        return kit;
    }

    static class BasicHTMLViewFactory
    extends HTMLEditorKit.HTMLFactory {
        BasicHTMLViewFactory() {
        }

        @Override
        public View create(Element elem) {
            View view = super.create(elem);
            if (view instanceof ImageView) {
                ((ImageView)view).setLoadsSynchronously(true);
            }
            return view;
        }
    }
}

