/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.gui.hidpi;

import com.actelion.research.gui.hidpi.ScaledEditorKit;
import java.awt.Font;
import javax.swing.text.AttributeSet;
import javax.swing.text.html.CSS;
import javax.swing.text.html.StyleSheet;

public class ScaledStyleSheet
extends StyleSheet {
    private static final long serialVersionUID = 1L;

    @Override
    public Font getFont(AttributeSet a) {
        Font font = super.getFont(a);
        float fontScaleFactor = this.getFontScaleFactor(a);
        return super.getFont(font.getFamily(), font.getStyle(), Math.round(font.getSize2D() * fontScaleFactor));
    }

    private float getFontScaleFactor(AttributeSet a) {
        Object attribute = a.getAttribute(CSS.Attribute.FONT_SIZE);
        if (attribute == null) {
            return ScaledEditorKit.getFontScaleFactor();
        }
        String fontSize = attribute.toString();
        int fsLength = fontSize.length();
        if (fsLength <= 1 || Character.isDigit(fontSize.charAt(fsLength - 1)) || fontSize.endsWith("pt")) {
            return ScaledEditorKit.getFontScaleFactor();
        }
        if (fontSize.endsWith("px")) {
            return 0.7692308f;
        }
        if (fontSize.endsWith("%") || fontSize.endsWith("em") || fontSize.endsWith("ex") || fontSize.endsWith("er")) {
            return this.getFontScaleFactor(a);
        }
        return ScaledEditorKit.getFontScaleFactor();
    }
}

