/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.gui.swing;

import com.actelion.research.gui.generic.GenericActionEvent;
import com.actelion.research.gui.generic.GenericCheckBox;
import com.actelion.research.gui.generic.GenericComboBox;
import com.actelion.research.gui.generic.GenericComponent;
import com.actelion.research.gui.generic.GenericDialog;
import com.actelion.research.gui.generic.GenericEventListener;
import com.actelion.research.gui.generic.GenericLabel;
import com.actelion.research.gui.generic.GenericTextField;
import com.actelion.research.gui.hidpi.HiDPIHelper;
import com.actelion.research.gui.swing.SwingCheckBox;
import com.actelion.research.gui.swing.SwingComboBox;
import com.actelion.research.gui.swing.SwingComponent;
import com.actelion.research.gui.swing.SwingLabel;
import com.actelion.research.gui.swing.SwingTextField;
import info.clearthought.layout.TableLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class SwingDialog
extends JDialog
implements ActionListener,
GenericDialog {
    private Component mParent;
    private JPanel mContent;
    private GenericEventListener<GenericActionEvent> mConsumer;

    public SwingDialog(Frame parent, String title) {
        super(parent, title, true);
        this.mParent = parent;
    }

    public SwingDialog(Dialog parent, String title) {
        super(parent, title, true);
        this.mParent = parent;
    }

    @Override
    public void setEventConsumer(GenericEventListener<GenericActionEvent> consumer) {
        this.mConsumer = consumer;
    }

    @Override
    public void setLayout(int[] hLayout, int[] vLayout) {
        int i;
        double[][] size = new double[][]{new double[hLayout.length], new double[vLayout.length]};
        for (i = 0; i < hLayout.length; ++i) {
            size[0][i] = hLayout[i] > 0 ? (double)HiDPIHelper.scale(hLayout[i]) : (double)hLayout[i];
        }
        for (i = 0; i < vLayout.length; ++i) {
            size[1][i] = vLayout[i] > 0 ? (double)HiDPIHelper.scale(vLayout[i]) : (double)vLayout[i];
        }
        this.mContent = new JPanel();
        this.mContent.setLayout(new TableLayout(size));
    }

    @Override
    public void add(GenericComponent c, int x, int y) {
        this.mContent.add((Component)((SwingComponent)c).getComponent(), x + "," + y);
    }

    @Override
    public void add(GenericComponent c, int x1, int y1, int x2, int y2) {
        this.mContent.add((Component)((SwingComponent)c).getComponent(), x1 + "," + y1 + "," + x2 + "," + y2);
    }

    @Override
    public void showDialog() {
        JPanel buttonpanel = new JPanel();
        int gap = HiDPIHelper.scale(8.0f);
        buttonpanel.setBorder(BorderFactory.createEmptyBorder(gap * 3 / 2, gap, gap, gap));
        buttonpanel.setLayout(new BorderLayout());
        JPanel ibp = new JPanel();
        ibp.setLayout(new GridLayout(1, 2, gap, 0));
        JButton bcancel = new JButton("Cancel");
        bcancel.addActionListener(this);
        ibp.add(bcancel);
        JButton bok = new JButton("OK");
        bok.addActionListener(this);
        ibp.add(bok);
        buttonpanel.add((Component)ibp, "East");
        this.getContentPane().add((Component)this.mContent, "Center");
        this.getContentPane().add((Component)buttonpanel, "South");
        this.getRootPane().setDefaultButton(bok);
        this.pack();
        this.setLocationRelativeTo(this.mParent);
        this.setVisible(true);
    }

    @Override
    public void disposeDialog() {
        this.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if ("OK".equals(e.getActionCommand())) {
            this.mConsumer.eventHappened(new GenericActionEvent((Object)this, 0, 0));
        } else if ("Cancel".equals(e.getActionCommand())) {
            this.mConsumer.eventHappened(new GenericActionEvent((Object)this, 1, 0));
        }
    }

    @Override
    public void showMessage(String message) {
        JOptionPane.showMessageDialog(this.mParent, message);
    }

    @Override
    public GenericLabel createLabel(String text) {
        return new SwingLabel(text);
    }

    @Override
    public GenericTextField createTextField(int width, int height) {
        return new SwingTextField(width, height);
    }

    @Override
    public GenericCheckBox createCheckBox(String text) {
        return new SwingCheckBox(text);
    }

    @Override
    public GenericComboBox createComboBox() {
        return new SwingComboBox();
    }
}

