/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.gui.swing;

import com.actelion.research.gui.LookAndFeelHelper;
import com.actelion.research.gui.generic.GenericDrawContext;
import com.actelion.research.gui.generic.GenericImage;
import com.actelion.research.gui.generic.GenericPolygon;
import com.actelion.research.gui.generic.GenericRectangle;
import com.actelion.research.gui.swing.SwingImage;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Stroke;
import java.awt.font.GlyphVector;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import javax.swing.UIManager;

public class SwingDrawContext
implements GenericDrawContext {
    private static boolean isMac = System.getProperty("os.name").toLowerCase().indexOf("mac") >= 0;
    private Graphics2D mG;

    public SwingDrawContext(Graphics2D g) {
        this.mG = g;
    }

    @Override
    public int getFontSize() {
        return this.mG.getFont().getSize();
    }

    @Override
    public void setFont(int size, boolean isBold, boolean isItalic) {
        int style = (isBold ? 1 : 0) + (isItalic ? 2 : 0);
        this.mG.setFont(this.mG.getFont().deriveFont(style, size));
    }

    @Override
    public void drawLine(double x1, double y1, double x2, double y2) {
        if (isMac) {
            this.mG.draw(new Line2D.Double(x1 - 0.5, y1 - 0.5, x2 - 0.5, y2 - 0.5));
        } else {
            this.mG.draw(new Line2D.Double(x1, y1, x2, y2));
        }
    }

    @Override
    public void drawDottedLine(double x1, double y1, double x2, double y2) {
        Stroke stroke = this.mG.getStroke();
        float width = ((BasicStroke)stroke).getLineWidth();
        this.mG.setStroke(new BasicStroke(width, 1, 1, width, new float[]{3.0f * width}, 0.0f));
        this.drawLine(x1, y1, x2, y2);
        this.mG.setStroke(stroke);
    }

    @Override
    public void drawRectangle(double x, double y, double w, double h) {
        this.mG.draw(new Rectangle2D.Double(x, y, w, h));
    }

    @Override
    public void fillRectangle(double x, double y, double w, double h) {
        this.mG.fill(new Rectangle2D.Double(x, y, w, h));
    }

    @Override
    public void drawCircle(double x, double y, double d) {
        if (isMac) {
            this.mG.draw(new Ellipse2D.Double(x - 0.5, y - 0.5, d, d));
        } else {
            this.mG.draw(new Ellipse2D.Double(x, y, d, d));
        }
    }

    @Override
    public void fillCircle(double x, double y, double d) {
        if (isMac) {
            this.mG.fill(new Ellipse2D.Double(x - 0.5, y - 0.5, d, d));
        } else {
            this.mG.fill(new Ellipse2D.Double(x, y, d, d));
        }
    }

    @Override
    public void drawPolygon(GenericPolygon p) {
        GeneralPath polygon = new GeneralPath(1, p.getSize());
        if (isMac) {
            polygon.moveTo((float)p.getX(0) - 0.5f, (float)p.getY(0) - 0.5f);
            for (int i = 1; i < p.getSize(); ++i) {
                polygon.lineTo((float)p.getX(i) - 0.5f, (float)p.getY(i) - 0.5f);
            }
            polygon.closePath();
        } else {
            polygon.moveTo((float)p.getX(0), (float)p.getY(0));
            for (int i = 1; i < p.getSize(); ++i) {
                polygon.lineTo((float)p.getX(i), (float)p.getY(i));
            }
            polygon.closePath();
        }
        this.mG.draw(polygon);
    }

    @Override
    public void fillPolygon(GenericPolygon p) {
        int i;
        GeneralPath polygon = new GeneralPath(1, p.getSize());
        polygon.moveTo((float)p.getX(0), (float)p.getY(0));
        for (i = 1; i < p.getSize(); ++i) {
            polygon.lineTo((float)p.getX(i), (float)p.getY(i));
        }
        polygon.closePath();
        this.mG.fill(polygon);
        if (isMac) {
            polygon = new GeneralPath(1, p.getSize());
            polygon.moveTo((float)p.getX(0) - 0.5f, (float)p.getY(0) - 0.5f);
            for (i = 1; i < p.getSize(); ++i) {
                polygon.lineTo((float)p.getX(i) - 0.5f, (float)p.getY(i) - 0.5f);
            }
            polygon.closePath();
        }
        this.mG.draw(polygon);
    }

    @Override
    public float getLineWidth() {
        return ((BasicStroke)this.mG.getStroke()).getLineWidth();
    }

    @Override
    public void setLineWidth(float lineWidth) {
        this.mG.setStroke(new BasicStroke(lineWidth, 1, 1));
    }

    @Override
    public int getRGB() {
        return this.mG.getColor().getRGB();
    }

    @Override
    public void setRGB(int rgb) {
        Color color = new Color(rgb);
        this.mG.setColor(color);
        this.mG.setPaint(color);
    }

    @Override
    public void drawString(double x, double y, String s) {
        this.mG.drawString(s, (float)Math.round(x), (float)Math.round(y));
    }

    @Override
    public void drawCenteredString(double x, double y, String s) {
        GlyphVector gv = this.mG.getFont().createGlyphVector(this.mG.getFontRenderContext(), s);
        double width = gv.getLogicalBounds().getWidth();
        this.mG.drawGlyphVector(gv, (float)(x - width / 2.0), (float)(y + (double)this.mG.getFont().getSize() / 3.0));
    }

    @Override
    public GenericRectangle getBounds(String s) {
        Rectangle2D r = this.mG.getFontMetrics().getStringBounds(s, this.mG);
        return new GenericRectangle(r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }

    @Override
    public void drawImage(GenericImage image, double x, double y) {
        this.mG.drawImage((Image)image.get(), Math.round((float)x), Math.round((float)y), null);
    }

    @Override
    public void drawImage(GenericImage image, double sx, double sy, double dx, double dy, double w, double h) {
        this.mG.drawImage((Image)image.get(), Math.round((float)dx), Math.round((float)dy), Math.round((float)(dx + w)), Math.round((float)(dy + h)), Math.round((float)sx), Math.round((float)sy), Math.round((float)(sx + w)), Math.round((float)(sy + h)), null);
    }

    @Override
    public boolean isDarkBackground() {
        return LookAndFeelHelper.isDarkLookAndFeel();
    }

    @Override
    public int getForegroundRGB() {
        Color color = UIManager.getColor("TextArea.foreground");
        return color == null ? 0 : color.getRGB();
    }

    @Override
    public int getBackgroundRGB() {
        Color color = UIManager.getColor("TextArea.background");
        return color == null ? 0 : color.getRGB();
    }

    @Override
    public int getSelectionBackgroundRGB() {
        Color color = UIManager.getColor("TextArea.selectionBackground");
        return color == null ? 0 : color.getRGB();
    }

    @Override
    public GenericImage createARGBImage(int width, int height) {
        return new SwingImage(width, height);
    }
}

