/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.gui.swing;

import com.actelion.research.gui.generic.GenericImage;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import javax.imageio.ImageIO;

public class SwingImage
implements GenericImage {
    private BufferedImage mImage;

    public SwingImage(BufferedImage image) {
        this.mImage = image;
    }

    public SwingImage(String name) {
        URL url = SwingImage.class.getResource("/images/" + name);
        if (url == null) {
            throw new RuntimeException("Could not find: " + name);
        }
        try {
            this.mImage = ImageIO.read(url);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public SwingImage(int width, int height) {
        this.mImage = new BufferedImage(width, height, 2);
    }

    @Override
    public int getRGB(int x, int y) {
        return this.mImage.getRGB(x, y);
    }

    @Override
    public void setRGB(int x, int y, int argb) {
        this.mImage.setRGB(x, y, argb);
    }

    @Override
    public BufferedImage get() {
        return this.mImage;
    }

    @Override
    public int getWidth() {
        return this.mImage.getWidth(null);
    }

    @Override
    public int getHeight() {
        return this.mImage.getHeight(null);
    }

    @Override
    public void scale(int width, int height) {
        Image scaledImage = this.mImage.getScaledInstance(width, height, 4);
        this.mImage = new BufferedImage(width, height, 2);
        Graphics2D g = this.mImage.createGraphics();
        g.drawImage(scaledImage, 0, 0, null);
        g.dispose();
    }
}

