/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.gui.swing;

import com.actelion.research.gui.generic.GenericActionEvent;
import com.actelion.research.gui.generic.GenericEventListener;
import com.actelion.research.gui.generic.GenericPopupMenu;
import com.actelion.research.gui.swing.SwingComponent;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;

public class SwingPopupMenu
extends SwingComponent
implements ActionListener,
GenericPopupMenu {
    private JPopupMenu mPopupMenu = (JPopupMenu)this.getComponent();
    private JMenu mSubMenu;
    private JComponent mOwner;

    public SwingPopupMenu(JComponent owner, GenericEventListener<GenericActionEvent> consumer) {
        super(new JPopupMenu());
        this.mOwner = owner;
        this.addEventConsumer(consumer);
    }

    @Override
    public void addItem(String text, String command, boolean enabled) {
        JMenuItem item = new JMenuItem(text);
        item.setEnabled(enabled);
        if (command != null) {
            item.setActionCommand(command);
        }
        item.addActionListener(this);
        if (this.mSubMenu != null) {
            this.mSubMenu.add(item);
        } else {
            this.mPopupMenu.add(item);
        }
    }

    @Override
    public void addRadioButtonItem(String text, String command, int colorRGB, boolean isSelected) {
        JRadioButtonMenuItem item = new JRadioButtonMenuItem(text, isSelected);
        if (command != null) {
            item.setActionCommand(command);
        }
        if (colorRGB != 0) {
            item.setBackground(new Color(colorRGB));
        }
        item.addActionListener(this);
        if (this.mSubMenu != null) {
            this.mSubMenu.add(item);
        } else {
            this.mPopupMenu.add(item);
        }
    }

    @Override
    public void startSubMenu(String text) {
        this.mSubMenu = new JMenu(text);
    }

    @Override
    public void endSubMenu() {
        this.mPopupMenu.add(this.mSubMenu);
        this.mSubMenu = null;
    }

    @Override
    public void addSeparator() {
        if (this.mSubMenu != null) {
            this.mSubMenu.addSeparator();
        } else {
            this.mPopupMenu.addSeparator();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.fireEvent(new GenericActionEvent((Object)this, 2, e.getActionCommand()));
    }

    @Override
    public void show(int x, int y) {
        this.mPopupMenu.show(this.mOwner, x, y);
    }
}

