/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.gui.swing;

import com.actelion.research.gui.FileHelper;
import com.actelion.research.gui.generic.GenericActionEvent;
import com.actelion.research.gui.generic.GenericDialog;
import com.actelion.research.gui.generic.GenericEventListener;
import com.actelion.research.gui.generic.GenericImage;
import com.actelion.research.gui.generic.GenericPopupMenu;
import com.actelion.research.gui.generic.GenericUIHelper;
import com.actelion.research.gui.hidpi.HiDPIHelper;
import com.actelion.research.gui.hidpi.ScaledEditorKit;
import com.actelion.research.gui.swing.SwingDialog;
import com.actelion.research.gui.swing.SwingImage;
import com.actelion.research.gui.swing.SwingPopupMenu;
import com.actelion.research.util.CursorHelper;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.io.File;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.text.html.HTMLEditorKit;

public class SwingUIHelper
implements GenericUIHelper {
    private JComponent mParentComponent;
    private JDialog mHelpDialog;

    public SwingUIHelper(JComponent parent) {
        this.mParentComponent = parent;
    }

    @Override
    public void showMessage(String message) {
        JOptionPane.showMessageDialog(this.getParent(), message);
    }

    @Override
    public GenericDialog createDialog(String title, GenericEventListener<GenericActionEvent> consumer) {
        Container c = this.mParentComponent;
        while (!(c instanceof Frame) && !(c instanceof Dialog)) {
            c = c.getParent();
        }
        SwingDialog dialog = c instanceof Frame ? new SwingDialog((Frame)c, title) : new SwingDialog((Dialog)c, title);
        dialog.setEventConsumer(consumer);
        return dialog;
    }

    @Override
    public GenericPopupMenu createPopupMenu(GenericEventListener<GenericActionEvent> consumer) {
        return new SwingPopupMenu(this.mParentComponent, consumer);
    }

    @Override
    public GenericImage createImage(String name) {
        return new SwingImage(name);
    }

    @Override
    public GenericImage createImage(int width, int height) {
        return new SwingImage(width, height);
    }

    @Override
    public void runLater(Runnable r) {
        SwingUtilities.invokeLater(r);
    }

    @Override
    public void grabFocus() {
        this.mParentComponent.requestFocus();
    }

    @Override
    public void setCursor(int cursor) {
        this.mParentComponent.setCursor(CursorHelper.getCursor(cursor));
    }

    @Override
    public File openChemistryFile(boolean isReaction) {
        return isReaction ? FileHelper.getFile(this.mParentComponent, "Please select a reaction file", 49408) : FileHelper.getFile(this.mParentComponent, "Please select a molecule file", 196608);
    }

    @Override
    public void showHelpDialog(String url, String title) {
        if (this.mHelpDialog == null || !this.mHelpDialog.isVisible()) {
            JEditorPane helpPane = new JEditorPane();
            helpPane.setEditorKit(HiDPIHelper.getUIScaleFactor() == 1.0f ? new HTMLEditorKit() : new ScaledEditorKit());
            helpPane.setEditable(false);
            try {
                helpPane.setPage(this.getClass().getResource(url));
            }
            catch (Exception ex) {
                helpPane.setText(ex.toString());
            }
            Component c = this.getParent();
            this.mHelpDialog = c instanceof Frame ? new JDialog((Frame)c, title, false) : new JDialog((Dialog)c, title, false);
            this.mHelpDialog.setSize(HiDPIHelper.scale(520.0f), HiDPIHelper.scale(440.0f));
            this.mHelpDialog.getContentPane().add(new JScrollPane(helpPane, 22, 31));
            int x = c.getX() >= 8 + this.mHelpDialog.getWidth() ? c.getX() - 8 - this.mHelpDialog.getWidth() : c.getX() + 8 + c.getWidth();
            this.mHelpDialog.setLocation(x, c.getY());
            this.mHelpDialog.setVisible(true);
        } else {
            Component c = this.getParent();
            int x = this.mHelpDialog.getX() + this.mHelpDialog.getWidth() / 2 >= c.getX() + c.getWidth() / 2 ? c.getX() - 8 - this.mHelpDialog.getWidth() : c.getX() + 8 + c.getWidth();
            this.mHelpDialog.setLocation(x, c.getY());
        }
    }

    private Component getParent() {
        Container parent = this.mParentComponent;
        while (!(parent instanceof Frame) && !(parent instanceof Dialog) && parent.getParent() != null) {
            parent = parent.getParent();
        }
        return parent;
    }
}

