/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.gui.wmf;

import com.actelion.research.gui.wmf.MetaFile;
import com.actelion.research.gui.wmf.WMFConstants;
import java.awt.Color;
import java.awt.Font;
import java.awt.Polygon;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class WMF
extends MetaFile
implements WMFConstants {
    private int maxObjectSize = 0;
    private ByteArrayOutputStream wmf = new ByteArrayOutputStream();
    private Vector<Boolean> handles = new Vector();
    private static boolean loaded = false;
    private static String[][] fontnames = new String[][]{{"helvetica", "Arial"}, {"timesroman", "Times New Roman"}, {"courier", "Courier New"}, {"zapfdingsbat", "Windings"}, {"dialog", "Arial"}, {"dialoginput", "Courier New"}, {"serif", "Times New Roman"}, {"sansserif", "Arial"}, {"monospaced", "Courier New"}};
    public static final int MFCOMMENT = 15;

    public WMF() {
        this.setupFontNames();
    }

    protected int addHandle() {
        for (int i = 0; i < this.handles.size(); ++i) {
            if (this.handles.elementAt(i).booleanValue()) continue;
            this.handles.setElementAt(Boolean.TRUE, i);
            return i;
        }
        this.handles.addElement(Boolean.TRUE);
        return this.handles.size() - 1;
    }

    @Override
    public void arc(int left, int top, int right, int bottom, int xstart, int ystart, int xend, int yend) {
        this.writeRecordHeader(2071, 8);
        this.writeWord(yend);
        this.writeWord(xend);
        this.writeWord(ystart);
        this.writeWord(xstart);
        this.writeWord(bottom);
        this.writeWord(right);
        this.writeWord(top);
        this.writeWord(left);
    }

    @Override
    public int createBrushIndirect(int style, Color color, int hatch) {
        this.writeRecordHeader(764, 4);
        this.writeWord(style);
        this.writeColor(color);
        this.writeWord(hatch);
        return this.addHandle();
    }

    @Override
    public int createFont(Font font, int i, boolean flag, boolean flag1) {
        int c = 400;
        if (font.isBold()) {
            c = 700;
        }
        return this.createFont(-font.getSize(), 0, i, 0, c, font.isItalic(), flag, flag1, (byte)0, (byte)0, (byte)0, (byte)0, (byte)0, this.translateFontName(font.getName()));
    }

    @Override
    public int createFont(int height, int with, int esc, int orient, int weight, boolean italic, boolean underline, boolean strikeOut, byte charSet, byte outPrecision, byte clipPrecision, byte quality, byte pitchAndFamily, String s) {
        this.writeRecordHeader(763, 9 + (s.length() + 2) / 2);
        this.writeWord(height);
        this.writeWord(with);
        this.writeWord(esc);
        this.writeWord(orient);
        this.writeWord(weight);
        int value = 0;
        if (italic) {
            value = 1;
        }
        if (underline) {
            value += 256;
        }
        this.writeWord(value);
        value = charSet << 8 & 0xFF00;
        if (strikeOut) {
            ++value;
        }
        this.writeWord(value);
        this.writeWord(outPrecision | clipPrecision << 8 & 0xFF00);
        this.writeWord(quality | pitchAndFamily << 8 & 0xFF00);
        byte[] buffer = new byte[s.length() + 2];
        s.getBytes(0, s.length(), buffer, 0);
        buffer[buffer.length - 2] = 0;
        buffer[buffer.length - 1] = 0;
        for (int i = 0; i < buffer.length / 2; ++i) {
            this.writeWord(buffer[i * 2] | buffer[i * 2 + 1] << 8 & 0xFF00);
        }
        return this.addHandle();
    }

    @Override
    public int createPatternBrush(int[] ai, int i, int j) {
        int k = (i * 3 + 3) / 4 * 4;
        this.writeRecordHeader(322, 22 + k / 2 * j);
        this.writeWord(3);
        this.writeWord(0);
        this.writeBitmap(ai, i, j);
        return this.addHandle();
    }

    @Override
    public int createPenIndirect(int style, int width, Color color) {
        this.writeRecordHeader(762, 5);
        this.writeWord(style);
        this.writeInteger(width);
        this.writeColor(color);
        return this.addHandle();
    }

    @Override
    public void deleteObject(int i) {
        if (i >= this.handles.size() || !this.handles.elementAt(i).booleanValue()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.writeRecordHeader(496, 1);
        this.writeWord(i);
        this.handles.setElementAt(Boolean.FALSE, i);
    }

    @Override
    public void ellipse(int left, int top, int right, int bottom) {
        this.writeRecordHeader(1048, 4);
        this.writeWord(bottom);
        this.writeWord(right);
        this.writeWord(top);
        this.writeWord(left);
    }

    @Override
    public void escape(int function, byte[] data) {
        this.writeRecordHeader(1574, 2 + (data.length + 1) / 2);
        this.writeWord(function);
        this.writeWord(data.length);
        byte[] copy = new byte[(data.length + 1) / 2 * 2];
        System.arraycopy(data, 0, copy, 0, data.length);
        for (int j = 0; j < copy.length; j += 2) {
            int t = copy[j] & 0xFF | copy[j + 1] << 8 & 0xFF00;
            this.writeWord(t);
        }
    }

    private int getBodySize() {
        return this.wmf.size() / 2;
    }

    private String getFontProperty(Properties properties, String s) throws Exception {
        String s1 = properties.getProperty(s + ".0");
        if (s1 == null) {
            s1 = properties.getProperty(s + ".plain.0");
        }
        if (s1 == null) {
            throw new Exception(s + " not found");
        }
        StringTokenizer stringtokenizer = new StringTokenizer(s1, ",");
        return stringtokenizer.nextToken().trim();
    }

    private int highWord(int i) {
        return (i & 0xFFFF0000) >> 16;
    }

    @Override
    public void intersectClipRect(int i, int j, int k, int l) {
        this.writeRecordHeader(1046, 4);
        this.writeWord(l);
        this.writeWord(k);
        this.writeWord(j);
        this.writeWord(i);
    }

    @Override
    public void lineTo(int x, int y) {
        this.writeRecordHeader(531, 2);
        this.writeWord(y);
        this.writeWord(x);
    }

    private void setupFontNames() {
        if (!loaded) {
            try {
                String language = Locale.getDefault().getLanguage();
                String country = Locale.getDefault().getCountry();
                String propsLib = "lib" + File.separatorChar + "font.properties";
                File file = new File(System.getProperty("java.home"), propsLib + '.' + language + '_' + country);
                if (!file.exists()) {
                    file = new File(System.getProperty("java.home"), propsLib + '.' + language);
                }
                if (!file.exists()) {
                    file = new File(System.getProperty("java.home"), propsLib);
                }
                if (file.exists()) {
                    Properties properties = new Properties();
                    properties.load(new FileInputStream(file));
                    String[][] as = new String[5][2];
                    int i = 0;
                    as[i][0] = "dialog";
                    as[i][1] = this.getFontProperty(properties, as[i][0]);
                    as[++i][0] = "dialoginput";
                    as[i][1] = this.getFontProperty(properties, as[i][0]);
                    as[++i][0] = "serif";
                    as[i][1] = this.getFontProperty(properties, as[i][0]);
                    as[++i][0] = "sansserif";
                    as[i][1] = this.getFontProperty(properties, as[i][0]);
                    as[++i][0] = "monospaced";
                    as[i][1] = this.getFontProperty(properties, as[i][0]);
                    fontnames = as;
                    loaded = true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private int lowWord(int i) {
        return i & 0xFFFF;
    }

    private void maxObjectSize(int i) {
        if (i > this.maxObjectSize) {
            this.maxObjectSize = i;
        }
    }

    protected void writeRecordHeader(int record, int size) {
        int totalSize = size + 3;
        this.writeInteger(totalSize);
        this.writeWord(record);
        this.maxObjectSize(totalSize);
    }

    @Override
    public void moveTo(int x, int y) {
        this.writeRecordHeader(532, 2);
        this.writeWord(y);
        this.writeWord(x);
    }

    private void outputInteger(OutputStream outputstream, int i) throws IOException {
        this.outputWord(outputstream, this.lowWord(i));
        this.outputWord(outputstream, this.highWord(i));
    }

    private void outputWord(OutputStream outputstream, int i) throws IOException {
        byte[] word = new byte[]{(byte)(i & 0xFF), (byte)((i & 0xFF00) >> 8)};
        outputstream.write(word);
    }

    @Override
    public void pie(int left, int top, int right, int bottom, int xR1, int yR1, int xR2, int yR2) {
        this.writeRecordHeader(2074, 8);
        this.writeWord(yR2);
        this.writeWord(xR2);
        this.writeWord(yR1);
        this.writeWord(xR1);
        this.writeWord(bottom);
        this.writeWord(right);
        this.writeWord(top);
        this.writeWord(left);
    }

    @Override
    public void polygon(int[] ptx, int[] pty, int count) {
        this.writeRecordHeader(804, 1 + 2 * count);
        this.writeWord(count);
        for (int j = 0; j < count; ++j) {
            this.writeWord(ptx[j]);
            this.writeWord(pty[j]);
        }
    }

    @Override
    public void polyline(int[] ptx, int[] pty, int count) {
        this.writeRecordHeader(805, 1 + 2 * count);
        this.writeWord(count);
        for (int j = 0; j < count; ++j) {
            this.writeWord(ptx[j]);
            this.writeWord(pty[j]);
        }
    }

    @Override
    public void polypolygon(Polygon[] apolygon) {
        int i = 0;
        for (int j = 0; j < apolygon.length; ++j) {
            i += apolygon[j].npoints;
        }
        this.writeRecordHeader(1336, 1 + apolygon.length + 2 * i);
        this.writeWord(apolygon.length);
        for (int k = 0; k < apolygon.length; ++k) {
            this.writeWord(apolygon[k].npoints);
        }
        for (int l = 0; l < apolygon.length; ++l) {
            for (int i1 = 0; i1 < apolygon[l].npoints; ++i1) {
                this.writeWord(apolygon[l].xpoints[i1]);
                this.writeWord(apolygon[l].ypoints[i1]);
            }
        }
    }

    @Override
    public void rectangle(int left, int top, int right, int bottom) {
        this.writeRecordHeader(1051, 4);
        this.writeWord(bottom);
        this.writeWord(right);
        this.writeWord(top);
        this.writeWord(left);
    }

    @Override
    public void roundRect(int left, int top, int right, int bottom, int width, int height) {
        this.writeRecordHeader(1564, 6);
        this.writeWord(height);
        this.writeWord(width);
        this.writeWord(bottom);
        this.writeWord(right);
        this.writeWord(top);
        this.writeWord(left);
    }

    @Override
    public void selectObject(int handle) {
        if (handle >= this.handles.size() || !this.handles.elementAt(handle).booleanValue()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.writeRecordHeader(301, 1);
        this.writeWord(handle);
    }

    @Override
    public void setBKColor(Color color) {
        this.writeRecordHeader(513, 2);
        this.writeColor(color);
    }

    @Override
    public void setBKMode(int mode) {
        this.writeRecordHeader(258, 1);
        this.writeWord(mode);
    }

    @Override
    public void setClipRgn() {
        this.writeRecordHeader(300, 1);
        this.writeWord(0);
    }

    @Override
    public void setMapMode(int mode) {
        this.writeRecordHeader(259, 1);
        this.writeWord(mode);
    }

    @Override
    public void setPixel(int x, int y, Color color) {
        this.writeRecordHeader(1055, 4);
        this.writeColor(color);
        this.writeWord(y);
        this.writeWord(x);
    }

    @Override
    public void setPolyFillMode(int mode) {
        this.writeRecordHeader(262, 1);
        this.writeWord(mode);
    }

    @Override
    public void setROP2(int mode) {
        this.writeRecordHeader(260, 1);
        this.writeWord(mode);
    }

    @Override
    public void setStretchBltMode(int mode) {
        this.writeRecordHeader(263, 1);
        this.writeWord(mode);
    }

    @Override
    public void setTextAlign(int i) {
        this.writeRecordHeader(302, 1);
        this.writeWord(i);
    }

    @Override
    public void setTextCharacterExtra(int i) {
        this.writeRecordHeader(264, 1);
        this.writeWord(i);
    }

    @Override
    public void setTextColor(Color color) {
        this.writeRecordHeader(521, 2);
        this.writeColor(color);
    }

    @Override
    public void setViewportExt(int i, int j) {
        this.writeRecordHeader(526, 2);
        this.writeWord(j);
        this.writeWord(i);
    }

    @Override
    public void setWindowExt(int cx, int cy) {
        this.writeRecordHeader(524, 2);
        this.writeWord(cy);
        this.writeWord(cx);
    }

    @Override
    public void setWindowOrg(int x, int y) {
        this.writeRecordHeader(523, 2);
        this.writeWord(y);
        this.writeWord(x);
    }

    @Override
    public void stretchBlt(int xOrigDest, int yOrigDest, int widthDest, int heightDest, int xOrigSrc, int yOrigSrc, int widthSrc, int heightSrc, int rasterOp, int[] pixelData, int imageWidth, int imageHeight) {
        int l2 = (imageWidth * 3 + 3) / 4 * 4;
        this.writeRecordHeader(2881, 30 + l2 / 2 * imageHeight);
        this.writeInteger(rasterOp);
        this.writeWord(heightSrc);
        this.writeWord(widthSrc);
        this.writeWord(yOrigSrc);
        this.writeWord(xOrigSrc);
        this.writeWord(heightDest);
        this.writeWord(widthDest);
        this.writeWord(yOrigDest);
        this.writeWord(xOrigDest);
        this.writeBitmap(pixelData, imageWidth, imageHeight);
    }

    @Override
    public void textOut(int x, int y, String s) {
        this.writeRecordHeader(1313, 3 + (s.length() + 1) / 2);
        this.writeWord(s.length());
        byte[] buffer = new byte[s.length() + 1];
        s.getBytes(0, s.length(), buffer, 0);
        buffer[buffer.length - 1] = 0;
        for (int k = 0; k < buffer.length / 2; ++k) {
            int l = 0;
            l = buffer[k * 2] | buffer[k * 2 + 1] << 8 & 0xFF00;
            this.writeWord(l);
        }
        this.writeWord(y);
        this.writeWord(x);
    }

    @Override
    public String translateFontName(String s) {
        String s1 = s;
        String s2 = s.toLowerCase();
        for (int i = 0; i < fontnames.length; ++i) {
            if (!s2.equals(fontnames[i][0])) continue;
            s1 = fontnames[i][1];
            break;
        }
        return s1;
    }

    protected void writeBitmap(int[] ai, int imageWidth, int imageHeight) {
        int y;
        int alignedWidth = (imageWidth * 3 + 3) / 4 * 4;
        byte[] buffer = new byte[alignedWidth * imageHeight];
        for (y = 0; y < imageHeight; ++y) {
            for (int x = 0; x < imageWidth; ++x) {
                int index = x * 3 + y * alignedWidth;
                int temp = ai[x + y * imageWidth];
                buffer[index + 2] = (byte)(temp >> 16 & 0xFF);
                buffer[index + 1] = (byte)(temp >> 8 & 0xFF);
                buffer[index] = (byte)(temp & 0xFF);
            }
        }
        this.writeInteger(40);
        this.writeInteger(imageWidth);
        this.writeInteger(imageHeight);
        this.writeWord(1);
        this.writeWord(24);
        this.writeInteger(0);
        this.writeInteger(0);
        this.writeInteger(0);
        this.writeInteger(0);
        this.writeInteger(0);
        this.writeInteger(0);
        for (y = imageHeight - 1; y >= 0; --y) {
            int index = y * alignedWidth;
            for (int x = 0; x < alignedWidth; x += 2) {
                int k2 = x + index;
                this.writeWord(buffer[k2 + 1] << 8 & 0xFF00 | buffer[k2] & 0xFF);
            }
        }
    }

    private void writeBody(OutputStream outputstream) throws IOException {
        this.wmf.writeTo(outputstream);
    }

    protected void writeColor(Color color) {
        this.writeInteger(color.getRed() & 0xFF | color.getGreen() << 8 & 0xFF00 | color.getBlue() << 16 & 0xFF0000);
    }

    private void writeHeader(OutputStream outputstream) throws IOException {
        this.writeRecordHeader(0, 0);
        this.outputWord(outputstream, 1);
        this.outputWord(outputstream, 9);
        this.outputWord(outputstream, 768);
        this.outputInteger(outputstream, this.getBodySize() + 9);
        this.outputWord(outputstream, this.handles.size());
        this.outputInteger(outputstream, this.maxObjectSize);
        this.outputWord(outputstream, 0);
    }

    protected void writeInteger(int i) {
        this.writeWord(this.lowWord(i));
        this.writeWord(this.highWord(i));
    }

    public void writeWMF(OutputStream outputstream) throws IOException {
        this.writeHeader(outputstream);
        this.writeBody(outputstream);
    }

    protected void writeWord(int i) {
        try {
            this.outputWord(this.wmf, i);
        }
        catch (IOException ioexception) {
            System.out.println(ioexception);
        }
    }
}

