/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.gui.wmf;

import com.actelion.research.gui.wmf.GraphicsState;
import com.actelion.research.gui.wmf.MetaFile;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.image.ImageObserver;
import java.awt.image.PixelGrabber;
import java.text.AttributedCharacterIterator;

public class WMFGraphics
extends Graphics {
    public static final int MM_ANISOTROPIC = 8;
    private static final int BS_NULL = 1;
    public static final int SRC_AND = 8913094;
    public static final int SRC_PAINT = 15597702;
    public static final int SRC_COPY = 0xCC0020;
    private MetaFile wmf;
    private Color foreground;
    private Color background;
    private Font font = new Font("Helvetica", 0, 12);
    private int penstyle;
    private int penwidth;
    private int brushfillstyle;
    private int brushhatch;
    private int fontescapement;
    private Image brushpattern;
    private int penhandle;
    private int brushhandle;
    private int fonthandle;
    private Rectangle clip;
    private Point origin;
    private GraphicsState state;

    public WMFGraphics(MetaFile w, int width, int height, Color fg, Color bg) {
        this.penstyle = 0;
        this.penwidth = 1;
        this.brushfillstyle = 0;
        this.brushhatch = 0;
        this.fontescapement = 0;
        this.brushpattern = null;
        this.origin = new Point(0, 0);
        this.foreground = fg;
        this.background = bg;
        this.state = new GraphicsState();
        this.state.increaseCount();
        this.setWMF(w, width, height);
        this.reset();
    }

    public Color getBackground() {
        return this.background;
    }

    public void setBackground(Color background) {
        this.background = background;
    }

    WMFGraphics(MetaFile w, GraphicsState graphicsstate, Color fg, Color bg, Font font, int penstyle, int penwidth, int brushFillStyle, int brushHatch, int fontEsc, Image image, Point origin, Rectangle rectangle) {
        this.wmf = w;
        this.state = graphicsstate;
        graphicsstate.increaseCount();
        this.foreground = fg;
        this.background = bg;
        this.font = font;
        this.penstyle = penstyle;
        this.penwidth = penwidth;
        this.brushfillstyle = brushFillStyle;
        this.brushhatch = brushHatch;
        this.fontescapement = fontEsc;
        this.brushpattern = image;
        this.origin = new Point(origin.x, origin.y);
        if (rectangle != null) {
            this.clip = new Rectangle(rectangle);
        }
        this.createHandles();
        this.setGDIPen();
        this.setGDIHollowBrush();
        this.setGDIFont();
    }

    public void GDIPolyPolygon(Polygon[] apolygon) {
        this.restore();
        this.setGDIFillBrush();
        this.wmf.polypolygon(apolygon);
        this.setGDIHollowBrush();
    }

    @Override
    public void clearRect(int i, int j, int k, int l) {
        this.restore();
        Color color = this.foreground;
        this.setColor(this.background);
        this.fillRect(i, j, k, l);
        this.setColor(color);
    }

    @Override
    public void clipRect(int i, int j, int k, int l) {
        this.restore();
        this.wmf.intersectClipRect(i, j, i + k + 1, j + l + 1);
        Rectangle rectangle = new Rectangle(i, j, k, l);
        this.clip = this.clip != null ? this.clip.intersection(rectangle) : rectangle;
        this.state.setClip(this.clip);
    }

    @Override
    public void copyArea(int i, int j, int k, int l, int i1, int j1) {
        System.err.println("copyArea not supported");
    }

    @Override
    public Graphics create() {
        WMFGraphics wmfgraphics = new WMFGraphics(this.wmf, this.state, this.foreground, this.background, this.font, this.penstyle, this.penwidth, this.brushfillstyle, this.brushhatch, this.fontescapement, this.brushpattern, this.origin, this.clip);
        return wmfgraphics;
    }

    public void createHandles() {
        this.penhandle = this.wmf.createPenIndirect(this.penstyle, this.penwidth, this.foreground);
        this.wmf.selectObject(this.penhandle);
        this.state.setPen(this.penhandle);
        this.brushhandle = this.wmf.createBrushIndirect(1, this.foreground, this.brushhatch);
        this.wmf.selectObject(this.brushhandle);
        this.state.setPen(this.brushhandle);
        this.fonthandle = this.wmf.createFont(this.font, this.fontescapement, false, false);
        this.wmf.selectObject(this.fonthandle);
        this.state.setPen(this.fonthandle);
    }

    public void deleteHandles() {
        this.wmf.deleteObject(this.penhandle);
        this.wmf.deleteObject(this.brushhandle);
        this.wmf.deleteObject(this.fonthandle);
    }

    @Override
    public void dispose() {
        this.state.decreaseCount();
    }

    @Override
    public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.restore();
        int k1 = x + width / 2;
        int l1 = y + height / 2;
        this.wmf.arc(x, y, x + width + 1, y + height + 1, k1 + (int)Math.round((double)width * Math.sin(Math.PI * 2 * (double)(startAngle + 90) / 360.0)), l1 + (int)Math.round((double)height * Math.cos(Math.PI * 2 * (double)(startAngle + 90) / 360.0)), k1 + (int)Math.round((double)width * Math.sin(Math.PI * 2 * (double)(startAngle + arcAngle + 90) / 360.0)), l1 + (int)Math.round((double)height * Math.cos(Math.PI * 2 * (double)(startAngle + arcAngle + 90) / 360.0)));
    }

    @Override
    public boolean drawImage(Image image, int leftD, int topD, int rightD, int bottomD, int leftS, int topS, int rightS, int bottomS, Color color, ImageObserver imageobserver) {
        this.restore();
        int imagewidth = image.getWidth(imageobserver);
        int imageheight = image.getHeight(imageobserver);
        int[] pixbuffer = new int[imagewidth * imageheight];
        PixelGrabber pixelgrabber = new PixelGrabber(image, 0, 0, imagewidth, imageheight, pixbuffer, 0, imagewidth);
        try {
            pixelgrabber.grabPixels();
        }
        catch (InterruptedException _ex) {
            return false;
        }
        if ((pixelgrabber.status() & 0x80) != 0) {
            return false;
        }
        int diffx = rightD - leftD;
        int diffy = bottomD - topD;
        int sourcediffx = rightS - leftS;
        int sourcediffy = bottomS - topS;
        int k3 = bottomS;
        bottomS = imageheight - topS;
        topS = imageheight - k3;
        if (diffx < 0 != sourcediffx < 0) {
            this.flipHorizontal(pixbuffer, imagewidth, imageheight);
            leftS = sourcediffx < 0 ? imagewidth - leftS : imagewidth - rightS;
        }
        if (diffx < 0) {
            leftD = rightD;
            if (sourcediffx < 0) {
                leftS = rightS;
            }
            diffx = -diffx;
        }
        if (sourcediffx < 0) {
            sourcediffx = -sourcediffx;
        }
        if (diffy < 0 != sourcediffy < 0) {
            this.flipVertical(pixbuffer, imagewidth, imageheight);
            topS = sourcediffy < 0 ? imageheight - topS : imageheight - bottomS;
        }
        if (diffy < 0) {
            topD = bottomD;
            if (sourcediffy < 0) {
                topS = bottomS;
            }
            diffy = -diffy;
        }
        if (sourcediffy < 0) {
            sourcediffy = -sourcediffy;
        }
        int l3 = color.getRGB();
        for (int i4 = 0; i4 < pixbuffer.length; ++i4) {
            if ((pixbuffer[i4] & 0xFF000000) != 0) continue;
            pixbuffer[i4] = l3;
        }
        this.wmf.stretchBlt(leftD, topD, diffx, diffy, leftS, topS, sourcediffx, sourcediffy, 0xCC0020, pixbuffer, imagewidth, imageheight);
        return true;
    }

    @Override
    public boolean drawImage(Image image, int leftD, int topD, int rightD, int bottomD, int leftS, int topS, int rightS, int bottomS, ImageObserver imageobserver) {
        this.restore();
        int imagewidth = image.getWidth(imageobserver);
        int imageheight = image.getHeight(imageobserver);
        int[] pixarray = new int[imagewidth * imageheight];
        PixelGrabber pixelgrabber = new PixelGrabber(image, 0, 0, imagewidth, imageheight, pixarray, 0, imagewidth);
        try {
            pixelgrabber.grabPixels();
        }
        catch (InterruptedException _ex) {
            return false;
        }
        if ((pixelgrabber.status() & 0x80) != 0) {
            return false;
        }
        int ddiffx = rightD - leftD;
        int ddiffy = bottomD - topD;
        int sdiffx = rightS - leftS;
        int sdiffy = bottomS - topS;
        bottomS = imageheight - topS;
        topS = imageheight - bottomS;
        if (ddiffx < 0 != sdiffx < 0) {
            this.flipHorizontal(pixarray, imagewidth, imageheight);
            leftS = sdiffx < 0 ? imagewidth - leftS : imagewidth - rightS;
        }
        if (ddiffx < 0) {
            leftD = rightD;
            if (sdiffx < 0) {
                leftS = rightS;
            }
            ddiffx = -ddiffx;
        }
        if (sdiffx < 0) {
            sdiffx = -sdiffx;
        }
        if (ddiffy < 0 != sdiffy < 0) {
            this.flipVertical(pixarray, imagewidth, imageheight);
            topS = sdiffy < 0 ? imageheight - topS : imageheight - bottomS;
        }
        if (ddiffy < 0) {
            topD = bottomD;
            if (sdiffy < 0) {
                topS = bottomS;
            }
            ddiffy = -ddiffy;
        }
        if (sdiffy < 0) {
            sdiffy = -sdiffy;
        }
        int[] ai1 = new int[pixarray.length];
        boolean flag = false;
        for (int l3 = 0; l3 < pixarray.length; ++l3) {
            if ((pixarray[l3] & 0xFF000000) == 0) {
                ai1[l3] = -1;
                pixarray[l3] = 0;
                flag = true;
                continue;
            }
            ai1[l3] = 0;
        }
        if (flag) {
            this.wmf.stretchBlt(leftD, topD, ddiffx, ddiffy, leftS, topS, sdiffx, sdiffy, 8913094, ai1, imagewidth, imageheight);
            this.wmf.stretchBlt(leftD, topD, ddiffx, ddiffy, leftS, topS, sdiffx, sdiffy, 15597702, pixarray, imagewidth, imageheight);
        } else {
            this.wmf.stretchBlt(leftD, topD, ddiffx, ddiffy, leftS, topS, sdiffx, sdiffy, 0xCC0020, pixarray, imagewidth, imageheight);
        }
        return true;
    }

    @Override
    public boolean drawImage(Image image, int left, int top, int width, int height, Color color, ImageObserver imageobserver) {
        this.restore();
        return this.drawImage(image, left, top, left + width, top + height, 0, 0, image.getWidth(imageobserver), image.getHeight(imageobserver), color, imageobserver);
    }

    @Override
    public boolean drawImage(Image image, int x, int y, int w, int h, ImageObserver imageobserver) {
        this.restore();
        return this.drawImage(image, x, y, x + w, y + h, 0, 0, image.getWidth(imageobserver), image.getHeight(imageobserver), imageobserver);
    }

    @Override
    public boolean drawImage(Image image, int x, int y, Color color, ImageObserver imageobserver) {
        this.restore();
        return this.drawImage(image, x, y, image.getWidth(imageobserver), image.getHeight(imageobserver), color, imageobserver);
    }

    @Override
    public boolean drawImage(Image image, int x, int y, ImageObserver imageobserver) {
        this.restore();
        return this.drawImage(image, x, y, image.getWidth(imageobserver), image.getHeight(imageobserver), imageobserver);
    }

    @Override
    public void drawLine(int x1, int y1, int x2, int y2) {
        this.restore();
        this.wmf.moveTo(x1, y1);
        this.wmf.lineTo(x2, y2);
        this.wmf.setPixel(x2, y2, this.getColor());
    }

    @Override
    public void drawOval(int x, int y, int width, int height) {
        this.restore();
        this.wmf.ellipse(x, y, x + width + 1, y + height + 1);
    }

    @Override
    public void drawPolygon(int[] ai, int[] ai1, int i) {
        this.restore();
        this.wmf.polygon(ai, ai1, i);
    }

    @Override
    public void drawPolyline(int[] xPoints, int[] yPoints, int i) {
        this.restore();
        this.wmf.polyline(xPoints, yPoints, i);
        this.wmf.setPixel(xPoints[i - 1], yPoints[i - 1], this.getColor());
    }

    @Override
    public void drawRect(int x, int y, int width, int height) {
        this.restore();
        this.wmf.rectangle(x, y, x + width + 1, y + height + 1);
    }

    @Override
    public void drawRoundRect(int x, int y, int width, int height, int i1, int j1) {
        this.restore();
        this.wmf.roundRect(x, y, x + width + 1, y + height + 1, i1, j1);
    }

    @Override
    public void drawString(String s, int x, int y) {
        this.restore();
        this.wmf.textOut(x, y, s);
    }

    @Override
    public void drawString(AttributedCharacterIterator attributedcharacteriterator, int i, int j) {
        System.err.println("drawString(java.text.AttributedCharacterIterator,..) not supported");
    }

    @Override
    public void fillArc(int x, int y, int width, int height, int startAngle, int endAngle) {
        this.restore();
        this.setGDIFillBrush();
        int cx = x + width / 2;
        int cy = y + height / 2;
        this.wmf.pie(x, y, x + width + 1, y + height + 1, cx + (int)Math.round((double)width * Math.sin(Math.PI * 2 * (double)(startAngle + 90) / 360.0)), cy + (int)Math.round((double)height * Math.cos(Math.PI * 2 * (double)(startAngle + 90) / 360.0)), cx + (int)Math.round((double)width * Math.sin(Math.PI * 2 * (double)(startAngle + endAngle + 90) / 360.0)), cy + (int)Math.round((double)height * Math.cos(Math.PI * 2 * (double)(startAngle + endAngle + 90) / 360.0)));
        this.setGDIHollowBrush();
    }

    @Override
    public void fillOval(int x, int y, int rx, int ry) {
        this.restore();
        this.setGDIFillBrush();
        this.drawOval(x, y, rx - 1, ry - 1);
        this.setGDIHollowBrush();
    }

    @Override
    public void fillPolygon(int[] ai, int[] ai1, int i) {
        this.restore();
        this.setGDIFillBrush();
        this.drawPolygon(ai, ai1, i);
        this.setGDIHollowBrush();
    }

    @Override
    public void fillRect(int i, int j, int k, int l) {
        this.restore();
        this.setGDIFillBrush();
        this.drawRect(i, j, k - 1, l - 1);
        this.setGDIHollowBrush();
    }

    @Override
    public void fillRoundRect(int i, int j, int k, int l, int i1, int j1) {
        this.restore();
        this.setGDIFillBrush();
        this.drawRoundRect(i, j, k - 1, l - 1, i1, j1);
        this.setGDIHollowBrush();
    }

    private void flipHorizontal(int[] ai, int i, int j) {
        for (int k = 0; k < j; ++k) {
            int l = k * j;
            for (int i1 = 0; i1 < i / 2; ++i1) {
                int j1 = ai[l + i1];
                ai[l + i1] = ai[l + i - 1 - i1];
                ai[l + i - 1 - i1] = j1;
            }
        }
    }

    private void flipVertical(int[] ai, int i, int j) {
        int[] ai1 = new int[i];
        for (int k = 0; k < j / 2; ++k) {
            System.arraycopy(ai, k * i, ai1, 0, i);
            System.arraycopy(ai, (j - k - 1) * i, ai, k * i, i);
            System.arraycopy(ai1, 0, ai, (j - k - 1) * i, i);
        }
    }

    public int getBrushFillStyle() {
        return this.brushfillstyle;
    }

    @Override
    public Shape getClip() {
        return this.getClipBounds();
    }

    @Override
    public Rectangle getClipBounds() {
        if (this.clip != null) {
            return new Rectangle(this.clip);
        }
        return null;
    }

    @Override
    public Color getColor() {
        return this.foreground;
    }

    @Override
    public Font getFont() {
        return this.font;
    }

    @Override
    public FontMetrics getFontMetrics(Font font1) {
        return Toolkit.getDefaultToolkit().getFontMetrics(font1);
    }

    public int getPenStyle() {
        return this.penstyle;
    }

    private void reset() {
        this.setPenStyle(0);
        this.setPenWidth(1);
        this.setBrushFillStyle(0);
        this.setBrushHatch(0);
        this.setFontEscapement(0);
    }

    private void restore() {
        if (this.state.getCount() > 1) {
            if (this.penhandle != this.state.getPen()) {
                this.wmf.selectObject(this.penhandle);
                this.state.setPen(this.penhandle);
            }
            if (this.brushhandle != this.state.getBrush()) {
                this.wmf.selectObject(this.brushhandle);
                this.state.setBrush(this.brushhandle);
            }
            if (this.fonthandle != this.state.getFont()) {
                this.wmf.selectObject(this.fonthandle);
                this.state.setFont(this.fonthandle);
            }
            if (this.clip != this.state.getClip()) {
                this.setClip(this.clip);
                this.state.setClip(this.clip);
            }
            if (!this.origin.equals(this.state.getOrigin())) {
                this.translate(this.origin.x, this.origin.y);
                this.state.setOrigin(this.origin);
            }
        }
    }

    public void setBrushFillStyle(int i) {
        this.brushfillstyle = i;
    }

    public void setBrushHatch(int i) {
        this.brushhatch = i;
    }

    public void setBrushPattern(Image image) {
        this.brushpattern = image;
    }

    @Override
    public void setClip(int x, int y, int w, int h) {
        this.setClip(new Rectangle(x, y, w, h));
    }

    @Override
    public void setClip(Shape shape) {
        this.wmf.setClipRgn();
        this.clip = null;
        if (shape != null) {
            Rectangle rectangle = shape.getBounds();
            this.clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    @Override
    public void setColor(Color color) {
        this.restore();
        this.foreground = color;
        this.setGDIPen();
        this.wmf.setTextColor(this.foreground);
    }

    @Override
    public void setFont(Font font1) {
        this.restore();
        this.font = font1;
        this.setGDIFont();
    }

    public void setFontEscapement(int i) {
        this.fontescapement = i;
        this.setGDIFont();
    }

    public int setGDIFillBrush() {
        int i;
        block7: {
            i = this.brushhandle;
            if (this.brushfillstyle == 3) {
                if (this.brushpattern != null) {
                    int j = this.brushpattern.getWidth(null);
                    int k = this.brushpattern.getHeight(null);
                    int[] ai = new int[j * k];
                    PixelGrabber pixelgrabber = new PixelGrabber(this.brushpattern, 0, 0, j, k, ai, 0, j);
                    try {
                        pixelgrabber.grabPixels();
                        if ((pixelgrabber.status() & 0x80) != 0) {
                            this.brushhandle = this.wmf.createBrushIndirect(0, this.foreground, this.brushhatch);
                            break block7;
                        }
                        this.brushhandle = this.wmf.createPatternBrush(ai, j, k);
                    }
                    catch (InterruptedException _ex) {
                        this.brushhandle = this.wmf.createBrushIndirect(0, this.foreground, this.brushhatch);
                    }
                } else {
                    this.brushhandle = this.wmf.createBrushIndirect(0, this.foreground, this.brushhatch);
                }
            } else {
                this.brushhandle = this.wmf.createBrushIndirect(this.brushfillstyle, this.foreground, this.brushhatch);
            }
        }
        this.wmf.selectObject(this.brushhandle);
        this.wmf.deleteObject(i);
        this.state.setBrush(this.brushhandle);
        return this.brushhandle;
    }

    public int setGDIFont() {
        int i = this.fonthandle;
        this.fonthandle = this.wmf.createFont(this.font, this.fontescapement, false, false);
        this.wmf.selectObject(this.fonthandle);
        this.wmf.deleteObject(i);
        this.state.setFont(this.fonthandle);
        return this.fonthandle;
    }

    public int setGDIHollowBrush() {
        int i = this.brushhandle;
        this.brushhandle = this.wmf.createBrushIndirect(1, this.foreground, this.brushhatch);
        this.wmf.selectObject(this.brushhandle);
        this.wmf.deleteObject(i);
        this.state.setBrush(this.brushhandle);
        return this.brushhandle;
    }

    public int setGDIPen() {
        int i = this.penhandle;
        this.penhandle = this.wmf.createPenIndirect(this.penstyle, this.penwidth, this.foreground);
        this.wmf.selectObject(this.penhandle);
        this.wmf.deleteObject(i);
        this.state.setPen(this.penhandle);
        return this.penhandle;
    }

    @Override
    public void setPaintMode() {
        System.err.println("setPaintMode not supported");
    }

    public void setPenStyle(int i) {
        this.penstyle = i;
        this.setGDIPen();
    }

    public void setPenWidth(int i) {
        this.penwidth = i;
        this.setGDIPen();
    }

    public void setWMF(MetaFile wmf1, int width, int height) {
        this.wmf = wmf1;
        this.createHandles();
        this.setup(width, height);
    }

    @Override
    public void setXORMode(Color color) {
        System.err.println("setXORMode not supported");
    }

    public void setSize(int width, int height) {
        this.wmf.setWindowExt(width, height);
    }

    private void setup(int width, int height) {
        this.wmf.setMapMode(8);
        this.wmf.setWindowOrg(0, 0);
        this.wmf.setWindowExt(width, height);
        this.wmf.setViewportExt(width, height);
        this.wmf.setTextAlign(24);
        this.wmf.setBKMode(1);
        this.wmf.setBKColor(this.background);
        this.wmf.setTextColor(this.foreground);
        this.wmf.setPolyFillMode(1);
        this.wmf.setStretchBltMode(3);
        this.wmf.setROP2(13);
        this.wmf.setTextCharacterExtra(0);
    }

    @Override
    public void translate(int i, int j) {
        this.origin.translate(i, j);
        this.wmf.setWindowOrg(-this.origin.x, -this.origin.y);
        this.state.setOrigin(this.origin);
    }

    public void setPolyFillMode(int alternate) {
        this.wmf.setPolyFillMode(alternate);
    }
}

