/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.gui.wmf;

import com.actelion.research.gui.wmf.WMF;
import com.actelion.research.gui.wmf.WMFGraphics;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageObserver;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.text.AttributedCharacterIterator;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;

public class WMFGraphics2D
extends Graphics2D {
    private BufferedImage img;
    private WMFGraphics wmfg;
    private Graphics2D g2D;
    private AffineTransform trans;
    private Stroke stroke;
    private Paint paint;
    private Color color;
    private Shape deviceclip;
    private boolean gdifontdrawing;
    private boolean gdipendrawing;
    private boolean gdipenwidthdrawing;
    private double flatness;

    public WMFGraphics2D(WMF wmf, int width, int height, Color fg, Color bg) {
        this.gdifontdrawing = true;
        this.gdipendrawing = true;
        this.gdipenwidthdrawing = true;
        this.flatness = 0.1;
        if (fg == null) {
            fg = Color.black;
        }
        if (bg == null) {
            bg = Color.white;
        }
        this.wmfg = new WMFGraphics(wmf, width, height, fg, bg);
        this.img = new BufferedImage(1, 1, 2);
        this.g2D = (Graphics2D)this.img.getGraphics();
        this.g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.g2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        this.trans = new AffineTransform();
        this.stroke = this.g2D.getStroke();
        this.paint = fg;
        this.color = fg;
        this.deviceclip = null;
    }

    private WMFGraphics2D(WMFGraphics2D src) {
        this.wmfg = (WMFGraphics)src.wmfg.create();
        this.trans = (AffineTransform)src.trans.clone();
        this.stroke = src.stroke;
        this.paint = src.paint;
        this.color = src.color;
        this.deviceclip = src.deviceclip;
        this.img = new BufferedImage(src.img.getWidth(), src.img.getHeight(), 2);
        this.flatness = src.flatness;
        this.gdifontdrawing = src.gdifontdrawing;
        this.gdipendrawing = src.gdipendrawing;
        this.gdipenwidthdrawing = src.gdipenwidthdrawing;
        this.g2D = (Graphics2D)src.img.getGraphics();
        this.g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.g2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
    }

    @Override
    public void addRenderingHints(Map<?, ?> map) {
        this.g2D.addRenderingHints(map);
    }

    @Override
    public void clearRect(int x, int y, int width, int height) {
        Paint paint1 = this.paint;
        this.setColor(this.getBackground());
        this.fillRect(x, y, width, height);
        this.setPaint(paint1);
    }

    @Override
    public void clip(Shape shape) {
        if (this.deviceclip != null) {
            Area area = new Area(this.getClip());
            if (shape != null) {
                area.intersect(new Area(shape));
            }
            shape = area;
        }
        this.setClip(shape);
    }

    @Override
    public void clipRect(int x, int y, int w, int h) {
        this.clip(new Rectangle(x, y, w, h));
    }

    @Override
    public void copyArea(int x, int y, int width, int height, int dx, int dy) {
        this.g2D.copyArea(x, y, width, height, dx, dy);
    }

    @Override
    public Graphics create() {
        WMFGraphics2D wmfgraphics2d = new WMFGraphics2D(this);
        return wmfgraphics2d;
    }

    @Override
    public void dispose() {
        this.wmfg.dispose();
        this.g2D.dispose();
        this.img.flush();
    }

    private void draw(Shape shape, int i) {
        Shape area = null;
        shape = this.trans.createTransformedShape(shape);
        if (this.deviceclip != null) {
            area = this.deviceclip;
        }
        AffineTransform affinetransform = new AffineTransform();
        PathIterator pathiterator = shape.getPathIterator(affinetransform, this.flatness);
        float[] af = new float[6];
        Vector<Polygon> vector = new Vector<Polygon>();
        Polygon polygon = null;
        float[] af1 = new float[6];
        while (!pathiterator.isDone()) {
            int segment = pathiterator.currentSegment(af);
            switch (segment) {
                case 0: {
                    if (polygon != null) {
                        vector.add(polygon);
                    }
                    polygon = new Polygon();
                    polygon.addPoint((int)((double)af[0] + 0.5), (int)((double)af[1] + 0.5));
                    System.arraycopy(af, 0, af1, 0, af.length);
                    break;
                }
                case 3: {
                    if (polygon == null) break;
                    polygon.addPoint((int)((double)af[2] + 0.5), (int)((double)af[3] + 0.5));
                    break;
                }
                case 2: {
                    if (polygon == null) break;
                    polygon.addPoint((int)((double)af[4] + 0.5), (int)((double)af[5] + 0.5));
                    break;
                }
                case 1: {
                    if (polygon == null) break;
                    polygon.addPoint((int)((double)af[0] + 0.5), (int)((double)af[1] + 0.5));
                    break;
                }
                case 4: {
                    if (polygon == null) break;
                    polygon.addPoint((int)af1[0], (int)af1[1]);
                    vector.add(polygon);
                    polygon = null;
                    break;
                }
            }
            pathiterator.next();
        }
        if (polygon != null) {
            vector.add(polygon);
        }
        Polygon[] apolygon = new Polygon[vector.size()];
        int k = 0;
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            apolygon[k] = (Polygon)iterator.next();
            ++k;
        }
        int penStyle = this.wmfg.getPenStyle();
        int brushFillStyle = this.wmfg.getBrushFillStyle();
        this.wmfg.setClip(area);
        this.wmfg.setColor(this.getColor());
        this.wmfg.setPenStyle(0);
        if (this.gdipenwidthdrawing) {
            this.wmfg.setPenWidth(i);
        } else {
            this.wmfg.setPenWidth(0);
        }
        this.wmfg.setGDIHollowBrush();
        for (int l = 0; l < apolygon.length; ++l) {
            this.wmfg.drawPolyline(apolygon[l].xpoints, apolygon[l].ypoints, apolygon[l].npoints);
        }
        this.wmfg.setBrushFillStyle(brushFillStyle);
        this.wmfg.setPenStyle(penStyle);
    }

    @Override
    public void fill(Shape shape) {
        Shape save = this.deviceclip;
        this.wmfg.setClip(save);
        Shape theShape = this.trans.createTransformedShape(shape);
        Rectangle2D area = theShape.getBounds2D();
        if (this.deviceclip != null) {
            area = area.createIntersection(this.deviceclip.getBounds2D());
        }
        if (!(this.getPaint() instanceof Color)) {
            Rectangle bounds = area.getBounds();
            PaintContext context = this.paint.createContext(this.img.getColorModel(), bounds, shape.getBounds(), this.trans, this.getRenderingHints());
            Raster raster = context.getRaster(bounds.x, bounds.y, bounds.width, bounds.height);
            BufferedImage bufferedimage = new BufferedImage(context.getColorModel(), raster.createCompatibleWritableRaster(), false, null);
            bufferedimage.setData(raster);
            BufferedImage bufferedimage1 = new BufferedImage(bounds.width, bounds.height, 2);
            Graphics2D graphics2d = (Graphics2D)bufferedimage1.getGraphics();
            graphics2d.addRenderingHints(this.getRenderingHints());
            graphics2d.setTransform(AffineTransform.getTranslateInstance(-bounds.x, -bounds.y));
            graphics2d.setClip(area);
            graphics2d.drawImage((Image)bufferedimage, bounds.x, bounds.y, null);
            this.wmfg.drawImage(bufferedimage1, bounds.x, bounds.y, bounds.width, bounds.height, null);
            return;
        }
        AffineTransform affinetransform = new AffineTransform();
        PathIterator pathiterator = theShape.getPathIterator(affinetransform, this.flatness);
        if (pathiterator.getWindingRule() == 0) {
            this.wmfg.setPolyFillMode(1);
        } else {
            this.wmfg.setPolyFillMode(2);
        }
        int i = this.wmfg.getPenStyle();
        this.wmfg.setPenStyle(5);
        this.wmfg.setColor(this.getColor());
        float[] af = new float[6];
        Vector<Polygon> vector = new Vector<Polygon>();
        Polygon polygon = null;
        while (!pathiterator.isDone()) {
            int j = pathiterator.currentSegment(af);
            switch (j) {
                case 0: {
                    if (polygon != null) {
                        vector.add(polygon);
                    }
                    polygon = new Polygon();
                    polygon.addPoint((int)((double)af[0] + 0.5), (int)((double)af[1] + 0.5));
                    break;
                }
                case 3: {
                    if (polygon == null) break;
                    polygon.addPoint((int)((double)af[2] + 0.5), (int)((double)af[3] + 0.5));
                    break;
                }
                case 2: {
                    if (polygon == null) break;
                    polygon.addPoint((int)((double)af[4] + 0.5), (int)((double)af[5] + 0.5));
                    break;
                }
                case 1: {
                    if (polygon == null) break;
                    polygon.addPoint((int)((double)af[0] + 0.5), (int)((double)af[1] + 0.5));
                    break;
                }
                case 4: {
                    if (polygon == null) break;
                    vector.add(polygon);
                    polygon = null;
                    break;
                }
            }
            pathiterator.next();
        }
        if (polygon != null) {
            vector.add(polygon);
        }
        Polygon[] apolygon = new Polygon[vector.size()];
        int k = 0;
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            apolygon[k] = (Polygon)iterator.next();
            ++k;
        }
        boolean flag1 = false;
        if (shape instanceof Arc2D) {
            flag1 = true;
        }
        if (!flag1) {
            this.wmfg.GDIPolyPolygon(apolygon);
        } else {
            for (int l = 0; l < apolygon.length; ++l) {
                this.wmfg.fillPolygon(apolygon[l]);
            }
        }
        this.wmfg.setPenStyle(i);
    }

    @Override
    public void draw(Shape shape) {
        if (this.gdipendrawing && this.getPaint() instanceof Color && this.stroke instanceof BasicStroke && (((BasicStroke)this.stroke).getDashArray() == null || ((BasicStroke)this.stroke).getDashArray().length == 0)) {
            this.draw(shape, (int)((BasicStroke)this.stroke).getLineWidth());
        }
    }

    @Override
    public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.draw(new Arc2D.Float(x, y, width, height, startAngle, arcAngle, 0));
    }

    @Override
    public void drawGlyphVector(GlyphVector glyphvector, float f, float f1) {
        this.fill(glyphvector.getOutline(f, f1));
    }

    @Override
    public boolean drawImage(Image image, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, Color color1, ImageObserver imageobserver) {
        int[] ai = new int[]{dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2};
        Rectangle rectangle = new Line2D.Float(dx1, dy1, dx2, dy2).getBounds();
        Shape shape = this.trans.createTransformedShape(rectangle);
        Rectangle rectangle1 = shape.getBounds();
        Image image1 = this.transformImage(image, ai, rectangle1, imageobserver, color1);
        this.wmfg.setClip(null);
        this.wmfg.drawImage(image1, rectangle1.x, rectangle1.y, rectangle1.width, rectangle1.height, imageobserver);
        return true;
    }

    @Override
    public boolean drawImage(Image image, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, ImageObserver imageobserver) {
        return this.drawImage(image, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, null, imageobserver);
    }

    @Override
    public boolean drawImage(Image image, int x, int y, int width, int height, Color color1, ImageObserver imageobserver) {
        Rectangle rc = new Rectangle(x, y, width, height);
        Shape shape = this.trans.createTransformedShape(rc);
        Rectangle bound = shape.getBounds();
        Image image1 = this.transformImage(image, rc, bound, imageobserver, color1);
        this.wmfg.setClip(null);
        this.wmfg.drawImage(image1, bound.x, bound.y, bound.width, bound.height, imageobserver);
        return true;
    }

    @Override
    public boolean drawImage(Image image, int x, int y, int width, int height, ImageObserver imageobserver) {
        return this.drawImage(image, x, y, width, height, null, imageobserver);
    }

    @Override
    public boolean drawImage(Image image, int x, int y, Color color1, ImageObserver imageobserver) {
        return this.drawImage(image, x, y, image.getWidth(imageobserver), image.getHeight(imageobserver), color1, imageobserver);
    }

    @Override
    public boolean drawImage(Image image, int x, int y, ImageObserver imageobserver) {
        return this.drawImage(image, x, y, image.getWidth(imageobserver), image.getHeight(imageobserver), imageobserver);
    }

    @Override
    public boolean drawImage(Image image, AffineTransform affinetransform, ImageObserver imageobserver) {
        AffineTransform affinetransform1 = (AffineTransform)this.trans.clone();
        this.trans.concatenate(affinetransform);
        this.drawImage(image, 0, 0, imageobserver);
        this.trans = affinetransform1;
        return true;
    }

    @Override
    public void drawImage(BufferedImage bufferedimage, BufferedImageOp bufferedimageop, int i, int j) {
        BufferedImage bufferedimage1 = bufferedimageop.filter(bufferedimage, null);
        this.drawImage(bufferedimage1, new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, i, j), null);
    }

    @Override
    public void drawLine(int x1, int y1, int x2, int y2) {
        this.draw(new GeneralPath(new Line2D.Float(x1, y1, x2, y2)));
    }

    @Override
    public void drawOval(int x, int y, int width, int height) {
        this.draw(new Ellipse2D.Float(x, y, width, height));
    }

    @Override
    public void drawPolygon(int[] xPoints, int[] yPoints, int i) {
        this.draw(new Polygon(xPoints, yPoints, i));
    }

    @Override
    public void drawPolyline(int[] xPoints, int[] yPoints, int i) {
        if (i > 0) {
            GeneralPath generalpath = new GeneralPath();
            generalpath.moveTo(xPoints[0], yPoints[0]);
            for (int j = 1; j < i; ++j) {
                generalpath.lineTo(xPoints[j], yPoints[j]);
            }
            this.draw(generalpath);
        }
    }

    @Override
    public void drawRect(int x, int y, int width, int height) {
        Rectangle rectangle = new Rectangle(x, y, width, height);
        this.draw(rectangle);
    }

    @Override
    public void drawRenderableImage(RenderableImage img, AffineTransform transform) {
        this.drawRenderedImage(img.createDefaultRendering(), transform);
    }

    @Override
    public void drawRenderedImage(RenderedImage img, AffineTransform transform) {
        BufferedImage bufferedimage = new BufferedImage(img.getColorModel(), img.getData().createCompatibleWritableRaster(), false, null);
        bufferedimage.setData(img.getData());
        this.drawImage(bufferedimage, transform, null);
    }

    @Override
    public void drawRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.draw(new RoundRectangle2D.Float(x, y, width, height, arcWidth, arcHeight));
    }

    @Override
    public void drawString(String s, float x, float y) {
        if (this.isGDIFontDrawing() && this.getPaint() instanceof Color) {
            boolean noClipping;
            boolean bl = noClipping = this.deviceclip == null;
            if (!noClipping) {
                GlyphVector glyphvector = this.getFont().createGlyphVector(this.getFontRenderContext(), s);
                Rectangle2D rectangle2d = glyphvector.getOutline(x, y).getBounds2D();
                noClipping = this.deviceclip.contains(this.trans.createTransformedShape(rectangle2d).getBounds2D());
            }
            if (noClipping) {
                boolean isIdent = this.trans.isIdentity() && this.getFont().getTransform().isIdentity();
                double scaleX = 1.0;
                double scale = 0.0;
                if (!isIdent) {
                    AffineTransform affinetransform = this.getFont().getTransform();
                    affinetransform.preConcatenate(this.trans);
                    scaleX = affinetransform.getScaleX();
                    boolean bl2 = isIdent = affinetransform.getShearX() == -affinetransform.getShearY() && affinetransform.getScaleX() == affinetransform.getScaleY();
                    if (isIdent && (affinetransform.getShearX() != 0.0 || affinetransform.getScaleX() < 0.0)) {
                        scaleX = Math.sqrt(affinetransform.getScaleX() * affinetransform.getScaleX() + affinetransform.getShearX() * affinetransform.getShearX());
                        scale = Math.acos(affinetransform.getScaleX() / scaleX);
                        if (affinetransform.getShearX() > 0.0) {
                            scale = -scale;
                        }
                    }
                }
                if (isIdent) {
                    this.wmfg.setColor(this.getColor());
                    float f2 = (float)((double)this.getFont().getSize2D() * scaleX);
                    Font font = this.getFont();
                    this.wmfg.setFont(this.getFont().deriveFont(f2));
                    if (scale != 0.0) {
                        this.wmfg.setFontEscapement((int)(-scale * 1800.0 / Math.PI));
                    }
                    Point2D.Double double1 = new Point2D.Double((double)x + this.getFont().getTransform().getTranslateX(), (double)y + this.getFont().getTransform().getTranslateY());
                    this.trans.transform(double1, double1);
                    this.wmfg.drawString(s, (int)double1.getX(), (int)double1.getY());
                    if (scale != 0.0) {
                        this.wmfg.setFontEscapement(0);
                    }
                    this.wmfg.setFont(font);
                    return;
                }
            }
        }
        this.drawGlyphVector(this.getFont().createGlyphVector(this.getFontRenderContext(), s), x, y);
    }

    @Override
    public void drawString(String s, int x, int y) {
        this.drawString(s, (float)x, (float)y);
    }

    @Override
    public void drawString(AttributedCharacterIterator attributedcharacteriterator, float f, float f1) {
        TextLayout textlayout = new TextLayout(attributedcharacteriterator, this.getFontRenderContext());
        Paint paint1 = this.getPaint();
        this.setColor(this.getColor());
        this.fill(textlayout.getOutline(AffineTransform.getTranslateInstance(f, f1)));
        this.setPaint(paint1);
    }

    @Override
    public void drawString(AttributedCharacterIterator it, int i, int j) {
        this.drawString(it, i, j);
    }

    @Override
    public void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.fill(new Arc2D.Float(x, y, width, height, startAngle, arcAngle, 2));
    }

    @Override
    public void fillOval(int x, int y, int width, int height) {
        this.fill(new Ellipse2D.Float(x, y, width, height));
    }

    @Override
    public void fillPolygon(int[] xPoints, int[] yPoints, int i) {
        this.fill(new Polygon(xPoints, yPoints, i));
    }

    @Override
    public void fillRect(int x, int y, int width, int height) {
        this.fill(new Rectangle(x, y, width, height));
    }

    @Override
    public void fillRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.fill(new RoundRectangle2D.Float(x, y, width, height, arcWidth, arcHeight));
    }

    @Override
    public Color getBackground() {
        return this.wmfg.getBackground();
    }

    @Override
    public Shape getClip() {
        try {
            return this.trans.createInverse().createTransformedShape(this.deviceclip);
        }
        catch (Exception _ex) {
            return null;
        }
    }

    @Override
    public Rectangle getClipBounds() {
        if (this.deviceclip != null) {
            return this.getClip().getBounds();
        }
        return null;
    }

    @Override
    public Color getColor() {
        return this.color;
    }

    @Override
    public Composite getComposite() {
        return this.g2D.getComposite();
    }

    @Override
    public GraphicsConfiguration getDeviceConfiguration() {
        return this.g2D.getDeviceConfiguration();
    }

    public double getFlatness() {
        return this.flatness;
    }

    @Override
    public Font getFont() {
        return this.wmfg.getFont();
    }

    @Override
    public FontMetrics getFontMetrics(Font font) {
        return this.wmfg.getFontMetrics(font);
    }

    @Override
    public FontRenderContext getFontRenderContext() {
        this.g2D.setTransform(this.trans);
        return this.g2D.getFontRenderContext();
    }

    @Override
    public Paint getPaint() {
        return this.paint;
    }

    @Override
    public Object getRenderingHint(RenderingHints.Key key) {
        return this.g2D.getRenderingHint(key);
    }

    @Override
    public RenderingHints getRenderingHints() {
        return this.g2D.getRenderingHints();
    }

    @Override
    public Stroke getStroke() {
        return this.stroke;
    }

    @Override
    public AffineTransform getTransform() {
        return (AffineTransform)this.trans.clone();
    }

    @Override
    public boolean hit(Rectangle rectangle, Shape shape, boolean flag) {
        this.g2D.setTransform(this.trans);
        this.g2D.setStroke(this.getStroke());
        this.g2D.setClip(this.getClip());
        return this.g2D.hit(rectangle, shape, flag);
    }

    public boolean isGDIFontDrawing() {
        return this.gdifontdrawing;
    }

    public boolean isGDIPenDrawing() {
        return this.gdipendrawing;
    }

    public boolean isGDIPenWidthDrawing() {
        return this.gdipenwidthdrawing;
    }

    @Override
    public void rotate(double theta) {
        this.trans.rotate(theta);
    }

    @Override
    public void rotate(double theta, double x, double y) {
        this.trans.rotate(theta, x, y);
    }

    @Override
    public void scale(double sx, double sy) {
        this.trans.scale(sx, sy);
    }

    @Override
    public void setBackground(Color color) {
        this.wmfg.setBackground(color);
    }

    @Override
    public void setClip(int x, int y, int width, int height) {
        this.setClip(new Rectangle(x, y, width, height));
    }

    @Override
    public void setClip(Shape shape) {
        this.deviceclip = this.trans.createTransformedShape(shape);
    }

    @Override
    public void setColor(Color color1) {
        this.setPaint(color1);
    }

    @Override
    public void setComposite(Composite composite) {
        this.g2D.setComposite(composite);
    }

    public void setFlatness(double d) {
        this.flatness = d;
    }

    @Override
    public void setFont(Font font) {
        this.wmfg.setFont(font);
    }

    public void setGDIFontDrawing(boolean flag) {
        this.gdifontdrawing = flag;
    }

    public void setGDIPenDrawing(boolean flag) {
        this.gdipendrawing = flag;
    }

    public void setGDIPenWidthDrawing(boolean flag) {
        this.gdipenwidthdrawing = flag;
    }

    @Override
    public void setPaint(Paint p) {
        if (p != null) {
            this.paint = p;
            if (p instanceof Color) {
                this.color = (Color)p;
            }
        }
    }

    @Override
    public void setPaintMode() {
        this.wmfg.setPaintMode();
    }

    @Override
    public void setRenderingHint(RenderingHints.Key key, Object obj) {
        this.g2D.setRenderingHint(key, obj);
    }

    @Override
    public void setRenderingHints(Map<?, ?> map) {
        this.g2D.setRenderingHints(map);
    }

    @Override
    public void setStroke(Stroke stroke1) {
        this.stroke = stroke1;
    }

    @Override
    public void setTransform(AffineTransform affinetransform) {
        this.trans = (AffineTransform)affinetransform.clone();
    }

    @Override
    public void setXORMode(Color color1) {
        this.wmfg.setXORMode(color1);
    }

    @Override
    public void shear(double shx, double shy) {
        this.trans.shear(shx, shy);
    }

    @Override
    public void transform(AffineTransform affinetransform) {
        this.trans.concatenate(affinetransform);
    }

    private Image transformImage(Image image, Rectangle rectangle, Rectangle rectangle1, ImageObserver imageobserver, Color bgcolor) {
        if (this.trans.isIdentity() && this.getClip() == null && bgcolor == null) {
            return image;
        }
        if (this.deviceclip != null) {
            Area area = new Area(this.deviceclip);
            area.intersect(new Area(this.trans.createTransformedShape(rectangle)));
            rectangle1.setBounds(area.getBounds());
        }
        BufferedImage bufferedimage = new BufferedImage(rectangle1.width, rectangle1.height, 2);
        Graphics2D graphics2d = (Graphics2D)bufferedimage.getGraphics();
        graphics2d.addRenderingHints(this.getRenderingHints());
        graphics2d.translate(-rectangle1.x, -rectangle1.y);
        graphics2d.transform((AffineTransform)this.getTransform().clone());
        graphics2d.setClip(this.getClip());
        if (bgcolor != null) {
            graphics2d.drawImage(image, rectangle.x, rectangle.y, rectangle.width, rectangle.height, bgcolor, imageobserver);
        } else {
            graphics2d.drawImage(image, rectangle.x, rectangle.y, rectangle.width, rectangle.height, imageobserver);
        }
        graphics2d.dispose();
        return bufferedimage;
    }

    private Image transformImage(Image image, int[] ai, Rectangle rectangle, ImageObserver imageobserver, Color bgcolor) {
        BufferedImage bufferedimage = new BufferedImage(rectangle.width, rectangle.height, 2);
        Graphics2D graphics2d = (Graphics2D)bufferedimage.getGraphics();
        graphics2d.addRenderingHints(this.getRenderingHints());
        graphics2d.translate(-rectangle.x, -rectangle.y);
        graphics2d.transform((AffineTransform)this.getTransform().clone());
        graphics2d.setClip(this.getClip());
        if (bgcolor != null) {
            graphics2d.drawImage(image, ai[0], ai[1], ai[2], ai[3], ai[4], ai[5], ai[6], ai[7], bgcolor, imageobserver);
        } else {
            graphics2d.drawImage(image, ai[0], ai[1], ai[2], ai[3], ai[4], ai[5], ai[6], ai[7], imageobserver);
        }
        return bufferedimage;
    }

    @Override
    public void translate(double tx, double ty) {
        this.trans.translate(tx, ty);
    }

    @Override
    public void translate(int x, int y) {
        this.trans.translate(x, y);
    }
}

