/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.util;

public class Angle {
    public final double TWO_PI = Math.PI * 2;
    private double mValue;

    public Angle() {
    }

    public Angle(Angle a) {
        this(a.mValue);
    }

    public Angle(double value) {
        this.mValue = value;
        this.normalize();
    }

    public void normalize() {
        while (this.mValue < -Math.PI) {
            this.mValue += Math.PI * 2;
        }
        while (this.mValue >= Math.PI) {
            this.mValue -= Math.PI * 2;
        }
    }

    public double toDegrees() {
        return 180.0 * this.mValue / Math.PI;
    }

    public double getValue() {
        return this.mValue;
    }

    public void setValue(double value) {
        this.mValue = value;
        this.normalize();
    }

    public double cos() {
        return Math.cos(this.mValue);
    }

    public double sin() {
        return Math.sin(this.mValue);
    }

    public double tan() {
        return Math.tan(this.mValue);
    }

    public static Angle arcsin(double x) {
        return new Angle(Math.asin(x));
    }

    public static Angle arccos(double x) {
        return new Angle(Math.acos(x));
    }

    public static Angle arctan(double y, double x) {
        return new Angle(Math.atan2(y, x));
    }

    public static double mean(Angle a1, Angle a2) {
        double mean = (a1.mValue + a2.mValue) / 2.0;
        double dif = a2.mValue - a1.mValue;
        if (Math.abs(dif) > Math.PI) {
            mean = mean < 0.0 ? (mean += Math.PI) : (mean -= Math.PI);
        }
        return mean;
    }

    public static double difference(double a2, double a1) {
        double a = a2 - a1;
        if (a >= Math.PI) {
            a -= Math.PI * 2;
        } else if (a < -Math.PI) {
            a += Math.PI * 2;
        }
        return a;
    }

    public static double difference(Angle a2, Angle a1) {
        return Angle.difference(a2.mValue, a1.mValue);
    }

    public void add(double value) {
        this.mValue += value;
        this.normalize();
    }

    public void add(Angle a) {
        this.add(a.mValue);
    }

    public void subtract(double value) {
        this.mValue -= value;
        this.normalize();
    }

    public void subtract(Angle a) {
        this.subtract(a.mValue);
    }

    public boolean isSmallerThan(Angle a) {
        double dif = a.mValue - this.mValue;
        return dif > 0.0 && dif < Math.PI || dif < 0.0 && dif > Math.PI;
    }

    public boolean isGreaterThan(Angle a) {
        double dif = this.mValue - a.mValue;
        return dif > 0.0 && dif < Math.PI || dif < 0.0 && dif > Math.PI;
    }

    public String toString() {
        return this.toDegrees() + " degrees";
    }
}

